/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.util.serial;

import gnu.io.CommDriver;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.RXTXVersion;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import replicatorg.app.Base;
import replicatorg.app.exceptions.SerialException;
import replicatorg.app.exceptions.UnknownSerialPortException;
import replicatorg.app.util.serial.ByteFifo;
import replicatorg.app.util.serial.Name;
import replicatorg.app.util.serial.SerialFifoEventListener;
import replicatorg.app.util.serial.UsbHardwareId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Serial
implements SerialPortEventListener {
    private static Set<Serial> portsInUse = new HashSet<Serial>();
    private AtomicBoolean connected = new AtomicBoolean(false);
    private SerialPort port;
    private String name;
    private int rate;
    private int parity;
    private int data;
    private int stop;
    private static ArrayList<String> manualPortOverrides;
    private static int TIMEOUT_DEFAULT;
    private int timeoutMillis = TIMEOUT_DEFAULT;
    private ByteFifo readFifo = new ByteFifo();
    public final AtomicReference<SerialFifoEventListener> listener = new AtomicReference();
    private InputStream input;
    private OutputStream output;

    public static Vector<Name> scanSerialNames() {
        Vector<Name> v = new Vector<Name>();
        try {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1 || portId.getPortType() != 1) continue;
                Name sn = new Name(portId.getName(), !portId.isCurrentlyOwned());
                v.add(sn);
            }
        }
        catch (Exception e) {
            Base.logger.fine("problem scanning SerialPorts: " + e);
        }
        Base.logger.fine("RXTX Version" + RXTXVersion.getVersion());
        manualPortOverrides = new ArrayList();
        try {
            File portsFile = new File(Base.getUserDirectory(), "ports");
            if (portsFile.exists()) {
                String port;
                BufferedReader br = new BufferedReader(new FileReader(portsFile));
                while ((port = br.readLine()) != null) {
                    File portFile = new File(port);
                    if (portFile.exists()) {
                        Name sn = new Name(port, true);
                        v.add(sn);
                    }
                    manualPortOverrides.add(port);
                }
                br.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (Serial port : portsInUse) {
            Name n = new Name(port.getName(), false);
            boolean contains = false;
            for (Name vi : v) {
                if (vi.compareTo(n) != 0) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            v.add(n);
        }
        if (Base.isLinux()) {
            Pattern idPattern = Pattern.compile("(FTDI_TTL232R_|usb-Arduino__www.arduino.cc__Arduino_Uno_)([^-]*)");
            File portDir = new File("/dev/serial/by-id/");
            if (portDir.exists() && portDir.isDirectory()) {
                for (File file : portDir.listFiles()) {
                    Matcher match = idPattern.matcher(file.getPath());
                    if (!match.find()) continue;
                    try {
                        String canonical = file.getCanonicalFile().getPath();
                        for (Name m : v) {
                            if (!m.getName().equals(canonical)) continue;
                            m.setAlias(match.group(2));
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            Pattern makerBotByIdPattern = Pattern.compile("usb-MakerBot_Industries_(MightyBoard)_([^-]*)");
            if (portDir.exists() && portDir.isDirectory()) {
                for (File file : portDir.listFiles()) {
                    Matcher match = makerBotByIdPattern.matcher(file.getPath());
                    if (!match.find()) continue;
                    try {
                        String canonical = file.getCanonicalFile().getPath();
                        for (Name m : v) {
                            if (!m.getName().equals(canonical)) continue;
                            m.setAlias("'MightyBoard " + match.group(2));
                            m.setHardwareId(UsbHardwareId.MIGHTY_BOARD);
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
        }
        return v;
    }

    public Serial(String portName, int baudRate, char parity, int dataBits, int stopBits) throws SerialException {
        this.init(portName, baudRate, parity, dataBits, stopBits);
    }

    public Serial(String name) throws SerialException {
        this.init(name, 38400, 'N', 8, 1.0f);
    }

    public String getName() {
        return this.name;
    }

    private CommPortIdentifier findPortIdentifier(String name) {
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier id = (CommPortIdentifier)portList.nextElement();
            if (id.getPortType() != 1 || !id.getName().equals(name)) continue;
            return id;
        }
        CommDriver RXTXDriver = null;
        for (String portName : manualPortOverrides) {
            if (!name.equals(portName)) continue;
            try {
                if (RXTXDriver == null) {
                    RXTXDriver = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
                    RXTXDriver.initialize();
                }
                CommPortIdentifier.addPortName((String)portName, (int)1, RXTXDriver);
                return CommPortIdentifier.getPortIdentifier((String)portName);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    private void init(String name, int rate, char parity, int data, float stop) throws SerialException {
        CommPortIdentifier portId;
        this.name = name;
        this.rate = rate;
        this.parity = 0;
        if (parity == 'E') {
            this.parity = 2;
        }
        if (parity == 'O') {
            this.parity = 1;
        }
        this.data = data;
        this.stop = (int)stop;
        if (stop == 1.5f) {
            this.stop = 3;
        }
        if (stop == 2.0f) {
            this.stop = 2;
        }
        if ((portId = this.findPortIdentifier(name)) == null) {
            throw new UnknownSerialPortException(name);
        }
        try {
            this.port = (SerialPort)portId.open("replicatorG", 2000);
            this.port.setSerialPortParams(this.rate, this.data, this.stop, this.parity);
            this.input = this.port.getInputStream();
            this.output = this.port.getOutputStream();
            this.port.addEventListener((SerialPortEventListener)this);
            this.port.notifyOnDataAvailable(true);
        }
        catch (PortInUseException e) {
            throw new SerialException("Serial port '" + name + "' already in use.  Try quiting any programs that may be using it.");
        }
        catch (Exception e) {
            throw new SerialException("Error opening serial port '" + name + "'.", e);
        }
        portsInUse.add(this);
        this.connected.set(true);
    }

    public synchronized void dispose() {
        this.connected.set(false);
        if (this.port != null) {
            this.port.removeEventListener();
        }
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.input = null;
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.output = null;
        }
        if (this.port != null) {
            this.port.close();
            this.port = null;
        }
        portsInUse.remove(this);
    }

    public void pulseRTSLow() {
        this.port.setDTR(false);
        this.port.setRTS(false);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.port.setDTR(true);
        this.port.setRTS(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int waitForBytes(int numberOfBytes) {
        try {
            long to = System.currentTimeMillis() + (long)this.timeoutMillis;
            while (System.currentTimeMillis() < to && this.readFifo.size() < numberOfBytes) {
                ByteFifo byteFifo = this.readFifo;
                synchronized (byteFifo) {
                    this.readFifo.wait(this.timeoutMillis);
                }
            }
            return 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        if (this.waitForBytes(1) == -1) {
            return -1;
        }
        ByteFifo byteFifo = this.readFifo;
        synchronized (byteFifo) {
            if (this.readFifo.size() > 0) {
                byte b = this.readFifo.dequeue();
                return b & 0xFF;
            }
            if (this.timeoutMillis < TIMEOUT_DEFAULT) {
                Base.logger.finest("Read timed out.");
            } else {
                Base.logger.warning("Read timed out.");
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes) {
        if (this.waitForBytes(bytes.length) == -1) {
            return -1;
        }
        ByteFifo byteFifo = this.readFifo;
        synchronized (byteFifo) {
            int idx = 0;
            while (this.readFifo.size() > 0 && idx < bytes.length) {
                bytes[idx++] = this.readFifo.dequeue();
            }
            return idx;
        }
    }

    public void write(byte[] bytes) {
        if (!this.connected.get()) {
            Base.logger.severe("serial disconnected");
            return;
        }
        try {
            this.output.write(bytes);
            this.output.flush();
        }
        catch (Exception e) {
            Base.logger.severe("serial error: \n" + e.getMessage());
        }
    }

    public void write(String what) {
        this.write(what.getBytes());
    }

    public void setTimeout(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ByteFifo byteFifo = this.readFifo;
        synchronized (byteFifo) {
            int maxEats;
            try {
                for (maxEats = 255; this.input.available() > 0 && maxEats > 0; --maxEats) {
                    this.input.read();
                    Thread.sleep(1L);
                }
            }
            catch (IOException e) {
                this.connected.set(false);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.readFifo.clear();
            this.readFifo.notifyAll();
            if (maxEats == 0) {
                throw new RuntimeException("Much more data than expected; check your serial line and reset your machine!");
            }
        }
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent event) {
        if (event.getEventType() != 1) {
            return;
        }
        ByteFifo byteFifo = this.readFifo;
        synchronized (byteFifo) {
            try {
                while (true) {
                    InputStream inputStream = this.input;
                    synchronized (inputStream) {
                        if (this.input.available() == 0) {
                            return;
                        }
                    }
                    int b = this.input.read();
                    if (b < 0) continue;
                    this.readFifo.enqueue((byte)b);
                    this.readFifo.notifyAll();
                    SerialFifoEventListener l = this.listener.get();
                    if (l == null) continue;
                    l.serialByteReceivedEvent(this.readFifo);
                }
            }
            catch (IOException e) {
                if (this.connected.get()) {
                    Base.logger.severe("Serial IO exception:" + event.toString() + ". Printer communication may be disrupted.");
                    this.dispose();
                }
            }
        }
    }

    static {
        TIMEOUT_DEFAULT = 500;
    }
}

