/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import replicatorg.app.Base;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SDCardCapture {
    public ResponseCode beginCapture(String var1);

    public int endCapture();

    public void beginFileCapture(String var1) throws FileNotFoundException;

    public void endFileCapture() throws IOException;

    public ResponseCode playback(String var1);

    public boolean hasFeatureSDCardCapture();

    public List<String> getFileList();

    public boolean isFinished();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseCode {
        SUCCESS("Success!"),
        FAIL_NO_CARD("No SD card was detected.  Please make sure you have a working, formatted\nSD card in the motherboard's SD slot and try again."),
        FAIL_INIT("ReplicatorG was unable to initialize the SD card.  Please make sure that\nthe SD card works properly."),
        FAIL_PARTITION("ReplicatorG was unable to read the SD card's partition table.  Please check\nthat the card is partitioned properly.\nIf you believe your SD card is OK, try resetting your device and restarting\nReplicatorG."),
        FAIL_FS("ReplicatorG was unable to open the filesystem on the SD card.  Please make sure\nthat the SD card has a single partition formatted with a FAT16 filesystem."),
        FAIL_ROOT_DIR("ReplicatorG was unable to read the root directory on the SD card.  Please\ncheck to see if the SD card was formatted properly."),
        FAIL_LOCKED("The SD card cannot be written to because it is locked.  Remove the card,\nswitch the lock off, and try again."),
        FAIL_NO_FILE("ReplicatorG could not find the build file on the SD card."),
        FAIL_GENERIC("Unknown SD card error.");

        private String message;

        private ResponseCode(String message) {
            this.message = message;
        }

        public static boolean processSDResponse(ResponseCode code) {
            if (code == SUCCESS) {
                return true;
            }
            String message = code.message;
            Base.logger.log(Level.WARNING, message);
            JOptionPane.showMessageDialog(null, message, "SD card error", 0);
            return false;
        }
    }
}

