/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.gen3;

import java.awt.Color;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Hashtable;
import replicatorg.app.Base;
import replicatorg.drivers.InteractiveDisplay;
import replicatorg.drivers.OnboardParameters;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.Version;
import replicatorg.drivers.gen3.Makerbot4GAlternateDriver;
import replicatorg.drivers.gen3.MotherboardCommandCode;
import replicatorg.drivers.gen3.PacketBuilder;
import replicatorg.drivers.gen3.PacketResponse;
import replicatorg.drivers.gen3.VidPid;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.ToolModel;
import replicatorg.machine.model.ToolheadsOffset;
import replicatorg.util.Point5d;

public class Makerbot4GSailfish
extends Makerbot4GAlternateDriver
implements InteractiveDisplay {
    private Hashtable ledColorByEffect;
    private boolean eepromChecked = false;
    protected static final int DEFAULT_RETRIES = 5;
    protected VidPid machineId = VidPid.UNKNOWN;
    private int toolCountOnboard = -1;
    Version toolVersion = new Version(0, 0);
    Version accelerationVersion = new Version(0, 0);

    public Makerbot4GSailfish() {
        this.absoluteXYZ = true;
        this.ledColorByEffect = new Hashtable();
        this.ledColorByEffect.put(0, Color.BLACK);
        Base.logger.info("Created a Sailfish");
        this.minimumVersion = new Version(4, 0);
        this.preferredVersion = new Version(4, 0);
        this.minimumAccelerationVersion = new Version(4, 0);
        this.minimumJettyAccelerationVersion = new Version(4, 0);
    }

    public String getDriverName() {
        return "Makerbot4GSailfish";
    }

    public boolean initializeBot() {
        for (ToolModel t : this.getMachine().getTools()) {
            if (t == null) continue;
            this.initSlave(t.getIndex());
        }
        this.getMotorRPM();
        this.getAccelerationState();
        this.machineId = VidPid.UNKNOWN;
        if (!this.verifyMachineId()) {
            Base.logger.severe("Machine ID Mismatch. Please re-select your machine.");
            return true;
        }
        if (!this.verifyToolCount()) {
            Base.logger.severe("Tool Count Mismatch. Expecting " + this.machine.getTools().size() + " tools, reported " + this.toolCountOnboard + "tools");
            Base.logger.severe("Please double-check your selected machine.");
        }
        boolean needsReset = this.checkAndWriteStepsPerMM();
        needsReset |= this.checkAndWriteAxisLengths();
        if (needsReset |= this.checkAndWriteMaxFeedRates()) {
            this.setInitialized(true);
            this.reset();
            this.setInitialized(false);
        }
        return true;
    }

    private void checkEEPROM() {
        if (!this.eepromChecked) {
            this.eepromChecked = true;
            if (this.version.getMajor() < 2) {
                byte[] versionBytes = this.readFromEEPROM(0, 2);
                if (versionBytes == null || versionBytes.length < 2) {
                    return;
                }
                if (versionBytes[0] != 90 || versionBytes[1] != 120) {
                    Base.logger.severe("Cleaning EEPROM to v1.X state");
                    byte[] eepromWipe = new byte[16];
                    Arrays.fill(eepromWipe, (byte)0);
                    eepromWipe[0] = 90;
                    eepromWipe[1] = 120;
                    this.writeToEEPROM(0, eepromWipe);
                    Arrays.fill(eepromWipe, (byte)0);
                    for (int i = 16; i < 256; i += 16) {
                        this.writeToEEPROM(i, eepromWipe);
                    }
                }
            }
        }
    }

    private void getAccelerationState() {
        Base.logger.fine("Geting Acceleration Status from Bot");
        boolean bl = this.acceleratedFirmware = this.getAccelerationStatus() != 0;
        if (this.acceleratedFirmware) {
            Base.logger.finest("Found accelerated firmware active");
        }
    }

    public boolean checkAndWriteStepsPerMM() {
        if (!this.hasJettyAcceleration()) {
            return false;
        }
        Point5d machineStepsPerMM = this.getMachine().getStepsPerMM();
        boolean needsReset = false;
        int stepperCount = 5;
        for (int i = 0; i < stepperCount; ++i) {
            double firmwareAxisStepsPerMM = this.read64FromEEPROM(139 + i * 8);
            double val = 0.0;
            switch (i) {
                case 0: {
                    val = machineStepsPerMM.x();
                    break;
                }
                case 1: {
                    val = machineStepsPerMM.y();
                    break;
                }
                case 2: {
                    val = machineStepsPerMM.z();
                    break;
                }
                case 3: {
                    val = machineStepsPerMM.a();
                    break;
                }
                case 4: {
                    val = machineStepsPerMM.b();
                }
            }
            val = (long)(val * 1.0E10);
            if (firmwareAxisStepsPerMM == val) continue;
            Base.logger.info("Bot StepsPerMM Axis " + i + ": " + firmwareAxisStepsPerMM / 1.0E10 + " machine xml has: " + val / 1.0E10 + ", updating bot");
            this.write64ToEEPROM64(139 + i * 8, (long)val);
            needsReset = true;
        }
        return needsReset;
    }

    public boolean checkAndWriteMaxFeedRates() {
        if (!this.hasJettyAcceleration()) {
            return false;
        }
        Point5d maximumFeedRates = this.getMachine().getMaximumFeedrates();
        boolean needsReset = false;
        int stepperCount = 5;
        for (int i = 0; i < stepperCount; ++i) {
            double firmwareAxisMaximumFeedRate = this.read32FromEEPROM(295 + i * 4);
            double val = 0.0;
            switch (i) {
                case 0: {
                    val = maximumFeedRates.x();
                    break;
                }
                case 1: {
                    val = maximumFeedRates.y();
                    break;
                }
                case 2: {
                    val = maximumFeedRates.z();
                    break;
                }
                case 3: {
                    val = maximumFeedRates.a();
                    break;
                }
                case 4: {
                    val = maximumFeedRates.b();
                }
            }
            if (firmwareAxisMaximumFeedRate == val) continue;
            Base.logger.info("Bot Maximum Feed Rate Axis " + i + ": " + firmwareAxisMaximumFeedRate + " machine xml has: " + val + ", updating bot");
            this.write32ToEEPROM32(295 + i * 4, (int)val);
            needsReset = true;
        }
        return needsReset;
    }

    public boolean checkAndWriteAxisLengths() {
        if (!this.hasJettyAcceleration()) {
            return false;
        }
        Point5d axisLengths = this.getMachine().getAxisLengths();
        Point5d machineStepsPerMM = this.getMachine().getStepsPerMM();
        boolean needsReset = false;
        int stepperCount = 5;
        for (int i = 0; i < stepperCount; ++i) {
            int firmwareAxisLength = this.read32FromEEPROM(444 + i * 4);
            int val = 0;
            switch (i) {
                case 0: {
                    val = (int)(axisLengths.x() * machineStepsPerMM.x());
                    break;
                }
                case 1: {
                    val = (int)(axisLengths.y() * machineStepsPerMM.y());
                    break;
                }
                case 2: {
                    val = (int)(axisLengths.z() * machineStepsPerMM.z());
                    break;
                }
                case 3: {
                    val = (int)(axisLengths.a() * machineStepsPerMM.a());
                    break;
                }
                case 4: {
                    val = (int)(axisLengths.b() * machineStepsPerMM.b());
                }
            }
            if (firmwareAxisLength == val) continue;
            Base.logger.info("Bot Length Axis " + i + ": " + firmwareAxisLength + " machine xml has: " + val + ", updating bot");
            this.write32ToEEPROM32(444 + i * 4, val);
            needsReset = true;
        }
        return needsReset;
    }

    public void queuePoint(Point5d p) throws RetryException {
        if (this.positionLost()) {
            super.queuePoint(p);
            return;
        }
        Point5d target = new Point5d(p);
        Point5d current = new Point5d(this.getPosition());
        Point5d deltaSteps = this.getAbsDeltaSteps(current, target);
        if (deltaSteps.length() > 0.0) {
            Point5d deltaMM = new Point5d();
            deltaMM.sub(target, current);
            target.setA(-deltaMM.a());
            target.setB(-deltaMM.b());
            Point5d delta3d = new Point5d();
            delta3d.setX(deltaMM.x());
            delta3d.setY(deltaMM.y());
            delta3d.setZ(deltaMM.z());
            double distance = delta3d.distance(new Point5d());
            Point5d deltaMMAbs = new Point5d(deltaMM);
            deltaMMAbs.absolute();
            double feedrate = this.getSafeFeedrate(deltaMMAbs);
            double minutes = distance / feedrate;
            if (minutes == 0.0) {
                distance = Math.max(Math.abs(deltaMM.a()), Math.abs(deltaMM.b()));
                minutes = distance / feedrate;
            }
            feedrate /= 60.0;
            Point5d stepsPerMM = this.machine.getStepsPerMM();
            Point5d excess = new Point5d(this.stepExcess);
            excess.setX(0.0);
            excess.setY(0.0);
            excess.setZ(0.0);
            Point5d steps = this.machine.mmToSteps(target, excess);
            excess.setX(0.0);
            excess.setY(0.0);
            excess.setZ(0.0);
            double usec = 6.0E7 * minutes;
            current.setA(0.0);
            current.setB(0.0);
            Point5d deltaStepsFinal = this.getAbsDeltaSteps(current, target);
            double dda_interval = usec / deltaStepsFinal.absolute_maximum();
            double dda_rate = 1000000.0 / dda_interval;
            int relativeAxes = 1 << AxisId.A.getIndex() | 1 << AxisId.B.getIndex();
            this.queueNewExtPoint(steps, (long)dda_rate, relativeAxes, (float)distance, (float)feedrate);
            this.pastExcess = new Point5d(this.stepExcess);
            this.stepExcess = excess;
            Point5d fakeOut = new Point5d(target);
            fakeOut.setA(p.a());
            fakeOut.setB(p.b());
            this.setInternalPosition(fakeOut);
        }
    }

    protected byte getColorBits(Color inputColor) {
        byte bitfield = 0;
        int red = inputColor.getRed();
        int green = inputColor.getGreen();
        int blue = inputColor.getBlue();
        bitfield = (byte)(bitfield | (byte)((blue >>= 6) << 4));
        bitfield = (byte)(bitfield | (byte)((green >>= 6) << 2));
        bitfield = (byte)(bitfield | (byte)(red >>= 6));
        return bitfield;
    }

    public void setLedStrip(Color color, int effectId) throws RetryException {
        Base.logger.fine("Sailfish sending setLedStrip");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.SET_LED_STRIP_COLOR.getCode());
        int Channel2 = 3;
        boolean Brightness = true;
        int BlinkRate = 0;
        int colorSelect = 63;
        colorSelect = this.getColorBits(color);
        pb.add8(color.getRed());
        pb.add8(color.getGreen());
        pb.add8(color.getBlue());
        pb.add8(BlinkRate);
        pb.add8(0);
        PacketResponse resp = this.runCommand(pb.getPacket());
        if (resp.isOK()) {
            Base.logger.fine("Sailfish setLedStrip went OK");
            this.ledColorByEffect.put(effectId, color);
        }
    }

    public void sendBeep(int frequencyHz, int durationMs, int effectId) throws RetryException {
        Base.logger.fine("Sailfish sending setBeep" + frequencyHz + durationMs + " effect" + effectId);
        Base.logger.fine("max 2147483647");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.SET_BEEP.getCode());
        pb.add16(frequencyHz);
        pb.add16(durationMs);
        pb.add8(effectId);
        PacketResponse resp = this.runCommand(pb.getPacket());
        if (resp.isOK()) {
            Base.logger.fine("Sailfish sendBeep went OK");
        }
    }

    public void enableMotor(int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        ToolModel curTool = this.machine.getTool(toolhead);
        Iterable<AxisId> axes = this.getHijackedAxes(curTool);
        EnumSet<AxisId> axesEnum = EnumSet.noneOf(AxisId.class);
        for (AxisId e : axes) {
            axesEnum.add(e);
        }
        this.enableAxes(axesEnum);
        curTool.enableMotor();
    }

    public void disableMotor(int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        ToolModel curTool = this.machine.getTool(toolhead);
        Iterable<AxisId> axes = this.getHijackedAxes(curTool);
        EnumSet<AxisId> axesEnum = EnumSet.noneOf(AxisId.class);
        for (AxisId e : axes) {
            axesEnum.add(e);
        }
        this.disableAxes(axesEnum);
        curTool.disableMotor();
    }

    public boolean hasToolheadsOffset() {
        return this.machine.getTools().size() != 1;
    }

    public double getToolheadsOffset(int axis) {
        Base.logger.finest("Sailfish getToolheadsOffset" + axis);
        if (axis < 0 || axis > 2) {
            Base.logger.severe("axis out of range" + axis);
            return 0.0;
        }
        this.checkEEPROM();
        double val = this.read32FromEEPROM(432 + axis * 4);
        ToolheadsOffset toolheadsOffset = this.getMachine().getToolheadsOffsets();
        Point5d stepsPerMM = this.getMachine().getStepsPerMM();
        switch (axis) {
            case 0: {
                val = val / stepsPerMM.x() / 10.0 + toolheadsOffset.x();
                break;
            }
            case 1: {
                val = val / stepsPerMM.y() / 10.0 + toolheadsOffset.y();
                break;
            }
            case 2: {
                val = val / stepsPerMM.z() / 10.0 + toolheadsOffset.z();
            }
        }
        return val;
    }

    public String getConfigValue(String key, String baseline) {
        if (this.getAccelerationStatus() != 0) {
            if (key.equals("desiredFeedrate")) {
                return "80";
            }
            if (key.equals("travelFeedrate")) {
                return "150";
            }
            if (key.equals("printTemp")) {
                return "240";
            }
        } else {
            if (key.equals("desiredFeedrate")) {
                return "40";
            }
            if (key.equals("travelFeedrate")) {
                return "55";
            }
            if (key.equals("printTemp")) {
                return "220";
            }
        }
        return baseline;
    }

    public void eepromStoreToolDelta(int axis, double distanceMm) {
        if (axis < 0 || axis > 2) {
            return;
        }
        int offsetSteps = 0;
        Point5d stepsPerMM = this.getMachine().getStepsPerMM();
        ToolheadsOffset toolheadsOffset = this.getMachine().getToolheadsOffsets();
        switch (axis) {
            case 0: {
                offsetSteps = (int)((distanceMm - toolheadsOffset.x()) * stepsPerMM.x() * 10.0);
                break;
            }
            case 1: {
                offsetSteps = (int)((distanceMm - toolheadsOffset.y()) * stepsPerMM.y() * 10.0);
                break;
            }
            case 2: {
                offsetSteps = (int)((distanceMm - toolheadsOffset.z()) * stepsPerMM.z() * 10.0);
            }
        }
        this.write32ToEEPROM32(432 + axis * 4, offsetSteps);
    }

    public byte getAccelerationStatus() {
        Base.logger.finest("Sailfish getAccelerationStatus");
        this.checkEEPROM();
        if (this.hasJettyAcceleration()) {
            byte[] val = this.readFromEEPROM(294, 1);
            return val[0];
        }
        return 0;
    }

    public void setAccelerationStatus(byte status) {
        Base.logger.info("Sailfish setAccelerationStatus");
        byte[] b = new byte[]{status};
        if (this.hasJettyAcceleration()) {
            this.writeToEEPROM(294, b);
        }
    }

    public int toolCountOnboard() {
        return this.toolCountOnboard;
    }

    public boolean verifyToolCount() {
        this.readToolheadCount();
        return this.toolCountOnboard == this.machine.getTools().size();
    }

    public boolean verifyMachineId() {
        if (this.machineId == VidPid.UNKNOWN) {
            this.readMachineVidPid();
        }
        return this.machineId.equals(VidPid.SAILFISH_G34);
    }

    public boolean canVerifyMachine() {
        return true;
    }

    public void readMachineVidPid() {
        this.checkEEPROM();
        byte[] b = this.readFromEEPROM(485, 4);
        this.machineId = VidPid.getPidVid(b);
    }

    private int read32FromEEPROM(int offset) {
        int val = 0;
        byte[] r = this.readFromEEPROM(offset, 4);
        if (r == null || r.length < 4) {
            Base.logger.severe("invalid read from read32FromEEPROM at " + offset);
            return val;
        }
        for (int i = 0; i < 4; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    private long read64FromEEPROM(int offset) {
        long val = 0L;
        byte[] r = this.readFromEEPROM(offset, 8);
        if (r == null || r.length < 8) {
            Base.logger.severe("invalid read from read64FromEEPROM at " + offset);
            return val;
        }
        for (int i = 0; i < 8; ++i) {
            val += ((long)r[i] & 0xFFL) << 8 * i;
        }
        return val;
    }

    private void write32ToEEPROM32(int offset, int value) {
        int s = value;
        byte[] buf = new byte[4];
        for (int i = 0; i < 4; ++i) {
            buf[i] = (byte)(s & 0xFF);
            s >>>= 8;
        }
        this.writeToEEPROM(offset, buf);
    }

    private void write64ToEEPROM64(int offset, long value) {
        long s = value;
        byte[] buf = new byte[8];
        for (int i = 0; i < 8; ++i) {
            buf[i] = (byte)(s & 0xFFL);
            s >>>= 8;
        }
        this.writeToEEPROM(offset, buf);
    }

    private int read16FromEEPROM(int offset) {
        int val = 0;
        byte[] r = this.readFromEEPROM(offset, 2);
        if (r == null || r.length < 2) {
            Base.logger.severe("invalid read from read16FromEEPROM at " + offset);
            return val;
        }
        for (int i = 0; i < 2; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    private void write16ToEEPROM(int offset, int value) {
        int s = value;
        byte[] buf = new byte[2];
        for (int i = 0; i < 2; ++i) {
            buf[i] = (byte)(s & 0xFF);
            s >>>= 8;
        }
        this.writeToEEPROM(offset, buf);
    }

    public void displayMessage(double seconds, String message, boolean buttonWait) throws RetryException {
        PacketBuilder pb;
        int options = 0;
        int MAX_MSG_PER_PACKET = 16;
        double timeout = 0.0;
        for (int sentTotal = 0; sentTotal < message.length(); sentTotal += pb.addString(message.substring(sentTotal), 16)) {
            pb = new PacketBuilder(MotherboardCommandCode.DISPLAY_MESSAGE.getCode());
            if (sentTotal + 16 >= message.length()) {
                timeout = seconds;
                options = (byte)(options | 2);
                if (buttonWait) {
                    options = (byte)(options | 4);
                }
            }
            if (sentTotal > 0) {
                options = (byte)(options | 1);
            }
            pb.add8(options);
            pb.add8(0);
            pb.add8(0);
            pb.add8((int)seconds);
            this.runCommand(pb.getPacket());
        }
    }

    public void sendBuildStartNotification(String buildName, int stepCount) throws RetryException {
        int MAX_MSG_PER_PACKET = 25;
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.BUILD_START_NOTIFICATION.getCode());
        pb.add32(stepCount);
        pb.addString(buildName, 25);
        this.runCommand(pb.getPacket());
    }

    public void sendBuildEndNotification(int endCode) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.BUILD_END_NOTIFICATION.getCode());
        pb.add8(endCode);
        this.runCommand(pb.getPacket());
    }

    public void updateBuildPercent(int percentDone) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.SET_BUILD_PERCENT.getCode());
        pb.add8(percentDone);
        pb.add8(255);
        this.runCommand(pb.getPacket());
    }

    public void playSong(int songId) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.QUEUE_SONG.getCode());
        pb.add8(songId);
        this.runCommand(pb.getPacket());
    }

    public void userPause(double seconds, boolean resetOnTimeout, int buttonMask) throws RetryException {
        int options = resetOnTimeout ? 1 : 0;
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.PAUSE_FOR_BUTTON.getCode());
        pb.add8(255);
        pb.add16((int)seconds);
        pb.add8(options);
        this.runCommand(pb.getPacket());
    }

    public void readToolheadCount() {
        byte[] toolCountByte = this.readFromEEPROM(430, 1);
        if (toolCountByte != null && toolCountByte.length > 0) {
            this.toolCountOnboard = toolCountByte[0];
        }
    }

    public int getToolheadCount() {
        if (this.toolCountOnboard == -1) {
            this.readToolheadCount();
        }
        return this.toolCountOnboard;
    }

    public boolean hasToolCountOnboard() {
        return true;
    }

    public void setToolCountOnboard(int i) {
        byte[] b = new byte[]{-1};
        if (i == 1 || i == 2) {
            b[0] = (byte)i;
        }
        this.writeToEEPROM(430, b);
    }

    private long readUInt32FromEEPROM(int offset) {
        byte[] r = this.readFromEEPROM(offset, 4);
        if (r == null || r.length < 4) {
            Base.logger.severe("invalid read from read32FromEEPROM at " + offset);
            return 0L;
        }
        long val = (long)r[0] & 0xFFL;
        val += ((long)r[1] & 0xFFL) << 8;
        val += ((long)r[2] & 0xFFL) << 16;
        return val += ((long)r[3] & 0xFFL) << 24;
    }

    private void writeUInt32ToEEPROM(int offset, long value) {
        int v = value > 0xFFFFFFFFL ? -1 : (value > 0L ? (int)(0xFFFFFFFFL & value) : 0);
        this.write32ToEEPROM32(offset, v);
    }

    private int getUInt8EEPROM(int offset) {
        byte[] val = this.readFromEEPROM(offset, 1);
        int i = (val[0] & 0x7F) + ((0x80 & val[0]) != 0 ? 128 : 0);
        return i;
    }

    private void setUInt8EEPROM(int offset, int val) {
        byte[] b = new byte[1];
        if (val > 255) {
            val = 255;
        }
        b[0] = (byte)(0xFF & val);
        this.writeToEEPROM(offset, b);
    }

    private long getUInt32EEPROM(int offset) {
        return this.readUInt32FromEEPROM(offset);
    }

    private void setUInt32EEPROM(int offset, long val) {
        this.writeUInt32ToEEPROM(offset, val);
    }

    public long getEEPROMParamUInt(OnboardParameters.EEPROMParams param) {
        switch (param) {
            case ACCEL_MAX_ACCELERATION_B: {
                return this.getUInt32EEPROM(422);
            }
            case ACCEL_EXTRUDER_DEPRIME_A: {
                return this.getUInt32EEPROM(389);
            }
            case ACCEL_EXTRUDER_DEPRIME_B: {
                return this.getUInt32EEPROM(426);
            }
        }
        return super.getEEPROMParamUInt(param);
    }

    public int getEEPROMParamInt(OnboardParameters.EEPROMParams param) {
        switch (param) {
            case ACCEL_SLOWDOWN_FLAG: {
                return this.getUInt8EEPROM(393);
            }
            case DITTO_PRINT_ENABLED: {
                return this.getUInt8EEPROM(476);
            }
            case EXTRUDER_HOLD: {
                return this.getUInt8EEPROM(489);
            }
            case TOOLHEAD_OFFSET_SYSTEM: {
                return this.getUInt8EEPROM(490);
            }
            case SD_USE_CRC: {
                return this.getUInt8EEPROM(491);
            }
            case PSTOP_ENABLE: {
                return this.getUInt8EEPROM(492);
            }
            case ENDSTOP_Z_MIN: {
                return this.getUInt8EEPROM(493);
            }
            case DEPRIME_ON_TRAVEL: {
                return this.getUInt8EEPROM(494);
            }
            case CLEAR_FOR_ESTOP: {
                return this.getUInt8EEPROM(495);
            }
            case ALEVEL_MAX_ZPROBE_HITS: {
                return this.getUInt8EEPROM(496);
            }
        }
        return super.getEEPROMParamInt(param);
    }

    public double getEEPROMParamFloat(OnboardParameters.EEPROMParams param) {
        switch (param) {
            case ACCEL_MAX_SPEED_CHANGE_B: {
                return (double)this.getUInt32EEPROM(418) / 10.0;
            }
            case ALEVEL_MAX_ZDELTA: {
                Point5d stepsPerMM = this.getMachine().getStepsPerMM();
                int val = this.read32FromEEPROM(498);
                double v = (double)val / stepsPerMM.z();
                Base.logger.severe("EEPROM -> val = " + val + "; stepsPerMM.z() = " + stepsPerMM.z() + "; value = " + v);
                return (double)val / stepsPerMM.z();
            }
        }
        return super.getEEPROMParamFloat(param);
    }

    public void setEEPROMParam(OnboardParameters.EEPROMParams param, int val) {
        if (val < 0) {
            val = 0;
        }
        switch (param) {
            case ACCEL_SLOWDOWN_FLAG: {
                this.setUInt8EEPROM(393, val != 0 ? 1 : 0);
                break;
            }
            case DITTO_PRINT_ENABLED: {
                this.setUInt8EEPROM(476, val != 0 ? 1 : 0);
                break;
            }
            case EXTRUDER_HOLD: {
                this.setUInt8EEPROM(489, val != 0 ? 1 : 0);
                break;
            }
            case TOOLHEAD_OFFSET_SYSTEM: {
                this.setUInt8EEPROM(490, val != 0 ? 1 : 0);
                break;
            }
            case SD_USE_CRC: {
                this.setUInt8EEPROM(491, val != 0 ? 1 : 0);
                break;
            }
            case PSTOP_ENABLE: {
                this.setUInt8EEPROM(492, val != 0 ? 1 : 0);
                break;
            }
            case ENDSTOP_Z_MIN: {
                this.setUInt8EEPROM(493, val != 0 ? 1 : 0);
                break;
            }
            case DEPRIME_ON_TRAVEL: {
                this.setUInt8EEPROM(494, val != 0 ? 1 : 0);
                break;
            }
            case CLEAR_FOR_ESTOP: {
                this.setUInt8EEPROM(495, val == 1 ? 1 : 0);
                break;
            }
            case ALEVEL_MAX_ZPROBE_HITS: {
                this.setUInt8EEPROM(496, val);
                break;
            }
            default: {
                super.setEEPROMParam(param, val);
            }
        }
    }

    public void setEEPROMParam(OnboardParameters.EEPROMParams param, long val) {
        if (val < 0L) {
            val = 0L;
        }
        switch (param) {
            case ACCEL_MAX_ACCELERATION_B: {
                this.setUInt32EEPROM(422, val);
                break;
            }
            case ACCEL_EXTRUDER_DEPRIME_A: {
                this.setUInt32EEPROM(389, val);
                break;
            }
            case ACCEL_EXTRUDER_DEPRIME_B: {
                this.setUInt32EEPROM(426, val);
                break;
            }
            default: {
                super.setEEPROMParam(param, val);
            }
        }
    }

    public void setEEPROMParam(OnboardParameters.EEPROMParams param, double val) {
        if (val < 0.0) {
            val = 0.0;
        }
        switch (param) {
            case ACCEL_MAX_SPEED_CHANGE_B: {
                this.setUInt32EEPROM(418, (long)(val * 10.0));
                break;
            }
            case ALEVEL_MAX_ZDELTA: {
                Point5d stepsPerMM = this.getMachine().getStepsPerMM();
                int ival = (int)(val * stepsPerMM.z());
                Base.logger.severe("EEPROM <- ival = " + ival + "; stepsPerMM.z() = " + stepsPerMM.z() + "; val = " + val);
                this.write32ToEEPROM32(498, ival);
                break;
            }
            default: {
                super.setEEPROMParam(param, val);
            }
        }
    }

    public boolean getPStop() {
        return 1 == this.getEEPROMParamInt(OnboardParameters.EEPROMParams.PSTOP_ENABLE);
    }

    public void setPStop(boolean enable) {
        this.setEEPROMParam(OnboardParameters.EEPROMParams.PSTOP_ENABLE, enable ? 1 : 0);
    }
}

