/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.gen3;

import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.vecmath.Point3d;
import replicatorg.app.Base;
import replicatorg.drivers.InteractiveDisplay;
import replicatorg.drivers.OnboardParameters;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.Version;
import replicatorg.drivers.gen3.Makerbot4GAlternateDriver;
import replicatorg.drivers.gen3.MightySailfish5XEEPROM;
import replicatorg.drivers.gen3.MotherboardCommandCode;
import replicatorg.drivers.gen3.PacketBuilder;
import replicatorg.drivers.gen3.PacketResponse;
import replicatorg.drivers.gen3.ToolCommandCode;
import replicatorg.drivers.gen3.VidPid;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.ToolModel;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MightySailfish
extends Makerbot4GAlternateDriver
implements InteractiveDisplay {
    private Hashtable ledColorByEffect;
    private Hashtable stepperValues;
    private int voltageReference;
    private boolean eepromChecked = false;
    protected static final int DEFAULT_RETRIES = 5;
    protected VidPid machineId = VidPid.UNKNOWN;
    protected int toolCountOnboard = -1;
    protected Version toolVersion = new Version(0, 0);

    @Override
    public boolean hasAdvancedFeatures() {
        return this.version.compareTo(this.getMinimumAdvancedFeatureVersion()) >= 0;
    }

    public MightySailfish() {
        this.absoluteXYZ = true;
        this.ledColorByEffect = new Hashtable();
        this.ledColorByEffect.put(0, Color.BLACK);
        Base.logger.info("Created a MightySailfish");
        this.stepperValues = new Hashtable();
        this.minimumVersion = new Version(5, 5);
        this.preferredVersion = new Version(6, 2);
        this.minimumAccelerationVersion = new Version(5, 3);
        this.minAdvancedFeatureVersion = new Version(6, 0);
        this.minimumJettyAccelerationVersion = new Version(6, 2);
    }

    @Override
    public String getDriverName() {
        return "MightySailfish";
    }

    @Override
    public void initSlave(int toolIndex) {
        ToolModel curTool = this.machine.getTool(toolIndex);
        curTool.setMotorSpeedReadingRPM(curTool.getMotorSpeedRPM());
    }

    @Override
    public boolean initializeBot() {
        for (ToolModel t : this.getMachine().getTools()) {
            if (t == null) continue;
            this.initSlave(t.getIndex());
        }
        this.getStepperValues();
        this.getMotorRPM();
        this.getAccelerationState();
        this.machineId = VidPid.UNKNOWN;
        if (!this.verifyMachineId()) {
            Base.logger.severe("Machine ID Mismatch. Please re-select your machine.");
            return true;
        }
        if (!this.verifyToolCount()) {
            Base.logger.severe("Tool Count Mismatch. Expecting " + this.machine.getTools().size() + " tools, reported " + this.toolCountOnboard + "tools");
            Base.logger.severe("Please double-check your selected machine.");
        }
        boolean needsReset = this.checkAndWriteStepsPerMM();
        needsReset |= this.checkAndWriteAxisLengths();
        if (needsReset |= this.checkAndWriteMaxFeedRates()) {
            this.setInitialized(true);
            this.reset();
            this.setInitialized(false);
        }
        return true;
    }

    public boolean getVersion_Adv() {
        return false;
    }

    public boolean getBuildStatistics_Adv() {
        return false;
    }

    public boolean getMotheboardModStats_Adv() {
        return false;
    }

    public boolean getToolheadStats_Adv() {
        return false;
    }

    public boolean getCommunicationStats() {
        return false;
    }

    private void getAccelerationState() {
        Base.logger.fine("Geting Acceleration Status from Bot");
        boolean bl = this.acceleratedFirmware = this.getAccelerationStatus() != 0;
        if (this.acceleratedFirmware) {
            Base.logger.finest("Found accelerated firmware active");
        }
    }

    private void getStepperValues() {
        int stepperCountMightyBoard = 5;
        Base.logger.fine("MightySailfish initial Sync");
        for (int i = 0; i < stepperCountMightyBoard; ++i) {
            int vRef = this.getStoredStepperVoltage(i);
            Base.logger.fine("Caching inital Stepper vRef from bot");
            Base.logger.finer("Stepper i = " + i + " vRef =" + vRef);
            this.stepperValues.put(new Integer(i), new Integer(vRef));
        }
    }

    @Override
    public void setStepperVoltage(int stepperId, int referenceValue) throws RetryException {
        Base.logger.fine("MightyBoard sending setStepperVoltage: " + stepperId + " " + referenceValue);
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.SET_STEPPER_REFERENCE_POT.getCode());
        if (stepperId > 5) {
            Base.logger.severe("set invalid stepper Id" + Integer.toString(stepperId));
            return;
        }
        if (referenceValue > 255) {
            referenceValue = 255;
        } else if (referenceValue < 0) {
            referenceValue = 0;
        }
        pb.add8(stepperId);
        pb.add8(referenceValue);
        PacketResponse pr = this.runCommand(pb.getPacket());
        if (pr.isOK()) {
            this.stepperValues.put(new Integer(stepperId), new Integer(referenceValue));
        }
    }

    @Override
    public int getStepperVoltage(int stepperId) {
        Integer key = new Integer(stepperId);
        if (this.stepperValues.containsKey(key)) {
            Integer stepperVal = (Integer)this.stepperValues.get(key);
            return stepperVal;
        }
        Base.logger.severe("No known local stepperVoltage: " + stepperId);
        return 0;
    }

    public boolean checkAndWriteStepsPerMM() {
        if (!this.hasJettyAcceleration()) {
            return false;
        }
        Point5d machineStepsPerMM = this.getMachine().getStepsPerMM();
        boolean needsReset = false;
        int stepperCountMightyBoard = 5;
        for (int i = 0; i < stepperCountMightyBoard; ++i) {
            double firmwareAxisStepsPerMM = this.read32FromEEPROM(420 + i * 4);
            double val = 0.0;
            switch (i) {
                case 0: {
                    val = machineStepsPerMM.x();
                    break;
                }
                case 1: {
                    val = machineStepsPerMM.y();
                    break;
                }
                case 2: {
                    val = machineStepsPerMM.z();
                    break;
                }
                case 3: {
                    val = machineStepsPerMM.a();
                    break;
                }
                case 4: {
                    val = machineStepsPerMM.b();
                }
            }
            val = (int)(val * 1000000.0);
            if (firmwareAxisStepsPerMM == val) continue;
            Base.logger.info("Bot StepsPerMM Axis " + i + ": " + firmwareAxisStepsPerMM / 1000000.0 + " machine xml has: " + val / 1000000.0 + ", updating bot");
            this.write32ToEEPROM32(420 + i * 4, (int)val);
            needsReset = true;
        }
        return needsReset;
    }

    public boolean checkAndWriteMaxFeedRates() {
        if (!this.hasJettyAcceleration()) {
            return false;
        }
        Point5d maximumFeedRates = this.getMachine().getMaximumFeedrates();
        boolean needsReset = false;
        int stepperCountMightyBoard = 5;
        for (int i = 0; i < stepperCountMightyBoard; ++i) {
            double firmwareAxisMaximumFeedRate = this.read32FromEEPROM(500 + i * 4);
            double val = 0.0;
            switch (i) {
                case 0: {
                    val = maximumFeedRates.x();
                    break;
                }
                case 1: {
                    val = maximumFeedRates.y();
                    break;
                }
                case 2: {
                    val = maximumFeedRates.z();
                    break;
                }
                case 3: {
                    val = maximumFeedRates.a();
                    break;
                }
                case 4: {
                    val = maximumFeedRates.b();
                }
            }
            if (firmwareAxisMaximumFeedRate == val) continue;
            Base.logger.info("Bot Maximum Feed Rate Axis " + i + ": " + firmwareAxisMaximumFeedRate + " machine xml has: " + val + ", updating bot");
            this.write32ToEEPROM32(500 + i * 4, (int)val);
            needsReset = true;
        }
        return needsReset;
    }

    public boolean checkAndWriteAxisLengths() {
        if (!this.hasJettyAcceleration()) {
            return false;
        }
        Point5d axisLengths = this.getMachine().getAxisLengths();
        Point5d machineStepsPerMM = this.getMachine().getStepsPerMM();
        boolean needsReset = false;
        int stepperCountMightyBoard = 5;
        for (int i = 0; i < stepperCountMightyBoard; ++i) {
            int firmwareAxisLength = this.read32FromEEPROM(396 + i * 4);
            int val = 0;
            switch (i) {
                case 0: {
                    val = (int)axisLengths.x();
                    break;
                }
                case 1: {
                    val = (int)axisLengths.y();
                    break;
                }
                case 2: {
                    val = (int)axisLengths.z();
                    break;
                }
                case 3: {
                    val = (int)axisLengths.a();
                    break;
                }
                case 4: {
                    val = (int)axisLengths.b();
                }
            }
            if (firmwareAxisLength == val) continue;
            Base.logger.info("Bot Length Axis " + i + ": " + firmwareAxisLength + " machine xml has: " + val + ", updating bot");
            this.write32ToEEPROM32(396 + i * 4, val);
            needsReset = true;
        }
        return needsReset;
    }

    @Override
    public boolean hasVrefSupport() {
        return true;
    }

    @Override
    public int getStoredStepperVoltage(int stepperId) {
        Base.logger.fine("Getting stored stepperVoltage: " + stepperId);
        int vRefForPotLocation = 6 + stepperId;
        Base.logger.finer("Getting stored stepperVoltage from eeprom addr: " + vRefForPotLocation);
        byte[] voltages = this.readFromEEPROM(vRefForPotLocation, 1);
        if (voltages == null) {
            Base.logger.severe("null response to EEPROM read at " + vRefForPotLocation);
            return 0;
        }
        return 0xFF & voltages[0];
    }

    @Override
    public void queuePoint(Point5d p) throws RetryException {
        if (this.positionLost()) {
            super.queuePoint(p);
            return;
        }
        Point5d target = new Point5d(p);
        Point5d current = new Point5d(this.getPosition());
        Point5d deltaSteps = this.getAbsDeltaSteps(current, target);
        if (deltaSteps.length() > 0.0) {
            Point5d deltaMM = new Point5d();
            deltaMM.sub(target, current);
            target.setA(-deltaMM.a());
            target.setB(-deltaMM.b());
            Point5d delta3d = new Point5d();
            delta3d.setX(deltaMM.x());
            delta3d.setY(deltaMM.y());
            delta3d.setZ(deltaMM.z());
            double distance = delta3d.distance(new Point5d());
            Point5d deltaMMAbs = new Point5d(deltaMM);
            deltaMMAbs.absolute();
            double feedrate = this.getSafeFeedrate(deltaMMAbs);
            double minutes = distance / feedrate;
            if (minutes == 0.0) {
                distance = Math.max(Math.abs(deltaMM.a()), Math.abs(deltaMM.b()));
                minutes = distance / feedrate;
            }
            feedrate /= 60.0;
            Point5d stepsPerMM = this.machine.getStepsPerMM();
            Point5d excess = new Point5d(this.stepExcess);
            excess.setX(0.0);
            excess.setY(0.0);
            excess.setZ(0.0);
            Point5d steps = this.machine.mmToSteps(target, excess);
            excess.setX(0.0);
            excess.setY(0.0);
            excess.setZ(0.0);
            double usec = 6.0E7 * minutes;
            current.setA(0.0);
            current.setB(0.0);
            Point5d deltaStepsFinal = this.getAbsDeltaSteps(current, target);
            double dda_interval = usec / deltaStepsFinal.absolute_maximum();
            double dda_rate = 1000000.0 / dda_interval;
            int relativeAxes = 1 << AxisId.A.getIndex() | 1 << AxisId.B.getIndex();
            if (this.isInitialized() && this.hasJettyAcceleration() && this.getBuildToFileVersion() == 0 || this.getBuildToFileVersion() >= 4) {
                this.queueNewExtPoint(steps, (long)dda_rate, relativeAxes, (float)distance, (float)feedrate);
            } else {
                this.queueNewPoint(steps, (long)usec, relativeAxes);
            }
            this.pastExcess = new Point5d(this.stepExcess);
            this.stepExcess = excess;
            Point5d fakeOut = new Point5d(target);
            fakeOut.setA(p.a());
            fakeOut.setB(p.b());
            this.setInternalPosition(fakeOut);
        }
    }

    @Override
    public void setStoredStepperVoltage(int stepperId, int referenceValue) {
        Base.logger.finer("MightySailfish sending storeStepperVoltage");
        if (stepperId > 5) {
            Base.logger.severe("store invalid stepper Id" + Integer.toString(stepperId));
            return;
        }
        if (referenceValue > 255) {
            referenceValue = 255;
        } else if (referenceValue < 0) {
            referenceValue = 0;
        }
        int vRefForPotLocation = 6 + stepperId;
        byte[] b = new byte[]{(byte)referenceValue};
        this.checkEEPROM();
        this.writeToEEPROM(vRefForPotLocation, b);
    }

    protected byte getColorBits(Color inputColor) {
        byte bitfield = 0;
        int red = inputColor.getRed();
        int green = inputColor.getGreen();
        int blue = inputColor.getBlue();
        bitfield = (byte)(bitfield | (byte)((blue >>= 6) << 4));
        bitfield = (byte)(bitfield | (byte)((green >>= 6) << 2));
        bitfield = (byte)(bitfield | (byte)(red >>= 6));
        return bitfield;
    }

    @Override
    public void setLedStrip(Color color, int effectId) throws RetryException {
        Base.logger.fine("MightySailfish sending setLedStrip");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.SET_LED_STRIP_COLOR.getCode());
        int Channel2 = 3;
        boolean Brightness = true;
        int BlinkRate = 0;
        int colorSelect = 63;
        colorSelect = this.getColorBits(color);
        pb.add8(color.getRed());
        pb.add8(color.getGreen());
        pb.add8(color.getBlue());
        pb.add8(BlinkRate);
        pb.add8(0);
        PacketResponse resp = this.runCommand(pb.getPacket());
        if (resp.isOK()) {
            Base.logger.fine("MightySailfish setLedStrip went OK");
            this.ledColorByEffect.put(effectId, color);
        }
    }

    @Override
    public void sendBeep(int frequencyHz, int durationMs, int effectId) throws RetryException {
        Base.logger.fine("MightySailfish sending setBeep" + frequencyHz + durationMs + " effect" + effectId);
        Base.logger.fine("max 2147483647");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.SET_BEEP.getCode());
        pb.add16(frequencyHz);
        pb.add16(durationMs);
        pb.add8(effectId);
        PacketResponse resp = this.runCommand(pb.getPacket());
        if (resp.isOK()) {
            Base.logger.fine("MightySailfish sendBeep went OK");
        }
    }

    private void checkEEPROM() {
        if (!this.eepromChecked) {
            this.eepromChecked = true;
            if (this.version.getMajor() < 2) {
                byte[] versionBytes = this.readFromEEPROM(0, 2);
                if (versionBytes == null || versionBytes.length < 2) {
                    return;
                }
                if (versionBytes[0] != 90 || versionBytes[1] != 120) {
                    Base.logger.severe("Cleaning EEPROM to v1.X state");
                    byte[] eepromWipe = new byte[16];
                    Arrays.fill(eepromWipe, (byte)0);
                    eepromWipe[0] = 90;
                    eepromWipe[1] = 120;
                    this.writeToEEPROM(0, eepromWipe);
                    Arrays.fill(eepromWipe, (byte)0);
                    for (int i = 16; i < 256; i += 16) {
                        this.writeToEEPROM(i, eepromWipe);
                    }
                }
                Base.logger.severe("checkEEPROM has version" + this.version.toString());
            }
        }
    }

    @Override
    public EnumSet<AxisId> getInvertedAxes() {
        this.checkEEPROM();
        byte[] b = this.readFromEEPROM(2, 1);
        EnumSet<AxisId> r = EnumSet.noneOf(AxisId.class);
        if (b != null) {
            if ((b[0] & 1) != 0) {
                r.add(AxisId.X);
            }
            if ((b[0] & 2) != 0) {
                r.add(AxisId.Y);
            }
            if ((b[0] & 4) != 0) {
                r.add(AxisId.Z);
            }
            if ((b[0] & 8) != 0) {
                r.add(AxisId.A);
            }
            if ((b[0] & 0x10) != 0) {
                r.add(AxisId.B);
            }
            if ((b[0] & 0x80) != 0) {
                r.add(AxisId.V);
            }
            return r;
        }
        Base.logger.severe("Null settings for getInvertedParameters");
        return EnumSet.noneOf(AxisId.class);
    }

    @Override
    public void setInvertedAxes(EnumSet<AxisId> axes) {
        byte[] b = new byte[1];
        if (axes.contains((Object)AxisId.X)) {
            b[0] = (byte)(b[0] | 1);
        }
        if (axes.contains((Object)AxisId.Y)) {
            b[0] = (byte)(b[0] | 2);
        }
        if (axes.contains((Object)AxisId.Z)) {
            b[0] = (byte)(b[0] | 4);
        }
        if (axes.contains((Object)AxisId.A)) {
            b[0] = (byte)(b[0] | 8);
        }
        if (axes.contains((Object)AxisId.B)) {
            b[0] = (byte)(b[0] | 0x10);
        }
        if (axes.contains((Object)AxisId.V)) {
            b[0] = (byte)(b[0] | 0x80);
        }
        this.writeToEEPROM(2, b);
    }

    @Override
    public String getMachineName() {
        if (this.botName != null) {
            return this.botName;
        }
        this.checkEEPROM();
        byte[] data = this.readFromEEPROM(34, 16);
        if (data == null) {
            return "no name";
        }
        try {
            String name;
            int len;
            for (len = 0; len < 16 && data[len] != 0; ++len) {
            }
            this.botName = name = new String(data, 0, len, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.botName;
    }

    @Override
    public void setMachineName(String machineName) {
        int maxLen = 16;
        if ((machineName = new String(machineName)).length() >= maxLen) {
            machineName = machineName.substring(0, maxLen - 1);
        }
        byte[] b = new byte[maxLen];
        int idx = 0;
        for (byte sb : machineName.getBytes()) {
            b[idx++] = sb;
            if (idx == maxLen) break;
        }
        if (idx < maxLen) {
            b[idx] = 0;
        } else {
            b[maxLen - 1] = 0;
        }
        this.writeToEEPROM(34, b);
    }

    @Override
    public double getAxisHomeOffset(int axis) {
        Base.logger.finest("MigtyBoard getAxisHomeOffset" + axis);
        if (axis < 0 || axis > 4) {
            Base.logger.severe("axis out of range" + axis);
            return 0.0;
        }
        this.checkEEPROM();
        double val = this.read32FromEEPROM(14 + axis * 4);
        Point5d stepsPerMM = this.getMachine().getStepsPerMM();
        switch (axis) {
            case 0: {
                val /= stepsPerMM.x();
                break;
            }
            case 1: {
                val /= stepsPerMM.y();
                break;
            }
            case 2: {
                val /= stepsPerMM.z();
                break;
            }
            case 3: {
                val /= stepsPerMM.a();
                break;
            }
            case 4: {
                val /= stepsPerMM.b();
            }
        }
        return val;
    }

    @Override
    public void setAxisHomeOffset(int axis, double offset) {
        if (axis < 0 || axis > 4) {
            return;
        }
        int offsetSteps = (int)offset;
        Point5d stepsPerMM = this.getMachine().getStepsPerMM();
        switch (axis) {
            case 0: {
                offsetSteps = (int)(offset * stepsPerMM.x());
                break;
            }
            case 1: {
                offsetSteps = (int)(offset * stepsPerMM.y());
                break;
            }
            case 2: {
                offsetSteps = (int)(offset * stepsPerMM.z());
                break;
            }
            case 3: {
                offsetSteps = (int)(offset * stepsPerMM.a());
                break;
            }
            case 4: {
                offsetSteps = (int)(offset * stepsPerMM.b());
            }
        }
        this.write32ToEEPROM32(14 + axis * 4, offsetSteps);
    }

    @Override
    public boolean hasToolheadsOffset() {
        return this.machine.getTools().size() != 1;
    }

    @Override
    public double getToolheadsOffset(int axis) {
        Base.logger.finest("MightySailfish getToolheadsOffset" + axis);
        if (axis < 0 || axis > 2) {
            Base.logger.severe("axis out of range" + axis);
            return 0.0;
        }
        this.checkEEPROM();
        double val = this.read32FromEEPROM(354 + axis * 4);
        Base.logger.fine("Reading tool " + axis + " offset of " + val + " steps");
        Point5d stepsPerMM = this.getMachine().getStepsPerMM();
        switch (axis) {
            case 0: {
                val /= stepsPerMM.x();
                break;
            }
            case 1: {
                val /= stepsPerMM.y();
                break;
            }
            case 2: {
                val /= stepsPerMM.z();
            }
        }
        return val;
    }

    @Override
    public String getConfigValue(String key, String baseline) {
        if (this.getAccelerationStatus() != 0) {
            if (key.equals("desiredFeedrate")) {
                return "80";
            }
            if (key.equals("travelFeedrate")) {
                return "150";
            }
            if (key.equals("printTemp")) {
                return "240";
            }
        } else {
            if (key.equals("desiredFeedrate")) {
                return "40";
            }
            if (key.equals("travelFeedrate")) {
                return "55";
            }
            if (key.equals("printTemp")) {
                return "220";
            }
        }
        return baseline;
    }

    @Override
    public void eepromStoreToolDelta(int axis, double distanceMm) {
        if (axis < 0 || axis > 2) {
            return;
        }
        int offsetSteps = 0;
        Point5d stepsPerMM = this.getMachine().getStepsPerMM();
        switch (axis) {
            case 0: {
                offsetSteps = (int)(distanceMm * stepsPerMM.x());
                break;
            }
            case 1: {
                offsetSteps = (int)(distanceMm * stepsPerMM.y());
                break;
            }
            case 2: {
                offsetSteps = (int)(distanceMm * stepsPerMM.z());
            }
        }
        Base.logger.fine("Sending tool " + axis + " offset of " + offsetSteps + "steps");
        this.write32ToEEPROM32(354 + axis * 4, offsetSteps);
    }

    @Override
    public int getAccelerationRate() {
        Base.logger.finest("MightySailfish getAccelerationRate");
        this.checkEEPROM();
        int val = this.read16FromEEPROM(368);
        return val;
    }

    @Override
    public void setAccelerationRate(int rate) {
        Base.logger.finest("MightySailfish setAccelerationRate");
        if (rate > Short.MAX_VALUE) {
            rate = Short.MAX_VALUE;
        }
        if (rate < Short.MIN_VALUE) {
            rate = Short.MIN_VALUE;
        }
        this.write16ToEEPROM(368, rate);
    }

    @Override
    public int getAxisAccelerationRate(int axis) {
        this.checkEEPROM();
        int val = this.read16FromEEPROM(370 + axis * 2);
        return val;
    }

    @Override
    public void setAxisAccelerationRate(int axis, int rate) {
        this.write16ToEEPROM(370 + axis * 2, rate);
    }

    @Override
    public int getAccelerationMinimumSpeed() {
        this.checkEEPROM();
        int val = this.read16FromEEPROM(390);
        return val;
    }

    @Override
    public void setAccelerationMinimumSpeed(int speed) {
        this.write16ToEEPROM(390, speed);
    }

    @Override
    public double getAxisJerk(int axis) {
        this.checkEEPROM();
        byte[] stored = this.readFromEEPROM(380 + axis * 2, 2);
        double val = this.byte16LEToFloat(stored);
        return val;
    }

    @Override
    public void setAxisJerk(int axis, double jerk) {
        this.writeToEEPROM(380 + axis * 2, this.floatToLE((float)jerk));
    }

    @Override
    public byte getAccelerationStatus() {
        Base.logger.finest("MightySailfish getAccelerationStatus");
        this.checkEEPROM();
        byte[] val = this.hasJettyAcceleration() ? this.readFromEEPROM(366, 1) : this.readFromEEPROM(366, 1);
        return val[0];
    }

    @Override
    public void setAccelerationStatus(byte status) {
        Base.logger.info("MightySailfish setAccelerationStatus");
        byte[] b = new byte[]{status};
        if (this.hasJettyAcceleration()) {
            this.writeToEEPROM(366, b);
        } else {
            this.writeToEEPROM(366, b);
        }
    }

    public void createThermistorTable(int which, double r0, double t0, double beta) {
        int ADC_RANGE = 1024;
        int NUMTEMPS = 20;
        byte[] table = new byte[80];
        class ThermistorConverter {
            final double ZERO_C_IN_KELVIN = 273.15;
            public double vadc;
            public double rs;
            public double vs;
            public double k;
            public double beta;

            public ThermistorConverter(double r0, double t0C, double beta, double r2) {
                this.beta = beta;
                this.vadc = 5.0;
                this.vs = 5.0;
                double t0K = 273.15 + t0C;
                this.k = r0 * Math.exp(-beta / t0K);
                this.rs = r2;
            }

            public double temp(double adc) {
                double v = adc * this.vadc / 1024.0;
                double r = this.rs * v / (this.vs - v);
                return this.beta / Math.log(r / this.k) - 273.15;
            }
        }
        ThermistorConverter tc = new ThermistorConverter(r0, t0, beta, 4700.0);
        double adc = 1.0;
        for (int i = 0; i < 20; ++i) {
            double temp = tc.temp(adc);
            int tempi = (int)temp;
            int adci = (int)adc;
            Base.logger.fine("{ " + Integer.toString(adci) + "," + Integer.toString(tempi) + " }");
            table[4 * i + 0] = (byte)(adci & 0xFF);
            table[4 * i + 1] = (byte)(adci >> 8);
            table[4 * i + 2] = (byte)(tempi & 0xFF);
            table[4 * i + 3] = (byte)(tempi >> 8);
            adc += 53.0;
        }
        byte[] eepromIndicator = new byte[]{90, 120};
        this.writeToToolEEPROM(0, eepromIndicator);
        this.writeToEEPROM(MightySailfish5XEEPROM.ECThermistorOffsets.beta(which), this.intToLE((int)beta));
        this.writeToEEPROM(MightySailfish5XEEPROM.ECThermistorOffsets.r0(which), this.intToLE((int)r0));
        this.writeToEEPROM(MightySailfish5XEEPROM.ECThermistorOffsets.t0(which), this.intToLE((int)t0));
        this.writeToEEPROM(MightySailfish5XEEPROM.ECThermistorOffsets.data(which), table);
    }

    @Override
    public int getBeta(int which, int toolIndex) {
        Base.logger.severe("beta for " + Integer.toString(toolIndex));
        byte[] r = this.readFromEEPROM(MightySailfish5XEEPROM.ECThermistorOffsets.beta(which), 4);
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    @Override
    public OnboardParameters.EndstopType getInvertedEndstops() {
        this.checkEEPROM();
        byte[] b = this.readFromEEPROM(4, 1);
        return OnboardParameters.EndstopType.endstopTypeForValue(b[0]);
    }

    @Override
    public void setInvertedEndstops(OnboardParameters.EndstopType endstops) {
        byte[] b = new byte[]{endstops.getValue()};
        this.writeToEEPROM(4, b);
    }

    @Override
    @Deprecated
    public OnboardParameters.ExtraFeatures getExtraFeatures(int toolIndex) {
        Base.logger.severe("extra Feat: " + Integer.toString(toolIndex));
        int efdat = this.read16FromToolEEPROM(0, 16516, toolIndex);
        OnboardParameters.ExtraFeatures ef = new OnboardParameters.ExtraFeatures();
        ef.swapMotorController = (efdat & 1) != 0;
        ef.heaterChannel = efdat >> 2 & 3;
        ef.hbpChannel = efdat >> 4 & 3;
        ef.abpChannel = efdat >> 6 & 3;
        return ef;
    }

    public void setExtraFeatures(OnboardParameters.ExtraFeatures features) {
        int efdat = 16384;
        if (features.swapMotorController) {
            efdat |= 1;
        }
        efdat |= features.heaterChannel << 2;
        efdat |= features.hbpChannel << 4;
        this.writeToToolEEPROM(0, this.intToLE(efdat |= features.abpChannel << 6, 2));
    }

    @Override
    public OnboardParameters.EstopType getEstopConfig() {
        return OnboardParameters.EstopType.NOT_PRESENT;
    }

    @Override
    public void setEstopConfig(OnboardParameters.EstopType estop) {
    }

    public void readMachineVidPid() {
        this.checkEEPROM();
        byte[] b = this.readFromEEPROM(68, 4);
        this.machineId = VidPid.getPidVid(b);
    }

    @Override
    public int toolCountOnboard() {
        return this.getToolheadCount();
    }

    public boolean verifyToolCount() {
        this.readToolheadCount();
        return this.toolCountOnboard == this.machine.getTools().size();
    }

    @Override
    public boolean verifyMachineId() {
        if (this.machineId == VidPid.UNKNOWN) {
            this.readMachineVidPid();
        }
        return this.machineId.equals(VidPid.MIGHTY_BOARD) || this.machineId.equals(VidPid.THE_REPLICATOR) || this.machineId.equals(VidPid.REPLICATOR_2) || this.machineId.equals(VidPid.REPLICATOR_2h) || this.machineId.equals(VidPid.REPLICATOR_2X);
    }

    @Override
    public boolean canVerifyMachine() {
        return true;
    }

    @Override
    public boolean setConnectedToolIndex(int index) {
        byte[] data = new byte[]{(byte)index};
        Base.logger.severe("setConnectedToolIndex not supported in MightySailfish");
        return false;
    }

    @Override
    @Deprecated
    protected void writeToToolEEPROM(int offset, byte[] data) {
        this.writeToToolEEPROM(offset, data, this.machine.currentTool().getIndex());
    }

    @Override
    protected void writeToToolEEPROM(int offset, byte[] data, int toolIndex) {
        int MAX_PAYLOAD = 11;
        while (data.length > 11) {
            byte[] head = new byte[11];
            byte[] tail = new byte[data.length - 11];
            System.arraycopy(data, 0, head, 0, 11);
            System.arraycopy(data, 11, tail, 0, data.length - 11);
            this.writeToToolEEPROM(offset, head, toolIndex);
            offset += 11;
            data = tail;
        }
        PacketBuilder slavepb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        slavepb.add8((byte)toolIndex);
        slavepb.add8(ToolCommandCode.WRITE_TO_EEPROM.getCode());
        slavepb.add16(offset);
        slavepb.add8(data.length);
        for (byte b : data) {
            slavepb.add8(b);
        }
        PacketResponse slavepr = this.runQuery(slavepb.getPacket());
        slavepr.printDebug();
        assert (toolIndex == 255 || toolIndex == 127 || slavepr.get8() == data.length);
    }

    @Override
    protected byte[] readFromToolEEPROM(int offset, int len, int toolIndex) {
        int toolInfoOffset = 0;
        if (toolIndex == 0) {
            toolInfoOffset = 256;
        } else if (toolIndex == 1) {
            toolInfoOffset = 284;
        }
        offset = toolInfoOffset + offset;
        Base.logger.finest("readFromToolEEPROM null" + offset + " " + len + " " + toolIndex);
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.READ_EEPROM.getCode());
        pb.add16(offset);
        pb.add8(len);
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.isOK()) {
            Base.logger.finest("readFromToolEEPROM ok at: " + offset + " len:" + len + " id:" + toolIndex);
            int rvlen = Math.min(pr.getPayload().length - 1, len);
            byte[] rv = new byte[rvlen];
            System.arraycopy(pr.getPayload(), 1, rv, 0, rvlen);
            return rv;
        }
        Base.logger.severe("On tool read: " + pr.getResponseCode().getMessage());
        Base.logger.severe("readFromToolEEPROM null" + offset + " " + len + " " + toolIndex);
        return null;
    }

    @Override
    public void enableMotor(int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        ToolModel curTool = this.machine.getTool(toolhead);
        Iterable<AxisId> axes = this.getHijackedAxes(curTool);
        EnumSet<AxisId> axesEnum = EnumSet.noneOf(AxisId.class);
        for (AxisId e : axes) {
            axesEnum.add(e);
        }
        this.enableAxes(axesEnum);
        curTool.enableMotor();
    }

    @Override
    public void disableMotor(int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        ToolModel curTool = this.machine.getTool(toolhead);
        Iterable<AxisId> axes = this.getHijackedAxes(curTool);
        EnumSet<AxisId> axesEnum = EnumSet.noneOf(AxisId.class);
        for (AxisId e : axes) {
            axesEnum.add(e);
        }
        this.disableAxes(axesEnum);
        curTool.disableMotor();
    }

    @Override
    public boolean getCoolingFanEnabled(int toolIndex) {
        Base.logger.severe("getCoolingFanEnable: " + Integer.toString(toolIndex));
        byte[] a = this.readFromToolEEPROM(26, 1, toolIndex);
        return a[0] == 1;
    }

    @Override
    public int getR0(int which, int toolIndex) {
        Base.logger.severe("getR0: " + Integer.toString(toolIndex));
        byte[] r = this.readFromEEPROM(MightySailfish5XEEPROM.ECThermistorOffsets.r0(which), 4);
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    @Override
    public int getT0(int which, int toolIndex) {
        Base.logger.severe("getT0: " + Integer.toString(toolIndex));
        byte[] r = this.readFromEEPROM(MightySailfish5XEEPROM.ECThermistorOffsets.t0(which), 4);
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    @Override
    @Deprecated
    protected int read16FromToolEEPROM(int offset, int defaultValue) {
        return this.read16FromToolEEPROM(offset, defaultValue, this.machine.currentTool().getIndex());
    }

    @Override
    @Deprecated
    protected int read16FromToolEEPROM(int offset, int defaultValue, int toolIndex) {
        byte[] r = this.readFromToolEEPROM(offset, 2, toolIndex);
        int val = r[0] & 0xFF;
        Base.logger.severe("val " + val + " & " + (r[1] & 0xFF));
        if ((val += (r[1] & 0xFF) << 8) == 65535) {
            Base.logger.fine("ERROR: Eeprom val at " + offset + " is 0xFFFF");
            return defaultValue;
        }
        return val;
    }

    @Override
    @Deprecated
    public OnboardParameters.BackoffParameters getBackoffParameters(int toolIndex) {
        OnboardParameters.BackoffParameters bp = new OnboardParameters.BackoffParameters();
        Base.logger.severe("backoff Forward: " + Integer.toString(toolIndex));
        bp.forwardMs = this.read16FromToolEEPROM(6, 300, toolIndex);
        Base.logger.severe("backoff sop: " + Integer.toString(toolIndex));
        bp.stopMs = this.read16FromToolEEPROM(2, 5, toolIndex);
        Base.logger.severe("backoff reverse: " + Integer.toString(toolIndex));
        bp.reverseMs = this.read16FromToolEEPROM(4, 500, toolIndex);
        Base.logger.severe("backoff trigger: " + Integer.toString(toolIndex));
        bp.triggerMs = this.read16FromToolEEPROM(8, 300, toolIndex);
        return bp;
    }

    @Override
    @Deprecated
    public void setBackoffParameters(OnboardParameters.BackoffParameters bp, int toolIndex) {
        this.writeToToolEEPROM(6, this.intToLE(bp.forwardMs, 2), toolIndex);
        this.writeToToolEEPROM(2, this.intToLE(bp.stopMs, 2), toolIndex);
        this.writeToToolEEPROM(4, this.intToLE(bp.reverseMs, 2), toolIndex);
        this.writeToToolEEPROM(8, this.intToLE(bp.triggerMs, 2), toolIndex);
    }

    @Override
    public OnboardParameters.PIDParameters getPIDParameters(int which, int toolIndex) {
        OnboardParameters.PIDParameters pp = new OnboardParameters.PIDParameters();
        int offset = 256;
        if (toolIndex == 1) {
            offset = 284;
        }
        Base.logger.finest("pid p: " + Integer.toString(toolIndex));
        byte[] stored = this.readFromEEPROM(offset + 10, 2);
        pp.p = this.byte16LEToFloat(stored);
        Base.logger.finest("pid i: " + Integer.toString(toolIndex));
        stored = this.readFromEEPROM(offset + 12, 2);
        pp.i = this.byte16LEToFloat(stored);
        Base.logger.finest("pid d: " + Integer.toString(toolIndex));
        stored = this.readFromEEPROM(offset + 14, 2);
        pp.d = this.byte16LEToFloat(stored);
        return pp;
    }

    @Override
    public void setPIDParameters(int which, OnboardParameters.PIDParameters pp, int toolIndex) {
        int offset = 256;
        if (toolIndex == 1) {
            offset = 284;
        }
        this.writeToEEPROM(offset + 10, this.floatToLE(pp.p));
        this.writeToEEPROM(offset + 12, this.floatToLE(pp.i));
        this.writeToEEPROM(offset + 14, this.floatToLE(pp.d));
    }

    private float readFloat16FromToolEEPROM(int offset, float defaultValue, int toolIndex) {
        byte[] r = this.readFromToolEEPROM(offset, 2, toolIndex);
        Base.logger.finest("val " + (r[0] & 0xFF) + " & " + (r[1] & 0xFF));
        if (r[0] == -1 && r[1] == -1) {
            Base.logger.fine("ERROR: Eeprom  float 16 val at " + offset + " is 0xFFFF");
            return defaultValue;
        }
        return (float)this.byteToInt(r[0]) + (float)this.byteToInt(r[1]) / 256.0f;
    }

    private int byteToInt(byte b) {
        return b & 0xFF;
    }

    private int read32FromEEPROM(int offset) {
        int val = 0;
        byte[] r = this.readFromEEPROM(offset, 4);
        if (r == null || r.length < 4) {
            Base.logger.severe("invalid read from read32FromEEPROM at " + offset);
            return val;
        }
        for (int i = 0; i < 4; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    private void write32ToEEPROM32(int offset, int value) {
        int s = value;
        byte[] buf = new byte[4];
        for (int i = 0; i < 4; ++i) {
            buf[i] = (byte)(s & 0xFF);
            s >>>= 8;
        }
        this.writeToEEPROM(offset, buf);
    }

    private int read16FromEEPROM(int offset) {
        int val = 0;
        byte[] r = this.readFromEEPROM(offset, 2);
        if (r == null || r.length < 2) {
            Base.logger.severe("invalid read from read16FromEEPROM at " + offset);
            return val;
        }
        for (int i = 0; i < 2; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    private void write16ToEEPROM(int offset, int value) {
        int s = value;
        byte[] buf = new byte[2];
        for (int i = 0; i < 2; ++i) {
            buf[i] = (byte)(s & 0xFF);
            s >>>= 8;
        }
        this.writeToEEPROM(offset, buf);
    }

    @Override
    public void resetSettingsToFactory() throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.RESET_TO_FACTORY.getCode());
        pb.add8(-1);
        pb.add8(ToolCommandCode.GET_PLATFORM_SP.getCode());
        PacketResponse pr = this.runCommand(pb.getPacket());
    }

    @Override
    public void resetToolToFactory(int toolIndex) {
    }

    @Override
    public void resetSettingsToBlank() throws RetryException {
        Base.logger.finer("resetting to Blank in Sanguino3G");
        byte[] eepromWipe = new byte[16];
        Arrays.fill(eepromWipe, (byte)-1);
        for (int i = 0; i < 512; i += 16) {
            this.writeToEEPROM(i, eepromWipe);
        }
    }

    @Override
    public void setExtraFeatures(OnboardParameters.ExtraFeatures features, int toolIndex) {
        int efdat = 16384;
        if (features.swapMotorController) {
            efdat |= 1;
        }
        efdat |= features.heaterChannel << 2;
        efdat |= features.hbpChannel << 4;
        this.writeToToolEEPROM(22, this.intToLE(efdat |= features.abpChannel << 6, 2), toolIndex);
    }

    @Override
    public double getPlatformTemperatureSetting(int toolhead) {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.GET_PLATFORM_SP.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        int sp = pr.get16();
        this.machine.getTool(toolhead).setPlatformTargetTemperature(sp);
        return this.machine.getTool(toolhead).getPlatformTargetTemperature();
    }

    @Override
    public void displayMessage(double seconds, String message, boolean buttonWait) throws RetryException {
        PacketBuilder pb;
        int options = 0;
        int MAX_MSG_PER_PACKET = 20;
        double timeout = 0.0;
        for (int sentTotal = 0; sentTotal < message.length(); sentTotal += pb.addString(message.substring(sentTotal), 20)) {
            pb = new PacketBuilder(MotherboardCommandCode.DISPLAY_MESSAGE.getCode());
            if (sentTotal + 20 >= message.length()) {
                timeout = seconds;
                options = (byte)(options | 2);
                if (buttonWait) {
                    options = (byte)(options | 4);
                }
            }
            if (sentTotal > 0) {
                options = (byte)(options | 1);
            }
            pb.add8(options);
            pb.add8(0);
            pb.add8(0);
            pb.add8((int)seconds);
            this.runCommand(pb.getPacket());
        }
    }

    @Override
    public void sendBuildStartNotification(String buildName, int stepCount) throws RetryException {
        int MAX_MSG_PER_PACKET = 25;
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.BUILD_START_NOTIFICATION.getCode());
        pb.add32(stepCount);
        pb.addString(buildName, 25);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void sendBuildEndNotification(int endCode) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.BUILD_END_NOTIFICATION.getCode());
        pb.add8(endCode);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void updateBuildPercent(int percentDone) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.SET_BUILD_PERCENT.getCode());
        pb.add8(percentDone);
        pb.add8(255);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void playSong(int songId) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.QUEUE_SONG.getCode());
        pb.add8(songId);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void userPause(double seconds, boolean resetOnTimeout, int buttonMask) throws RetryException {
        int options = resetOnTimeout ? 1 : 0;
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.PAUSE_FOR_BUTTON.getCode());
        pb.add8(255);
        pb.add16((int)seconds);
        pb.add8(options);
        this.runCommand(pb.getPacket());
    }

    @Override
    public double getTemperatureSetting(int toolhead) {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.GET_SP.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        int sp = pr.get16();
        this.machine.getTool(toolhead).setTargetTemperature(sp);
        return this.machine.getTool(toolhead).getTargetTemperature();
    }

    @Override
    public Version getToolVersion() {
        return this.toolVersion;
    }

    @Override
    public void setMotorRPM(double rpm, int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        ToolModel curTool = this.machine.getTool(toolhead);
        curTool.setMotorSpeedRPM(rpm);
    }

    @Override
    public void requestToolChange(int toolhead, int timeout) throws RetryException {
        this.selectTool(toolhead);
        Base.logger.fine("Waiting for tool #" + toolhead);
        if (this.machine.getTool(toolhead).getTargetTemperature() > 0.0) {
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.WAIT_FOR_TOOL.getCode());
            pb.add8((byte)toolhead);
            pb.add16(100);
            pb.add16(timeout);
            this.runCommand(pb.getPacket());
        }
        boolean needsToHeatHPB = false;
        int toolheadWithHBP = -1;
        for (ToolModel t : this.machine.getTools()) {
            if (!t.hasHeatedPlatform() || !(t.getPlatformTargetTemperature() > 0.0)) continue;
            toolheadWithHBP = t.getIndex();
            needsToHeatHPB = true;
        }
        if (needsToHeatHPB && toolheadWithHBP > -1) {
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.WAIT_FOR_PLATFORM.getCode());
            pb.add8((byte)toolheadWithHBP);
            pb.add16(100);
            pb.add16(timeout);
            this.runCommand(pb.getPacket());
        }
    }

    @Override
    public String getMachineType() {
        if (this.machineId.equals(VidPid.MIGHTY_BOARD)) {
            return "MightyBoard";
        }
        if (this.machineId.equals(VidPid.THE_REPLICATOR)) {
            return "The Replicator";
        }
        if (this.machineId.equals(VidPid.REPLICATOR_2) || this.machineId.equals(VidPid.REPLICATOR_2h)) {
            return "Replicator 2";
        }
        if (this.machineId.equals(VidPid.REPLICATOR_2X)) {
            return "Replicator 2X";
        }
        return "MightyBoard(unverified)";
    }

    public void readToolheadCount() {
        byte[] toolCountByte = this.readFromEEPROM(66, 1);
        if (toolCountByte != null && toolCountByte.length > 0) {
            this.toolCountOnboard = toolCountByte[0];
        }
    }

    public int getToolheadCount() {
        if (this.toolCountOnboard == -1) {
            this.readToolheadCount();
        }
        return this.toolCountOnboard;
    }

    @Override
    public boolean hasToolCountOnboard() {
        return true;
    }

    @Override
    public void setToolCountOnboard(int i) {
        byte[] b = new byte[]{-1};
        if (i == 1 || i == 2) {
            b[0] = (byte)i;
        }
        this.writeToEEPROM(66, b);
    }

    @Override
    public Point3d getOffset(int i) {
        if (!this.hasAdvancedFeatures()) {
            return this.offsets[i];
        }
        return this.offsets[0];
    }

    @Override
    public void setOffsetX(int offsetSystemNum, double j) {
        if (!this.hasAdvancedFeatures()) {
            this.offsets[offsetSystemNum].x = j;
        } else {
            Base.logger.info("offsets deprecated in firmware: " + this.version.toString());
        }
    }

    @Override
    public void setOffsetY(int offsetSystemNum, double j) {
        if (!this.hasAdvancedFeatures()) {
            this.offsets[offsetSystemNum].y = j;
        } else {
            Base.logger.info("offsets deprecated in firmware: " + this.version.toString());
        }
    }

    @Override
    public void setOffsetZ(int offsetSystemNum, double j) {
        if (!this.hasAdvancedFeatures()) {
            this.offsets[offsetSystemNum].z = j;
        } else {
            Base.logger.info("offsets deprecated in firmware: " + this.version.toString());
        }
    }

    @Override
    public boolean hasHbp() {
        return this.getEEPROMParamInt(OnboardParameters.EEPROMParams.HBP_PRESENT) == 1;
    }

    @Override
    public void setHbpSetting(boolean on_off) {
        this.setEEPROMParam(OnboardParameters.EEPROMParams.HBP_PRESENT, on_off ? 1 : 0);
    }

    private long readUInt32FromEEPROM(int offset) {
        byte[] r = this.readFromEEPROM(offset, 4);
        if (r == null || r.length < 4) {
            Base.logger.severe("invalid read from read32FromEEPROM at " + offset);
            return 0L;
        }
        long val = (long)r[0] & 0xFFL;
        val += ((long)r[1] & 0xFFL) << 8;
        val += ((long)r[2] & 0xFFL) << 16;
        return val += ((long)r[3] & 0xFFL) << 24;
    }

    private void writeUInt32ToEEPROM(int offset, long value) {
        int v = value > 0xFFFFFFFFL ? -1 : (value > 0L ? (int)(0xFFFFFFFFL & value) : 0);
        this.write32ToEEPROM32(offset, v);
    }

    private int getUInt8EEPROM(int offset) {
        byte[] val = this.readFromEEPROM(offset, 1);
        int i = (val[0] & 0x7F) + ((0x80 & val[0]) != 0 ? 128 : 0);
        return i;
    }

    private void setUInt8EEPROM(int offset, int val) {
        byte[] b = new byte[1];
        if (val > 255) {
            val = 255;
        }
        b[0] = (byte)(0xFF & val);
        this.writeToEEPROM(offset, b);
    }

    private long getUInt32EEPROM(int offset) {
        return this.readUInt32FromEEPROM(offset);
    }

    private void setUInt32EEPROM(int offset, long val) {
        this.writeUInt32ToEEPROM(offset, val);
    }

    @Override
    public int getEEPROMParamInt(OnboardParameters.EEPROMParams param) {
        switch (param) {
            case ACCEL_EXTRUDER_DEPRIME_A: {
                return this.read16FromEEPROM(480);
            }
            case ACCEL_EXTRUDER_DEPRIME_B: {
                return this.read16FromEEPROM(482);
            }
            case ACCEL_MAX_ACCELERATION_A: {
                return this.read16FromEEPROM(376);
            }
            case ACCEL_MAX_ACCELERATION_B: {
                return this.read16FromEEPROM(378);
            }
            case ACCEL_MAX_ACCELERATION_X: {
                return this.read16FromEEPROM(370);
            }
            case ACCEL_MAX_ACCELERATION_Y: {
                return this.read16FromEEPROM(372);
            }
            case ACCEL_MAX_ACCELERATION_Z: {
                return this.read16FromEEPROM(374);
            }
            case ACCEL_MAX_EXTRUDER_NORM: {
                return this.read16FromEEPROM(368);
            }
            case ACCEL_MAX_EXTRUDER_RETRACT: {
                return this.read16FromEEPROM(390);
            }
            case ACCEL_MAX_SPEED_CHANGE_A: {
                return this.read16FromEEPROM(386);
            }
            case ACCEL_MAX_SPEED_CHANGE_B: {
                return this.read16FromEEPROM(388);
            }
            case ACCEL_MAX_SPEED_CHANGE_X: {
                return this.read16FromEEPROM(380);
            }
            case ACCEL_MAX_SPEED_CHANGE_Y: {
                return this.read16FromEEPROM(382);
            }
            case ACCEL_MAX_SPEED_CHANGE_Z: {
                return this.read16FromEEPROM(384);
            }
            case ACCEL_SLOWDOWN_FLAG: {
                return this.getUInt8EEPROM(484);
            }
            case ALEVEL_MAX_ZPROBE_HITS: {
                return this.getUInt8EEPROM(3940);
            }
            case PREHEAT_DURING_PAUSE: {
                return this.getUInt8EEPROM(4094);
            }
            case OVERRIDE_GCODE_TEMP: {
                return this.getUInt8EEPROM(4093);
            }
            case EXTRUDER_HOLD: {
                return this.getUInt8EEPROM(3986);
            }
            case TOOLHEAD_OFFSET_SYSTEM: {
                return this.getUInt8EEPROM(3987);
            }
            case SD_USE_CRC: {
                return this.getUInt8EEPROM(3985);
            }
            case PSTOP_ENABLE: {
                return this.getUInt8EEPROM(3984);
            }
            case HBP_PRESENT: {
                return this.getUInt8EEPROM(76);
            }
            case MOOD_LIGHT_SCRIPT: {
                return this.getUInt8EEPROM(320);
            }
            case MOOD_LIGHT_SHOW_HEATING: {
                return this.getUInt8EEPROM(322);
            }
            case MOOD_LIGHT_CUSTOM_RED: {
                return this.getUInt8EEPROM(324);
            }
            case MOOD_LIGHT_CUSTOM_GREEN: {
                return this.getUInt8EEPROM(325);
            }
            case MOOD_LIGHT_CUSTOM_BLUE: {
                return this.getUInt8EEPROM(326);
            }
            case DEPRIME_ON_TRAVEL: {
                return this.getUInt8EEPROM(523);
            }
            case CLEAR_FOR_ESTOP: {
                return this.getUInt8EEPROM(3982);
            }
            case ENABLE_ALTERNATE_UART: {
                return this.getUInt8EEPROM(3983);
            }
        }
        Base.logger.log(Level.WARNING, "getEEPROMParamInt(" + (Object)((Object)param) + ") call failed");
        return 0;
    }

    @Override
    public long getEEPROMParamUInt(OnboardParameters.EEPROMParams param) {
        switch (param) {
            default: 
        }
        Base.logger.log(Level.WARNING, "getEEPROMParamUInt(" + (Object)((Object)param) + ") call failed");
        return 0L;
    }

    @Override
    public double getEEPROMParamFloat(OnboardParameters.EEPROMParams param) {
        switch (param) {
            case ACCEL_ADVANCE_K: {
                return (double)this.getUInt32EEPROM(472) / 100000.0;
            }
            case ACCEL_ADVANCE_K2: {
                return (double)this.getUInt32EEPROM(476) / 100000.0;
            }
            case ALEVEL_MAX_ZDELTA: {
                Point5d stepsPerMM = this.getMachine().getStepsPerMM();
                int val = this.read32FromEEPROM(3942);
                return (double)val / stepsPerMM.z();
            }
        }
        Base.logger.log(Level.WARNING, "getEEPROMParamFloat(" + (Object)((Object)param) + ") call failed");
        return 0.0;
    }

    @Override
    public void setEEPROMParam(OnboardParameters.EEPROMParams param, int val) {
        if (val < 0) {
            val = 0;
        }
        switch (param) {
            case ACCEL_EXTRUDER_DEPRIME_A: {
                this.write16ToEEPROM(480, val);
                break;
            }
            case ACCEL_EXTRUDER_DEPRIME_B: {
                this.write16ToEEPROM(482, val);
                break;
            }
            case ACCEL_MAX_ACCELERATION_A: {
                this.write16ToEEPROM(376, val);
                break;
            }
            case ACCEL_MAX_ACCELERATION_B: {
                this.write16ToEEPROM(378, val);
                break;
            }
            case ACCEL_MAX_ACCELERATION_X: {
                this.write16ToEEPROM(370, val);
                break;
            }
            case ACCEL_MAX_ACCELERATION_Y: {
                this.write16ToEEPROM(372, val);
                break;
            }
            case ACCEL_MAX_ACCELERATION_Z: {
                this.write16ToEEPROM(374, val);
                break;
            }
            case ACCEL_MAX_EXTRUDER_NORM: {
                this.write16ToEEPROM(368, val);
                break;
            }
            case ACCEL_MAX_EXTRUDER_RETRACT: {
                this.write16ToEEPROM(390, val);
                break;
            }
            case ACCEL_MAX_SPEED_CHANGE_A: {
                this.write16ToEEPROM(386, val);
                break;
            }
            case ACCEL_MAX_SPEED_CHANGE_B: {
                this.write16ToEEPROM(388, val);
                break;
            }
            case ACCEL_MAX_SPEED_CHANGE_X: {
                this.write16ToEEPROM(380, val);
                break;
            }
            case ACCEL_MAX_SPEED_CHANGE_Y: {
                this.write16ToEEPROM(382, val);
                break;
            }
            case ACCEL_MAX_SPEED_CHANGE_Z: {
                this.write16ToEEPROM(384, val);
                break;
            }
            case ACCEL_SLOWDOWN_FLAG: {
                this.setUInt8EEPROM(484, val != 0 ? 1 : 0);
                break;
            }
            case ALEVEL_MAX_ZPROBE_HITS: {
                this.setUInt8EEPROM(3940, val);
                break;
            }
            case PREHEAT_DURING_PAUSE: {
                this.setUInt8EEPROM(4094, val != 0 ? 1 : 0);
                break;
            }
            case OVERRIDE_GCODE_TEMP: {
                this.setUInt8EEPROM(4093, val != 0 ? 1 : 0);
                break;
            }
            case EXTRUDER_HOLD: {
                this.setUInt8EEPROM(3986, val != 0 ? 1 : 0);
                break;
            }
            case TOOLHEAD_OFFSET_SYSTEM: {
                this.setUInt8EEPROM(3987, val != 0 ? 1 : 0);
                break;
            }
            case SD_USE_CRC: {
                this.setUInt8EEPROM(3985, val != 0 ? 1 : 0);
                break;
            }
            case PSTOP_ENABLE: {
                this.setUInt8EEPROM(3984, val != 0 ? 1 : 0);
                break;
            }
            case HBP_PRESENT: {
                this.setUInt8EEPROM(76, val != 0 ? 1 : 0);
                break;
            }
            case MOOD_LIGHT_SCRIPT: {
                this.setUInt8EEPROM(320, val);
                break;
            }
            case MOOD_LIGHT_SHOW_HEATING: {
                this.setUInt8EEPROM(322, val != 0 ? 1 : 0);
                break;
            }
            case MOOD_LIGHT_CUSTOM_RED: {
                this.setUInt8EEPROM(324, val);
                break;
            }
            case MOOD_LIGHT_CUSTOM_GREEN: {
                this.setUInt8EEPROM(325, val);
                break;
            }
            case MOOD_LIGHT_CUSTOM_BLUE: {
                this.setUInt8EEPROM(326, val);
                break;
            }
            case DEPRIME_ON_TRAVEL: {
                this.setUInt8EEPROM(523, val);
                break;
            }
            case ENABLE_ALTERNATE_UART: {
                this.setUInt8EEPROM(3983, val == 1 ? 1 : 0);
                break;
            }
            case CLEAR_FOR_ESTOP: {
                this.setUInt8EEPROM(3982, val == 1 ? 1 : 0);
                break;
            }
            default: {
                Base.logger.log(Level.WARNING, "setEEPROMParam(" + (Object)((Object)param) + ", " + val + ") call failed");
            }
        }
    }

    @Override
    public void setEEPROMParam(OnboardParameters.EEPROMParams param, long val) {
        if (val < 0L) {
            val = 0L;
        }
        switch (param) {
            default: 
        }
        Base.logger.log(Level.WARNING, "setEEPROMParam(" + (Object)((Object)param) + ", " + val + ") call failed");
    }

    @Override
    public void setEEPROMParam(OnboardParameters.EEPROMParams param, double val) {
        if (val < 0.0) {
            val = 0.0;
        }
        switch (param) {
            case ACCEL_ADVANCE_K: {
                this.setUInt32EEPROM(472, (long)(val * 100000.0));
                break;
            }
            case ACCEL_ADVANCE_K2: {
                this.setUInt32EEPROM(476, (long)(val * 100000.0));
                break;
            }
            case ALEVEL_MAX_ZDELTA: {
                Point5d stepsPerMM = this.getMachine().getStepsPerMM();
                int ival = (int)(val * stepsPerMM.z());
                this.write32ToEEPROM32(3942, ival);
                break;
            }
            default: {
                Base.logger.log(Level.WARNING, "setEEPROMParam(" + (Object)((Object)param) + ", " + val + ") call failed");
            }
        }
    }

    @Override
    public boolean getPStop() {
        return 1 == this.getEEPROMParamInt(OnboardParameters.EEPROMParams.PSTOP_ENABLE);
    }

    @Override
    public void setPStop(boolean enable) {
        this.setEEPROMParam(OnboardParameters.EEPROMParams.PSTOP_ENABLE, enable ? 1 : 0);
    }
}

