/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.gen3;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.util.serial.Serial;
import replicatorg.drivers.DriverError;
import replicatorg.drivers.MultiTool;
import replicatorg.drivers.OnboardParameters;
import replicatorg.drivers.PenPlotter;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.SDCardCapture;
import replicatorg.drivers.SerialDriver;
import replicatorg.drivers.Version;
import replicatorg.drivers.gen3.MotherboardCommandCode;
import replicatorg.drivers.gen3.PacketBuilder;
import replicatorg.drivers.gen3.PacketProcessor;
import replicatorg.drivers.gen3.PacketResponse;
import replicatorg.drivers.gen3.Sanguino3GEEPRPOM;
import replicatorg.drivers.gen3.ToolCommandCode;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.ToolModel;
import replicatorg.uploader.FirmwareUploader;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sanguino3GDriver
extends SerialDriver
implements OnboardParameters,
SDCardCapture,
PenPlotter,
MultiTool {
    protected static final int DEFAULT_RETRIES = 5;
    Point5d pastExcess = new Point5d(0.0, 0.0, 0.0, 0.0, 0.0);
    Version toolVersion = new Version(0, 0);
    private boolean eepromChecked = false;
    protected boolean acceleratedFirmware = false;
    protected boolean absoluteXYZ = false;
    static boolean isNotifiedFinishedFeature = false;
    private final Version extendedStopVersion = new Version(2, 7);
    FileOutputStream fileCaptureOstream = null;

    public Sanguino3GDriver() {
        this.hasEmergencyStop = true;
        this.hasSoftStop = true;
        this.minimumVersion = new Version(3, 0);
        this.preferredVersion = new Version(3, 0);
        this.setInitialized(false);
    }

    @Override
    public void loadXML(Node xml) {
        super.loadXML(xml);
    }

    @Override
    public void initialize() {
        Base.logger.fine("Attempting to initialize device");
        assert (this.serial != null) : "No serial port found.";
        if (!this.isInitialized()) {
            try {
                int timeout = 2600;
                this.connectToDevice(timeout);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.isInitialized()) {
            if (this.version.compareTo(this.getMinimumVersion()) < 0) {
                Base.logger.log(Level.WARNING, "\n********************************************************\nThis version of ReplicatorG is not reccomended for use with firmware before version " + this.getMinimumVersion() + ". Either update your firmware or proceed with caution.\n" + "********************************************************");
            }
            this.sendInit();
            super.initialize();
            this.invalidatePosition();
            return;
        }
        Base.logger.info("Unable to connect to firmware.");
        this.dispose();
    }

    public boolean initializeBot() {
        for (ToolModel t : this.getMachine().getTools()) {
            if (t == null) continue;
            this.initSlave(t.getIndex());
        }
        return true;
    }

    private boolean attemptConnection() {
        this.serial.clear();
        this.version = this.getVersionInternal();
        if (this.version != null) {
            boolean initOk = this.initializeBot();
            if (!initOk) {
                this.setInitialized(false);
                return false;
            }
            String MB_NAME = "RepRap Motherboard v1.X";
            FirmwareUploader.checkLatestVersion("RepRap Motherboard v1.X", this.version);
            if (this.version.getMajor() < 2) {
                this.serial.setTimeout(Integer.MAX_VALUE);
            }
            this.setInitialized(true);
        }
        return this.isInitialized();
    }

    @Override
    public void assessState() {
        if (this.isInitialized() && !this.serial.isConnected()) {
            this.setError("Serial disconnected");
            this.setInitialized(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToDevice(int timeoutMillis) {
        assert (this.serial != null);
        Serial serial = this.serial;
        synchronized (serial) {
            this.serial.clear();
            this.serial.setTimeout(timeoutMillis);
            if (this.attemptConnection()) {
                return;
            }
            try {
                Thread.sleep(timeoutMillis);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            if (this.attemptConnection()) {
                return;
            }
            Base.logger.warning("No connection; trying to pulse RTS to reset device.");
            this.serial.pulseRTSLow();
            try {
                Thread.sleep(timeoutMillis);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            this.attemptConnection();
        }
    }

    protected PacketResponse runCommand(byte[] packet) throws RetryException {
        return this.runCommand(packet, 5);
    }

    protected PacketResponse runQueryNoLogging(byte[] packet, int retries) {
        try {
            return this.runCommand(packet, retries, CommandType.QUERY, false);
        }
        catch (RetryException re) {
            throw new RuntimeException("Queries can not have valid retries!");
        }
    }

    protected PacketResponse runQuery(byte[] packet, int retries) {
        try {
            return this.runCommand(packet, retries, CommandType.QUERY, true);
        }
        catch (RetryException re) {
            throw new RuntimeException("Queries can not have valid retries!");
        }
    }

    protected PacketResponse runQuery(byte[] packet) {
        return this.runQuery(packet, 5);
    }

    @Override
    public List<Integer> toolheadsWithStoredData() {
        Vector<ToolModel> tools = this.getMachine().getTools();
        Vector<Integer> toolsList = new Vector<Integer>();
        for (ToolModel t : tools) {
            toolsList.add(new Integer(t.getIndex()));
        }
        return toolsList;
    }

    void printDebugData(String title, byte[] data) {
        StringBuffer buf = new StringBuffer(title + ": ");
        for (int i = 0; i < data.length; ++i) {
            buf.append(Integer.toHexString(data[i] & 0xFF));
            buf.append(" ");
        }
        Base.logger.finer(buf.toString());
    }

    protected PacketResponse runCommand(byte[] packet, int retries) throws RetryException {
        return this.runCommand(packet, retries, CommandType.COMMAND, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PacketResponse runCommand(byte[] packet, int retries, CommandType commandType, boolean logOperationalErrors) throws RetryException {
        boolean isCommand;
        if (retries == 0) {
            if (logOperationalErrors) {
                Base.logger.severe("Packet timed out!");
            }
            return PacketResponse.timeoutResponse();
        }
        if (retries < 0) {
            Base.logger.severe("Attempt to send packet with negative retries");
            return null;
        }
        if (packet == null || packet.length < 4) {
            Base.logger.severe("Attempt to send empty or too-small packet");
            return null;
        }
        boolean bl = isCommand = (packet[2] & 0x80) != 0;
        if (this.fileCaptureOstream != null) {
            try {
                if (isCommand) {
                    this.fileCaptureOstream.write(packet, 2, packet.length - 3);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return PacketResponse.okResponse();
        }
        if (this.serial == null) {
            return PacketResponse.timeoutResponse();
        }
        PacketResponse pr = new PacketResponse();
        assert (this.serial != null);
        Serial serial = this.serial;
        synchronized (serial) {
            if (Thread.currentThread().isInterrupted()) {
                Thread.interrupted();
                try {
                    Thread.sleep(10L);
                    this.serial.clear();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                Thread.currentThread().interrupt();
                return pr;
            }
            PacketProcessor pp = new PacketProcessor();
            if (packet == null) {
                Base.logger.severe("null packet in runCommand");
                return PacketResponse.timeoutResponse();
            }
            if (this.serial == null) {
                Base.logger.severe("null serial in runCommand");
                return PacketResponse.timeoutResponse();
            }
            this.serial.write(packet);
            this.printDebugData("OUT", packet);
            boolean completed = false;
            while (!completed) {
                int b = this.serial.read();
                if (b == -1) {
                    if (Thread.currentThread().isInterrupted()) break;
                    if (commandType == CommandType.QUERY) {
                        return this.runCommand(packet, 0, commandType, logOperationalErrors);
                    }
                    if (retries > 1) {
                        if (logOperationalErrors) {
                            Base.logger.severe("Read timed out; retries remaining: " + Integer.toString(retries));
                        }
                    } else if (retries == 1 && !logOperationalErrors) {
                        return PacketResponse.timeoutResponse();
                    }
                    return this.runCommand(packet, retries - 1, commandType, logOperationalErrors);
                }
                try {
                    completed = pp.processByte((byte)b);
                }
                catch (PacketProcessor.CRCException e) {
                    if (logOperationalErrors) {
                        Base.logger.severe("Bad CRC received; retries remaining: " + Integer.toString(retries));
                    }
                    return this.runCommand(packet, retries - 1, commandType, logOperationalErrors);
                }
                catch (PacketProcessor.PacketNoiseException e) {
                    if (logOperationalErrors) {
                        Base.logger.severe("Bad Start Byte received; retries remaining: " + Integer.toString(retries));
                    }
                    return this.runCommand(packet, retries - 1, commandType, logOperationalErrors);
                }
            }
            if (!(pr = pp.getResponse()).isOK()) {
                if (pr.getResponseCode() == PacketResponse.ResponseCode.BUFFER_OVERFLOW) {
                    if (commandType == CommandType.QUERY) {
                        return PacketResponse.timeoutResponse();
                    }
                    throw new RetryException();
                }
                if (pr.getResponseCode() == PacketResponse.ResponseCode.BOT_RX_TIMEDOUT) {
                    if (logOperationalErrors) {
                        Base.logger.severe("Printer timed out packet from RepG, will try again");
                    }
                    if (commandType == CommandType.QUERY) {
                        return PacketResponse.timeoutResponse();
                    }
                    throw new RetryException();
                }
                if (pr.getResponseCode() == PacketResponse.ResponseCode.CANCEL) {
                    Base.getEditor().handleStop();
                    Base.logger.severe("Build Canceled by Printer");
                } else if (pr.getResponseCode() == PacketResponse.ResponseCode.BOT_BUILDING) {
                    Base.getEditor().handleStop();
                    Base.logger.severe("Printer was building from SD Card, when RepG sent it a command, build cancelled");
                } else if (pr.getResponseCode() == PacketResponse.ResponseCode.BOT_OVERHEAT) {
                    Base.getEditor().handleStop();
                    Base.logger.severe("Printer has overheated, build cancelled");
                } else if (pr.getResponseCode() == PacketResponse.ResponseCode.UNSUPPORTED && packet[2] == MotherboardCommandCode.IS_FINISHED.getCode()) {
                    if (!isNotifiedFinishedFeature) {
                        Base.logger.severe("isBufferEmpty: IsFinished not supported by this firmware. Update your firmware.");
                        isNotifiedFinishedFeature = true;
                    }
                } else {
                    if (logOperationalErrors) {
                        this.printDebugData("Unknown error sending, retry", packet);
                        Base.logger.severe(pr.getResponseCode().getMessage() + "; retries remaining: " + Integer.toString(retries));
                    }
                    if (retries > 1) {
                        return this.runCommand(packet, retries - 1, commandType, logOperationalErrors);
                    }
                    if (retries == 1 && (pr.getResponseCode() == PacketResponse.ResponseCode.GENERIC_ERROR || pr.getResponseCode() == PacketResponse.ResponseCode.CRC_MISMATCH || pr.getResponseCode() == PacketResponse.ResponseCode.QUERY_OVERFLOW || pr.getResponseCode() == PacketResponse.ResponseCode.UNSUPPORTED || pr.getResponseCode() == PacketResponse.ResponseCode.UNKNOWN || pr.getResponseCode() == PacketResponse.ResponseCode.DOWNSTREAM_TIMEOUT || pr.getResponseCode() == PacketResponse.ResponseCode.TOOL_LOCK_TIMEOUT) && this.isInitialized() && commandType != CommandType.QUERY) {
                        Base.getEditor().handleStop();
                        Base.logger.severe("Build Canceled Due To Communications Error");
                    }
                }
            }
        }
        return pr;
    }

    @Override
    public boolean isFinished() {
        if (this.fileCaptureOstream != null) {
            return true;
        }
        return this.isBufferEmpty();
    }

    @Override
    public boolean isBufferEmpty() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.IS_FINISHED.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.isOK()) {
            int v = pr.get8();
            boolean finished = v != 0;
            Base.logger.fine("Buffer empty: " + Boolean.toString(finished));
            return finished;
        }
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public Version getVersionInternal() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.VERSION.getCode());
        pb.add16(40);
        PacketResponse pr = this.runQueryNoLogging(pb.getPacket(), 1);
        if (pr.isEmpty() || !pr.isOK()) {
            return null;
        }
        int versionNum = pr.get16();
        pb = new PacketBuilder(MotherboardCommandCode.GET_BUILD_NAME.getCode());
        pb.add16(40);
        String buildname = "";
        pr = this.runQueryNoLogging(pb.getPacket(), 1);
        if (!pr.isEmpty() && pr.isOK()) {
            byte[] payload = pr.getPayload();
            byte[] subarray = new byte[payload.length - 1];
            System.arraycopy(payload, 1, subarray, 0, subarray.length);
            buildname = " (" + new String(subarray) + ")";
        }
        Base.logger.fine("Reported version: " + versionNum + " " + buildname);
        if (versionNum == 0) {
            Base.logger.severe("Null version reported!");
            return null;
        }
        Version v = new Version(versionNum / 100, versionNum % 100);
        Base.logger.warning("Motherboard firmware v" + v + buildname);
        return v;
    }

    @Override
    public OnboardParameters.CommunicationStatistics getCommunicationStatistics() {
        OnboardParameters.CommunicationStatistics stats = new OnboardParameters.CommunicationStatistics();
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.GET_COMMUNICATION_STATS.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket(), 1);
        if (pr.isEmpty()) {
            return null;
        }
        stats.packetCount = pr.get32();
        stats.sentPacketCount = pr.get32();
        stats.packetFailureCount = pr.get32();
        stats.packetRetryCount = pr.get32();
        stats.noiseByteCount = pr.get32();
        return stats;
    }

    public void initSlave(int toolhead) {
        byte[] payload;
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        PacketBuilder slavepb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        slavepb.add8((byte)toolhead);
        slavepb.add8(ToolCommandCode.VERSION.getCode());
        int slaveVersionNum = 0;
        PacketResponse slavepr = this.runQueryNoLogging(slavepb.getPacket(), 2);
        if (!slavepr.isEmpty()) {
            slaveVersionNum = slavepr.get16();
        }
        slavepb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        slavepb.add8((byte)toolhead);
        slavepb.add8(ToolCommandCode.GET_BUILD_NAME.getCode());
        slavepr = this.runQueryNoLogging(slavepb.getPacket(), 2);
        String buildname = "";
        slavepr = this.runQuery(slavepb.getPacket(), 1);
        if (!slavepr.isEmpty() && (payload = slavepr.getPayload()).length > 0) {
            byte[] subarray = new byte[payload.length - 1];
            System.arraycopy(payload, 1, subarray, 0, subarray.length);
            buildname = " (" + new String(subarray) + ")";
        }
        Base.logger.fine("Reported slave board version: " + slaveVersionNum + " " + buildname);
        if (slaveVersionNum == 0) {
            String message = "Toolhead " + Integer.toString(toolhead) + ": Not found.\nMake sure the toolhead is connected, " + "the power supply is plugged in and turned on, and the " + "power switch on the motherboard is on.";
            this.setError(new DriverError(message, false));
            Base.logger.severe(message);
        } else {
            Version sv;
            this.toolVersion = sv = new Version(slaveVersionNum / 100, slaveVersionNum % 100);
            Base.logger.warning("Toolhead " + Integer.toString(toolhead) + ": Extruder controller firmware v" + sv + buildname);
            String EC_NAME = "Extruder Controller v2.2";
            FirmwareUploader.checkLatestVersion("Extruder Controller v2.2", sv);
        }
        ToolModel curToolMod = this.getMachine().getTool(toolhead);
        if (curToolMod != null) {
            if (curToolMod.motorIsStepper()) {
                double targetRPM = curToolMod.getMotorSpeedRPM();
                try {
                    this.setMotorRPM(targetRPM, toolhead);
                }
                catch (RetryException e) {
                    Base.logger.severe("could not init motor RPM, got exception" + e);
                }
            } else {
                int targetPWM = curToolMod.getMotorSpeedPWM();
                try {
                    this.setMotorSpeedPWM(targetPWM, toolhead);
                }
                catch (RetryException e) {
                    Base.logger.severe("could not init motor RPM, got exception" + e);
                }
            }
        }
    }

    public void sendInit() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.INIT.getCode());
        this.runQuery(pb.getPacket());
    }

    @Override
    public void queuePoint(Point5d p) throws RetryException {
        Base.logger.finer("Queued point " + p);
        Point5d deltaSteps = this.getAbsDeltaSteps(this.getCurrentPosition(false), p);
        double masterSteps = this.getLongestLength(deltaSteps);
        if (masterSteps > 0.0) {
            Point5d steps = this.machine.mmToSteps(p);
            Point5d delta = this.getDelta(p);
            double feedrate = this.getSafeFeedrate(delta);
            long micros = this.convertFeedrateToMicros(this.getCurrentPosition(false), p, feedrate);
            this.queueAbsolutePoint(steps, micros);
            super.queuePoint(p);
        }
    }

    protected void queueAbsolutePoint(Point5d steps, long micros) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.QUEUE_POINT_ABS.getCode());
        Base.logger.fine("Queued absolute point " + steps + " at " + Long.toString(micros) + " usec.");
        pb.add32((int)steps.x());
        pb.add32((int)steps.y());
        pb.add32((int)steps.z());
        pb.add32((int)micros);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void setCurrentPosition(Point5d p) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.SET_POSITION.getCode());
        Point5d excess = new Point5d(this.pastExcess);
        if (this.absoluteXYZ) {
            excess.setX(0.0);
            excess.setY(0.0);
            excess.setZ(0.0);
        }
        Point5d steps = this.machine.mmToSteps(p, excess);
        pb.add32((int)steps.x());
        pb.add32((int)steps.y());
        pb.add32((int)steps.z());
        Base.logger.fine("Set current position to " + p + " (" + steps + ")");
        this.runCommand(pb.getPacket());
        super.setCurrentPosition(p);
    }

    @Override
    public void homeAxes(EnumSet<AxisId> axes, boolean positive, double feedrate) throws RetryException {
        Base.logger.fine("Homing axes " + axes.toString());
        int flags = 0;
        double timeout = 0.0;
        Point5d homingFeedrates = this.machine.getHomingFeedrates();
        Point5d timeOut = this.machine.getTimeOut();
        if (feedrate <= 0.0) {
            feedrate = 0.0;
            for (AxisId axis : this.machine.getAvailableAxes()) {
                feedrate = Math.max(homingFeedrates.axis(axis), feedrate);
            }
        }
        Point5d target = new Point5d();
        for (AxisId axis : axes) {
            flags = (byte)(flags + (1 << axis.getIndex()));
            feedrate = Math.min(feedrate, homingFeedrates.axis(axis));
            timeout = Math.max(timeout, timeOut.axis(axis));
            target.setAxis(axis, 1.0);
        }
        long micros = this.convertFeedrateToMicros(new Point5d(), target, feedrate);
        int code = positive ? MotherboardCommandCode.FIND_AXES_MAXIMUM.getCode() : MotherboardCommandCode.FIND_AXES_MINIMUM.getCode();
        PacketBuilder pb = new PacketBuilder(code);
        pb.add8(flags);
        pb.add32((int)micros);
        pb.add16((int)timeout);
        this.runCommand(pb.getPacket());
        this.invalidatePosition();
    }

    @Override
    public void delay(long millis) throws RetryException {
        Base.logger.finer("Delaying " + millis + " millis.");
        Base.logger.fine("Sanguino3GDriver.enableMotor()");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.DELAY.getCode());
        pb.add32(millis);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void openClamp(int clampIndex) {
        super.openClamp(clampIndex);
    }

    @Override
    public void closeClamp(int clampIndex) {
        super.closeClamp(clampIndex);
    }

    @Override
    public void enableDrives() throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.ENABLE_AXES.getCode());
        pb.add8(159);
        this.runCommand(pb.getPacket());
        super.enableDrives();
    }

    @Override
    public void disableDrives() throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.ENABLE_AXES.getCode());
        pb.add8(31);
        this.runCommand(pb.getPacket());
        super.disableDrives();
    }

    private int axesToBitfield(EnumSet<AxisId> axes) {
        int v = 0;
        for (AxisId axis : axes) {
            v += 1 << axis.getIndex();
        }
        return v;
    }

    @Override
    public void enableAxes(EnumSet<AxisId> axes) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.ENABLE_AXES.getCode());
        pb.add8(128 + (this.axesToBitfield(axes) & 0x1F));
        this.runCommand(pb.getPacket());
        super.enableAxes(axes);
    }

    @Override
    public void disableAxes(EnumSet<AxisId> axes) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.ENABLE_AXES.getCode());
        pb.add8(this.axesToBitfield(axes) & 0x1F);
        this.runCommand(pb.getPacket());
        super.disableAxes(axes);
    }

    @Override
    public void changeGearRatio(int ratioIndex) {
        super.changeGearRatio(ratioIndex);
    }

    @Override
    public void requestToolChange(int toolhead, int timeout) throws RetryException {
        PacketBuilder pb;
        this.selectTool(toolhead);
        Base.logger.fine("Waiting for tool #" + toolhead);
        if (this.machine.getTool(toolhead).getTargetTemperature() > 0.0) {
            pb = new PacketBuilder(MotherboardCommandCode.WAIT_FOR_TOOL.getCode());
            pb.add8((byte)toolhead);
            pb.add16(100);
            pb.add16(timeout);
            this.runCommand(pb.getPacket());
        }
        if (this.machine.getTool(toolhead) != null && this.machine.getTool(toolhead).hasHeatedPlatform() && this.machine.getTool(toolhead).getPlatformTargetTemperature() > 0.0) {
            pb = new PacketBuilder(MotherboardCommandCode.WAIT_FOR_PLATFORM.getCode());
            pb.add8((byte)toolhead);
            pb.add16(100);
            pb.add16(timeout);
            this.runCommand(pb.getPacket());
        }
    }

    @Override
    public void selectTool(int toolIndex) throws RetryException {
        Base.logger.fine("Selecting tool #" + toolIndex);
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.CHANGE_TOOL.getCode());
        pb.add8((byte)toolIndex);
        this.runCommand(pb.getPacket());
        super.selectTool(toolIndex);
    }

    @Override
    public void setMotorRPM(double rpm, int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        long microseconds = rpm == 0.0 ? 0L : Math.round(6.0E7 / rpm);
        Base.logger.fine("Setting motor 1 speed to " + rpm + " RPM (" + microseconds + " microseconds)");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.SET_MOTOR_1_RPM.getCode());
        pb.add8(4);
        pb.add32(microseconds);
        this.runCommand(pb.getPacket());
        super.setMotorRPM(rpm, toolhead);
    }

    @Override
    public void setMotorSpeedPWM(int pwm) throws RetryException {
        this.setMotorSpeedPWM(pwm, this.machine.currentTool().getIndex());
    }

    @Override
    public void setMotorSpeedPWM(int pwm, int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        if (this.machine.getTool(toolhead).getMotorUsesRelay() && pwm > 0) {
            Base.logger.fine("Tool motor uses relay, overriding PWM setting");
            pwm = 255;
        }
        Base.logger.fine("Setting motor 1 speed to " + pwm + " PWM");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.SET_MOTOR_1_PWM.getCode());
        pb.add8(1);
        pb.add8((byte)(pwm > 255 ? 255 : pwm));
        this.runCommand(pb.getPacket());
        super.setMotorSpeedPWM(pwm, toolhead);
    }

    @Override
    @Deprecated
    public void enableMotor() throws RetryException {
        this.enableMotor(-1);
    }

    @Override
    public void enableMotor(int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int flags = 1;
        if (this.machine.getTool(toolhead).getMotorDirection() == ToolModel.MOTOR_CLOCKWISE) {
            flags = (byte)(flags + 2);
        }
        Base.logger.fine("Toggling motor 1 w/ flags: " + Integer.toBinaryString(flags));
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.TOGGLE_MOTOR_1.getCode());
        pb.add8(1);
        pb.add8(flags);
        this.runCommand(pb.getPacket());
        super.enableMotor(toolhead);
    }

    @Override
    public void disableMotor(int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int flags = 0;
        if (this.machine.getTool(toolhead).getSpindleDirection() == ToolModel.MOTOR_CLOCKWISE) {
            flags = (byte)(flags + 2);
        }
        Base.logger.finer("Disabling motor 1");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.TOGGLE_MOTOR_1.getCode());
        pb.add8(1);
        pb.add8(flags);
        this.runCommand(pb.getPacket());
        super.disableMotor(toolhead);
    }

    @Override
    @Deprecated
    public int getMotorSpeedPWM() {
        return this.getMotorSpeedPWM(this.machine.currentTool().getIndex());
    }

    public int getMotorSpeedPWM(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.GET_MOTOR_1_PWM.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        pr.printDebug();
        int pwm = pr.get8();
        Base.logger.fine("Current motor 1 PWM: " + pwm);
        this.machine.getTool(toolhead).setMotorSpeedReadingPWM(pwm);
        return pwm;
    }

    @Override
    public double getMotorRPM() {
        return this.getMotorRPM(this.machine.currentTool().getIndex());
    }

    public double getMotorRPM(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.GET_MOTOR_1_RPM.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        long micros = pr.get32();
        double rpm = 0.0;
        if (micros > 0L) {
            rpm = 6.0E7 / (double)micros;
        }
        Base.logger.fine("Current motor 1 RPM: " + rpm + " (" + micros + ")");
        this.machine.getTool(toolhead).setMotorSpeedReadingRPM(rpm);
        return rpm;
    }

    @Override
    @Deprecated
    public void readToolStatus() {
        this.readToolStatus(this.machine.currentTool().getIndex());
    }

    public void readToolStatus(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.GET_TOOL_STATUS.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.isEmpty()) {
            return;
        }
        int status = pr.get8();
        this.machine.getTool(toolhead).setToolStatus(status);
        if (Base.logger.isLoggable(Level.FINE)) {
            Base.logger.fine("Extruder Status: " + status + ": " + ((status & 0x80) != 0 ? "EXTRUDER_ERROR " : "") + ((status & 0x40) != 0 ? "PLATFORM_ERROR " : "") + ((status & 0x20) != 0 ? "WDRF " : "") + ((status & 0x10) != 0 ? "BORF " : "") + ((status & 8) != 0 ? "EXTRF " : "") + ((status & 4) != 0 ? "PORF " : "") + ((status & 1) != 0 ? "READY" : "NOT READY") + " ");
        }
        this.readToolPIDState();
    }

    private int fixSigned(int value) {
        if (value >= 32768) {
            value -= 65536;
        }
        return value;
    }

    @Deprecated
    public void readToolPIDState() {
        this.readToolPIDState(this.machine.currentTool().getIndex());
    }

    public void readToolPIDState(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        if (Base.logger.isLoggable(Level.FINE)) {
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
            pb.add8((byte)toolhead);
            pb.add8(ToolCommandCode.GET_PID_STATE.getCode());
            PacketResponse pr = this.runQuery(pb.getPacket());
            if (pr.isEmpty()) {
                return;
            }
            int extruderErrorTerm = this.fixSigned(pr.get16());
            int extruderDeltaTerm = this.fixSigned(pr.get16());
            int extruderLastOutput = this.fixSigned(pr.get16());
            int platformErrorTerm = this.fixSigned(pr.get16());
            int platformDeltaTerm = this.fixSigned(pr.get16());
            int platformLastOutput = this.fixSigned(pr.get16());
            Base.logger.fine("Extuder PID State:  error: " + extruderErrorTerm + "  delta: " + extruderDeltaTerm + "  output: " + extruderLastOutput);
            Base.logger.fine("Platform PID State:  error: " + platformErrorTerm + "  delta: " + platformDeltaTerm + "  output: " + platformLastOutput);
        }
    }

    @Override
    @Deprecated
    public void setServoPos(int index, double degree) throws RetryException {
        this.setServoPos(index, degree, this.machine.currentTool().getIndex());
    }

    public void setServoPos(int index, double degree, int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int command = 0;
        if (index == 0) {
            command = ToolCommandCode.SET_SERVO_1_POS.getCode();
        } else if (index == 1) {
            command = ToolCommandCode.SET_SERVO_2_POS.getCode();
        } else {
            Base.logger.severe("Servo index " + index + " not supported, ignoring");
            return;
        }
        if (degree != 255.0) {
            if (degree < 0.0) {
                degree = 0.0;
            } else if (degree > 180.0) {
                degree = 180.0;
            }
        }
        Base.logger.fine("Setting servo " + index + " position to " + degree + " degrees");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(command);
        pb.add8(1);
        pb.add8((byte)degree);
        this.runCommand(pb.getPacket());
    }

    @Override
    @Deprecated
    public void setSpindleRPM(double rpm) throws RetryException {
        this.setSpindleRPM(rpm, this.machine.currentTool().getIndex());
    }

    @Override
    public void setSpindleRPM(double rpm, int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        long microseconds = (int)Math.round(6.0E7 / rpm);
        microseconds = Math.min(microseconds, 29L);
        Base.logger.fine("Setting motor 2 speed to " + rpm + " RPM (" + microseconds + " microseconds)");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.SET_MOTOR_2_RPM.getCode());
        pb.add8(4);
        pb.add32(microseconds);
        this.runCommand(pb.getPacket());
        super.setSpindleRPM(rpm, toolhead);
    }

    @Override
    @Deprecated
    public void setSpindleSpeedPWM(int pwm) throws RetryException {
        this.setSpindleSpeedPWM(pwm, this.machine.currentTool().getIndex());
    }

    @Override
    public void setSpindleSpeedPWM(int pwm, int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        Base.logger.fine("Setting motor 2 speed to " + pwm + " PWM");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.SET_MOTOR_2_PWM.getCode());
        pb.add8(1);
        pb.add8((byte)pwm);
        this.runCommand(pb.getPacket());
        super.setSpindleSpeedPWM(pwm, toolhead);
    }

    @Override
    @Deprecated
    public void enableSpindle() throws RetryException {
        this.enableSpindle(this.machine.currentTool().getIndex());
    }

    @Override
    public void enableSpindle(int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int flags = 1;
        if (this.machine.getTool(toolhead).getSpindleDirection() == ToolModel.MOTOR_CLOCKWISE) {
            flags = (byte)(flags + 2);
        }
        Base.logger.fine("Toggling motor 2 w/ flags: " + Integer.toBinaryString(flags));
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.TOGGLE_MOTOR_2.getCode());
        pb.add8(1);
        pb.add8(flags);
        this.runCommand(pb.getPacket());
        super.enableSpindle(toolhead);
    }

    @Override
    @Deprecated
    public void disableSpindle() throws RetryException {
        this.disableSpindle(this.machine.currentTool().getIndex());
    }

    @Override
    public void disableSpindle(int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int flags = 0;
        if (this.machine.getTool(toolhead).getSpindleDirection() == ToolModel.MOTOR_CLOCKWISE) {
            flags = (byte)(flags + 2);
        }
        Base.logger.fine("Disabling motor 2");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.TOGGLE_MOTOR_2.getCode());
        pb.add8(1);
        pb.add8(flags);
        this.runCommand(pb.getPacket());
        super.disableSpindle(toolhead);
    }

    @Deprecated
    public double getSpindleSpeedRPM() throws RetryException {
        return this.getSpindleSpeedRPM(this.machine.currentTool().getIndex());
    }

    public double getSpindleSpeedRPM(int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.GET_MOTOR_2_RPM.getCode());
        PacketResponse pr = this.runCommand(pb.getPacket());
        long micros = pr.get32();
        double rpm = 6.0E7 / (double)micros;
        Base.logger.fine("Current motor 2 RPM: " + rpm + " (" + micros + ")");
        this.machine.getTool(toolhead).setSpindleSpeedReadingRPM(rpm);
        return rpm;
    }

    @Override
    @Deprecated
    public int getSpindleSpeedPWM() {
        return this.getSpindleSpeedPWM(this.machine.currentTool().getIndex());
    }

    @Deprecated
    public int getSpindleSpeedPWM(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.GET_MOTOR_2_PWM.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        int pwm = pr.get8();
        Base.logger.fine("Current motor 1 PWM: " + pwm);
        this.machine.getTool(toolhead).setSpindleSpeedReadingPWM(pwm);
        return pwm;
    }

    @Override
    @Deprecated
    public void setTemperature(double temperature) throws RetryException {
        this.setTemperature(temperature, this.machine.currentTool().getIndex());
    }

    @Override
    public void setTemperature(double temperature, int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int temp = (int)Math.round(temperature);
        temp = Math.min(temp, 65535);
        Base.logger.fine("Setting temperature to " + temp + "C");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.SET_TEMP.getCode());
        pb.add8(2);
        pb.add16(temp);
        this.runCommand(pb.getPacket());
        super.setTemperature(temperature, toolhead);
    }

    @Override
    @Deprecated
    public void readTemperature() {
        this.readAllTemperatures();
    }

    @Override
    public void readAllTemperatures() {
        Vector<ToolModel> tools = this.machine.getTools();
        for (ToolModel t : tools) {
            this.readTemperature(t.getIndex());
            this.getTemperatureSetting(t.getIndex());
        }
    }

    @Override
    public void readTemperature(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.GET_TEMP.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.getResponseCode() == PacketResponse.ResponseCode.TIMEOUT) {
            Base.logger.finer("timeout reading temp");
        } else if (pr.isEmpty()) {
            Base.logger.finer("empty response, no temp");
        } else {
            int temp = pr.get16();
            this.machine.getTool(toolhead).setCurrentTemperature(temp);
            Base.logger.finer("New Current temperature: " + this.machine.getTool(toolhead).getCurrentTemperature() + "C");
        }
        if (this.machine.getTool(toolhead).alwaysReadBuildPlatformTemp()) {
            this.readPlatformTemperature(toolhead);
        }
        super.readTemperature(toolhead);
    }

    @Override
    @Deprecated
    public void setPlatformTemperature(double temperature) throws RetryException {
        this.setAllPlatformTemperatures(temperature);
    }

    @Override
    public void setPlatformTemperature(double temperature, int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int temp = (int)Math.round(temperature);
        temp = Math.min(temp, 65535);
        Base.logger.fine("Setting platform temperature to " + temp + "C");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.SET_PLATFORM_TEMP.getCode());
        pb.add8(2);
        pb.add16(temp);
        this.runCommand(pb.getPacket());
        this.machine.getTool(toolhead).setPlatformTargetTemperature(temperature);
    }

    public void setAllPlatformTemperatures(double temperature) throws RetryException {
        for (ToolModel t : this.machine.getTools()) {
            this.setPlatformTemperature(temperature, t.getIndex());
        }
    }

    @Override
    @Deprecated
    public void readPlatformTemperature() {
        this.readAllPlatformTemperatures();
    }

    @Override
    public void readPlatformTemperature(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.GET_PLATFORM_TEMP.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.isEmpty()) {
            return;
        }
        int temp = pr.get16();
        this.machine.getTool(toolhead).setPlatformCurrentTemperature(temp);
        Base.logger.fine("Current platform temperature (T" + toolhead + "): " + this.machine.getTool(toolhead).getPlatformCurrentTemperature() + "C");
    }

    @Override
    public void readAllPlatformTemperatures() {
        for (ToolModel tool : this.machine.getTools()) {
            this.readPlatformTemperature(tool.getIndex());
            this.getPlatformTemperatureSetting(tool.getIndex());
        }
    }

    @Override
    public void enableFloodCoolant() {
        super.enableFloodCoolant();
    }

    @Override
    public void disableFloodCoolant() {
        super.disableFloodCoolant();
    }

    @Override
    public void enableMistCoolant() {
        super.enableMistCoolant();
    }

    @Override
    public void disableMistCoolant() {
        super.disableMistCoolant();
    }

    @Override
    @Deprecated
    public void enableFan() throws RetryException {
        this.enableFan(this.machine.currentTool().getIndex());
    }

    @Override
    public void enableFan(int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        Base.logger.fine("Enabling fan");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        Base.logger.fine("Tool index " + toolhead);
        pb.add8(ToolCommandCode.TOGGLE_FAN.getCode());
        pb.add8(1);
        pb.add8(1);
        this.runCommand(pb.getPacket());
        super.enableFan(toolhead);
    }

    @Override
    @Deprecated
    public void disableFan() throws RetryException {
        this.disableFan(this.machine.currentTool().getIndex());
    }

    @Override
    public void disableFan(int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        Base.logger.fine("Disabling fan");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.TOGGLE_FAN.getCode());
        pb.add8(1);
        pb.add8(0);
        this.runCommand(pb.getPacket());
        super.disableFan(toolhead);
    }

    @Override
    @Deprecated
    public void setAutomatedBuildPlatformRunning(boolean state) throws RetryException {
        this.setAutomatedBuildPlatformRunning(state, this.machine.currentTool().getIndex());
    }

    @Override
    public void setAutomatedBuildPlatformRunning(boolean state, int toolhead) throws RetryException {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        Base.logger.fine("Toggling ABP to " + state);
        int newState = state ? 1 : 0;
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.TOGGLE_ABP.getCode());
        pb.add8(1);
        pb.add8(newState);
        this.runCommand(pb.getPacket());
        super.setAutomatedBuildPlatformRunning(state, toolhead);
    }

    @Override
    @Deprecated
    public void openValve() throws RetryException {
        this.openValve(this.machine.currentTool().getIndex());
    }

    @Override
    public void openValve(int toolhead) throws RetryException {
        Base.logger.fine("Opening valve");
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.TOGGLE_VALVE.getCode());
        pb.add8(1);
        pb.add8(1);
        this.runCommand(pb.getPacket());
        super.openValve(toolhead);
    }

    @Override
    @Deprecated
    public void closeValve() throws RetryException {
        this.closeValve(this.machine.currentTool().getIndex());
    }

    @Override
    public void closeValve(int toolhead) throws RetryException {
        Base.logger.fine("Closing valve");
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.TOGGLE_VALVE.getCode());
        pb.add8(1);
        pb.add8(0);
        this.runCommand(pb.getPacket());
        super.closeValve(toolhead);
    }

    @Override
    public void openCollet() {
        super.openCollet();
    }

    @Override
    public void closeCollet() {
        super.closeCollet();
    }

    @Override
    public void pause() {
        Base.logger.fine("Sending asynch pause command");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.PAUSE.getCode());
        this.runQuery(pb.getPacket());
    }

    @Override
    public void unpause() {
        Base.logger.fine("Sending asynch unpause command");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.PAUSE.getCode());
        this.runQuery(pb.getPacket());
    }

    private Point5d getAbsDeltaDistance(Point5d current, Point5d target) {
        Point5d delta = new Point5d();
        delta.sub(target, current);
        delta.absolute();
        return delta;
    }

    protected Point5d getAbsDeltaSteps(Point5d current, Point5d target) {
        return this.machine.mmToSteps(this.getAbsDeltaDistance(current, target));
    }

    protected long convertFeedrateToMicros(Point5d current, Point5d target, double feedrate) {
        Point5d deltaDistance = this.getAbsDeltaDistance(current, target);
        Point5d deltaSteps = this.machine.mmToSteps(deltaDistance);
        double masterSteps = this.getLongestLength(deltaSteps);
        double distance = deltaDistance.magnitude();
        double micros = distance / feedrate * 6.0E7;
        double step_delay = micros / masterSteps;
        return Math.round(step_delay);
    }

    protected double getLongestLength(Point5d p) {
        double longest = 0.0;
        for (int i = 0; i < 5; ++i) {
            longest = Math.max(longest, p.get(i));
        }
        return longest;
    }

    @Override
    public String getDriverName() {
        return "Sanguino3G";
    }

    @Override
    public void stop(boolean abort) {
        PacketBuilder pb;
        if (!abort && this.version.atLeast(this.extendedStopVersion)) {
            Base.logger.fine("Stop motion.");
            pb = new PacketBuilder(MotherboardCommandCode.EXTENDED_STOP.getCode());
            pb.add8(3);
        } else {
            Base.logger.fine("Stop all.");
            pb = new PacketBuilder(MotherboardCommandCode.ABORT.getCode());
        }
        Thread.interrupted();
        this.runQuery(pb.getPacket());
        this.invalidatePosition();
    }

    @Override
    protected Point5d reconcilePosition() throws RetryException {
        if (this.fileCaptureOstream != null) {
            return null;
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.GET_POSITION.getCode());
        PacketResponse pr = this.runCommand(pb.getPacket());
        Point5d steps = new Point5d(pr.get32(), pr.get32(), pr.get32(), 0.0, 0.0);
        return this.machine.stepsToMM(steps);
    }

    @Override
    public void reset() {
        Base.logger.info("Reset Board");
        if (this.isInitialized() && this.version.compareTo(new Version(1, 4)) >= 0) {
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.RESET.getCode());
            Thread.interrupted();
            this.runQuery(pb.getPacket());
            this.invalidatePosition();
        }
        this.setInitialized(false);
        this.initialize();
    }

    private void checkEEPROM() {
        if (!this.eepromChecked) {
            this.eepromChecked = true;
            if (this.version.getMajor() < 2) {
                byte[] versionBytes = this.readFromEEPROM(0, 2);
                if (versionBytes == null || versionBytes.length < 2) {
                    return;
                }
                if (versionBytes[0] != 90 || versionBytes[1] != 120) {
                    Base.logger.severe("Cleaning EEPROM to v1.X state");
                    byte[] eepromWipe = new byte[16];
                    Arrays.fill(eepromWipe, (byte)0);
                    eepromWipe[0] = 90;
                    eepromWipe[1] = 120;
                    this.writeToEEPROM(0, eepromWipe);
                    Arrays.fill(eepromWipe, (byte)0);
                    for (int i = 16; i < 256; i += 16) {
                        this.writeToEEPROM(i, eepromWipe);
                    }
                }
            }
        }
    }

    protected void writeToEEPROM(int offset, byte[] data) {
        assert (data.length <= 16);
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.WRITE_EEPROM.getCode());
        pb.add16(offset);
        pb.add8(data.length);
        for (byte b : data) {
            pb.add8(b);
        }
        PacketResponse pr = this.runQuery(pb.getPacket());
        assert (pr.get8() == data.length);
    }

    @Deprecated
    protected byte[] readFromToolEEPROM(int offset, int len) {
        return this.readFromToolEEPROM(offset, len, this.machine.currentTool().getIndex());
    }

    protected byte[] readFromToolEEPROM(int offset, int len, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)toolhead);
        pb.add8(ToolCommandCode.READ_FROM_EEPROM.getCode());
        pb.add16(offset);
        pb.add8(len);
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.isOK()) {
            int rvlen = Math.min(pr.getPayload().length - 1, len);
            byte[] rv = new byte[rvlen];
            System.arraycopy(pr.getPayload(), 1, rv, 0, rvlen);
            return rv;
        }
        Base.logger.severe("On tool read: " + pr.getResponseCode().getMessage());
        Base.logger.severe("readFromToolEEPROM null" + offset + " " + len + " " + toolhead);
        return null;
    }

    @Deprecated
    protected void writeToToolEEPROM(int offset, byte[] data) {
        this.writeToToolEEPROM(offset, data, this.machine.currentTool().getIndex());
    }

    protected void writeToToolEEPROM(int offset, byte[] data, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int MAX_PAYLOAD = 11;
        while (data.length > 11) {
            byte[] head = new byte[11];
            byte[] tail = new byte[data.length - 11];
            System.arraycopy(data, 0, head, 0, 11);
            System.arraycopy(data, 11, tail, 0, data.length - 11);
            this.writeToToolEEPROM(offset, head, toolhead);
            offset += 11;
            data = tail;
        }
        PacketBuilder slavepb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        slavepb.add8((byte)toolhead);
        slavepb.add8(ToolCommandCode.WRITE_TO_EEPROM.getCode());
        slavepb.add16(offset);
        slavepb.add8(data.length);
        for (byte b : data) {
            slavepb.add8(b);
        }
        PacketResponse slavepr = this.runQuery(slavepb.getPacket());
        slavepr.printDebug();
        assert (toolhead == 255 || toolhead == 127 || slavepr.get8() == data.length);
    }

    protected byte[] readFromEEPROM(int offset, int len) {
        int MAX_EEPROM_READ_SZ = 16;
        if (len > 16) {
            Base.logger.severe("readFromEEPROM too big for: " + offset + " size: " + len);
        }
        assert (len <= 16);
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.READ_EEPROM.getCode());
        pb.add16(offset);
        pb.add8(len);
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.isOK()) {
            Base.logger.finest("readFromEEPROM ok for: " + offset + " size: " + len);
            int rvlen = Math.min(pr.getPayload().length - 1, len);
            byte[] rv = new byte[rvlen];
            System.arraycopy(pr.getPayload(), 1, rv, 0, rvlen);
            return rv;
        }
        Base.logger.severe("readFromEEPROM fail for: " + offset + " size: " + len);
        Base.logger.severe("readFromEEPROM PR is: " + pr.toString());
        return null;
    }

    @Override
    public EnumSet<AxisId> getInvertedAxes() {
        this.checkEEPROM();
        byte[] b = this.readFromEEPROM(2, 1);
        EnumSet<AxisId> r = EnumSet.noneOf(AxisId.class);
        if ((b[0] & 1) != 0) {
            r.add(AxisId.X);
        }
        if ((b[0] & 2) != 0) {
            r.add(AxisId.Y);
        }
        if ((b[0] & 4) != 0) {
            r.add(AxisId.Z);
        }
        if ((b[0] & 8) != 0) {
            r.add(AxisId.A);
        }
        if ((b[0] & 0x10) != 0) {
            r.add(AxisId.B);
        }
        if ((b[0] & 0x80) != 0) {
            r.add(AxisId.V);
        }
        return r;
    }

    @Override
    public void setInvertedAxes(EnumSet<AxisId> axes) {
        byte[] b = new byte[1];
        if (axes.contains((Object)AxisId.X)) {
            b[0] = (byte)(b[0] | 1);
        }
        if (axes.contains((Object)AxisId.Y)) {
            b[0] = (byte)(b[0] | 2);
        }
        if (axes.contains((Object)AxisId.Z)) {
            b[0] = (byte)(b[0] | 4);
        }
        if (axes.contains((Object)AxisId.A)) {
            b[0] = (byte)(b[0] | 8);
        }
        if (axes.contains((Object)AxisId.B)) {
            b[0] = (byte)(b[0] | 0x10);
        }
        if (axes.contains((Object)AxisId.V)) {
            b[0] = (byte)(b[0] | 0x80);
        }
        this.writeToEEPROM(2, b);
    }

    @Override
    public String getMachineName() {
        this.checkEEPROM();
        byte[] data = this.readFromEEPROM(32, 16);
        if (data == null) {
            return new String();
        }
        try {
            int len;
            for (len = 0; len < 16 && data[len] != 0; ++len) {
            }
            return new String(data, 0, len, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setMachineName(String machineName) {
        if ((machineName = new String(machineName)).length() >= 16) {
            machineName = machineName.substring(0, 15);
        }
        byte[] b = new byte[16];
        int idx = 0;
        for (byte sb : machineName.getBytes()) {
            b[idx++] = sb;
            if (idx == 16) break;
        }
        if (idx < 16) {
            b[idx] = 0;
        } else {
            b[15] = 0;
        }
        this.writeToEEPROM(32, b);
    }

    @Override
    public double getAxisHomeOffset(int axis) {
        if (axis < 0 || axis > 4) {
            return 0.0;
        }
        this.checkEEPROM();
        byte[] r = this.readFromEEPROM(96 + axis * 4, 4);
        double val = 0.0;
        for (int i = 0; i < 4; ++i) {
            val += (double)((r[i] & 0xFF) << 8 * i);
        }
        Point5d stepsPerMM = this.getMachine().getStepsPerMM();
        switch (axis) {
            case 0: {
                val /= stepsPerMM.x();
                break;
            }
            case 1: {
                val /= stepsPerMM.y();
                break;
            }
            case 2: {
                val /= stepsPerMM.z();
                break;
            }
            case 3: {
                val /= stepsPerMM.a();
                break;
            }
            case 4: {
                val /= stepsPerMM.b();
            }
        }
        return val;
    }

    @Override
    public void setAxisHomeOffset(int axis, double offset) {
        if (axis < 0 || axis > 4) {
            return;
        }
        int offsetSteps = 0;
        Point5d stepsPerMM = this.getMachine().getStepsPerMM();
        switch (axis) {
            case 0: {
                offsetSteps = (int)(offset * stepsPerMM.x());
                break;
            }
            case 1: {
                offsetSteps = (int)(offset * stepsPerMM.y());
                break;
            }
            case 2: {
                offsetSteps = (int)(offset * stepsPerMM.z());
                break;
            }
            case 3: {
                offsetSteps = (int)(offset * stepsPerMM.a());
                break;
            }
            case 4: {
                offsetSteps = (int)(offset * stepsPerMM.b());
            }
        }
        this.writeToEEPROM(96 + axis * 4, this.intToLE(offsetSteps));
    }

    @Override
    public boolean hasToolheadsOffset() {
        return false;
    }

    @Override
    public double getToolheadsOffset(int axis) {
        Base.logger.info("Cannot get tolerance error for S3G driver");
        return 0.0;
    }

    @Override
    public void eepromStoreToolDelta(int axis, double offset) {
        Base.logger.info("Cannot store tolerance error for S3G driver");
    }

    @Override
    public int getAccelerationRate() {
        Base.logger.info("Cannot get acceleration rate for S3G driver");
        return 0;
    }

    @Override
    public void setAccelerationRate(int rate) {
        Base.logger.info("Cannot set acceleration rate for S3G driver");
    }

    @Override
    public byte getAccelerationStatus() {
        Base.logger.info("Cannot get acceleration status for S3G driver");
        return 0;
    }

    @Override
    public void setAccelerationStatus(byte status) {
        Base.logger.info("Cannot set acceleration status for S3G driver");
    }

    @Override
    public int getAxisAccelerationRate(int axis) {
        Base.logger.info("Cannot get acceleration axis rate for S3G driver");
        return 0;
    }

    @Override
    public void setAxisAccelerationRate(int axis, int rate) {
        Base.logger.info("Cannot set acceleration axis rate for S3G driver");
    }

    @Override
    public double getAxisJerk(int axis) {
        Base.logger.info("Cannot get acceleration axis jerk for S3G driver");
        return 0.0;
    }

    @Override
    public void setAxisJerk(int axis, double jerk) {
        Base.logger.info("Cannot set acceleration axis rate for S3G driver");
    }

    @Override
    public int getAccelerationMinimumSpeed() {
        Base.logger.info("Cannot get acceleration minimum speed for S3G driver");
        return 0;
    }

    @Override
    public void setAccelerationMinimumSpeed(int speed) {
        Base.logger.info("Cannot set acceleration minimum speed for S3G driver");
    }

    @Override
    public boolean hasAcceleration() {
        return false;
    }

    @Override
    public boolean hasJettyAcceleration() {
        return false;
    }

    @Override
    public boolean hasAdvancedFeatures() {
        return false;
    }

    @Override
    public int getEEPROMParamInt(OnboardParameters.EEPROMParams param) {
        Base.logger.info("This EEPROM interface, getEEPROMParamInt, is not supported for this driver");
        return 0;
    }

    @Override
    public long getEEPROMParamUInt(OnboardParameters.EEPROMParams param) {
        Base.logger.info("This EEPROM interface, getEEPROMParamUInt, is not supported for this driver");
        return 0L;
    }

    @Override
    public double getEEPROMParamFloat(OnboardParameters.EEPROMParams param) {
        Base.logger.info("This EEPROM interface, getEEPROMParamDouble, is not supported for this driver");
        return 0.0;
    }

    @Override
    public void setEEPROMParam(OnboardParameters.EEPROMParams param, int value) {
        Base.logger.info("This EEPROM interface, setEEPROMParam(param,int), is not supported for this driver");
    }

    @Override
    public void setEEPROMParam(OnboardParameters.EEPROMParams param, long value) {
        Base.logger.info("This EEPROM interface, setEEPROMParam(param,long), is not supported for this driver");
    }

    @Override
    public void setEEPROMParam(OnboardParameters.EEPROMParams param, double value) {
        Base.logger.info("This EEPROM interface, setEEPROMParam(param,double), is not supported for this driver");
    }

    @Override
    public void storeHomePositions(EnumSet<AxisId> axes) throws RetryException {
        byte b = 0;
        if (axes.contains((Object)AxisId.X)) {
            b = (byte)(b | 1);
        }
        if (axes.contains((Object)AxisId.Y)) {
            b = (byte)(b | 2);
        }
        if (axes.contains((Object)AxisId.Z)) {
            b = (byte)(b | 4);
        }
        if (axes.contains((Object)AxisId.A)) {
            b = (byte)(b | 8);
        }
        if (axes.contains((Object)AxisId.B)) {
            b = (byte)(b | 0x10);
        }
        Base.logger.fine("Storing home positions [" + (axes.contains((Object)AxisId.X) ? "X" : "") + (axes.contains((Object)AxisId.Y) ? "Y" : "") + (axes.contains((Object)AxisId.Z) ? "Z" : "") + (axes.contains((Object)AxisId.A) ? "A" : "") + (axes.contains((Object)AxisId.B) ? "B" : "") + "]");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.STORE_HOME_POSITIONS.getCode());
        pb.add8(b);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void recallHomePositions(EnumSet<AxisId> axes) throws RetryException {
        byte b = 0;
        if (axes.contains((Object)AxisId.X)) {
            b = (byte)(b | 1);
        }
        if (axes.contains((Object)AxisId.Y)) {
            b = (byte)(b | 2);
        }
        if (axes.contains((Object)AxisId.Z)) {
            b = (byte)(b | 4);
        }
        if (axes.contains((Object)AxisId.A)) {
            b = (byte)(b | 8);
        }
        if (axes.contains((Object)AxisId.B)) {
            b = (byte)(b | 0x10);
        }
        Base.logger.fine("Recalling home positions [" + (axes.contains((Object)AxisId.X) ? "X" : "") + (axes.contains((Object)AxisId.Y) ? "Y" : "") + (axes.contains((Object)AxisId.Z) ? "Z" : "") + (axes.contains((Object)AxisId.A) ? "A" : "") + (axes.contains((Object)AxisId.B) ? "B" : "") + "]");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.RECALL_HOME_POSITIONS.getCode());
        pb.add8(b);
        this.runCommand(pb.getPacket());
        this.invalidatePosition();
    }

    @Override
    public boolean hasFeatureOnboardParameters() {
        if (!this.isInitialized()) {
            return false;
        }
        return this.version.compareTo(new Version(1, 2)) >= 0;
    }

    @Override
    public void createThermistorTable(int which, double r0, double t0, double beta, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int ADC_RANGE = 1024;
        int NUMTEMPS = 20;
        byte[] table = new byte[80];
        class ThermistorConverter {
            final double ZERO_C_IN_KELVIN = 273.15;
            public double vadc;
            public double rs;
            public double vs;
            public double k;
            public double beta;

            public ThermistorConverter(double r0, double t0C, double beta, double r2) {
                this.beta = beta;
                this.vadc = 5.0;
                this.vs = 5.0;
                double t0K = 273.15 + t0C;
                this.k = r0 * Math.exp(-beta / t0K);
                this.rs = r2;
            }

            public double temp(double adc) {
                double v = adc * this.vadc / 1024.0;
                double r = this.rs * v / (this.vs - v);
                return this.beta / Math.log(r / this.k) - 273.15;
            }
        }
        ThermistorConverter tc = new ThermistorConverter(r0, t0, beta, 4700.0);
        double adc = 1.0;
        for (int i = 0; i < 20; ++i) {
            double temp = tc.temp(adc);
            int tempi = (int)temp;
            int adci = (int)adc;
            Base.logger.fine("{ " + Integer.toString(adci) + "," + Integer.toString(tempi) + " }");
            table[4 * i + 0] = (byte)(adci & 0xFF);
            table[4 * i + 1] = (byte)(adci >> 8);
            table[4 * i + 2] = (byte)(tempi & 0xFF);
            table[4 * i + 3] = (byte)(tempi >> 8);
            adc += 53.0;
        }
        byte[] eepromIndicator = new byte[]{90, 120};
        this.writeToToolEEPROM(0, eepromIndicator, toolhead);
        this.writeToToolEEPROM(Sanguino3GEEPRPOM.ECThermistorOffsets.beta(which), this.intToLE((int)beta), toolhead);
        this.writeToToolEEPROM(Sanguino3GEEPRPOM.ECThermistorOffsets.r0(which), this.intToLE((int)r0), toolhead);
        this.writeToToolEEPROM(Sanguino3GEEPRPOM.ECThermistorOffsets.t0(which), this.intToLE((int)t0), toolhead);
        this.writeToToolEEPROM(Sanguino3GEEPRPOM.ECThermistorOffsets.data(which), table, toolhead);
    }

    @Override
    public boolean getCoolingFanEnabled(int toolhead) {
        byte[] a;
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        return (a = this.readFromToolEEPROM(28, 1, toolhead))[0] == 1;
    }

    @Override
    public int getCoolingFanSetpoint(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        return this.read16FromToolEEPROM(29, 50, toolhead);
    }

    @Override
    public void setCoolingFanParameters(boolean enabled, int setpoint, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        if (enabled) {
            this.writeToToolEEPROM(28, new byte[]{1}, toolhead);
        } else {
            this.writeToToolEEPROM(28, new byte[]{0}, toolhead);
        }
        this.writeToToolEEPROM(29, this.intToLE(setpoint), toolhead);
    }

    protected byte[] intToLE(int s, int sz) {
        byte[] buf = new byte[sz];
        for (int i = 0; i < sz; ++i) {
            buf[i] = (byte)(s & 0xFF);
            s >>>= 8;
        }
        return buf;
    }

    protected byte[] floatToLE(float f) {
        byte[] buf = new byte[2];
        double d = f;
        double intPart = Math.floor(d);
        double fracPart = Math.floor((d - intPart) * 256.0);
        buf[0] = (byte)intPart;
        buf[1] = (byte)fracPart;
        return buf;
    }

    protected byte[] intToLE(int s) {
        return this.intToLE(s, 4);
    }

    protected float byte16LEToFloat(byte[] r, int offset) {
        return (float)(this.byteToInt(r[offset + 1]) | this.byteToInt(r[offset]) << 8) / 255.0f;
    }

    protected float byte16LEToFloat(byte[] r) {
        return this.byte16LEToFloat(r, 0);
    }

    SDCardCapture.ResponseCode convertSDCode(int code) {
        switch (code) {
            case 0: {
                return SDCardCapture.ResponseCode.SUCCESS;
            }
            case 1: {
                return SDCardCapture.ResponseCode.FAIL_NO_CARD;
            }
            case 2: {
                return SDCardCapture.ResponseCode.FAIL_INIT;
            }
            case 3: {
                return SDCardCapture.ResponseCode.FAIL_PARTITION;
            }
            case 4: {
                return SDCardCapture.ResponseCode.FAIL_FS;
            }
            case 5: {
                return SDCardCapture.ResponseCode.FAIL_ROOT_DIR;
            }
            case 6: {
                return SDCardCapture.ResponseCode.FAIL_LOCKED;
            }
            case 7: {
                return SDCardCapture.ResponseCode.FAIL_NO_FILE;
            }
        }
        return SDCardCapture.ResponseCode.FAIL_GENERIC;
    }

    @Override
    public void beginFileCapture(String path) throws FileNotFoundException {
        this.fileCaptureOstream = new FileOutputStream(new File(path));
    }

    @Override
    public void endFileCapture() throws IOException {
        this.fileCaptureOstream.close();
        this.fileCaptureOstream = null;
    }

    @Override
    public SDCardCapture.ResponseCode beginCapture(String filename) {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.CAPTURE_TO_FILE.getCode());
        for (byte b : filename.getBytes()) {
            pb.add8(b);
        }
        pb.add8(0);
        PacketResponse pr = this.runQuery(pb.getPacket());
        return this.convertSDCode(pr.get8());
    }

    @Override
    public int endCapture() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.END_CAPTURE.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        return pr.get32();
    }

    @Override
    public SDCardCapture.ResponseCode playback(String filename) {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.PLAYBACK_CAPTURE.getCode());
        for (byte b : filename.getBytes()) {
            pb.add8(b);
        }
        pb.add8(0);
        PacketResponse pr = this.runQuery(pb.getPacket());
        return this.convertSDCode(pr.get8());
    }

    @Override
    public boolean hasFeatureSDCardCapture() {
        if (!this.isInitialized()) {
            return false;
        }
        return this.version.compareTo(new Version(1, 3)) >= 0;
    }

    @Override
    public List<String> getFileList() {
        Vector<String> fileList = new Vector<String>();
        boolean reset = true;
        while (true) {
            char c;
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.NEXT_FILENAME.getCode());
            pb.add8(reset ? 1 : 0);
            reset = false;
            PacketResponse pr = this.runQuery(pb.getPacket());
            SDCardCapture.ResponseCode rc = this.convertSDCode(pr.get8());
            if (rc != SDCardCapture.ResponseCode.SUCCESS) {
                return fileList;
            }
            StringBuffer s = new StringBuffer();
            while ((c = (char)pr.get8()) != '\u0000') {
                s.append(c);
            }
            if (s.length() == 0) break;
            fileList.add(s.toString());
        }
        return fileList;
    }

    @Override
    public int getBeta(int which, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        byte[] r = this.readFromToolEEPROM(Sanguino3GEEPRPOM.ECThermistorOffsets.beta(which), 4, toolhead);
        int val = 0;
        if (r == null || r.length < 4) {
            Base.logger.fine("failure to read getBeta");
            return val;
        }
        for (int i = 0; i < 4; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    @Override
    public int getR0(int which, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        byte[] r = this.readFromToolEEPROM(Sanguino3GEEPRPOM.ECThermistorOffsets.r0(which), 4, toolhead);
        int val = 0;
        if (r == null || r.length < 4) {
            Base.logger.fine("failure to read getR0");
            return val;
        }
        for (int i = 0; i < 4; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    @Override
    public int getT0(int which, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        byte[] r = this.readFromToolEEPROM(Sanguino3GEEPRPOM.ECThermistorOffsets.t0(which), 4, toolhead);
        int val = 0;
        if (r == null || r.length < 4) {
            Base.logger.fine("failure to read getT0");
            return val;
        }
        for (int i = 0; i < 4; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    @Deprecated
    protected int read16FromToolEEPROM(int offset, int defaultValue) {
        return this.read16FromToolEEPROM(offset, defaultValue, this.machine.currentTool().getIndex());
    }

    protected int read16FromToolEEPROM(int offset, int defaultValue, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        byte[] r = this.readFromToolEEPROM(offset, 2, toolhead);
        int val = r[0] & 0xFF;
        if ((val += (r[1] & 0xFF) << 8) == 65535) {
            return defaultValue;
        }
        return val;
    }

    private int byteToInt(byte b) {
        return b & 0xFF;
    }

    private float readFloat16FromToolEEPROM(int offset, float defaultValue, int toolhead) {
        byte[] r;
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        if ((r = this.readFromToolEEPROM(offset, 2, toolhead)) == null) {
            Base.logger.severe("null read from tool at " + offset + " for tool " + toolhead + " default " + defaultValue);
            return defaultValue;
        }
        if (r[0] == -1 && r[1] == -1) {
            return defaultValue;
        }
        return (float)this.byteToInt(r[0]) + (float)this.byteToInt(r[1]) / 256.0f;
    }

    @Override
    public OnboardParameters.BackoffParameters getBackoffParameters(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        OnboardParameters.BackoffParameters bp = new OnboardParameters.BackoffParameters();
        bp.forwardMs = this.read16FromToolEEPROM(8, 300, toolhead);
        bp.stopMs = this.read16FromToolEEPROM(4, 5, toolhead);
        bp.reverseMs = this.read16FromToolEEPROM(6, 500, toolhead);
        bp.triggerMs = this.read16FromToolEEPROM(10, 300, toolhead);
        return bp;
    }

    @Override
    public void setBackoffParameters(OnboardParameters.BackoffParameters bp, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        this.writeToToolEEPROM(8, this.intToLE(bp.forwardMs, 2), toolhead);
        this.writeToToolEEPROM(4, this.intToLE(bp.stopMs, 2), toolhead);
        this.writeToToolEEPROM(6, this.intToLE(bp.reverseMs, 2), toolhead);
        this.writeToToolEEPROM(10, this.intToLE(bp.triggerMs, 2), toolhead);
    }

    @Override
    public OnboardParameters.PIDParameters getPIDParameters(int which, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        OnboardParameters.PIDParameters pp = new OnboardParameters.PIDParameters();
        int offset = which == 0 ? 12 : 18;
        pp.p = this.readFloat16FromToolEEPROM(offset + 0, 7.0f, toolhead);
        pp.i = this.readFloat16FromToolEEPROM(offset + 2, 0.325f, toolhead);
        pp.d = this.readFloat16FromToolEEPROM(offset + 4, 36.0f, toolhead);
        return pp;
    }

    @Override
    public void setPIDParameters(int which, OnboardParameters.PIDParameters pp, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int offset = which == 0 ? 12 : 18;
        this.writeToToolEEPROM(offset + 0, this.floatToLE(pp.p), toolhead);
        this.writeToToolEEPROM(offset + 2, this.floatToLE(pp.i), toolhead);
        this.writeToToolEEPROM(offset + 4, this.floatToLE(pp.d), toolhead);
    }

    @Override
    public void resetSettingsToFactory() throws RetryException {
        Base.logger.finer("resetting to Factory in Sanguino3G");
        this.resetSettingsToBlank();
    }

    @Override
    public void resetSettingsToBlank() throws RetryException {
        Base.logger.finer("resetting to Blank in Sanguino3G");
        byte[] eepromWipe = new byte[16];
        Arrays.fill(eepromWipe, (byte)-1);
        for (int i = 0; i < 512; i += 16) {
            this.writeToEEPROM(i, eepromWipe);
        }
    }

    @Override
    public void resetToolToFactory(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        this.resetToolToBlank(toolhead);
    }

    @Override
    public void resetToolToBlank(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        byte[] eepromWipe = new byte[16];
        Arrays.fill(eepromWipe, (byte)-1);
        for (int i = 0; i < 512; i += 16) {
            this.writeToToolEEPROM(i, eepromWipe, toolhead);
        }
    }

    @Override
    public OnboardParameters.EndstopType getInvertedEndstops() {
        this.checkEEPROM();
        byte[] b = this.readFromEEPROM(3, 1);
        return OnboardParameters.EndstopType.endstopTypeForValue(b[0]);
    }

    @Override
    public void setInvertedEndstops(OnboardParameters.EndstopType endstops) {
        byte[] b = new byte[]{endstops.getValue()};
        this.writeToEEPROM(3, b);
    }

    @Override
    public OnboardParameters.ExtraFeatures getExtraFeatures(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int efdat = this.read16FromToolEEPROM(24, 16516, toolhead);
        OnboardParameters.ExtraFeatures ef = new OnboardParameters.ExtraFeatures();
        ef.swapMotorController = (efdat & 1) != 0;
        ef.heaterChannel = efdat >> 2 & 3;
        ef.hbpChannel = efdat >> 4 & 3;
        ef.abpChannel = efdat >> 6 & 3;
        return ef;
    }

    @Override
    public void setExtraFeatures(OnboardParameters.ExtraFeatures features, int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        int efdat = 16384;
        if (features.swapMotorController) {
            efdat |= 1;
        }
        efdat |= features.heaterChannel << 2;
        efdat |= features.hbpChannel << 4;
        this.writeToToolEEPROM(24, this.intToLE(efdat |= features.abpChannel << 6, 2), toolhead);
    }

    @Override
    public OnboardParameters.EstopType getEstopConfig() {
        this.checkEEPROM();
        byte[] b = this.readFromEEPROM(116, 1);
        return OnboardParameters.EstopType.estopTypeForValue(b[0]);
    }

    @Override
    public void setEstopConfig(OnboardParameters.EstopType estop) {
        byte[] b = new byte[]{estop.getValue()};
        this.writeToEEPROM(116, b);
    }

    @Override
    @Deprecated
    public double getPlatformTemperatureSetting() {
        return this.getPlatformTemperatureSetting(this.machine.currentTool().getIndex());
    }

    public double getPlatformTemperatureSetting(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        if (this.toolVersion.atLeast(new Version(2, 3))) {
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
            pb.add8((byte)toolhead);
            pb.add8(ToolCommandCode.GET_PLATFORM_SP.getCode());
            PacketResponse pr = this.runQuery(pb.getPacket());
            int sp = pr.get16();
            this.machine.getTool(toolhead).setPlatformTargetTemperature(sp);
        }
        return this.machine.getTool(toolhead).getPlatformTargetTemperature();
    }

    @Override
    @Deprecated
    public double getTemperatureSetting() {
        return this.getTemperatureSetting(this.machine.currentTool().getIndex());
    }

    public double getTemperatureSetting(int toolhead) {
        if (toolhead == -1) {
            toolhead = this.machine.currentTool().getIndex();
        }
        if (this.toolVersion.atLeast(new Version(2, 3))) {
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
            pb.add8((byte)toolhead);
            pb.add8(ToolCommandCode.GET_SP.getCode());
            PacketResponse pr = this.runQuery(pb.getPacket());
            int sp = pr.get16();
            this.machine.getTool(toolhead).setTargetTemperature(sp);
        }
        return this.machine.getTool(toolhead).getTargetTemperature();
    }

    public Version getToolVersion() {
        return this.toolVersion;
    }

    @Override
    public boolean setConnectedToolIndex(int index) {
        byte[] data = new byte[]{(byte)index};
        this.writeToToolEEPROM(26, data, 255);
        this.writeToToolEEPROM(26, data, 127);
        return false;
    }

    @Override
    public boolean toolsCanBeReindexed() {
        return true;
    }

    @Override
    public boolean supportsSimultaneousTools() {
        return true;
    }

    @Override
    public boolean hasVrefSupport() {
        return false;
    }

    @Override
    public void setStoredStepperVoltage(int stepperId, int referenceValue) {
        throw new UnsupportedOperationException("Store Stepper Voltage not supported in Sanguino3GDriver");
    }

    @Override
    public int getStoredStepperVoltage(int stepperId) {
        throw new UnsupportedOperationException("Get Stored Stepper Voltage not supported in Sanguino3GDriver");
    }

    @Override
    public EnumMap<AxisId, String> getAxisAlises() {
        return new EnumMap<AxisId, String>(AxisId.class);
    }

    @Override
    public boolean canVerifyMachine() {
        return false;
    }

    @Override
    public boolean verifyMachineId() {
        return false;
    }

    @Override
    public String getMachineType() {
        return "MakerBot Sanguino";
    }

    @Override
    public int toolCountOnboard() {
        return 0;
    }

    @Override
    public boolean hasToolCountOnboard() {
        return false;
    }

    @Override
    public void setToolCountOnboard(int i) {
    }

    @Override
    public boolean hasHbp() {
        return false;
    }

    @Override
    public void setHbpSetting(boolean on_off) {
    }

    private static final class CoolingFanOffsets {
        static final int COOLING_FAN_ENABLE = 28;
        static final int COOLING_FAN_SETPOINT_C = 29;

        private CoolingFanOffsets() {
        }
    }

    private static final class PIDOffsets {
        static final int PID_EXTRUDER = 12;
        static final int PID_HBP = 18;
        static final int P_TERM_OFFSET = 0;
        static final int I_TERM_OFFSET = 2;
        static final int D_TERM_OFFSET = 4;

        private PIDOffsets() {
        }
    }

    private static final class ECBackoffOffsets {
        static final int STOP_MS = 4;
        static final int REVERSE_MS = 6;
        static final int FORWARD_MS = 8;
        static final int TRIGGER_MS = 10;

        private ECBackoffOffsets() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CommandType {
        COMMAND,
        QUERY;

    }
}

