/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine.builder;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import replicatorg.app.Base;
import replicatorg.drivers.Driver;
import replicatorg.drivers.SDCardCapture;
import replicatorg.drivers.SimulationDriver;
import replicatorg.machine.Machine;
import replicatorg.machine.builder.Direct;
import replicatorg.machine.builder.MachineBuilder;
import replicatorg.model.GCodeSource;

public class ToLocalFile
implements MachineBuilder {
    Direct directBuilder;
    SDCardCapture sdcc;
    public boolean setupFailed = true;

    public ToLocalFile(Driver driver, SimulationDriver simulator, GCodeSource source, String remoteName) {
        if (!(driver instanceof SDCardCapture)) {
            Base.logger.log(Level.WARNING, "Build to a file requires a driver with SDCardCapture!");
            return;
        }
        this.sdcc = (SDCardCapture)((Object)driver);
        try {
            this.sdcc.beginFileCapture(remoteName);
            this.directBuilder = new Direct(driver, simulator, source);
            this.setupFailed = false;
        }
        catch (FileNotFoundException e) {
            Base.logger.log(Level.WARNING, "Build to file failed: File Not Found!");
        }
    }

    public boolean finished() {
        if (this.setupFailed) {
            return true;
        }
        if (!this.directBuilder.finished()) {
            return false;
        }
        try {
            this.sdcc.endFileCapture();
            Base.logger.info("Finished writing to file!");
        }
        catch (IOException e) {
            Base.logger.log(Level.WARNING, "Could not finish writing to file");
        }
        return true;
    }

    public void runNext() {
        if (this.directBuilder != null) {
            this.directBuilder.runNext();
        }
    }

    public int getLinesTotal() {
        if (this.directBuilder == null) {
            return -1;
        }
        return this.directBuilder.getLinesTotal();
    }

    public int getLinesProcessed() {
        if (this.directBuilder == null) {
            return -1;
        }
        return this.directBuilder.getLinesProcessed();
    }

    public boolean isInteractive() {
        return false;
    }

    public Machine.JobTarget getTarget() {
        return Machine.JobTarget.FILE;
    }
}

