/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.gcode;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import javax.vecmath.Point3d;
import replicatorg.app.Base;
import replicatorg.app.exceptions.GCodeException;
import replicatorg.app.gcode.GCodeCommand;
import replicatorg.app.gcode.GCodeEnumeration;
import replicatorg.drivers.DriverQueryInterface;
import replicatorg.drivers.MultiTool;
import replicatorg.drivers.commands.ChangeGearRatio;
import replicatorg.drivers.commands.CloseClamp;
import replicatorg.drivers.commands.CloseCollet;
import replicatorg.drivers.commands.CloseValve;
import replicatorg.drivers.commands.DataCaptureNote;
import replicatorg.drivers.commands.Delay;
import replicatorg.drivers.commands.DisableAxes;
import replicatorg.drivers.commands.DisableDrives;
import replicatorg.drivers.commands.DisableFan;
import replicatorg.drivers.commands.DisableFloodCoolant;
import replicatorg.drivers.commands.DisableMistCoolant;
import replicatorg.drivers.commands.DisableMotor;
import replicatorg.drivers.commands.DisableSpindle;
import replicatorg.drivers.commands.DisplayMessage;
import replicatorg.drivers.commands.DriverCommand;
import replicatorg.drivers.commands.EnableAxes;
import replicatorg.drivers.commands.EnableDrives;
import replicatorg.drivers.commands.EnableExtruderMotor;
import replicatorg.drivers.commands.EnableFan;
import replicatorg.drivers.commands.EnableFloodCoolant;
import replicatorg.drivers.commands.EnableMistCoolant;
import replicatorg.drivers.commands.EnableSpindle;
import replicatorg.drivers.commands.GCodePassthrough;
import replicatorg.drivers.commands.GetPosition;
import replicatorg.drivers.commands.HomeAxes;
import replicatorg.drivers.commands.Initialize;
import replicatorg.drivers.commands.OpenClamp;
import replicatorg.drivers.commands.OpenCollet;
import replicatorg.drivers.commands.OpenValve;
import replicatorg.drivers.commands.OptionalHalt;
import replicatorg.drivers.commands.PauseAtZPos;
import replicatorg.drivers.commands.PlaySong;
import replicatorg.drivers.commands.ProgramEnd;
import replicatorg.drivers.commands.ProgramRewind;
import replicatorg.drivers.commands.QueuePoint;
import replicatorg.drivers.commands.ReadTemperature;
import replicatorg.drivers.commands.RecallHomePositions;
import replicatorg.drivers.commands.RequestToolChange;
import replicatorg.drivers.commands.SelectTool;
import replicatorg.drivers.commands.SetAccelerationToggle;
import replicatorg.drivers.commands.SetAxisOffset;
import replicatorg.drivers.commands.SetBuildPercent;
import replicatorg.drivers.commands.SetChamberTemperature;
import replicatorg.drivers.commands.SetCurrentPosition;
import replicatorg.drivers.commands.SetFeedrate;
import replicatorg.drivers.commands.SetMotorDirection;
import replicatorg.drivers.commands.SetPlatformTemperature;
import replicatorg.drivers.commands.SetServo;
import replicatorg.drivers.commands.SetSpindleDirection;
import replicatorg.drivers.commands.SetSpindleRPM;
import replicatorg.drivers.commands.SetStepperVoltage;
import replicatorg.drivers.commands.SetTemperature;
import replicatorg.drivers.commands.StartDataCapture;
import replicatorg.drivers.commands.StopDataCapture;
import replicatorg.drivers.commands.StoreHomePositions;
import replicatorg.drivers.commands.ToggleAutomatedBuildPlatform;
import replicatorg.drivers.commands.UnconditionalHalt;
import replicatorg.drivers.commands.WaitUntilBufferEmpty;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.ToolheadAlias;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCodeParser {
    protected DriverQueryInterface driver;
    public static double curveSectionMM = Base.preferences.getDouble("replicatorg.parser.curve_segment_mm", 1.0);
    public static double curveSectionInches = curveSectionMM / 25.4;
    protected double curveSection = 0.0;
    protected Point3d currentOffset;
    boolean absoluteMode = false;
    double feedrate = 0.0;
    protected int tool;
    public static int UNITS_MM = 0;
    public static int UNITS_INCHES = 1;
    protected int units;

    Queue<DriverCommand> drawArc(Point5d center, Point5d endpoint, boolean clockwise) {
        double angleB;
        double angleA;
        LinkedList<DriverCommand> points = new LinkedList<DriverCommand>();
        Point5d current = this.driver.getCurrentPosition(false);
        double aX = current.x() - center.x();
        double aY = current.y() - center.y();
        double bX = endpoint.x() - center.x();
        double bY = endpoint.y() - center.y();
        if (clockwise) {
            angleA = Math.atan2(bY, bX);
            angleB = Math.atan2(aY, aX);
        } else {
            angleA = Math.atan2(aY, aX);
            angleB = Math.atan2(bY, bX);
        }
        if (angleB <= angleA) {
            angleB += Math.PI * 2;
        }
        double angle = angleB - angleA;
        double radius = Math.sqrt(aX * aX + aY * aY);
        double length = radius * angle;
        int steps = (int)Math.ceil(Math.max(angle * 2.4, length / this.curveSection));
        Point5d newPoint = new Point5d(current);
        double arcStartZ = current.z();
        for (int s = 1; s <= steps; ++s) {
            int step = !clockwise ? s : steps - s;
            newPoint.setX(center.x() + radius * Math.cos(angleA + angle * ((double)step / (double)steps)));
            newPoint.setY(center.y() + radius * Math.sin(angleA + angle * ((double)step / (double)steps)));
            newPoint.setZ(arcStartZ + (endpoint.z() - arcStartZ) * (double)s / (double)steps);
            points.add(new QueuePoint(newPoint));
        }
        return points;
    }

    public GCodeParser() {
        this.tool = ToolheadAlias.SINGLE.number;
        this.units = UNITS_MM;
        this.curveSection = curveSectionMM;
        this.currentOffset = new Point3d();
    }

    protected double getMaxFeedrate() {
        return this.driver.getMaximumFeedrates().x();
    }

    public void init(DriverQueryInterface drv) {
        this.driver = drv;
        this.currentOffset = this.driver.getOffset(0);
    }

    public boolean parse(String cmd, Queue<DriverCommand> commandQueue) {
        GCodeCommand gcode = new GCodeCommand(cmd);
        if (this.driver.isPassthroughDriver()) {
            commandQueue.add(new GCodePassthrough(gcode.getCommand()));
        } else {
            try {
                if (gcode.hasCode('G')) {
                    this.buildGCodes(gcode, commandQueue);
                } else if (gcode.hasCode('M')) {
                    this.buildMCodes(gcode, commandQueue);
                } else if (gcode.hasCode('T')) {
                    this.buildTCodes(gcode, commandQueue);
                }
            }
            catch (GCodeException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private double convertToMM(double value, int units) {
        if (units == UNITS_INCHES) {
            return value * 25.4;
        }
        return value;
    }

    private EnumSet<AxisId> getAxes(GCodeCommand gcode) {
        EnumSet<AxisId> axes = EnumSet.noneOf(AxisId.class);
        if (gcode.hasCode('X')) {
            axes.add(AxisId.X);
        }
        if (gcode.hasCode('Y')) {
            axes.add(AxisId.Y);
        }
        if (gcode.hasCode('Z')) {
            axes.add(AxisId.Z);
        }
        if (gcode.hasCode('A')) {
            axes.add(AxisId.A);
        }
        if (gcode.hasCode('B')) {
            axes.add(AxisId.B);
        }
        return axes;
    }

    private void buildTCodes(GCodeCommand gcode, Queue<DriverCommand> commands) throws GCodeException {
        if (this.driver instanceof MultiTool && ((MultiTool)((Object)this.driver)).supportsSimultaneousTools()) {
            throw new GCodeException("the current driver" + this.driver.toString() + " does not support multipleTools");
        }
        this.tool = (int)gcode.getCodeValue('T');
        commands.add(new SelectTool(this.tool));
        this.currentOffset = this.driver.getOffset(this.tool + 1);
    }

    private void buildMCodes(GCodeCommand gcode, Queue<DriverCommand> commands) throws GCodeException {
        if (gcode.hasCode('T') && this.driver instanceof MultiTool && ((MultiTool)((Object)this.driver)).supportsSimultaneousTools()) {
            commands.add(new SelectTool((int)gcode.getCodeValue('T')));
            this.tool = (int)gcode.getCodeValue('T');
        }
        if (GCodeEnumeration.getGCode("M", (int)gcode.getCodeValue('M')) == null) {
            String message = "Unrecognized MCode! M" + (int)gcode.getCodeValue('M');
            Base.logger.log(Level.SEVERE, message);
            throw new GCodeException(message);
        }
        switch (GCodeEnumeration.getGCode("M", (int)gcode.getCodeValue('M'))) {
            case M0: {
                commands.add(new WaitUntilBufferEmpty());
                commands.add(new UnconditionalHalt(gcode.getComment()));
                break;
            }
            case M1: {
                commands.add(new WaitUntilBufferEmpty());
                commands.add(new OptionalHalt(gcode.getComment()));
                break;
            }
            case M2: {
                commands.add(new WaitUntilBufferEmpty());
                commands.add(new ProgramEnd(gcode.getComment()));
                break;
            }
            case M30: {
                commands.add(new WaitUntilBufferEmpty());
                commands.add(new ProgramRewind(gcode.getComment()));
                break;
            }
            case M3: {
                commands.add(new SetSpindleDirection(DriverCommand.AxialDirection.CLOCKWISE));
                commands.add(new EnableSpindle());
                break;
            }
            case M4: {
                commands.add(new SetSpindleDirection(DriverCommand.AxialDirection.COUNTERCLOCKWISE));
                commands.add(new EnableSpindle());
                break;
            }
            case M5: {
                commands.add(new DisableSpindle());
                break;
            }
            case M6: {
                int timeout = 65535;
                if (gcode.hasCode('P')) {
                    timeout = (int)gcode.getCodeValue('P');
                }
                if (gcode.hasCode('T')) {
                    commands.add(new RequestToolChange((int)gcode.getCodeValue('T'), timeout));
                    break;
                }
                throw new GCodeException("The T parameter is required for tool changes. (M6)");
            }
            case M7: {
                commands.add(new EnableFloodCoolant());
                break;
            }
            case M8: {
                commands.add(new EnableMistCoolant());
                break;
            }
            case M9: {
                commands.add(new DisableFloodCoolant());
                commands.add(new DisableMistCoolant());
                break;
            }
            case M10: {
                if (gcode.hasCode('Q')) {
                    commands.add(new CloseClamp((int)gcode.getCodeValue('Q')));
                    break;
                }
                throw new GCodeException("The Q parameter is required for clamp operations. (M10)");
            }
            case M11: {
                if (gcode.hasCode('Q')) {
                    commands.add(new OpenClamp((int)gcode.getCodeValue('Q')));
                    break;
                }
                throw new GCodeException("The Q parameter is required for clamp operations. (M11)");
            }
            case M13: {
                commands.add(new SetSpindleDirection(DriverCommand.AxialDirection.CLOCKWISE));
                commands.add(new EnableSpindle());
                commands.add(new EnableFloodCoolant());
                break;
            }
            case M14: {
                commands.add(new SetSpindleDirection(DriverCommand.AxialDirection.COUNTERCLOCKWISE));
                commands.add(new EnableSpindle());
                commands.add(new EnableFloodCoolant());
                break;
            }
            case M17: {
                EnumSet<AxisId> axes = this.getAxes(gcode);
                if (axes.isEmpty()) {
                    commands.add(new EnableDrives());
                    break;
                }
                commands.add(new EnableAxes(axes));
                break;
            }
            case M18: {
                EnumSet<AxisId> axes = this.getAxes(gcode);
                if (axes.isEmpty()) {
                    commands.add(new DisableDrives());
                    break;
                }
                commands.add(new DisableAxes(axes));
                break;
            }
            case M21: {
                commands.add(new OpenCollet());
                break;
            }
            case M22: {
                commands.add(new CloseCollet());
                break;
            }
            case M40: {
                commands.add(new ChangeGearRatio(0));
                break;
            }
            case M41: {
                commands.add(new ChangeGearRatio(1));
                break;
            }
            case M42: {
                commands.add(new ChangeGearRatio(2));
                break;
            }
            case M43: {
                commands.add(new ChangeGearRatio(3));
                break;
            }
            case M44: {
                commands.add(new ChangeGearRatio(4));
                break;
            }
            case M45: {
                commands.add(new ChangeGearRatio(5));
                break;
            }
            case M46: {
                commands.add(new ChangeGearRatio(6));
                break;
            }
            case M50: {
                this.driver.getSpindleRPM();
                break;
            }
            case M70: {
                if (gcode.hasCode('P')) {
                    commands.add(new DisplayMessage(gcode.getCodeValue('P'), gcode.getComment(), false));
                    break;
                }
                commands.add(new DisplayMessage(0.0, gcode.getComment(), false));
                break;
            }
            case M71: {
                if (gcode.getComment().length() > 0) {
                    commands.add(new DisplayMessage(0.0, gcode.getComment(), true));
                    break;
                }
                commands.add(new DisplayMessage(0.0, "Paused, press button\nto continue", true));
                break;
            }
            case M72: {
                commands.add(new PlaySong(gcode.getCodeValue('P')));
                break;
            }
            case M73: {
                commands.add(new SetBuildPercent(gcode.getCodeValue('P'), gcode.getComment()));
                break;
            }
            case M101: {
                commands.add(new SetMotorDirection(DriverCommand.AxialDirection.CLOCKWISE));
                commands.add(new EnableExtruderMotor());
                break;
            }
            case M102: {
                commands.add(new SetMotorDirection(DriverCommand.AxialDirection.COUNTERCLOCKWISE));
                commands.add(new EnableExtruderMotor());
                break;
            }
            case M103: {
                commands.add(new DisableMotor());
                break;
            }
            case M104: {
                if (!gcode.hasCode('S')) break;
                commands.add(new SetTemperature(gcode.getCodeValue('S')));
                break;
            }
            case M105: {
                commands.add(new ReadTemperature());
                break;
            }
            case M106: {
                if (this.driver.hasAutomatedBuildPlatform()) {
                    commands.add(new ToggleAutomatedBuildPlatform(true));
                    break;
                }
                commands.add(new EnableFan());
                break;
            }
            case M107: {
                if (this.driver.hasAutomatedBuildPlatform()) {
                    commands.add(new ToggleAutomatedBuildPlatform(false));
                    break;
                }
                commands.add(new DisableFan());
                break;
            }
            case M108: {
                break;
            }
            case M109: 
            case M140: {
                if (!gcode.hasCode('S')) break;
                commands.add(new SetPlatformTemperature(gcode.getCodeValue('S')));
                break;
            }
            case M110: {
                commands.add(new SetChamberTemperature(gcode.getCodeValue('S')));
                break;
            }
            case M126: {
                commands.add(new OpenValve());
                break;
            }
            case M127: {
                commands.add(new CloseValve());
                break;
            }
            case M128: {
                commands.add(new GetPosition());
                break;
            }
            case M131: {
                EnumSet<AxisId> axes = this.getAxes(gcode);
                commands.add(new StoreHomePositions(axes));
                break;
            }
            case M132: {
                EnumSet<AxisId> axes = this.getAxes(gcode);
                commands.add(new RecallHomePositions(axes));
                commands.add(new WaitUntilBufferEmpty());
                break;
            }
            case M141: 
            case M142: {
                break;
            }
            case M200: {
                commands.add(new Initialize());
                break;
            }
            case M300: {
                if (!gcode.hasCode('S')) break;
                commands.add(new SetServo(0, gcode.getCodeValue('S')));
                break;
            }
            case M301: {
                if (!gcode.hasCode('S')) break;
                commands.add(new SetServo(1, gcode.getCodeValue('S')));
                break;
            }
            case M310: {
                commands.add(new WaitUntilBufferEmpty());
                commands.add(new StartDataCapture(gcode.getComment()));
                break;
            }
            case M311: {
                commands.add(new WaitUntilBufferEmpty());
                commands.add(new StopDataCapture());
                break;
            }
            case M312: {
                commands.add(new WaitUntilBufferEmpty());
                commands.add(new DataCaptureNote(gcode.getComment()));
                break;
            }
            case M320: {
                commands.add(new SetAccelerationToggle(true));
                break;
            }
            case M321: {
                commands.add(new SetAccelerationToggle(false));
                break;
            }
            case M322: {
                if (gcode.hasCode('Z')) {
                    commands.add(new PauseAtZPos(gcode.getCodeValue('Z')));
                    break;
                }
                throw new GCodeException("The Z parameter is required for PauseAtZPos. (M322)");
            }
            default: {
                throw new GCodeException("Unknown M code: M" + (int)gcode.getCodeValue('M'));
            }
        }
    }

    private void buildGCodes(GCodeCommand gcode, Queue<DriverCommand> commands) throws GCodeException {
        GCodeEnumeration codeEnum;
        if (!gcode.hasCode('G')) {
            throw new GCodeException("Not a G code!");
        }
        Point5d pos = this.driver.getCurrentPosition(false);
        double iVal = this.convertToMM(gcode.getCodeValue('I'), this.units);
        double jVal = this.convertToMM(gcode.getCodeValue('J'), this.units);
        double kVal = this.convertToMM(gcode.getCodeValue('K'), this.units);
        double qVal = this.convertToMM(gcode.getCodeValue('Q'), this.units);
        double rVal = this.convertToMM(gcode.getCodeValue('R'), this.units);
        double xVal = this.convertToMM(gcode.getCodeValue('X'), this.units);
        double yVal = this.convertToMM(gcode.getCodeValue('Y'), this.units);
        double zVal = this.convertToMM(gcode.getCodeValue('Z'), this.units);
        double aVal = this.convertToMM(gcode.getCodeValue('A'), this.units);
        double bVal = this.convertToMM(gcode.getCodeValue('B'), this.units);
        double eVal = this.convertToMM(gcode.getCodeValue('E'), this.units);
        xVal += this.currentOffset.x;
        yVal += this.currentOffset.y;
        zVal += this.currentOffset.z;
        if (this.absoluteMode) {
            if (gcode.hasCode('X')) {
                pos.setX(xVal);
            }
            if (gcode.hasCode('Y')) {
                pos.setY(yVal);
            }
            if (gcode.hasCode('Z')) {
                pos.setZ(zVal);
            }
            if (gcode.hasCode('A')) {
                pos.setA(aVal);
            }
            if (gcode.hasCode('E')) {
                if (this.driver.getMachine().getTool(this.tool).getMotorStepperAxis().name() == "B") {
                    pos.setB(eVal);
                } else {
                    pos.setA(eVal);
                }
            }
            if (gcode.hasCode('B')) {
                pos.setB(bVal);
            }
        } else {
            if (gcode.hasCode('X')) {
                pos.setX(pos.x() + xVal);
            }
            if (gcode.hasCode('Y')) {
                pos.setY(pos.y() + yVal);
            }
            if (gcode.hasCode('Z')) {
                pos.setZ(pos.z() + zVal);
            }
            if (gcode.hasCode('A')) {
                pos.setA(pos.a() + aVal);
            }
            if (gcode.hasCode('E')) {
                if (this.driver.getMachine().getTool(this.tool).getMotorStepperAxis().name() == "B") {
                    pos.setB(pos.b() + eVal);
                } else {
                    pos.setA(pos.a() + eVal);
                }
            }
            if (gcode.hasCode('B')) {
                pos.setB(pos.b() + bVal);
            }
        }
        if (gcode.hasCode('F')) {
            this.feedrate = gcode.getCodeValue('F');
            commands.add(new SetFeedrate(this.feedrate));
        }
        if ((codeEnum = GCodeEnumeration.getGCode("G", (int)gcode.getCodeValue('G'))) == null) {
            String message = "Unrecognized GCode! G" + (int)gcode.getCodeValue('G');
            Base.logger.log(Level.SEVERE, message);
            throw new GCodeException(message);
        }
        switch (codeEnum) {
            case G0: {
                if (gcode.hasCode('F')) {
                    commands.add(new SetFeedrate(this.feedrate));
                } else {
                    Point5d diff = this.driver.getCurrentPosition(false);
                    diff.sub(pos);
                    diff.absolute();
                    double length = diff.length();
                    double selectedFR = Double.MAX_VALUE;
                    Point5d maxFR = this.driver.getMaximumFeedrates();
                    for (int idx = 0; idx < 3; ++idx) {
                        double candidate;
                        double axisMove = diff.get(idx);
                        if (axisMove == 0.0 || !((candidate = maxFR.get(idx) * length / axisMove) < selectedFR)) continue;
                        selectedFR = candidate;
                    }
                    if (selectedFR == Double.MAX_VALUE) {
                        selectedFR = maxFR.get(0);
                    }
                    commands.add(new SetFeedrate(selectedFR));
                }
                commands.add(new QueuePoint(pos));
                break;
            }
            case G1: {
                commands.add(new SetFeedrate(this.feedrate));
                commands.add(new QueuePoint(pos));
                break;
            }
            case G2: 
            case G3: {
                if (gcode.hasCode('I') || gcode.hasCode('J')) {
                    Point5d center = new Point5d();
                    Point5d current = this.driver.getCurrentPosition(false);
                    center.setX(current.x() + iVal);
                    center.setY(current.y() + jVal);
                    if (codeEnum == GCodeEnumeration.G2) {
                        commands.addAll(this.drawArc(center, pos, true));
                        break;
                    }
                    commands.addAll(this.drawArc(center, pos, false));
                    break;
                }
                if (!gcode.hasCode('R')) break;
                throw new GCodeException("G02/G03 arcs with (R)adius parameter are not supported yet.");
            }
            case G4: {
                commands.add(new Delay((long)gcode.getCodeValue('P')));
                break;
            }
            case G10: {
                if (gcode.hasCode('P')) {
                    int offsetSystemNum = (int)gcode.getCodeValue('P');
                    if (offsetSystemNum < 1 || offsetSystemNum > 6) break;
                    if (gcode.hasCode('X')) {
                        commands.add(new SetAxisOffset(AxisId.X, offsetSystemNum, gcode.getCodeValue('X')));
                    }
                    if (gcode.hasCode('Y')) {
                        commands.add(new SetAxisOffset(AxisId.Y, offsetSystemNum, gcode.getCodeValue('Y')));
                    }
                    if (!gcode.hasCode('Z')) break;
                    commands.add(new SetAxisOffset(AxisId.Z, offsetSystemNum, gcode.getCodeValue('Z')));
                    break;
                }
                Base.logger.warning("No coordinate system indicated use G10 Pn, where n is 0-6.");
                break;
            }
            case G20: 
            case G70: {
                this.units = UNITS_INCHES;
                this.curveSection = curveSectionInches;
                break;
            }
            case G21: 
            case G71: {
                this.units = UNITS_MM;
                this.curveSection = curveSectionMM;
                break;
            }
            case G28: {
                EnumSet<AxisId> axes = this.getAxes(gcode);
                if (gcode.hasCode('F')) {
                    commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.POSITIVE, this.feedrate));
                    break;
                }
                commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.POSITIVE));
                break;
            }
            case G161: {
                EnumSet<AxisId> axes = this.getAxes(gcode);
                if (gcode.hasCode('F')) {
                    commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.NEGATIVE, this.feedrate));
                    break;
                }
                commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.NEGATIVE));
                break;
            }
            case G162: {
                EnumSet<AxisId> axes = this.getAxes(gcode);
                if (gcode.hasCode('F')) {
                    commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.POSITIVE, this.feedrate));
                    break;
                }
                commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.POSITIVE));
                break;
            }
            case G53: {
                this.currentOffset = this.driver.getOffset(0);
                break;
            }
            case G54: {
                this.currentOffset = this.driver.getOffset(1);
                break;
            }
            case G55: {
                this.currentOffset = this.driver.getOffset(2);
                break;
            }
            case G56: {
                this.currentOffset = this.driver.getOffset(3);
                break;
            }
            case G57: {
                this.currentOffset = this.driver.getOffset(4);
                break;
            }
            case G58: {
                this.currentOffset = this.driver.getOffset(5);
                break;
            }
            case G59: {
                this.currentOffset = this.driver.getOffset(6);
                break;
            }
            case G90: {
                this.absoluteMode = true;
                break;
            }
            case G91: {
                this.absoluteMode = false;
                break;
            }
            case G92: {
                Point5d current = this.driver.getCurrentPosition(false);
                if (gcode.hasCode('X')) {
                    current.setX(xVal);
                }
                if (gcode.hasCode('Y')) {
                    current.setY(yVal);
                }
                if (gcode.hasCode('Z')) {
                    current.setZ(zVal);
                }
                if (gcode.hasCode('A')) {
                    current.setA(aVal);
                }
                if (gcode.hasCode('E')) {
                    if (this.driver.getMachine().getTool(this.tool).getMotorStepperAxis().name() == "B") {
                        current.setB(eVal);
                    } else {
                        current.setA(eVal);
                    }
                }
                if (gcode.hasCode('B')) {
                    current.setB(bVal);
                }
                commands.add(new SetCurrentPosition(current));
                break;
            }
            case G97: {
                commands.add(new SetSpindleRPM(gcode.getCodeValue('S')));
                break;
            }
            case G130: {
                if (gcode.hasCode('X')) {
                    commands.add(new SetStepperVoltage(0, (int)gcode.getCodeValue('X')));
                }
                if (gcode.hasCode('Y')) {
                    commands.add(new SetStepperVoltage(1, (int)gcode.getCodeValue('Y')));
                }
                if (gcode.hasCode('Z')) {
                    commands.add(new SetStepperVoltage(2, (int)gcode.getCodeValue('Z')));
                }
                if (gcode.hasCode('A')) {
                    commands.add(new SetStepperVoltage(3, (int)gcode.getCodeValue('A')));
                }
                if (!gcode.hasCode('B')) break;
                commands.add(new SetStepperVoltage(4, (int)gcode.getCodeValue('B')));
                break;
            }
            default: {
                throw new GCodeException("Unknown G code: G" + (int)gcode.getCodeValue('G'));
            }
        }
    }
}

