/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.onboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.prefs.BackingStoreException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.text.InternationalFormatter;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.drivers.Driver;
import replicatorg.drivers.OnboardParameters;
import replicatorg.drivers.RetryException;
import replicatorg.machine.model.AxisId;

public class MachineOnboardParameters
extends JPanel {
    private static final long serialVersionUID = 7876192459063774731L;
    private final OnboardParameters target;
    private final Driver driver;
    private final JFrame parent;
    private final JTabbedPane subTabs;
    private final MachineOnboardAccelerationParameters accelUI;
    private DriverType driverType = DriverType.OTHER;
    private JTextField machineNameField = new JTextField();
    private static final String[] toolCountChoices = new String[]{"unavailable", "1", "2"};
    private JComboBox toolCountField = new JComboBox<String>(toolCountChoices);
    private JCheckBox hbpToggleBox = new JCheckBox();
    private JCheckBox xAxisInvertBox = new JCheckBox();
    private JCheckBox yAxisInvertBox = new JCheckBox();
    private JCheckBox zAxisInvertBox = new JCheckBox();
    private JCheckBox aAxisInvertBox = new JCheckBox();
    private JCheckBox bAxisInvertBox = new JCheckBox();
    private JCheckBox zHoldBox = new JCheckBox();
    private JCheckBox pStopBox = new JCheckBox();
    private JCheckBox clear4EStopBox = new JCheckBox();
    private JCheckBox zMinStopBox = new JCheckBox();
    private JButton resetToFactoryButton = new JButton("Reset motherboard to factory settings");
    private JButton resetToBlankButton = new JButton("Reset motherboard completely");
    private JButton commitButton = new JButton("Commit Changes");
    private static final String[] endstopInversionChoices = new String[]{"No endstops installed", "Inverted (Default; Mechanical switch or H21LOB-based enstops)", "Non-inverted (H21LOI-based endstops)"};
    private JComboBox endstopInversionSelection = new JComboBox<String>(endstopInversionChoices);
    private static final String[] estopChoices = new String[]{"No emergency stop installed", "Active high emergency stop (safety cutoff kit)", "Active low emergency stop (custom solution)"};
    private JComboBox estopSelection = new JComboBox<String>(estopChoices);
    private static final int MAX_NAME_LENGTH = 15;
    private boolean disconnectNeededOnExit = false;
    private static final int defaultToolTipWidth = 60;
    private NumberFormat threePlaces = Base.getLocalFormat();
    private JFormattedTextField xAxisHomeOffsetField;
    private JFormattedTextField yAxisHomeOffsetField;
    private JFormattedTextField zAxisHomeOffsetField;
    private JFormattedTextField aAxisHomeOffsetField;
    private JFormattedTextField bAxisHomeOffsetField;
    private JFormattedTextField vref0;
    private JFormattedTextField vref1;
    private JFormattedTextField vref2;
    private JFormattedTextField vref3;
    private JFormattedTextField vref4;
    private JFormattedTextField xToolheadOffsetField;
    private JFormattedTextField yToolheadOffsetField;

    private void requestResetFromUser(String extendedMessage) {
        int confirm;
        String message = "For these changes to take effect your motherboard needs to reset. <br/>This may take up to <b>10 seconds</b>.";
        if (extendedMessage != null) {
            message = message + extendedMessage;
        }
        if ((confirm = JOptionPane.showConfirmDialog(this, "<html>" + message + "</html>", "Reset board.", -1, 1)) == 0) {
            this.disconnectNeededOnExit = true;
            this.driver.reset();
        } else {
            this.disconnectNeededOnExit = false;
        }
    }

    private void commit() {
        String newName = this.machineNameField.getText();
        if (newName.length() > 15) {
            this.machineNameField.setText(newName.substring(0, 15));
        }
        this.target.setMachineName(this.machineNameField.getText());
        if (this.target.hasToolCountOnboard()) {
            if (this.toolCountField.getSelectedIndex() > 0) {
                this.target.setToolCountOnboard(this.toolCountField.getSelectedIndex());
            } else {
                this.target.setToolCountOnboard(-1);
            }
        }
        if (this.driverType == DriverType.MIGHTYBOARD || this.driverType == DriverType.MIGHTYSAILFISH) {
            this.target.setHbpSetting(this.hbpToggleBox.isSelected());
        }
        EnumSet<AxisId> axesInverted = EnumSet.noneOf(AxisId.class);
        if (this.xAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.X);
        }
        if (this.yAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.Y);
        }
        if (this.zAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.Z);
        }
        if (this.aAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.A);
        }
        if (this.bAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.B);
        }
        if (!this.zHoldBox.isSelected()) {
            axesInverted.add(AxisId.V);
        }
        this.target.setInvertedAxes(axesInverted);
        int idx = this.endstopInversionSelection.getSelectedIndex();
        OnboardParameters.EndstopType endstops = OnboardParameters.EndstopType.values()[idx];
        this.target.setInvertedEndstops(endstops);
        if (this.driverType != DriverType.MIGHTYBOARD && this.driverType != DriverType.MIGHTYSAILFISH) {
            idx = this.estopSelection.getSelectedIndex();
            OnboardParameters.EstopType estop = OnboardParameters.EstopType.estopTypeForValue((byte)idx);
            this.target.setEstopConfig(estop);
        }
        this.target.setPStop(this.pStopBox.isSelected());
        this.target.setEEPROMParam(OnboardParameters.EEPROMParams.CLEAR_FOR_ESTOP, this.clear4EStopBox.isSelected() ? 1 : 0);
        if (this.driverType == DriverType.SAILFISH) {
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ENDSTOP_Z_MIN, this.zMinStopBox.isSelected() ? 1 : 0);
        }
        this.target.setAxisHomeOffset(0, ((Number)this.xAxisHomeOffsetField.getValue()).doubleValue());
        this.target.setAxisHomeOffset(1, ((Number)this.yAxisHomeOffsetField.getValue()).doubleValue());
        this.target.setAxisHomeOffset(2, ((Number)this.zAxisHomeOffsetField.getValue()).doubleValue());
        this.target.setAxisHomeOffset(3, ((Number)this.aAxisHomeOffsetField.getValue()).doubleValue());
        this.target.setAxisHomeOffset(4, ((Number)this.bAxisHomeOffsetField.getValue()).doubleValue());
        if (this.target.hasVrefSupport()) {
            this.target.setStoredStepperVoltage(0, ((Number)this.vref0.getValue()).intValue());
            this.target.setStoredStepperVoltage(1, ((Number)this.vref1.getValue()).intValue());
            this.target.setStoredStepperVoltage(2, ((Number)this.vref2.getValue()).intValue());
            this.target.setStoredStepperVoltage(3, ((Number)this.vref3.getValue()).intValue());
            this.target.setStoredStepperVoltage(4, ((Number)this.vref4.getValue()).intValue());
        }
        if (this.target.hasToolheadsOffset()) {
            this.target.eepromStoreToolDelta(0, ((Number)this.xToolheadOffsetField.getValue()).doubleValue());
            this.target.eepromStoreToolDelta(1, ((Number)this.yToolheadOffsetField.getValue()).doubleValue());
        }
        this.accelUI.setEEPROMFromUI();
        String extendedMessage = null;
        if (this.target.hasAcceleration() && this.driverType == DriverType.MIGHTYBOARD) {
            int feedrate = Base.preferences.getInt("replicatorg.skeinforge.printOMatic5D.desiredFeedrate", 40);
            int travelRate = Base.preferences.getInt("replicatorg.skeinforge.printOMatic5D.travelFeedrate", 55);
            if (this.accelUI.isAccelerationEnabled()) {
                Base.logger.finest("forced skeinforge speedup");
                if (feedrate <= 40) {
                    Base.preferences.put("replicatorg.skeinforge.printOMatic5D.desiredFeedrate", "100");
                }
                if (travelRate <= 55) {
                    Base.preferences.put("replicatorg.skeinforge.printOMatic5D.travelFeedrate", "150");
                }
                extendedMessage = "  <br/><b>Also updating Print-O-Matic speed settings!</b>";
            } else {
                Base.logger.finest("forced skeinforge slowdown");
                if (feedrate > 40) {
                    Base.preferences.put("replicatorg.skeinforge.printOMatic5D.desiredFeedrate", "40");
                }
                if (travelRate > 55) {
                    Base.preferences.put("replicatorg.skeinforge.printOMatic5D.travelFeedrate", "55");
                }
                int xJog = 0;
                int zJog = 0;
                try {
                    if (Base.preferences.nodeExists("controlpanel.feedrate.z")) {
                        zJog = Base.preferences.getInt("controlpanel.feedrate.z", 480);
                    }
                    if (Base.preferences.nodeExists("controlpanel.feedrate.y")) {
                        xJog = Base.preferences.getInt("controlpanel.feedrate.x", 480);
                    }
                    if (zJog < 480) {
                        Base.preferences.put("controlpanel.feedrate.z", "480");
                    }
                    if (xJog < 480) {
                        Base.preferences.put("controlpanel.feedrate.x", "480");
                    }
                }
                catch (BackingStoreException e) {
                    Base.logger.severe(e.toString());
                }
                extendedMessage = "  <br/><b>Also updating Print-O-Matic speed settings!</b>";
            }
        }
        this.requestResetFromUser(extendedMessage);
    }

    private void resetToBlank() {
        try {
            this.target.resetSettingsToBlank();
            this.requestResetFromUser("<b>Resetting EEPROM to completely blank</b>");
            this.dispose();
        }
        catch (RetryException e) {
            Base.logger.severe("reset to blank failed due to error" + e.toString());
            Base.logger.severe("Please restart your machine for safety");
        }
    }

    private void resetToFactory() {
        try {
            this.target.resetSettingsToFactory();
            this.requestResetFromUser("<b>Resetting EEPROM to Factory Default.</b>");
            this.dispose();
        }
        catch (RetryException e) {
            Base.logger.severe("reset to blank failed due to error" + e.toString());
            Base.logger.severe("Please restart your machine for safety");
        }
    }

    private void loadParameters() {
        this.machineNameField.setText(this.target.getMachineName());
        if (this.target.hasToolCountOnboard()) {
            int toolCount = this.target.toolCountOnboard();
            if (toolCount == 1 || toolCount == 2) {
                this.toolCountField.setSelectedIndex(toolCount);
            } else {
                this.toolCountField.setSelectedIndex(0);
            }
        }
        EnumSet<AxisId> invertedAxes = this.target.getInvertedAxes();
        this.xAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.X));
        this.yAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.Y));
        this.zAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.Z));
        this.aAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.A));
        this.bAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.B));
        this.zHoldBox.setSelected(!invertedAxes.contains((Object)AxisId.V));
        this.pStopBox.setSelected(this.target.getPStop());
        this.clear4EStopBox.setSelected(this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.CLEAR_FOR_ESTOP) == 1);
        if (this.driverType == DriverType.SAILFISH) {
            this.zMinStopBox.setSelected(this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ENDSTOP_Z_MIN) == 1);
        }
        if (this.driverType == DriverType.MIGHTYBOARD || this.driverType == DriverType.MIGHTYSAILFISH) {
            this.hbpToggleBox.setSelected(this.target.hasHbp());
        }
        OnboardParameters.EndstopType endstops = this.target.getInvertedEndstops();
        this.endstopInversionSelection.setSelectedIndex(endstops.ordinal());
        if (this.driverType != DriverType.MIGHTYBOARD && this.driverType != DriverType.MIGHTYSAILFISH) {
            OnboardParameters.EstopType estop = this.target.getEstopConfig();
            this.estopSelection.setSelectedIndex(estop.ordinal());
        }
        this.xAxisHomeOffsetField.setValue(this.target.getAxisHomeOffset(0));
        this.yAxisHomeOffsetField.setValue(this.target.getAxisHomeOffset(1));
        this.zAxisHomeOffsetField.setValue(this.target.getAxisHomeOffset(2));
        this.aAxisHomeOffsetField.setValue(this.target.getAxisHomeOffset(3));
        this.bAxisHomeOffsetField.setValue(this.target.getAxisHomeOffset(4));
        if (this.target.hasVrefSupport()) {
            this.vref0.setValue(this.target.getStoredStepperVoltage(0));
            this.vref1.setValue(this.target.getStoredStepperVoltage(1));
            this.vref2.setValue(this.target.getStoredStepperVoltage(2));
            this.vref3.setValue(this.target.getStoredStepperVoltage(3));
            this.vref4.setValue(this.target.getStoredStepperVoltage(4));
        }
        if (this.target.hasToolheadsOffset()) {
            this.xToolheadOffsetField.setValue(this.target.getToolheadsOffset(0));
            this.yToolheadOffsetField.setValue(this.target.getToolheadsOffset(1));
        }
        this.accelUI.setUIFromEEPROM();
    }

    protected void dispose() {
        this.parent.dispose();
    }

    public MachineOnboardParameters(OnboardParameters target, Driver driver, JFrame parent) {
        this.threePlaces.setMaximumFractionDigits(3);
        this.xAxisHomeOffsetField = new JFormattedTextField(this.threePlaces);
        this.yAxisHomeOffsetField = new JFormattedTextField(this.threePlaces);
        this.zAxisHomeOffsetField = new JFormattedTextField(this.threePlaces);
        this.aAxisHomeOffsetField = new JFormattedTextField(this.threePlaces);
        this.bAxisHomeOffsetField = new JFormattedTextField(this.threePlaces);
        this.vref0 = new JFormattedTextField(this.threePlaces);
        this.vref1 = new JFormattedTextField(this.threePlaces);
        this.vref2 = new JFormattedTextField(this.threePlaces);
        this.vref3 = new JFormattedTextField(this.threePlaces);
        this.vref4 = new JFormattedTextField(this.threePlaces);
        this.xToolheadOffsetField = new JFormattedTextField(this.threePlaces);
        this.yToolheadOffsetField = new JFormattedTextField(this.threePlaces);
        this.target = target;
        this.driver = driver;
        this.parent = parent;
        String driverName = target.getDriverName();
        this.driverType = driverName == null ? DriverType.OTHER : (driverName.equalsIgnoreCase("mightyboard") ? DriverType.MIGHTYBOARD : (driverName.equalsIgnoreCase("mightysailfish") ? DriverType.MIGHTYSAILFISH : (driverName.equalsIgnoreCase("makerbot4gsailfish") ? DriverType.SAILFISH : DriverType.OTHER)));
        this.setLayout((LayoutManager)new MigLayout("fill", "[r][l][r]"));
        this.add(new JLabel("Machine Name (max. " + Integer.toString(15) + " chars)"));
        this.machineNameField.setColumns(15);
        this.add((Component)this.machineNameField, "span 2, wrap");
        this.subTabs = new JTabbedPane();
        this.add((Component)this.subTabs, "span 3, wrap");
        JPanel endstopsTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l][r][l]"));
        this.subTabs.addTab("Endstops/Axis Inversion", endstopsTab);
        JPanel homeVrefsTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l][r][l]"));
        if (target.hasVrefSupport()) {
            this.subTabs.addTab("Homing/VREFs", homeVrefsTab);
        } else {
            this.subTabs.addTab("Homing", homeVrefsTab);
        }
        EnumMap<AxisId, String> axesAltNamesMap = target.getAxisAlises();
        if (target.hasToolCountOnboard()) {
            endstopsTab.add(new JLabel("Reported Tool Count:"));
            endstopsTab.add((Component)this.toolCountField, "span 2, wrap");
        }
        if (this.driverType == DriverType.MIGHTYBOARD || this.driverType == DriverType.MIGHTYSAILFISH) {
            endstopsTab.add(new JLabel("HBP present"));
            endstopsTab.add((Component)this.hbpToggleBox, "span 2, wrap");
        }
        endstopsTab.add(new JLabel("Invert X axis"));
        endstopsTab.add((Component)this.xAxisInvertBox, "span 2, wrap");
        endstopsTab.add(new JLabel("Invert Y axis"));
        endstopsTab.add((Component)this.yAxisInvertBox, "span 2, wrap");
        endstopsTab.add(new JLabel("Invert Z axis"));
        endstopsTab.add((Component)this.zAxisInvertBox, "span 2, wrap");
        String aName = "Invert A axis";
        if (axesAltNamesMap.containsKey((Object)AxisId.A)) {
            aName = aName + " (" + axesAltNamesMap.get((Object)AxisId.A) + ") ";
        }
        endstopsTab.add(new JLabel(aName));
        endstopsTab.add((Component)this.aAxisInvertBox, "span 2, wrap");
        String bName = "Invert B axis";
        if (axesAltNamesMap.containsKey((Object)AxisId.B)) {
            bName = bName + " (" + axesAltNamesMap.get((Object)AxisId.B) + ") ";
        }
        endstopsTab.add(new JLabel(bName));
        endstopsTab.add((Component)this.bAxisInvertBox, "span 2, wrap");
        endstopsTab.add(new JLabel("Hold Z axis"));
        endstopsTab.add((Component)this.zHoldBox, "span 2, wrap");
        if (this.driverType == DriverType.SAILFISH) {
            endstopsTab.add(new JLabel("3G5D Z endstop is min"));
            this.zMinStopBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "When checked, the 3G5D Z endstop is treated as a Z minimum endstop.  When not checked, the 3G5D Z endstop is treated as a Z maximum endstop.  This setting is ignored by Gen 4 electronics."));
            endstopsTab.add((Component)this.zMinStopBox, "span 2, wrap");
        }
        endstopsTab.add(new JLabel("Pause stop"));
        this.pStopBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "When checked, enable Sailfish's Pause Stop (P-Stop) switch detect mechanism for automatically pausing prints via an external electrical signal"));
        endstopsTab.add((Component)this.pStopBox, "span 2, wrap");
        if (this.driverType != DriverType.MIGHTYBOARD && this.driverType != DriverType.MIGHTYSAILFISH) {
            endstopsTab.add(new JLabel("Emergency stop"));
            endstopsTab.add((Component)this.estopSelection, "spanx, wrap");
        }
        endstopsTab.add(new JLabel("Clear build for e-stop"));
        this.clear4EStopBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "By default when sending an abort, cancel, or stop command over USB, the bot treats the request as an Emergency Stop and stops immediately. Unfortunately, MBI changed this interpetation in 2013 to a non-Emergency Stop and clears the build away from the extruder nozzle first.  (They should have implemented a new command instead which did a non-EStop.)  To emulate this MBI behavior, check this box.  To keep the older, Emergency Stop behavior, leave this box unchecked."));
        endstopsTab.add((Component)this.clear4EStopBox, "span 2, wrap");
        endstopsTab.add(new JLabel("Invert endstops"));
        endstopsTab.add((Component)this.endstopInversionSelection, "span 2, wrap");
        this.xAxisHomeOffsetField.setColumns(10);
        this.yAxisHomeOffsetField.setColumns(10);
        this.zAxisHomeOffsetField.setColumns(10);
        this.aAxisHomeOffsetField.setColumns(10);
        this.bAxisHomeOffsetField.setColumns(10);
        if (target.hasVrefSupport()) {
            this.vref0.setColumns(4);
            this.vref1.setColumns(4);
            this.vref2.setColumns(4);
            this.vref3.setColumns(4);
            this.vref4.setColumns(4);
            homeVrefsTab.add(new JLabel("X home offset (mm)"));
            homeVrefsTab.add(this.xAxisHomeOffsetField);
            homeVrefsTab.add((Component)new JLabel("VREF Pot. X"), "split");
            homeVrefsTab.add((Component)this.vref0, "wrap");
            homeVrefsTab.add(new JLabel("Y home offset (mm)"));
            homeVrefsTab.add(this.yAxisHomeOffsetField);
            homeVrefsTab.add((Component)new JLabel("VREF Pot. Y"), "split");
            homeVrefsTab.add((Component)this.vref1, "wrap");
            homeVrefsTab.add(new JLabel("Z home offset (mm)"));
            homeVrefsTab.add(this.zAxisHomeOffsetField);
            homeVrefsTab.add((Component)new JLabel("VREF Pot. Z"), "split");
            homeVrefsTab.add((Component)this.vref2, "wrap");
            homeVrefsTab.add(new JLabel("A home offset (mm)"));
            homeVrefsTab.add(this.aAxisHomeOffsetField);
            homeVrefsTab.add((Component)new JLabel("VREF Pot. A"), "split");
            homeVrefsTab.add((Component)this.vref3, "wrap");
            homeVrefsTab.add(new JLabel("B home offset (mm)"));
            homeVrefsTab.add(this.bAxisHomeOffsetField);
            homeVrefsTab.add((Component)new JLabel("VREF Pot. B"), "split");
            homeVrefsTab.add((Component)this.vref4, "wrap");
        } else {
            homeVrefsTab.add(new JLabel("X home offset (mm)"));
            homeVrefsTab.add((Component)this.xAxisHomeOffsetField, "wrap");
            homeVrefsTab.add(new JLabel("Y home offset (mm)"));
            homeVrefsTab.add((Component)this.yAxisHomeOffsetField, "wrap");
            homeVrefsTab.add(new JLabel("Z home offset (mm)"));
            homeVrefsTab.add((Component)this.zAxisHomeOffsetField, "wrap");
            homeVrefsTab.add(new JLabel("A home offset (mm)"));
            homeVrefsTab.add((Component)this.aAxisHomeOffsetField, "wrap");
            homeVrefsTab.add(new JLabel("B home offset (mm)"));
            homeVrefsTab.add((Component)this.bAxisHomeOffsetField, "wrap");
        }
        if (target.hasToolheadsOffset()) {
            this.xToolheadOffsetField.setColumns(10);
            this.yToolheadOffsetField.setColumns(10);
            homeVrefsTab.add(new JLabel("X toolhead offset (mm)"));
            homeVrefsTab.add((Component)this.xToolheadOffsetField, "wrap");
            homeVrefsTab.add(new JLabel("Y toolhead offset (mm)"));
            homeVrefsTab.add((Component)this.yToolheadOffsetField, "wrap");
        }
        this.accelUI = target.hasAcceleration() ? (this.driverType == DriverType.MIGHTYBOARD ? (target.hasJettyAcceleration() ? new JettyMightyBoardMachineOnboardAccelerationParameters(target, driver, this.subTabs) : new MightyBoardMachineOnboardAccelerationParameters(target, driver, this.subTabs)) : (this.driverType == DriverType.MIGHTYSAILFISH ? new MightySailfishMachineOnboardAccelerationParameters(target, driver, this.subTabs) : (this.driverType == DriverType.SAILFISH ? new SailfishG3MachineOnboardAccelerationParameters(target, driver, this.subTabs) : new G3FirmwareMachineOnboardAccelerationParameters(target, driver, this.subTabs)))) : new MachineOnboardAccelerationParameters(target, driver, this.subTabs);
        this.accelUI.buildUI();
        this.resetToFactoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MachineOnboardParameters.this.resetToFactory();
            }
        });
        this.resetToFactoryButton.setToolTipText("Reset the onboard settings to the factory defaults");
        this.add((Component)this.resetToFactoryButton, "split 1");
        this.resetToBlankButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MachineOnboardParameters.this.resetToBlank();
            }
        });
        this.resetToBlankButton.setToolTipText("Reset the onboard settings to *completely blank*");
        this.add(this.resetToBlankButton);
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MachineOnboardParameters.this.commit();
                MachineOnboardParameters.this.disconnectNeededOnExit = true;
                MachineOnboardParameters.this.dispose();
            }
        });
        this.add((Component)this.commitButton, "al right");
        this.loadParameters();
    }

    public boolean disconnectOnExit() {
        return this.disconnectNeededOnExit;
    }

    public boolean leavePreheatRunning() {
        return this.driverType == DriverType.MIGHTYBOARD || this.driverType == DriverType.MIGHTYSAILFISH;
    }

    private static final String wrap2HTML(int width, String str) {
        return MachineOnboardParameters.wrap2HTML(width, str, -1);
    }

    private static final String wrap2HTML(int width, String str, int max) {
        char[] s;
        if (str.length() < width && max <= 0) {
            return str;
        }
        if (max <= 0) {
            s = str.toCharArray();
        } else {
            str = str + "  This value must be non-negative and not exceed " + max + ".";
            s = str.toCharArray();
        }
        StringBuilder html = new StringBuilder();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        html.append("<HTML>");
        for (int i = 0; i < s.length; ++i) {
            word.append(s[i]);
            if (!Character.isWhitespace(s[i])) continue;
            if (line.length() == 0) {
                line.append((CharSequence)word);
                word.delete(0, word.length());
            }
            if (line.length() + word.length() > width) {
                if (html.length() > 6) {
                    html.append("<br>");
                }
                html.append((CharSequence)line);
                line.delete(0, line.length());
            }
            if (word.length() <= 0) continue;
            line.append((CharSequence)word);
            word.delete(0, word.length());
        }
        line.append((CharSequence)word);
        if (html.length() > 6) {
            html.append("<br>");
        }
        html.append((CharSequence)line);
        html.append("</HTML>");
        return html.toString();
    }

    private static final JFormattedTextField PositiveTextFieldDouble(NumberFormat nf, String tip) {
        JFormattedTextField textField = new JFormattedTextField(nf);
        JFormattedTextField.AbstractFormatter fmtr = textField.getFormatter();
        if (fmtr instanceof InternationalFormatter) {
            InternationalFormatter ifr = (InternationalFormatter)fmtr;
            ifr.setMinimum(new Double(0.0));
        }
        if (tip != null) {
            textField.setToolTipText(MachineOnboardParameters.wrap2HTML(60, tip));
        }
        return textField;
    }

    private static final JFormattedTextField PositiveTextFieldDoubleMax(NumberFormat nf, double max, String tip) {
        JFormattedTextField textField = new JFormattedTextField(nf);
        JFormattedTextField.AbstractFormatter fmtr = textField.getFormatter();
        if (fmtr instanceof InternationalFormatter) {
            InternationalFormatter ifr = (InternationalFormatter)fmtr;
            ifr.setMinimum(new Double(0.0));
            ifr.setMaximum(new Double(max));
        }
        if (tip != null) {
            textField.setToolTipText(MachineOnboardParameters.wrap2HTML(60, tip));
        }
        return textField;
    }

    private static final JFormattedTextField PositiveTextFieldInt(NumberFormat nf, String tip) {
        JFormattedTextField textField = new JFormattedTextField(nf);
        JFormattedTextField.AbstractFormatter fmtr = textField.getFormatter();
        if (fmtr instanceof InternationalFormatter) {
            InternationalFormatter ifr = (InternationalFormatter)fmtr;
            ifr.setMinimum(new Integer(0));
        }
        if (tip != null) {
            textField.setToolTipText(MachineOnboardParameters.wrap2HTML(60, tip));
        }
        return textField;
    }

    private static final JFormattedTextField PositiveTextFieldInt(NumberFormat nf, int max, String tip) {
        JFormattedTextField textField = new JFormattedTextField(nf);
        JFormattedTextField.AbstractFormatter fmtr = textField.getFormatter();
        if (fmtr instanceof InternationalFormatter) {
            InternationalFormatter ifr = (InternationalFormatter)fmtr;
            ifr.setMinimum(new Integer(0));
            ifr.setMaximum(new Integer(max));
        }
        if (tip != null) {
            textField.setToolTipText(MachineOnboardParameters.wrap2HTML(60, tip, max));
        }
        return textField;
    }

    private static final void addWithSharedToolTips(JPanel panel, String labelText, JComponent buddy) {
        JLabel label = new JLabel(labelText);
        label.setToolTipText(buddy.getToolTipText());
        panel.add(label);
        panel.add(buddy);
    }

    private static final void addWithSharedToolTips(JPanel panel, String labelText, JComponent buddy, String layoutGoodies2) {
        JLabel label = new JLabel(labelText);
        label.setToolTipText(buddy.getToolTipText());
        panel.add(label);
        panel.add((Component)buddy, layoutGoodies2);
    }

    private static final void addWithSharedToolTips(JPanel panel, String labelText, String layoutGoodies1, JComponent buddy, String layoutGoodies2) {
        JLabel label = new JLabel(labelText);
        label.setToolTipText(buddy.getToolTipText());
        panel.add((Component)label, layoutGoodies1);
        panel.add((Component)buddy, layoutGoodies2);
    }

    private static final void addWithSharedToolTips(JPanel panel, String labelText, String layoutGoodies1, JComponent buddy) {
        JLabel label = new JLabel(labelText);
        label.setToolTipText(buddy.getToolTipText());
        panel.add((Component)label, layoutGoodies1);
        panel.add(buddy);
    }

    private class SailfishG3MachineOnboardAccelerationParameters
    extends MachineOnboardAccelerationParameters {
        AccelParamsTab1 draftParams;
        AccelParamsTab1 qualityParams;
        final int width = 60;
        public final int moodLightChoiceIndex_DEFAULT = 0;
        public final int moodLightScriptId_DEFAULT = 2;
        public final String[] moodLightChoices;
        private NumberFormat repNF;
        private NumberFormat tempNF;
        private JCheckBox accelerationBox;
        private JCheckBox dittoBox;
        private JCheckBox extruderHoldBox;
        private JCheckBox checkCRCBox;
        private JButton draftButton;
        private JButton qualityButton;
        private JFormattedTextField xAxisMaxAcceleration;
        private JFormattedTextField yAxisMaxAcceleration;
        private JFormattedTextField zAxisMaxAcceleration;
        private JFormattedTextField aAxisMaxAcceleration;
        private JFormattedTextField bAxisMaxAcceleration;
        private JFormattedTextField xAxisMaxSpeedChange;
        private JFormattedTextField yAxisMaxSpeedChange;
        private JFormattedTextField zAxisMaxSpeedChange;
        private JFormattedTextField aAxisMaxSpeedChange;
        private JFormattedTextField bAxisMaxSpeedChange;
        private NumberFormat kNF;
        private JFormattedTextField JKNAdvance1;
        private JFormattedTextField JKNAdvance2;
        private NumberFormat alevelNF;
        private JFormattedTextField alevelMaxZDiff;
        private JFormattedTextField alevelMaxZProbeHits;
        private JCheckBox extruderDeprimeTravel;
        private JFormattedTextField extruderDeprimeA;
        private JFormattedTextField extruderDeprimeB;
        private JCheckBox overrideGCodeTempBox;
        private JFormattedTextField tool0Temp;
        private JFormattedTextField tool1Temp;
        private JFormattedTextField platformTemp;
        private JCheckBox slowdownFlagBox;
        private final String[] lcdDimensionChoices;
        private JComboBox lcdDimensionsChoice;
        private JFormattedTextField buzzerRepeats;
        private JColorChooser moodLightCustomColor;
        private JComboBox moodLightScript;

        private SailfishG3MachineOnboardAccelerationParameters(OnboardParameters target, Driver driver, JTabbedPane subtabs) {
            super(target, driver, subtabs);
            this.draftParams = new AccelParamsTab1(true, new long[]{1000L, 1000L, 150L, 2000L, 2000L}, new double[]{40.0, 40.0, 10.0, 40.0, 40.0});
            this.qualityParams = new AccelParamsTab1(true, new long[]{1000L, 1000L, 150L, 2000L, 2000L}, new double[]{15.0, 15.0, 10.0, 20.0, 20.0});
            this.width = 60;
            this.moodLightChoiceIndex_DEFAULT = 0;
            this.moodLightScriptId_DEFAULT = 2;
            this.moodLightChoices = new String[]{"Off (2)", "Bot status (0)", "Custom color (1)", "Almond (12)", "Blue (6)", "Blue, Alice (15)", "Blue, Deep Sky (22)", "Blue, Midnight (21)", "Cyan (7)", "Gold (25)", "Gray (19)", "Gray, Light (20)", "Gray, Slate (18)", "Green (5)", "Green, Forest (24)", "Green, Olive (23)", "Hot Pink (26)", "Lavender (16)", "Linen (27)", "Magenta (8)", "Mint Cream (14)", "Orange (11)", "Peach Puff (13)", "Purple (10)", "Red (4)", "Rose, Misty (17)", "White (3)", "Yellow (9)", "Cycle Rainbow (110)", "Cycle Random (111)", "Cycle Red/Green/Blue (101)", "Cycle S.O.S. (118)", "Cycle Seasons (115)", "Cycle Traffic Lights (117)", "Cycle White/Red/Green/Blue/Off (100)", "Random Candle (112)", "Random Neon Reds (114)", "Random Thunderstorms (116)", "Random Water (113)", "Flashing Blue (105)", "Flashing Cyan (106)", "Flashing Green (104)", "Flashing Magenta (107)", "Flashing Red (103)", "Flashing White (102)", "Flashing Yellow (108)"};
            this.repNF = NumberFormat.getIntegerInstance();
            this.tempNF = NumberFormat.getIntegerInstance();
            this.tempNF.setMaximumIntegerDigits(3);
            this.accelerationBox = new JCheckBox();
            this.accelerationBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Enable or disable printing with acceleration"));
            this.dittoBox = new JCheckBox();
            this.dittoBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Enable ditto printing in which two copies of the build will be simultaneously printed, one copy with the left extruder and the other with the right extruder.  The object must be such that the print heads will not interfere with one another; the firmware will not automatically guard against that."));
            this.extruderHoldBox = new JCheckBox();
            this.extruderHoldBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Check this box if using a 3mm filament extruder.  Using extruder hold causes the extruder stepper motors to remain engaged throughout the entire build regardless of whether or not the gcode requests that they be disabled via M103 commands.  When 3mm filament extruder stepper motors are disabled, the filament has a tendency to back out a tiny amount owing to the high pressure within the melt chamber of a 3mm extruder."));
            this.checkCRCBox = new JCheckBox();
            this.checkCRCBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Your SD cards contain a tiny computer which talks with the computer within your bot.  Electrical noise within your bot can introduce errors in these conversations which, in turn, can cause defects in your print or even cause the print to fail.  These errors normally go undetected: the bot and SD card do not normally check to see whether the file data sent from the SD card to the bot arrives without errors and the bot assumes that the data is correct with no errors.  By enabling this feature, the SD card's computer is told to add extra information to the end of each data transfer.  This extra information, a 16bit CRC, is used to confirm that the file data was transferred without the introduction of errors.  If your bot then sees that an error occurred, it will ask the SD card to retransmit the data.  This maximizes the likelihood of successful prints by catching and repairing data transfer errors.  If the same file data fails to transfer correctly after five attempts, then the print is gracefully cancelled and an error message displayed.  NOTE THAT Replicator 1's are particularly susceptible to data transfer errors owing to their electronics design."));
            this.draftButton = new JButton("Quick Draft");
            this.draftButton.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "By clicking this button, the on-screen acceleration parameters will be changed to suggested values for rapid draft-quality builds.  The values will not be committed to your Replicator until you click the Commit button.  You may adjust the settings before committing them to your Replicator."));
            this.qualityButton = new JButton("Fine Quality");
            this.qualityButton.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "By clicking this button, the on-screen acceleration parameters will be changed to suggested values for fine-quality builds.  The values will not be committed to your Replicator until you click the Commit button.  You may adjust the settings before committing them to your Replicator."));
            this.xAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 22000, "The maximum acceleration and deceleration along the X axis in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the X axis.");
            this.yAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 22000, "The maximum acceleration and deceleration along the Y axis in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the Y axis.");
            this.zAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 5200, "The maximum acceleration and deceleration along the Z axis in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the Z axis.");
            this.aAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 20000, "The maximum acceleration and deceleration experienced by the right extruder in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the right extruder's filament axis.");
            this.bAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 20000, "The maximum acceleration and deceleration experienced by the left extruder in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the left extruder's filament axis.");
            this.xAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the X axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the X axis.");
            this.yAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the Y axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the Y axis.");
            this.zAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the Z axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the Z axis.");
            this.aAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate for the right extruder when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change for the right extruder.");
            this.bAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate for the left extruder when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change for the left extruder.");
            this.kNF = NumberFormat.getNumberInstance();
            this.kNF.setMaximumFractionDigits(5);
            this.kNF.setMaximumIntegerDigits(2);
            this.JKNAdvance1 = MachineOnboardParameters.PositiveTextFieldDouble(this.kNF, "The value of the empirically fit Jetty-Kubicek-Newman Advance parameter K which helps control the amount of additional plastic that should be extruded during the acceleration phase and not extruded during the deceleration phase of each move.  It can be used to remove blobbing and splaying on the corners of cubes or at the junctions between line segments.  Typical values for this parameter range from around 0.0001 to 0.01.  Set to a value of 0 to disable use of this compensation.");
            this.JKNAdvance2 = MachineOnboardParameters.PositiveTextFieldDouble(this.kNF, "The value of the empirically fit Jetty-Kubicek-Newman Advance parameter K2, which helps during the deceleration phase of moves to reduce built up pressure in the extruder nozzle.  Typical values for this parameter range from around 0.001 to 0.1.  Set to a value of 0 to disable use of this compensation.");
            this.alevelNF = NumberFormat.getNumberInstance();
            this.alevelNF.setMaximumFractionDigits(2);
            this.alevelNF.setMaximumIntegerDigits(1);
            this.alevelMaxZDiff = MachineOnboardParameters.PositiveTextFieldDoubleMax(this.alevelNF, 0.99, "The maximum vertical difference in height between any two probed leveling points may not exceed this value. Specify the value in units of millimeters.  The default value is 0.50 mm and may range from 0.01 to 0.99 mm. Only applicable on bots with firmware-based auto-leveling.");
            this.alevelMaxZProbeHits = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 200, "If the auto-leveling probe registers too many hits during a print, then the bot will pause printing and request manual intervention.  To ignore probe hits while printing, specify a value of 0.  Otherwise specify the maximum number of probe hits to allow before pausing.  The default value is 20.  Enter a value  between 1 and 200; 0 to disable.  Only applicable on bots with firmware-based auto-leveling.");
            this.extruderDeprimeTravel = new JCheckBox();
            this.extruderDeprimeTravel.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "The firmware can retract the filament thus depriming the extruder on (1) detected travel moves, (2) pauses of the build, and (3) tiny brief pauses caused by the acceleration planner not keeping pace with the print and leaving the bot very briefly idle.  Item (3) can cause tiny pimples or zits on the print.  When this box is checked and the deprime values are non-zero, the extruder is deprimed on (1), (2), and (3) and reprimed when extrusion resumes.  When this box is not checked and the deprime values are non-zero, the extruder is deprimed on (2) and (3) and reprimed when extrusion resumes.  If you will be using retraction/deprime with your slicer, then leave this box unchecked.  To entirely disable firmware deprime, set the deprime values to zero."));
            this.extruderDeprimeA = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The number of steps to retract the right extruder's filament when the pipeline of buffered moves empties, the bot is paused, or \"deprime on travel\" is enabled and a travel move is detected.  Set to a value of 0 to disable this feature for this extruder.  Do not use with Skeinforge's Reversal plugin nor Skeinforge's Dimension plugin's \"Retraction Distance\".");
            this.extruderDeprimeB = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The number of steps to retract the right extruder's filament when the pipeline of buffered moves empties, the bot is paused, or \"deprime on travel\" is enabled and a travel move is detected.  Set to a value of 0 to disable this feature for this extruder.  Do not use with Skeinforge's Reversal plugin nor Skeinforge's Dimension plugin's \"Retraction Distance\".");
            this.overrideGCodeTempBox = new JCheckBox();
            this.overrideGCodeTempBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "When enabled, override the gcode temperature settings using the preheat temperature settings for the extruders and build platform."));
            this.tool0Temp = MachineOnboardParameters.PositiveTextFieldInt(this.tempNF, 255, "Temperature in degrees Celsius to preheat extruder 0 to.  This temperature is also used as the override temperature when the \"override gcode temperature\" feature is enabled.");
            this.tool1Temp = MachineOnboardParameters.PositiveTextFieldInt(this.tempNF, 255, "Temperature in degrees Celsius to preheat extruder 1 to.  This temperature is also used as the override temperature when the \"override gcode temperature\" feature is enabled.");
            this.platformTemp = MachineOnboardParameters.PositiveTextFieldInt(this.tempNF, 255, "Temperature in degrees Celsius to preheat the build platform to.  This temperature is also used as the override temperature when the \"override gcode temperature\" feature is enabled.");
            this.slowdownFlagBox = new JCheckBox();
            this.slowdownFlagBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "If you are printing an object with fine details or at very fast speeds, it is possible that the planner will be unable to keep up with printing.  This may be evidenced by frequent pauses accompanied by unwanted plastic blobs or zits.  You may be able to mitigate this by enabling \"slowdown\".  When slowdown is enabled and the planner is having difficulty keeping up, the printing feed rate is reduced so as to cause each segment to take more time to print.  The reduction in printing speed then gives the planner a chance to catch up."));
            this.lcdDimensionChoices = new String[]{"16 x 4", "20 x 4", "24 x 4"};
            this.lcdDimensionsChoice = new JComboBox<String>(this.lcdDimensionChoices);
            this.lcdDimensionsChoice.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Select the dimensions of the LCD screen display in your Gen 4 LCD interface.  Measurements are the number of character columns by the number of character rows.  The standard Gen 4 LCD display is 16 x 4."));
            this.buzzerRepeats = MachineOnboardParameters.PositiveTextFieldInt(this.tempNF, 255, "The number of times the buzzer should buzz when activated.  Use of this feature requires installation of a buzzer as per Thingiverse Thing 16170, \"Buzzer Support\".");
            this.moodLightCustomColor = new JColorChooser();
            this.moodLightCustomColor.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Select the custom color used when the \"Custom Color\" mood light script is selected.  Use of this feature requires installation of Thingiverse Thing 15347, \"Mood Lighting For ToM\"."));
            this.moodLightScript = new JComboBox<String>(this.moodLightChoices);
            this.moodLightScript.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Select the mood light script to be played by the mood lighting.  Use of this feature requires installation of Thingiverse Thing 15347, \"Mood Lighting For ToM\"."));
            int dismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
            if (dismissDelay < 10000) {
                ToolTipManager.sharedInstance().setDismissDelay(10000);
            }
            this.draftButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    SailfishG3MachineOnboardAccelerationParameters.this.setUIFields(SailfishG3MachineOnboardAccelerationParameters.this.draftParams);
                }
            });
            this.qualityButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    SailfishG3MachineOnboardAccelerationParameters.this.setUIFields(SailfishG3MachineOnboardAccelerationParameters.this.qualityParams);
                }
            });
        }

        AccelParams getAccelParamsFromUI() {
            int scriptId = this.findMoodLightScriptId(this.moodLightScript.getSelectedIndex());
            if (scriptId < 0) {
                scriptId = 2;
            }
            int lcdIndex = this.lcdDimensionsChoice.getSelectedIndex();
            int lcdType = 0;
            if (lcdIndex == 1) {
                lcdType = 50;
            } else if (lcdIndex == 2) {
                lcdType = 51;
            }
            Color c = this.moodLightCustomColor.getColor();
            return new AccelParams(new AccelParamsTab1(this.accelerationBox.isSelected(), new long[]{((Number)this.xAxisMaxAcceleration.getValue()).longValue(), ((Number)this.yAxisMaxAcceleration.getValue()).longValue(), ((Number)this.zAxisMaxAcceleration.getValue()).longValue(), ((Number)this.aAxisMaxAcceleration.getValue()).longValue(), ((Number)this.bAxisMaxAcceleration.getValue()).longValue()}, new double[]{((Number)this.xAxisMaxSpeedChange.getValue()).doubleValue(), ((Number)this.yAxisMaxSpeedChange.getValue()).doubleValue(), ((Number)this.zAxisMaxSpeedChange.getValue()).doubleValue(), ((Number)this.aAxisMaxSpeedChange.getValue()).doubleValue(), ((Number)this.bAxisMaxSpeedChange.getValue()).doubleValue()}), new AccelParamsTab2(this.slowdownFlagBox.isSelected(), this.extruderDeprimeTravel.isSelected(), new long[]{((Number)this.extruderDeprimeA.getValue()).longValue(), ((Number)this.extruderDeprimeB.getValue()).longValue()}, new double[]{((Number)this.JKNAdvance1.getValue()).doubleValue(), ((Number)this.JKNAdvance2.getValue()).doubleValue()}), new AccelParamsTab3(this.overrideGCodeTempBox.isSelected(), this.dittoBox.isSelected(), this.extruderHoldBox.isSelected(), this.checkCRCBox.isSelected(), ((Number)this.alevelMaxZDiff.getValue()).doubleValue(), ((Number)this.alevelMaxZProbeHits.getValue()).intValue(), ((Number)this.buzzerRepeats.getValue()).intValue(), lcdType, scriptId, new int[]{c.getRed(), c.getGreen(), c.getBlue()}, new int[]{((Number)this.tool0Temp.getValue()).intValue(), ((Number)this.tool1Temp.getValue()).intValue(), ((Number)this.platformTemp.getValue()).intValue()}));
        }

        public boolean isAccelerationEnabled() {
            return this.accelerationBox.isSelected();
        }

        private void setEEPROMFromUI(AccelParams params) {
            this.target.setAccelerationStatus(params.tab1.accelerationEnabled ? (byte)1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.DITTO_PRINT_ENABLED, params.tab3.dittoEnabled ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.EXTRUDER_HOLD, params.tab3.extruderHold ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.SD_USE_CRC, params.tab3.checkCRC ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.OVERRIDE_GCODE_TEMP, params.tab3.overrideGCodeTempEnabled ? 1 : 0);
            int lv = params.tab2.slowdownEnabled ? 1 : 0;
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_SLOWDOWN_FLAG, lv);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_X, params.tab1.maxAccelerations[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Y, params.tab1.maxAccelerations[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Z, params.tab1.maxAccelerations[2]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_A, params.tab1.maxAccelerations[3]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_B, params.tab1.maxAccelerations[4]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_X, params.tab1.maxSpeedChanges[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Y, params.tab1.maxSpeedChanges[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Z, params.tab1.maxSpeedChanges[2]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_A, params.tab1.maxSpeedChanges[3]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_B, params.tab1.maxSpeedChanges[4]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K, params.tab2.JKNadvance[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K2, params.tab2.JKNadvance[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.DEPRIME_ON_TRAVEL, params.tab2.deprimeTravel ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_A, params.tab2.deprime[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_B, params.tab2.deprime[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.LCD_TYPE, params.tab3.lcdType);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.OVERRIDE_GCODE_TEMP, params.tab3.overrideGCodeTempEnabled ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.TOOL0_TEMP, params.tab3.overrideTemps[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.TOOL1_TEMP, params.tab3.overrideTemps[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.PLATFORM_TEMP, params.tab3.overrideTemps[2]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.BUZZER_REPEATS, params.tab3.buzzerRepeats);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_SCRIPT, params.tab3.scriptId);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_RED, params.tab3.rgb[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_GREEN, params.tab3.rgb[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_BLUE, params.tab3.rgb[2]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ALEVEL_MAX_ZDELTA, params.tab3.alevelMaxZDiff);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ALEVEL_MAX_ZPROBE_HITS, params.tab3.alevelMaxZProbeHits);
        }

        public void setEEPROMFromUI() {
            this.setEEPROMFromUI(this.getAccelParamsFromUI());
        }

        private void setUIFields(AccelParamsTab1 params) {
            this.setUIFields(params, null, null);
        }

        private void setUIFields(AccelParamsTab1 tab1, AccelParamsTab2 tab2, AccelParamsTab3 tab3) {
            if (tab1 != null) {
                this.accelerationBox.setSelected(tab1.accelerationEnabled);
                if (tab1.maxAccelerations != null) {
                    this.xAxisMaxAcceleration.setValue(tab1.maxAccelerations[0]);
                    this.yAxisMaxAcceleration.setValue(tab1.maxAccelerations[1]);
                    this.zAxisMaxAcceleration.setValue(tab1.maxAccelerations[2]);
                    this.aAxisMaxAcceleration.setValue(tab1.maxAccelerations[3]);
                    this.bAxisMaxAcceleration.setValue(tab1.maxAccelerations[4]);
                }
                if (tab1.maxSpeedChanges != null) {
                    this.xAxisMaxSpeedChange.setValue(tab1.maxSpeedChanges[0]);
                    this.yAxisMaxSpeedChange.setValue(tab1.maxSpeedChanges[1]);
                    this.zAxisMaxSpeedChange.setValue(tab1.maxSpeedChanges[2]);
                    this.aAxisMaxSpeedChange.setValue(tab1.maxSpeedChanges[3]);
                    this.bAxisMaxSpeedChange.setValue(tab1.maxSpeedChanges[4]);
                }
            }
            if (tab2 != null) {
                this.slowdownFlagBox.setSelected(tab2.slowdownEnabled);
                this.extruderDeprimeTravel.setSelected(tab2.deprimeTravel);
                if (tab2.JKNadvance != null) {
                    this.JKNAdvance1.setValue(tab2.JKNadvance[0]);
                    this.JKNAdvance2.setValue(tab2.JKNadvance[1]);
                }
                if (tab2.deprime != null) {
                    this.extruderDeprimeA.setValue(tab2.deprime[0]);
                    this.extruderDeprimeB.setValue(tab2.deprime[1]);
                }
            }
            if (tab3 != null) {
                this.overrideGCodeTempBox.setSelected(tab3.overrideGCodeTempEnabled);
                this.dittoBox.setSelected(tab3.dittoEnabled);
                this.extruderHoldBox.setSelected(tab3.extruderHold);
                this.checkCRCBox.setSelected(tab3.checkCRC);
                this.alevelMaxZProbeHits.setValue(tab3.alevelMaxZProbeHits);
                this.alevelMaxZDiff.setValue(tab3.alevelMaxZDiff);
                this.buzzerRepeats.setValue(tab3.buzzerRepeats);
                int lcdIndex = tab3.lcdType == 50 ? 1 : (tab3.lcdType == 51 ? 2 : 0);
                this.lcdDimensionsChoice.setSelectedIndex(lcdIndex);
                int moodLightChoice = this.findMoodLightChoice(tab3.scriptId);
                if (moodLightChoice < 0) {
                    moodLightChoice = 0;
                }
                this.moodLightScript.setSelectedIndex(moodLightChoice);
                if (tab3.rgb != null) {
                    this.moodLightCustomColor.setColor(tab3.rgb[0], tab3.rgb[1], tab3.rgb[2]);
                }
                if (tab3.overrideTemps != null) {
                    this.tool0Temp.setValue(tab3.overrideTemps[0]);
                    this.tool1Temp.setValue(tab3.overrideTemps[1]);
                    this.platformTemp.setValue(tab3.overrideTemps[2]);
                }
            }
        }

        public void setUIFromEEPROM() {
            boolean accelerationEnabled = this.target.getAccelerationStatus() != 0;
            boolean deprimeTravel = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.DEPRIME_ON_TRAVEL) == 1;
            boolean slowdownEnabled = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_SLOWDOWN_FLAG) != 0;
            boolean overrideGCodeTempEnabled = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.OVERRIDE_GCODE_TEMP) != 0;
            boolean dittoEnabled = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.DITTO_PRINT_ENABLED) != 0;
            boolean extruderHold = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.EXTRUDER_HOLD) != 0;
            boolean checkCRC = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.SD_USE_CRC) == 1;
            int buzzerRepeats = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.BUZZER_REPEATS);
            int scriptId = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_SCRIPT);
            int lcdType = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.LCD_TYPE);
            int maxZProbeHits = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ALEVEL_MAX_ZPROBE_HITS);
            double maxZDiff = this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ALEVEL_MAX_ZDELTA);
            long[] maxAccelerations = new long[]{this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_X), this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Y), this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Z), this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_A), this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_B)};
            double[] maxSpeedChanges = new double[]{this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_X), this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Y), this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Z), this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_A), this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_B)};
            double[] JKNadvance = new double[]{this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K), this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K2)};
            long[] deprime = new long[]{this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_A), this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_B)};
            int[] rgb = new int[]{this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_RED), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_GREEN), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_BLUE)};
            int[] overrideTemps = new int[]{this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.TOOL0_TEMP), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.TOOL1_TEMP), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.PLATFORM_TEMP)};
            this.setUIFields(new AccelParamsTab1(accelerationEnabled, maxAccelerations, maxSpeedChanges), new AccelParamsTab2(slowdownEnabled, deprimeTravel, deprime, JKNadvance), new AccelParamsTab3(overrideGCodeTempEnabled, dittoEnabled, extruderHold, checkCRC, maxZDiff, maxZProbeHits, buzzerRepeats, lcdType, scriptId, rgb, overrideTemps));
        }

        public void buildUI() {
            JPanel accelerationTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l][r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Acceleration", accelerationTab);
            JPanel accelerationMiscTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Acceleration (Misc)", accelerationMiscTab);
            JPanel miscTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l][r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Misc", miscTab);
            this.xAxisMaxAcceleration.setColumns(8);
            this.xAxisMaxSpeedChange.setColumns(4);
            this.yAxisMaxAcceleration.setColumns(8);
            this.yAxisMaxSpeedChange.setColumns(4);
            this.zAxisMaxAcceleration.setColumns(8);
            this.zAxisMaxSpeedChange.setColumns(4);
            this.aAxisMaxAcceleration.setColumns(8);
            this.aAxisMaxSpeedChange.setColumns(4);
            this.bAxisMaxAcceleration.setColumns(8);
            this.bAxisMaxSpeedChange.setColumns(4);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Acceleration enabled", this.accelerationBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "X max acceleration (mm/s\u00b2)", this.xAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "X max speed change (mm/s)", this.xAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Y max acceleration (mm/s\u00b2)", this.yAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Y max speed change (mm/s)", this.yAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Z max acceleration (mm/s\u00b2)", this.zAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Z max speed change (mm/s)", this.zAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Right extruder max acceleration (mm/s\u00b2)", this.aAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Right extruder max speed change (mm/s)", this.aAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Left extruder acceleration (mm/s\u00b2)", this.bAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Left extruder max speed change (mm/s)", this.bAxisMaxSpeedChange, "wrap");
            accelerationTab.add((Component)this.qualityButton, "span 2, gapleft push");
            accelerationTab.add((Component)this.draftButton, "span 2, gapright push, gapbottom push");
            this.JKNAdvance1.setColumns(8);
            this.JKNAdvance2.setColumns(8);
            this.extruderDeprimeA.setColumns(8);
            this.extruderDeprimeB.setColumns(8);
            this.alevelMaxZDiff.setColumns(8);
            this.alevelMaxZProbeHits.setColumns(8);
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Slow printing when acceleration planing falls behind", this.slowdownFlagBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "JKN Advance K", this.JKNAdvance1, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "JKN Advance K2", this.JKNAdvance2, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Deprime on travel moves", this.extruderDeprimeTravel, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Right extruder deprime (steps)", this.extruderDeprimeA, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Left extruder deprime (steps)", this.extruderDeprimeB, "wrap, gapbottom push");
            this.tool0Temp.setColumns(8);
            this.tool1Temp.setColumns(8);
            this.platformTemp.setColumns(8);
            this.buzzerRepeats.setColumns(8);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Override gcode temperatures", this.overrideGCodeTempBox);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Gen 4 LCD dimensions", this.lcdDimensionsChoice, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Right/sole extruder preheat & override temperature (C)", this.tool0Temp);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Buzzer repeats", this.buzzerRepeats, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Left extruder preheat & override temperature (C)", this.tool1Temp);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Check SD card reads", this.checkCRCBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Platform preheat & override temperature (C)", this.platformTemp);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Ditto (duplicate) printing enabled", this.dittoBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Auto-level max Z probe hits", this.alevelMaxZProbeHits);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Extruder hold enabled", this.extruderHoldBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Auto-level max Z height difference", this.alevelMaxZDiff);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Mood light script", this.moodLightScript, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Mood light color", this.moodLightCustomColor, "span 4, wrap, gapbottom push, gapright push");
        }

        public int findMoodLightChoice(int scriptId) {
            String str = "(" + scriptId + ")";
            for (int i = 0; i < this.moodLightChoices.length; ++i) {
                if (!this.moodLightChoices[i].contains(str)) continue;
                return i;
            }
            return -1;
        }

        public int findMoodLightScriptId(int choiceIndex) {
            int end2;
            if (choiceIndex < 0 || choiceIndex > this.moodLightChoices.length) {
                return -1;
            }
            int start = this.moodLightChoices[choiceIndex].indexOf(40);
            if (start < 0) {
                return -1;
            }
            if ((end2 = this.moodLightChoices[choiceIndex].indexOf(41, ++start)) < 0) {
                return -1;
            }
            int scriptId = -1;
            try {
                scriptId = Integer.parseInt(this.moodLightChoices[choiceIndex].substring(start, end2));
            }
            catch (Exception e) {
                // empty catch block
            }
            return scriptId;
        }

        private class AccelParams {
            public AccelParamsTab1 tab1;
            public AccelParamsTab2 tab2;
            public AccelParamsTab3 tab3;

            AccelParams(AccelParamsTab1 params1, AccelParamsTab2 params2, AccelParamsTab3 params3) {
                this.tab1 = params1;
                this.tab2 = params2;
                this.tab3 = params3;
            }
        }

        class AccelParamsTab3 {
            boolean overrideGCodeTempEnabled;
            boolean dittoEnabled;
            boolean extruderHold;
            boolean checkCRC;
            double alevelMaxZDiff;
            int alevelMaxZProbeHits;
            int buzzerRepeats;
            int lcdType;
            int scriptId;
            int[] rgb;
            int[] overrideTemps;

            AccelParamsTab3(boolean overrideGCodeTempEnabled, boolean dittoEnabled, boolean extruderHold, boolean checkCRC, double alevelMaxZDiff, int alevelMaxZProbeHits, int buzzerRepeats, int lcdType, int scriptId, int[] rgb, int[] overrideTemps) {
                this.overrideGCodeTempEnabled = overrideGCodeTempEnabled;
                this.dittoEnabled = dittoEnabled;
                this.extruderHold = extruderHold;
                this.checkCRC = checkCRC;
                double d = alevelMaxZDiff < 0.01 ? 0.01 : (this.alevelMaxZDiff = alevelMaxZDiff > 0.99 ? 0.99 : alevelMaxZDiff);
                this.alevelMaxZProbeHits = alevelMaxZProbeHits <= 0 ? 0 : (alevelMaxZProbeHits > 200 ? 200 : alevelMaxZProbeHits);
                this.buzzerRepeats = buzzerRepeats;
                this.lcdType = lcdType;
                this.scriptId = scriptId;
                this.rgb = rgb;
                this.overrideTemps = overrideTemps;
            }
        }

        class AccelParamsTab2 {
            boolean slowdownEnabled;
            boolean deprimeTravel;
            long[] deprime;
            double[] JKNadvance;

            AccelParamsTab2(boolean slowdownEnabled, boolean deprimeTravel, long[] deprime, double[] JKNadvance) {
                this.slowdownEnabled = slowdownEnabled;
                this.deprimeTravel = deprimeTravel;
                this.deprime = deprime;
                this.JKNadvance = JKNadvance;
            }
        }

        class AccelParamsTab1 {
            boolean accelerationEnabled;
            long[] maxAccelerations;
            double[] maxSpeedChanges;

            AccelParamsTab1(boolean accelerationEnabled, long[] maxAccelerations, double[] maxSpeedChanges) {
                this.accelerationEnabled = accelerationEnabled;
                this.maxAccelerations = maxAccelerations;
                this.maxSpeedChanges = maxSpeedChanges;
            }
        }
    }

    private class G3FirmwareMachineOnboardAccelerationParameters
    extends MachineOnboardAccelerationParameters {
        final int width = 60;
        private NumberFormat frNF;
        private NumberFormat accNF;
        private NumberFormat kNF;
        private NumberFormat minSegTimeNF;
        private NumberFormat jerkNF;
        private NumberFormat tempNF;
        private NumberFormat sdNF;
        private JCheckBox accelerationBox;
        private JCheckBox accelerationPlannerBox;
        private JCheckBox accelerationStrangledBox;
        private JCheckBox inverted5DExtruderBox;
        private JFormattedTextField xAxisMaxFeedrate;
        private JFormattedTextField yAxisMaxFeedrate;
        private JFormattedTextField zAxisMaxFeedrate;
        private JFormattedTextField aAxisMaxFeedrate;
        private JFormattedTextField normalMoveAcceleration;
        private JFormattedTextField xAxisMaxAcceleration;
        private JFormattedTextField yAxisMaxAcceleration;
        private JFormattedTextField zAxisMaxAcceleration;
        private JFormattedTextField aAxisMaxAcceleration;
        private JFormattedTextField xAxisMaxSpeedChange;
        private JFormattedTextField yAxisMaxSpeedChange;
        private JFormattedTextField zAxisMaxSpeedChange;
        private JFormattedTextField aAxisMaxSpeedChange;
        private JFormattedTextField JKNAdvance1;
        private JFormattedTextField JKNAdvance2;
        private JCheckBox clockwiseExtruderChoice;
        private JFormattedTextField extruderStepsPerMM;
        private JFormattedTextField extruderDeprime;
        private JFormattedTextField revMaxFeedrate;
        private JFormattedTextField extruderMoveAcceleration;
        private JFormattedTextField minFeedrate;
        private JFormattedTextField minTravelFeedrate;
        private JFormattedTextField minPlannerSpeed;
        private JFormattedTextField minSegmentTime;
        private JFormattedTextField slowDownLimit;
        private final String[] lcdDimensionChoices;
        private JComboBox lcdDimensionsChoice;
        public final int moodLightChoiceIndex_DEFAULT = 0;
        public final int moodLightScriptId_DEFAULT = 2;
        public final String[] moodLightChoices;
        private JCheckBox overrideGCodeTempBox;
        private JFormattedTextField tool0Temp;
        private JFormattedTextField tool1Temp;
        private JFormattedTextField platformTemp;
        private JFormattedTextField buzzerRepeats;
        private JColorChooser moodLightCustomColor;
        private JComboBox moodLightScript;

        private G3FirmwareMachineOnboardAccelerationParameters(OnboardParameters target, Driver driver, JTabbedPane subtabs) {
            super(target, driver, subtabs);
            this.width = 60;
            this.frNF = NumberFormat.getIntegerInstance();
            this.frNF.setMaximumIntegerDigits(4);
            this.accNF = NumberFormat.getIntegerInstance();
            this.kNF = NumberFormat.getNumberInstance();
            this.kNF.setMaximumFractionDigits(5);
            this.kNF.setMaximumIntegerDigits(2);
            this.minSegTimeNF = NumberFormat.getNumberInstance();
            this.minSegTimeNF.setMaximumFractionDigits(4);
            this.minSegTimeNF.setMaximumIntegerDigits(1);
            this.jerkNF = NumberFormat.getNumberInstance();
            this.jerkNF.setMaximumFractionDigits(1);
            this.jerkNF.setMaximumIntegerDigits(4);
            this.tempNF = NumberFormat.getIntegerInstance();
            this.tempNF.setMaximumIntegerDigits(3);
            this.sdNF = NumberFormat.getIntegerInstance();
            this.sdNF.setMaximumIntegerDigits(1);
            this.accelerationBox = new JCheckBox();
            this.accelerationBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Enable or disable printing with acceleration"));
            this.accelerationPlannerBox = new JCheckBox();
            this.accelerationPlannerBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "The accelerated stepper driver attempts to plan moves ahead of the actual printing.  This is done because planning can be slow relative to the time it takes to print small, fine details.  Planning ahead of printing avoids situations where printing pauses while waiting for the next accelerated move to be computed.  Printing pauses produce blobs and zits when unwanted plastic oozes at one spot on the build from the idle extruder. Consequently, it is strongly recommended that you leave the planner enabled."));
            this.accelerationStrangledBox = new JCheckBox();
            this.accelerationStrangledBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "By checking this box, the accelerated stepper driver will be used but acceleration will not be used.  Each segment will print at the target feedrate without gently accelerating up to (or down to) that speed.  Check this box when you wish to print an object without acceleration but using the accelerated stepper driver.  You may also want to decrease the per-axis max feedrates."));
            this.inverted5DExtruderBox = new JCheckBox();
            this.inverted5DExtruderBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Enabled when building models sliced using Volumetric 5D and prepared for your printer using the makerbot4g driver."));
            this.xAxisMaxFeedrate = MachineOnboardParameters.PositiveTextFieldInt(this.frNF, "The maximum feedrate along the X axis measured in units of mm/s.  I.e., the maximum magnitude of the component of the feedrate vector along the X axis.");
            this.yAxisMaxFeedrate = MachineOnboardParameters.PositiveTextFieldInt(this.frNF, "The maximum feedrate along the Y axis measured in units of mm/s.  I.e., the maximum magnitude of the component of the feedrate vector along the Y axis.");
            this.zAxisMaxFeedrate = MachineOnboardParameters.PositiveTextFieldInt(this.frNF, "The maximum feedrate along the Z axis measured in units of mm/s.  I.e., the maximum magnitude of the component of the feedrate vector along the Z axis.");
            this.aAxisMaxFeedrate = MachineOnboardParameters.PositiveTextFieldInt(this.frNF, "The maximum feedrate to be experienced by extruder in units of mm/s.  I.e., the maximum magnitude of the component of the feedrate vector along the extruder's axis.");
            this.normalMoveAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.accNF, "The maximum rate of acceleration for normal printing moves in which filament is extruded and there is motion along any or all of the X, Y, or Z axes.  I.e., the maximum magnitude of the acceleration vector in units of millimeters per second squared, mm/s\u00b2.");
            this.xAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.accNF, "The maximum acceleration and deceleration along the X axis in units of mm/\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the X axis.");
            this.yAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.accNF, "The maximum acceleration and deceleration along the Y axis in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the Y axis.");
            this.zAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.accNF, "The maximum acceleration and deceleration along the Z axis in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the Z axis.");
            this.aAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.accNF, "The maximum acceleration and deceleration experienced by the extruder in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the extruder's axis.");
            this.xAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldDouble(this.jerkNF, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the X axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the X axis.");
            this.yAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldDouble(this.jerkNF, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the Y axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the Y axis.");
            this.zAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldDouble(this.jerkNF, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the Z axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the Z axis.");
            this.aAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldDouble(this.jerkNF, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the A axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the A axis.");
            this.JKNAdvance1 = MachineOnboardParameters.PositiveTextFieldDouble(this.kNF, "The value of the empirically fit Jetty-Kubicek-Newman Advance parameter K which helps control the amount of additional plastic that should be extruded during the acceleration phase and not extruded during the deceleration phase of each move.  It can be used to remove blobbing and splaying on the corners of cubes or at the junctions between line segments.  Typical values for this parameter range from around 0.0001 to 0.01.  Set to a value of 0 to disable use of this compensation.");
            this.JKNAdvance2 = MachineOnboardParameters.PositiveTextFieldDouble(this.kNF, "The value of the empirically fit Jetty-Kubicek-Newman Advance parameter K2, which helps during the deceleration phase of moves to reduce built up pressure in the extruder nozzle.  Typical values for this parameter range from around 0.001 to 0.02.  Set to a value of 0 to disable use of this compensation.");
            this.clockwiseExtruderChoice = new JCheckBox();
            this.clockwiseExtruderChoice.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Select the direction you need the extruder to turn in order to extrude filament.  For most Thing-o-Matic Stepstruders, this box is left unchecked when using 5D and checked when not using 5D.  You may need to do the opposite if your extruder's stepper motor is wired differently.  The same effect can be had by inverting the A-axis; this option primarily exists for users with a Gen 4 LCD interface."));
            this.extruderStepsPerMM = MachineOnboardParameters.PositiveTextFieldDouble(this.jerkNF, "The number of extruder steps required to extrude a single millimeter of filament.  Not to be confused with the number of extruder steps per millimeter of raw, input filament -- the \"stepspermm\" value used by ReplicatorG.  Typical values for a Stepstruder Mk7 with 1.75mm filament range from about 3.8 to 4.8 steps/mm.  For a Mk6 with 3.00 mm filament, typical values range from about 1.2 to 1.7.");
            this.extruderDeprime = MachineOnboardParameters.PositiveTextFieldDouble(this.jerkNF, "The number of stepper motor steps to retract the extruded filament when the pipeline of buffered moves empties or a travel-only move is encountered.  The default value is 4.0 mm.  Set to a value of 0 to disable this feature.  Do not use with Skeinforge's Reversal plugin nor Skeinforge's Dimension plugin's \"Retraction Distance\".");
            this.revMaxFeedrate = MachineOnboardParameters.PositiveTextFieldInt(this.frNF, "The maximum feedrate in mm/s to use in an extruder-only move.  An extruder-only move is a move in which there is no motion along the X, Y, or Z axes: the only motion is the extruder extruding or retracting filament.  Typically this value should be at least as large as the max A axis feedrate.");
            this.extruderMoveAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.accNF, "The maximum acceleration or deceleration in mm/s\u00b2 to use in an extruder-only move.  An extruder-only move is a move in which there is no motion along the X, Y, or Z axes: the only motion is the extruder extruding or retracting filament.  Typically this value should be at least as large as the A axis max acceleration.");
            this.minFeedrate = MachineOnboardParameters.PositiveTextFieldDouble(this.jerkNF, "The slowest feedrate to print at, in mm/s.  Use of this may help prevent some forms of blobbing.  This feature is useful when using older versions of Skeinforge which did not offer this functionality.");
            this.minTravelFeedrate = MachineOnboardParameters.PositiveTextFieldDouble(this.jerkNF, "The slowest feedrate to travel at, in mm/s.  This feature is useful when using older versions of Skeinforge which did not offer this functionality.");
            this.minPlannerSpeed = MachineOnboardParameters.PositiveTextFieldInt(this.frNF, "The slowest feedrate in mm/s to use at the junctions between adjoining line segments.  It is unlikely that this parameter needs to be adjusted.  Increasing its value will not speed up your printing.  Nearly always the acceleration planner ends up with junction speeds far in excess of this value (but within the maximum feedrate and acceleration limits).");
            this.minSegmentTime = MachineOnboardParameters.PositiveTextFieldDouble(this.minSegTimeNF, "The minimum time in seconds that printing a segment should take when the planning buffer is running dry (i.e., printing is proceeding faster than the microprocessor can plan ahead).  Increase this value if you see blobs or pauses while printing models with very fine details or when printing at high speed.");
            this.slowDownLimit = MachineOnboardParameters.PositiveTextFieldInt(this.sdNF, 8, "WARNING: you probably do not want to adjust this parameter.  The slowdown limit sets a threshhold for the plan ahead logic instructing it when to start enforcing the minimum segment print time.  The larger the value, the sooner it starts enforcing the slowdown limit.  Acceptable values are 3, 4, 5, 6, 7, and 8.  A value of 0 disables this feature.  Any attempt to use a value of 1 or 2 will result in a value of 3 being used instead.");
            this.lcdDimensionChoices = new String[]{"16 x 4", "20 x 4", "24 x 4"};
            this.lcdDimensionsChoice = new JComboBox<String>(this.lcdDimensionChoices);
            this.lcdDimensionsChoice.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Select the dimensions of the LCD screen display in your Gen 4 LCD interface.  Measurements are the number of character columns by the number of character rows.  The standard Gen 4 LCD display is 16 x 4."));
            this.moodLightChoiceIndex_DEFAULT = 0;
            this.moodLightScriptId_DEFAULT = 2;
            this.moodLightChoices = new String[]{"Off (2)", "Bot status (0)", "Custom color (1)", "Almond (12)", "Blue (6)", "Blue, Alice (15)", "Blue, Deep Sky (22)", "Blue, Midnight (21)", "Cyan (7)", "Gold (25)", "Gray (19)", "Gray, Light (20)", "Gray, Slate (18)", "Green (5)", "Green, Forest (24)", "Green, Olive (23)", "Hot Pink (26)", "Lavender (16)", "Linen (27)", "Magenta (8)", "Mint Cream (14)", "Orange (11)", "Peach Puff (13)", "Purple (10)", "Red (4)", "Rose, Misty (17)", "White (3)", "Yellow (9)", "Cycle Rainbow (110)", "Cycle Random (111)", "Cycle Red/Green/Blue (101)", "Cycle S.O.S. (118)", "Cycle Seasons (115)", "Cycle Traffic Lights (117)", "Cycle White/Red/Green/Blue/Off (100)", "Random Candle (112)", "Random Neon Reds (114)", "Random Thunderstorms (116)", "Random Water (113)", "Flashing Blue (105)", "Flashing Cyan (106)", "Flashing Green (104)", "Flashing Magenta (107)", "Flashing Red (103)", "Flashing White (102)", "Flashing Yellow (108)"};
            this.overrideGCodeTempBox = new JCheckBox();
            this.overrideGCodeTempBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "When enabled, override the gcode temperature settings using the preheat temperature settings for the extruders and build platform."));
            this.tool0Temp = MachineOnboardParameters.PositiveTextFieldInt(this.tempNF, 255, "Temperature in degrees Celsius to preheat extruder 0 to.  This temperature is also used as the override temperature when the \"override gcode temperature\" feature is enabled.");
            this.tool1Temp = MachineOnboardParameters.PositiveTextFieldInt(this.tempNF, 255, "Temperature in degrees Celsius to preheat extruder 1 to.  This temperature is also used as the override temperature when the \"override gcode temperature\" feature is enabled.");
            this.platformTemp = MachineOnboardParameters.PositiveTextFieldInt(this.tempNF, 255, "Temperature in degrees Celsius to preheat the build platform to.  This temperature is also used as the override temperature when the \"override gcode temperature\" feature is enabled.");
            this.buzzerRepeats = MachineOnboardParameters.PositiveTextFieldInt(this.tempNF, 255, "The number of times the buzzer should buzz when activated.  Use of this feature requires installation of a buzzer as per Thingiverse Thing 16170, \"Buzzer Support\".");
            this.moodLightCustomColor = new JColorChooser();
            this.moodLightCustomColor.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Select the custom color used when the \"Custom Color\" mood light script is selected.  Use of this feature requires installation of Thingiverse Thing 15347, \"Mood Lighting For ToM\"."));
            this.moodLightScript = new JComboBox<String>(this.moodLightChoices);
            this.moodLightScript.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Select the mood light script to be played by the mood lighting.  Use of this feature requires installation of Thingiverse Thing 15347, \"Mood Lighting For ToM\"."));
            int dismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
            if (dismissDelay < 10000) {
                ToolTipManager.sharedInstance().setDismissDelay(10000);
            }
        }

        public int findMoodLightChoice(int scriptId) {
            String str = "(" + scriptId + ")";
            for (int i = 0; i < this.moodLightChoices.length; ++i) {
                if (!this.moodLightChoices[i].contains(str)) continue;
                return i;
            }
            return -1;
        }

        public int findMoodLightScriptId(int choiceIndex) {
            int end2;
            if (choiceIndex < 0 || choiceIndex > this.moodLightChoices.length) {
                return -1;
            }
            int start = this.moodLightChoices[choiceIndex].indexOf(40);
            if (start < 0) {
                return -1;
            }
            if ((end2 = this.moodLightChoices[choiceIndex].indexOf(41, ++start)) < 0) {
                return -1;
            }
            int scriptId = -1;
            try {
                scriptId = Integer.parseInt(this.moodLightChoices[choiceIndex].substring(start, end2));
            }
            catch (Exception e) {
                // empty catch block
            }
            return scriptId;
        }

        public boolean isAccelerationEnabled() {
            return this.accelerationBox.isSelected();
        }

        public void setEEPROMFromUI() {
            byte status = 0;
            if (this.accelerationBox.isSelected()) {
                status = (byte)(status | 1);
            }
            if (this.accelerationPlannerBox.isSelected()) {
                status = (byte)(status | 2);
            }
            if (this.accelerationStrangledBox.isSelected()) {
                status = (byte)(status | 4);
            }
            this.target.setAccelerationStatus(status);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_EXTRUDER_NORM, ((Number)this.normalMoveAcceleration.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_FEEDRATE_X, ((Number)this.xAxisMaxFeedrate.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_FEEDRATE_Y, ((Number)this.yAxisMaxFeedrate.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_FEEDRATE_Z, ((Number)this.zAxisMaxFeedrate.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_FEEDRATE_A, ((Number)this.aAxisMaxFeedrate.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_X, ((Number)this.xAxisMaxAcceleration.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Y, ((Number)this.yAxisMaxAcceleration.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Z, ((Number)this.zAxisMaxAcceleration.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_A, ((Number)this.aAxisMaxAcceleration.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_X, ((Number)this.xAxisMaxSpeedChange.getValue()).doubleValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Y, ((Number)this.yAxisMaxSpeedChange.getValue()).doubleValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Z, ((Number)this.zAxisMaxSpeedChange.getValue()).doubleValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_A, ((Number)this.aAxisMaxSpeedChange.getValue()).doubleValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MIN_PLANNER_SPEED, ((Number)this.minPlannerSpeed.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K, ((Number)this.JKNAdvance1.getValue()).doubleValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K2, ((Number)this.JKNAdvance2.getValue()).doubleValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_E_STEPS_PER_MM, ((Number)this.extruderStepsPerMM.getValue()).doubleValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_REV_MAX_FEED_RATE, ((Number)this.revMaxFeedrate.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_EXTRUDER_RETRACT, ((Number)this.extruderMoveAcceleration.getValue()).longValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_A, ((Number)this.extruderDeprime.getValue()).doubleValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_CLOCKWISE_EXTRUDER, this.clockwiseExtruderChoice.isSelected() ? 1L : 0L);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MIN_FEED_RATE, ((Number)this.minFeedrate.getValue()).doubleValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.INVERTED_EXTRUDER_5D, this.inverted5DExtruderBox.isSelected() ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MIN_TRAVEL_FEED_RATE, ((Number)this.minTravelFeedrate.getValue()).doubleValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MIN_SEGMENT_TIME, ((Number)this.minSegmentTime.getValue()).doubleValue());
            long lv = ((Number)this.slowDownLimit.getValue()).longValue();
            if (lv < 0L) {
                lv = 0L;
            } else if (lv == 1L || lv == 2L) {
                lv = 3L;
            } else if (lv > 8L) {
                lv = 8L;
            }
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_SLOWDOWN_LIMIT, lv);
            int lcd = this.lcdDimensionsChoice.getSelectedIndex();
            int lcdType = 0;
            if (lcd == 1) {
                lcdType = 50;
            } else if (lcd == 2) {
                lcdType = 51;
            }
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.LCD_TYPE, lcdType);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.OVERRIDE_GCODE_TEMP, this.overrideGCodeTempBox.isSelected() ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.TOOL0_TEMP, ((Number)this.tool0Temp.getValue()).intValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.TOOL1_TEMP, ((Number)this.tool0Temp.getValue()).intValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.PLATFORM_TEMP, ((Number)this.platformTemp.getValue()).intValue());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.BUZZER_REPEATS, ((Number)this.buzzerRepeats.getValue()).intValue());
            int scriptId = this.findMoodLightScriptId(this.moodLightScript.getSelectedIndex());
            if (scriptId < 0) {
                scriptId = 2;
            }
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_SCRIPT, scriptId);
            Color c = this.moodLightCustomColor.getColor();
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_RED, c.getRed());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_GREEN, c.getGreen());
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_BLUE, c.getBlue());
        }

        public void setUIFromEEPROM() {
            byte aStatus = this.target.getAccelerationStatus();
            this.accelerationBox.setSelected((aStatus & 1) != 0);
            this.accelerationPlannerBox.setSelected((aStatus & 2) != 0);
            this.accelerationStrangledBox.setSelected((aStatus & 4) != 0);
            this.xAxisMaxFeedrate.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_FEEDRATE_X));
            this.yAxisMaxFeedrate.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_FEEDRATE_Y));
            this.zAxisMaxFeedrate.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_FEEDRATE_Z));
            this.aAxisMaxFeedrate.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_FEEDRATE_A));
            this.xAxisMaxAcceleration.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_X));
            this.yAxisMaxAcceleration.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Y));
            this.zAxisMaxAcceleration.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Z));
            this.aAxisMaxAcceleration.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_A));
            this.xAxisMaxSpeedChange.setValue(this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_X));
            this.yAxisMaxSpeedChange.setValue(this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Y));
            this.zAxisMaxSpeedChange.setValue(this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Z));
            this.aAxisMaxSpeedChange.setValue(this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_A));
            this.JKNAdvance1.setValue(this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K));
            this.JKNAdvance2.setValue(this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K2));
            this.minPlannerSpeed.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MIN_PLANNER_SPEED));
            this.normalMoveAcceleration.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_EXTRUDER_NORM));
            this.extruderStepsPerMM.setValue(this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_E_STEPS_PER_MM));
            this.revMaxFeedrate.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_REV_MAX_FEED_RATE));
            this.extruderMoveAcceleration.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_MAX_EXTRUDER_RETRACT));
            this.extruderDeprime.setValue(this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_A));
            this.clockwiseExtruderChoice.setSelected(0L != this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_CLOCKWISE_EXTRUDER));
            this.inverted5DExtruderBox.setSelected(0 != this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.INVERTED_EXTRUDER_5D));
            this.minFeedrate.setValue(this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MIN_FEED_RATE));
            this.minTravelFeedrate.setValue(this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MIN_TRAVEL_FEED_RATE));
            this.minSegmentTime.setValue(this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_MIN_SEGMENT_TIME));
            this.slowDownLimit.setValue(this.target.getEEPROMParamUInt(OnboardParameters.EEPROMParams.ACCEL_SLOWDOWN_LIMIT));
            int lcdType = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.LCD_TYPE);
            if (lcdType == 50) {
                this.lcdDimensionsChoice.setSelectedIndex(1);
            } else if (lcdType == 51) {
                this.lcdDimensionsChoice.setSelectedIndex(2);
            } else {
                this.lcdDimensionsChoice.setSelectedIndex(0);
            }
            this.overrideGCodeTempBox.setSelected(this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.OVERRIDE_GCODE_TEMP) != 0);
            this.tool0Temp.setValue(this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.TOOL0_TEMP));
            this.tool1Temp.setValue(this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.TOOL1_TEMP));
            this.platformTemp.setValue(this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.PLATFORM_TEMP));
            this.buzzerRepeats.setValue(this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.BUZZER_REPEATS));
            int moodLightChoice = this.findMoodLightChoice(this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_SCRIPT));
            if (moodLightChoice < 0) {
                moodLightChoice = 0;
            }
            this.moodLightScript.setSelectedIndex(moodLightChoice);
            this.moodLightCustomColor.setColor(this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_RED), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_GREEN), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_BLUE));
        }

        public void buildUI() {
            JPanel accelerationTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l][r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Acceleration", accelerationTab);
            JPanel accelerationMiscTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l][r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Acceleration (Advanced)", accelerationMiscTab);
            JPanel miscTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l][r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Misc", miscTab);
            this.normalMoveAcceleration.setColumns(8);
            this.xAxisMaxFeedrate.setColumns(4);
            this.xAxisMaxAcceleration.setColumns(8);
            this.yAxisMaxFeedrate.setColumns(4);
            this.yAxisMaxAcceleration.setColumns(8);
            this.zAxisMaxFeedrate.setColumns(4);
            this.zAxisMaxAcceleration.setColumns(8);
            this.aAxisMaxFeedrate.setColumns(4);
            this.aAxisMaxAcceleration.setColumns(8);
            this.xAxisMaxSpeedChange.setColumns(4);
            this.yAxisMaxSpeedChange.setColumns(4);
            this.zAxisMaxSpeedChange.setColumns(4);
            this.aAxisMaxSpeedChange.setColumns(4);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Acceleration enabled", "split 2", this.accelerationBox);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Max acceleration (magnitude of acceleration vector; mm/s\u00b2)", "span 2, gapleft push", this.normalMoveAcceleration, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "X max feedrate (mm/s)", this.xAxisMaxFeedrate);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "X max acceleration (mm/s\u00b2)", this.xAxisMaxAcceleration, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Y max feedrate (mm/s)", this.yAxisMaxFeedrate);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Y max acceleration (mm/s\u00b2)", this.yAxisMaxAcceleration, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Z max feedrate (mm/s)", this.zAxisMaxFeedrate);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Z max acceleration (mm/s\u00b2)", this.zAxisMaxAcceleration, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "A max feedrate (mm/s)", this.aAxisMaxFeedrate);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "A max acceleration (mm/s\u00b2)", this.aAxisMaxAcceleration, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "X max speed change (mm/s)", this.xAxisMaxSpeedChange, "span 2, wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Y max speed change (mm/s)", this.yAxisMaxSpeedChange, "span 2, wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Z max speed change (mm/s)", this.zAxisMaxSpeedChange, "span 2, wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "A max speed change (mm/s)", this.aAxisMaxSpeedChange, "span 2, wrap");
            this.JKNAdvance1.setColumns(8);
            this.JKNAdvance2.setColumns(8);
            this.extruderMoveAcceleration.setColumns(8);
            this.revMaxFeedrate.setColumns(4);
            this.minPlannerSpeed.setColumns(4);
            this.minSegmentTime.setColumns(4);
            this.slowDownLimit.setColumns(4);
            this.extruderDeprime.setColumns(4);
            this.extruderStepsPerMM.setColumns(4);
            this.minFeedrate.setColumns(4);
            this.minTravelFeedrate.setColumns(4);
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "JKN Advance K", this.JKNAdvance1);
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Extruder deprime (mm)", this.extruderDeprime, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "JKN Advance K2", this.JKNAdvance2);
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Extruder steps/mm", this.extruderStepsPerMM, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Max acceleration for extruder-only moves (mm/s\u00b2)", this.extruderMoveAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Min printing feedrate (mm/s)", this.minFeedrate, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Max feedrate for extruder-only moves (mm/s)", this.revMaxFeedrate);
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Min travel feedrate (mm/s)", this.minTravelFeedrate, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Min feedrate at junctions (mm/s)", this.minPlannerSpeed);
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Clockwise extruder", this.clockwiseExtruderChoice, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Min segment printing time (s)", this.minSegmentTime);
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Acceleration planner enabled", this.accelerationPlannerBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Planner slowdown limit", "gapbottom push", this.slowDownLimit, "gapbottom push");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Acceleration strangled", "gapbottom push", this.accelerationStrangledBox, "wrap");
            this.tool0Temp.setColumns(8);
            this.tool1Temp.setColumns(8);
            this.platformTemp.setColumns(8);
            this.buzzerRepeats.setColumns(8);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Override gcode temperatures", this.overrideGCodeTempBox);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Gen 4 LCD dimensions", this.lcdDimensionsChoice, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Extruder 0 preheat & override temperature (C)", this.tool0Temp);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Buzzer repeats", this.buzzerRepeats, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Extruder 1 preheat & override temperature (C)", this.tool1Temp);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Clockwise extruder", this.clockwiseExtruderChoice, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Platform preheat & override temperature (C)", this.platformTemp);
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Volumetric 5D extruder", this.inverted5DExtruderBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Mood light script", this.moodLightScript, "span 4, wrap");
            MachineOnboardParameters.addWithSharedToolTips(miscTab, "Mood light color", this.moodLightCustomColor, "span 4, wrap, gapbottom push, gapright push");
        }
    }

    private class MightySailfishMachineOnboardAccelerationParameters
    extends MachineOnboardAccelerationParameters {
        final int UI_TAB_1 = 1;
        final int UI_TAB_2 = 2;
        final int UI_TAB_LED = 4;
        AccelParamsTab1 draftParams;
        AccelParamsTab1 qualityParams;
        final int width = 60;
        private NumberFormat repNF;
        private JCheckBox accelerationBox;
        private JCheckBox extruderHoldBox;
        private JCheckBox checkCRCBox;
        private JButton draftButton;
        private JButton qualityButton;
        private JFormattedTextField xAxisMaxAcceleration;
        private JFormattedTextField yAxisMaxAcceleration;
        private JFormattedTextField zAxisMaxAcceleration;
        private JFormattedTextField aAxisMaxAcceleration;
        private JFormattedTextField bAxisMaxAcceleration;
        private JFormattedTextField xAxisMaxSpeedChange;
        private JFormattedTextField yAxisMaxSpeedChange;
        private JFormattedTextField zAxisMaxSpeedChange;
        private JFormattedTextField aAxisMaxSpeedChange;
        private JFormattedTextField bAxisMaxSpeedChange;
        private NumberFormat kNF;
        private JFormattedTextField JKNAdvance1;
        private JFormattedTextField JKNAdvance2;
        private JCheckBox extruderDeprimeTravel;
        private NumberFormat alevelNF;
        private JFormattedTextField alevelMaxZDiff;
        private JFormattedTextField alevelMaxZProbeHits;
        private JFormattedTextField extruderDeprimeA;
        private JFormattedTextField extruderDeprimeB;
        private JCheckBox overrideGCodeTempBox;
        private JCheckBox preheatDuringPauseBox;
        private JCheckBox slowdownFlagBox;
        private JCheckBox moodLightShowHeatingBox;
        public final String[] moodLightChoices;
        private JColorChooser moodLightCustomColor;
        private JComboBox moodLightScript;

        private MightySailfishMachineOnboardAccelerationParameters(OnboardParameters target, Driver driver, JTabbedPane subtabs) {
            super(target, driver, subtabs);
            this.UI_TAB_1 = 1;
            this.UI_TAB_2 = 2;
            this.UI_TAB_LED = 4;
            this.draftParams = new AccelParamsTab1(true, new int[]{1000, 1000, 150, 2000, 2000}, new int[]{40, 40, 10, 40, 40});
            this.qualityParams = new AccelParamsTab1(true, new int[]{1000, 1000, 150, 2000, 2000}, new int[]{15, 15, 10, 20, 20});
            this.width = 60;
            this.repNF = NumberFormat.getIntegerInstance();
            this.accelerationBox = new JCheckBox();
            this.accelerationBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Enable or disable printing with acceleration"));
            this.extruderHoldBox = new JCheckBox();
            this.extruderHoldBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Check this box if using a 3mm filament extruder.  Using extruder hold causes the extruder stepper motors to remain engaged throughout the entire build regardless of whether or not the gcode requests that they be disabled via M103 commands.  When 3mm filament extruder stepper motors are disabled, the filament has a tendency to back out a tiny amount owing to the high pressure within the melt chamber of a 3mm extruder."));
            this.checkCRCBox = new JCheckBox();
            this.checkCRCBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Your SD cards contain a tiny computer which talks with the computer within your bot.  Electrical noise within your bot can introduce errors in these conversations which, in turn, can cause defects in your print or even cause the print to fail.  These errors normally go undetected: the bot and SD card do not normally check to see whether the file data sent from the SD card to the bot arrives without errors and the bot assumes that the data is correct with no errors.  By enabling this feature, the SD card's computer is told to add extra information to the end of each data transfer.  This extra information, a 16bit CRC, is used to confirm that the file data was transferred without the introduction of errors.  If your bot then sees that an error occurred, it will ask the SD card to retransmit the data.  This maximizes the likelihood of successful prints by catching and repairing data transfer errors.  If the same file data fails to transfer correctly after five attempts, then the print is gracefully cancelled and an error message displayed.  NOTE THAT Replicator 1's are particularly susceptible to data transfer errors owing to their electronics design."));
            this.draftButton = new JButton("Quick Draft");
            this.draftButton.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "By clicking this button, the on-screen acceleration parameters will be changed to suggested values for rapid draft-quality builds.  The values will not be committed to your Replicator until you click the Commit button.  You may adjust the settings before committing them to your Replicator."));
            this.qualityButton = new JButton("Fine Quality");
            this.qualityButton.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "By clicking this button, the on-screen acceleration parameters will be changed to suggested values for fine-quality builds.  The values will not be committed to your Replicator until you click the Commit button.  You may adjust the settings before committing them to your Replicator."));
            this.xAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The maximum acceleration and deceleration along the X axis in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the X axis.");
            this.yAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The maximum acceleration and deceleration along the Y axis in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the Y axis.");
            this.zAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 2600, "The maximum acceleration and deceleration along the Z axis in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the Z axis.");
            this.aAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The maximum acceleration and deceleration experienced by the right extruder in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the right extruder's filament axis.");
            this.bAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The maximum acceleration and deceleration experienced by the left extruder in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the left extruder's filament axis.");
            this.xAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the X axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the X axis.");
            this.yAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the Y axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the Y axis.");
            this.zAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the Z axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the Z axis.");
            this.aAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate for the right extruder when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change for the right extruder.");
            this.bAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate for the left extruder when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change for the left extruder.");
            this.kNF = NumberFormat.getNumberInstance();
            this.kNF.setMaximumFractionDigits(5);
            this.kNF.setMaximumIntegerDigits(2);
            this.JKNAdvance1 = MachineOnboardParameters.PositiveTextFieldDouble(this.kNF, "The value of the empirically fit Jetty-Kubicek-Newman Advance parameter K which helps control the amount of additional plastic that should be extruded during the acceleration phase and not extruded during the deceleration phase of each move.  It can be used to remove blobbing and splaying on the corners of cubes or at the junctions between line segments.  Typical values for this parameter range from around 0.0001 to 0.01.  Set to a value of 0 to disable use of this compensation.");
            this.JKNAdvance2 = MachineOnboardParameters.PositiveTextFieldDouble(this.kNF, "The value of the empirically fit Jetty-Kubicek-Newman Advance parameter K2, which helps during the deceleration phase of moves to reduce built up pressure in the extruder nozzle.  Typical values for this parameter range from around 0.001 to 0.1.  Set to a value of 0 to disable use of this compensation.");
            this.extruderDeprimeTravel = new JCheckBox();
            this.extruderDeprimeTravel.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "The firmware can retract the filament thus depriming the extruder on (1) detected travel moves, (2) pauses of the build, and (3) tiny brief pauses caused by the acceleration planner not keeping pace with the print and leaving the bot very briefly idle.  Item (3) can cause tiny pimples or zits on the print.  When this box is checked and the deprime values ares non-zero, the extruder is deprimed on (1), (2), and (3) and reprimed when extrusion resumes.  When this box is not checked and the deprime values are non-zero, the extruder is deprimed on (2) and (3) and reprimed when extrusion resumes.  If you will be using retraction/deprime with your slicer, then leave this box unchecked.  To entirely disable firmware deprime, set the deprime values to be zero."));
            this.alevelNF = NumberFormat.getNumberInstance();
            this.alevelNF.setMaximumFractionDigits(2);
            this.alevelNF.setMaximumIntegerDigits(1);
            this.alevelMaxZDiff = MachineOnboardParameters.PositiveTextFieldDoubleMax(this.alevelNF, 0.99, "The maximum vertical difference in height between any two probed leveling points may not exceed this value. Specify the value in units of millimeters.  The default value is 0.50 mm and may range from 0.01 to 0.99 mm. Only applicable on bots with firmware-based auto-leveling.");
            this.alevelMaxZProbeHits = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 200, "If the auto-leveling probe registers too many hits during a print, then the bot will pause printing and request manual intervention.  To ignore probe hits while printing, specify a value of 0.  Otherwise specify the maximum number of probe hits to allow before pausing.  The default value is 20.  Enter a value  between 1 and 200; 0 to disable.  Only applicable on bots with firmware-based auto-leveling.");
            this.extruderDeprimeA = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The number of steps to retract the right extruder's filament when the pipeline of buffered moves empties, the bot is paused, or \"deprime on travel\" is enabled and a travel move is detected.  Set to a value of 0 to disable this feature for this extruder.  Do not use with Skeinforge's Reversal plugin nor Skeinforge's Dimension plugin's \"Retraction Distance\".");
            this.extruderDeprimeB = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The number of steps to retract the right extruder's filament when the pipeline of buffered moves empties, the bot is paused, or \"deprime on travel\" is enabled and a travel move is detected.  Set to a value of 0 to disable this feature for this extruder.  Do not use with Skeinforge's Reversal plugin nor Skeinforge's Dimension plugin's \"Retraction Distance\".");
            this.overrideGCodeTempBox = new JCheckBox();
            this.overrideGCodeTempBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "When enabled, override the gcode temperature settings using the preheat temperature settings for the extruders and build platform."));
            this.preheatDuringPauseBox = new JCheckBox();
            this.preheatDuringPauseBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "When enabled, leave the extruder and platform heaters enabled whilst paused."));
            this.slowdownFlagBox = new JCheckBox();
            this.slowdownFlagBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "If you are printing an object with fine details or at very fast speeds, it is possible that the planner will be unable to keep up with printing.  This may be evidenced by frequent pauses accompanied by unwanted plastic blobs or zits.  You may be able to mitigate this by enabling \"slowdown\".  When slowdown is enabled and the planner is having difficulty keeping up, the printing feed rate is reduced so as to cause each segment to take more time to print.  The reduction in printing speed then gives the planner a chance to catch up."));
            this.moodLightShowHeatingBox = new JCheckBox();
            this.moodLightChoices = new String[]{"White", "Red", "Orange", "Pink", "Green", "Blue", "Purple", "Off", "Custom Color"};
            this.moodLightCustomColor = new JColorChooser();
            this.moodLightCustomColor.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Select the color to use when the \"Custom Color\" lighting choice is selected."));
            this.moodLightScript = new JComboBox<String>(this.moodLightChoices);
            this.moodLightScript.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Select the LED lighting color.  To use a custom color, select \"Custom Color\" and then pick the color with the color selection tool below."));
            int dismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
            if (dismissDelay < 10000) {
                ToolTipManager.sharedInstance().setDismissDelay(10000);
            }
            this.draftButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    MightySailfishMachineOnboardAccelerationParameters.this.setUIFields(MightySailfishMachineOnboardAccelerationParameters.this.draftParams);
                }
            });
            this.qualityButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    MightySailfishMachineOnboardAccelerationParameters.this.setUIFields(MightySailfishMachineOnboardAccelerationParameters.this.qualityParams);
                }
            });
        }

        AccelParams getAccelParamsFromUI() {
            Color c = this.moodLightCustomColor.getColor();
            return new AccelParams(new AccelParamsTab1(this.accelerationBox.isSelected(), new int[]{((Number)this.xAxisMaxAcceleration.getValue()).intValue(), ((Number)this.yAxisMaxAcceleration.getValue()).intValue(), ((Number)this.zAxisMaxAcceleration.getValue()).intValue(), ((Number)this.aAxisMaxAcceleration.getValue()).intValue(), ((Number)this.bAxisMaxAcceleration.getValue()).intValue()}, new int[]{((Number)this.xAxisMaxSpeedChange.getValue()).intValue(), ((Number)this.yAxisMaxSpeedChange.getValue()).intValue(), ((Number)this.zAxisMaxSpeedChange.getValue()).intValue(), ((Number)this.aAxisMaxSpeedChange.getValue()).intValue(), ((Number)this.bAxisMaxSpeedChange.getValue()).intValue()}), new AccelParamsTab2(this.slowdownFlagBox.isSelected(), this.extruderDeprimeTravel.isSelected(), this.overrideGCodeTempBox.isSelected(), this.preheatDuringPauseBox.isSelected(), this.extruderHoldBox.isSelected(), this.checkCRCBox.isSelected(), ((Number)this.alevelMaxZDiff.getValue()).doubleValue(), ((Number)this.alevelMaxZProbeHits.getValue()).intValue(), new int[]{((Number)this.extruderDeprimeA.getValue()).intValue(), ((Number)this.extruderDeprimeB.getValue()).intValue()}, new double[]{((Number)this.JKNAdvance1.getValue()).doubleValue(), ((Number)this.JKNAdvance2.getValue()).doubleValue()}), new LEDParamsTab(this.moodLightScript.getSelectedIndex(), this.moodLightShowHeatingBox.isSelected(), c.getRed(), c.getGreen(), c.getBlue()));
        }

        public boolean isAccelerationEnabled() {
            return this.accelerationBox.isSelected();
        }

        private void setEEPROMFromUI(AccelParams params) {
            this.target.setAccelerationStatus(params.tab1.accelerationEnabled ? (byte)1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.OVERRIDE_GCODE_TEMP, params.tab2.overrideGCodeTempEnabled ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.PREHEAT_DURING_PAUSE, params.tab2.preheatDuringPauseEnabled ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_SLOWDOWN_FLAG, params.tab2.slowdownEnabled ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.EXTRUDER_HOLD, params.tab2.extruderHold ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.SD_USE_CRC, params.tab2.checkCRC ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_X, params.tab1.maxAccelerations[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Y, params.tab1.maxAccelerations[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Z, params.tab1.maxAccelerations[2]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_A, params.tab1.maxAccelerations[3]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_B, params.tab1.maxAccelerations[4]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_X, params.tab1.maxSpeedChanges[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Y, params.tab1.maxSpeedChanges[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Z, params.tab1.maxSpeedChanges[2]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_A, params.tab1.maxSpeedChanges[3]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_B, params.tab1.maxSpeedChanges[4]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K, params.tab2.JKNadvance[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K2, params.tab2.JKNadvance[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.DEPRIME_ON_TRAVEL, params.tab2.deprimeTravel ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_A, params.tab2.deprime[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_B, params.tab2.deprime[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_SCRIPT, params.tabLED.colorChoice);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_SHOW_HEATING, params.tabLED.showHeating ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_RED, params.tabLED.red);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_GREEN, params.tabLED.green);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_BLUE, params.tabLED.blue);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ALEVEL_MAX_ZDELTA, params.tab2.alevelMaxZDiff);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ALEVEL_MAX_ZPROBE_HITS, params.tab2.alevelMaxZProbeHits);
        }

        public void setEEPROMFromUI() {
            this.setEEPROMFromUI(this.getAccelParamsFromUI());
        }

        private void setUIFields(AccelParamsTab1 params) {
            this.setUIFields(1, params.accelerationEnabled, false, false, false, false, false, false, params.maxAccelerations, params.maxSpeedChanges, 0.0, 0, null, null, 0, false, 0, 0, 0);
        }

        private void setUIFields(int tabs, boolean accelerationEnabled, boolean slowdownEnabled, boolean deprimeTravel, boolean overrideGCodeTempEnabled, boolean preheatDuringPauseEnabled, boolean extruderHoldEnabled, boolean checkCRC, int[] maxAccelerations, int[] maxSpeedChanges, double maxZDiff, int maxZProbeHits, double[] JKNadvance, int[] deprime, int colorChoice, boolean showHeating, int red, int green, int blue) {
            if ((tabs & 1) != 0) {
                this.accelerationBox.setSelected(accelerationEnabled);
                if (maxAccelerations != null) {
                    this.xAxisMaxAcceleration.setValue(maxAccelerations[0]);
                    this.yAxisMaxAcceleration.setValue(maxAccelerations[1]);
                    this.zAxisMaxAcceleration.setValue(maxAccelerations[2]);
                    this.aAxisMaxAcceleration.setValue(maxAccelerations[3]);
                    this.bAxisMaxAcceleration.setValue(maxAccelerations[4]);
                }
                if (maxSpeedChanges != null) {
                    this.xAxisMaxSpeedChange.setValue(maxSpeedChanges[0]);
                    this.yAxisMaxSpeedChange.setValue(maxSpeedChanges[1]);
                    this.zAxisMaxSpeedChange.setValue(maxSpeedChanges[2]);
                    this.aAxisMaxSpeedChange.setValue(maxSpeedChanges[3]);
                    this.bAxisMaxSpeedChange.setValue(maxSpeedChanges[4]);
                }
            }
            if ((tabs & 2) != 0) {
                this.slowdownFlagBox.setSelected(slowdownEnabled);
                this.extruderDeprimeTravel.setSelected(deprimeTravel);
                this.overrideGCodeTempBox.setSelected(overrideGCodeTempEnabled);
                this.preheatDuringPauseBox.setSelected(preheatDuringPauseEnabled);
                this.extruderHoldBox.setSelected(extruderHoldEnabled);
                this.checkCRCBox.setSelected(checkCRC);
                this.alevelMaxZProbeHits.setValue(maxZProbeHits);
                this.alevelMaxZDiff.setValue(maxZDiff);
                if (JKNadvance != null) {
                    this.JKNAdvance1.setValue(JKNadvance[0]);
                    this.JKNAdvance2.setValue(JKNadvance[1]);
                }
                if (deprime != null) {
                    this.extruderDeprimeA.setValue(deprime[0]);
                    this.extruderDeprimeB.setValue(deprime[1]);
                }
            }
            if ((tabs & 4) != 0) {
                if (colorChoice < 0 || colorChoice > 8) {
                    colorChoice = 0;
                }
                this.moodLightScript.setSelectedIndex(colorChoice);
                this.moodLightShowHeatingBox.setSelected(showHeating);
                this.moodLightCustomColor.setColor(red & 0xFF, green & 0xFF, blue & 0xFF);
            }
        }

        public void setUIFromEEPROM() {
            boolean accelerationEnabled = this.target.getAccelerationStatus() != 0;
            boolean slowdownEnabled = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_SLOWDOWN_FLAG) != 0;
            boolean deprimeTravel = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.DEPRIME_ON_TRAVEL) == 1;
            boolean overrideGCodeTempEnabled = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.OVERRIDE_GCODE_TEMP) != 0;
            boolean preheatDuringPauseEnabled = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.PREHEAT_DURING_PAUSE) != 0;
            boolean extruderHoldEnabled = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.EXTRUDER_HOLD) != 0;
            boolean checkCRC = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.SD_USE_CRC) == 1;
            int[] maxAccelerations = new int[]{this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_X), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Y), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Z), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_A), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_B)};
            int[] maxSpeedChanges = new int[]{this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_X), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Y), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Z), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_A), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_B)};
            double[] JKNadvance = new double[]{this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K), this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K2)};
            int[] deprime = new int[]{this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_A), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_B)};
            int colorChoice = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_SCRIPT);
            boolean showHeating = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_SHOW_HEATING) != 0;
            int red = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_RED);
            int green = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_GREEN);
            int blue = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.MOOD_LIGHT_CUSTOM_BLUE);
            int maxZProbeHits = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ALEVEL_MAX_ZPROBE_HITS);
            double maxZDiff = this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ALEVEL_MAX_ZDELTA);
            this.setUIFields(7, accelerationEnabled, slowdownEnabled, deprimeTravel, overrideGCodeTempEnabled, preheatDuringPauseEnabled, extruderHoldEnabled, checkCRC, maxAccelerations, maxSpeedChanges, maxZDiff, maxZProbeHits, JKNadvance, deprime, colorChoice, showHeating, red, green, blue);
        }

        public void buildUI() {
            JPanel accelerationTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l][r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Acceleration", accelerationTab);
            JPanel accelerationMiscTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Acceleration (Misc)", accelerationMiscTab);
            JPanel LEDTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Lighting", LEDTab);
            this.xAxisMaxAcceleration.setColumns(8);
            this.xAxisMaxSpeedChange.setColumns(4);
            this.yAxisMaxAcceleration.setColumns(8);
            this.yAxisMaxSpeedChange.setColumns(4);
            this.zAxisMaxAcceleration.setColumns(8);
            this.zAxisMaxSpeedChange.setColumns(4);
            this.aAxisMaxAcceleration.setColumns(8);
            this.aAxisMaxSpeedChange.setColumns(4);
            this.bAxisMaxAcceleration.setColumns(8);
            this.bAxisMaxSpeedChange.setColumns(4);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Acceleration enabled", this.accelerationBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "X max acceleration (mm/s\u00b2)", this.xAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "X max speed change (mm/s)", this.xAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Y max acceleration (mm/s\u00b2)", this.yAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Y max speed change (mm/s)", this.yAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Z max acceleration (mm/s\u00b2)", this.zAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Z max speed change (mm/s)", this.zAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Right extruder max acceleration (mm/s\u00b2)", this.aAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Right extruder max speed change (mm/s)", this.aAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Left extruder acceleration (mm/s\u00b2)", this.bAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Left extruder max speed change (mm/s)", this.bAxisMaxSpeedChange, "wrap");
            accelerationTab.add((Component)this.qualityButton, "span 2, gapleft push");
            accelerationTab.add((Component)this.draftButton, "span 2, gapright push");
            this.JKNAdvance1.setColumns(8);
            this.JKNAdvance2.setColumns(8);
            this.extruderDeprimeA.setColumns(8);
            this.extruderDeprimeB.setColumns(8);
            this.alevelMaxZDiff.setColumns(8);
            this.alevelMaxZProbeHits.setColumns(8);
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Slow printing when acceleration planing falls behind", this.slowdownFlagBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Override the target temperatures in the gcode", this.overrideGCodeTempBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Preheat during paused operations", this.preheatDuringPauseBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "JKN Advance K", this.JKNAdvance1, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "JKN Advance K2", this.JKNAdvance2, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Deprime on travel moves", this.extruderDeprimeTravel, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Right extruder deprime (steps)", this.extruderDeprimeA, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Left extruder deprime (steps)", this.extruderDeprimeB, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Enable SD card error checking", this.checkCRCBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Extruder hold enabled", this.extruderHoldBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Auto-level max Z probe hits", this.alevelMaxZProbeHits, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Auto-level max Z height difference", this.alevelMaxZDiff, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(LEDTab, "Show heating progress by changing the lighting color", this.moodLightShowHeatingBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(LEDTab, "Lighting color when idle or during printing", this.moodLightScript, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(LEDTab, "Custom color choice", this.moodLightCustomColor, "span 2, wrap, gapbottom push, gapright push");
        }

        private class AccelParams {
            public AccelParamsTab1 tab1;
            public AccelParamsTab2 tab2;
            public LEDParamsTab tabLED;

            AccelParams(AccelParamsTab1 params1, AccelParamsTab2 params2, LEDParamsTab paramsLED) {
                this.tab1 = params1;
                this.tab2 = params2;
                this.tabLED = paramsLED;
            }
        }

        class AccelParamsTab2 {
            boolean slowdownEnabled;
            boolean deprimeTravel;
            boolean overrideGCodeTempEnabled;
            boolean preheatDuringPauseEnabled;
            boolean extruderHold;
            boolean checkCRC;
            double alevelMaxZDiff;
            int alevelMaxZProbeHits;
            int[] deprime;
            double[] JKNadvance;

            AccelParamsTab2(boolean slowdownEnabled, boolean deprimeTravel, boolean overrideGCodeTempEnabled, boolean preheatDuringPauseEnabled, boolean extruderHold, boolean checkCRC, double alevelMaxZDiff, int alevelMaxZProbeHits, int[] deprime, double[] JKNadvance) {
                this.slowdownEnabled = slowdownEnabled;
                this.deprimeTravel = deprimeTravel;
                this.overrideGCodeTempEnabled = overrideGCodeTempEnabled;
                this.preheatDuringPauseEnabled = preheatDuringPauseEnabled;
                this.extruderHold = extruderHold;
                this.checkCRC = checkCRC;
                double d = alevelMaxZDiff < 0.01 ? 0.01 : (this.alevelMaxZDiff = alevelMaxZDiff > 0.99 ? 0.99 : alevelMaxZDiff);
                this.alevelMaxZProbeHits = alevelMaxZProbeHits <= 0 ? 0 : (alevelMaxZProbeHits > 200 ? 200 : alevelMaxZProbeHits);
                this.deprime = deprime;
                this.JKNadvance = JKNadvance;
            }
        }

        class AccelParamsTab1 {
            boolean accelerationEnabled;
            int[] maxAccelerations;
            int[] maxSpeedChanges;

            AccelParamsTab1(boolean accelerationEnabled, int[] maxAccelerations, int[] maxSpeedChanges) {
                this.accelerationEnabled = accelerationEnabled;
                this.maxAccelerations = maxAccelerations;
                this.maxSpeedChanges = maxSpeedChanges;
            }

            boolean isEqual(AccelParamsTab1 params) {
                if (this == params) {
                    return true;
                }
                return this.accelerationEnabled == params.accelerationEnabled && Arrays.equals(this.maxAccelerations, params.maxAccelerations) && Arrays.equals(this.maxSpeedChanges, params.maxSpeedChanges);
            }
        }

        class LEDParamsTab {
            int colorChoice;
            boolean showHeating;
            int red;
            int green;
            int blue;

            LEDParamsTab(int colorChoice, boolean showHeating, int red, int green, int blue) {
                if (colorChoice < 0 || colorChoice > 8) {
                    colorChoice = 0;
                }
                this.colorChoice = colorChoice;
                this.showHeating = showHeating;
                this.red = red & 0xFF;
                this.green = green & 0xFF;
                this.blue = blue & 0xFF;
            }

            boolean isEqual(LEDParamsTab params) {
                if (this == params) {
                    return true;
                }
                return this.colorChoice == params.colorChoice && this.showHeating == params.showHeating && this.red == params.red && this.green == params.green && this.blue == params.blue;
            }
        }
    }

    private class JettyMightyBoardMachineOnboardAccelerationParameters
    extends MachineOnboardAccelerationParameters {
        final int UI_TAB_1 = 1;
        final int UI_TAB_2 = 2;
        AccelParamsTab1 draftParams;
        AccelParamsTab1 qualityParams;
        final int width = 60;
        private NumberFormat repNF;
        private JCheckBox accelerationBox;
        private JButton draftButton;
        private JButton qualityButton;
        private JFormattedTextField xAxisMaxAcceleration;
        private JFormattedTextField yAxisMaxAcceleration;
        private JFormattedTextField zAxisMaxAcceleration;
        private JFormattedTextField aAxisMaxAcceleration;
        private JFormattedTextField bAxisMaxAcceleration;
        private JFormattedTextField xAxisMaxSpeedChange;
        private JFormattedTextField yAxisMaxSpeedChange;
        private JFormattedTextField zAxisMaxSpeedChange;
        private JFormattedTextField aAxisMaxSpeedChange;
        private JFormattedTextField bAxisMaxSpeedChange;
        private JFormattedTextField normalMoveAcceleration;
        private JFormattedTextField extruderMoveAcceleration;
        private NumberFormat kNF;
        private JFormattedTextField JKNAdvance1;
        private JFormattedTextField JKNAdvance2;
        private JFormattedTextField extruderDeprimeA;
        private JFormattedTextField extruderDeprimeB;
        private JCheckBox slowdownFlagBox;

        private JettyMightyBoardMachineOnboardAccelerationParameters(OnboardParameters target, Driver driver, JTabbedPane subtabs) {
            super(target, driver, subtabs);
            this.UI_TAB_1 = 1;
            this.UI_TAB_2 = 2;
            this.draftParams = new AccelParamsTab1(true, new int[]{2000, 2000}, new int[]{1000, 1000, 150, 2000, 2000}, new int[]{40, 40, 10, 40, 40});
            this.qualityParams = new AccelParamsTab1(true, new int[]{2000, 2000}, new int[]{1000, 1000, 150, 2000, 2000}, new int[]{15, 15, 10, 20, 20});
            this.width = 60;
            this.repNF = NumberFormat.getIntegerInstance();
            this.accelerationBox = new JCheckBox();
            this.accelerationBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "Enable or disable printing with acceleration"));
            this.draftButton = new JButton("Quick Draft");
            this.draftButton.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "By clicking this button, the on-screen acceleration parameters will be changed to suggested values for rapid draft-quality builds.  The values will not be committed to your Replicator until you click the Commit button.  You may adjust the settings before committing them to your Replicator."));
            this.qualityButton = new JButton("Fine Quality");
            this.qualityButton.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "By clicking this button, the on-screen acceleration parameters will be changed to suggested values for fine-quality builds.  The values will not be committed to your Replicator until you click the Commit button.  You may adjust the settings before committing them to your Replicator."));
            this.xAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The maximum acceleration and deceleration along the X axis in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the X axis.");
            this.yAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The maximum acceleration and deceleration along the Y axis in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the Y axis.");
            this.zAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 2600, "The maximum acceleration and deceleration along the Z axis in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the Z axis.");
            this.aAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The maximum acceleration and deceleration experienced by the right extruder in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the right extruder's filament axis.");
            this.bAxisMaxAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The maximum acceleration and deceleration experienced by the left extruder in units of mm/s\u00b2.  I.e., the maximum magnitude of the component of the acceleration vector along the left extruder's filament axis.");
            this.xAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the X axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the X axis.");
            this.yAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the Y axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the Y axis.");
            this.zAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate along the Z axis when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change along the Z axis.");
            this.aAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate for the right extruder when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change for the right extruder.");
            this.bAxisMaxSpeedChange = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 300, "Yet Another Jerk (YAJ) algorithm's maximum change in feedrate for the left extruder when transitioning from one printed segment to another, measured in units of mm/s.  I.e., the maximum magnitude of the component of the velocity change for the left extruder.");
            this.normalMoveAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The maximum rate of acceleration for normal printing moves in which filament is extruded and there is motion along any or all of the X, Y, or Z axes.  I.e., the maximum magnitude of the acceleration vector in units of millimeters per second squared, mm/s\u00b2.");
            this.extruderMoveAcceleration = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The maximum acceleration or deceleration in mm/s\u00b2 to use in an extruder-only move.  An extruder-only move is a move in which there is no motion along the X, Y, or Z axes: the only motion is the extruder extruding or retracting filament.  Typically this value should be at least as large as the A and B axis max accelerations.");
            this.kNF = NumberFormat.getNumberInstance();
            this.kNF.setMaximumFractionDigits(5);
            this.kNF.setMaximumIntegerDigits(2);
            this.JKNAdvance1 = MachineOnboardParameters.PositiveTextFieldDouble(this.kNF, "The value of the empirically fit Jetty-Kubicek-Newman Advance parameter K which helps control the amount of additional plastic that should be extruded during the acceleration phase and not extruded during the deceleration phase of each move.  It can be used to remove blobbing and splaying on the corners of cubes or at the junctions between line segments.  Typical values for this parameter range from around 0.0001 to 0.01.  Set to a value of 0 to disable use of this compensation.");
            this.JKNAdvance2 = MachineOnboardParameters.PositiveTextFieldDouble(this.kNF, "The value of the empirically fit Jetty-Kubicek-Newman Advance parameter K2, which helps during the deceleration phase of moves to reduce built up pressure in the extruder nozzle.  Typical values for this parameter range from around 0.001 to 0.1.  Set to a value of 0 to disable use of this compensation.");
            this.extruderDeprimeA = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The number of steps to retract the right extruder's filament when the pipeline of buffered moves empties, the bot is paused, or \"deprime on travel\" is enabled and a travel move is detected.  Set to a value of 0 to disable this feature for this extruder.  Do not use with Skeinforge's Reversal plugin nor Skeinforge's Dimension plugin's \"Retraction Distance\".");
            this.extruderDeprimeB = MachineOnboardParameters.PositiveTextFieldInt(this.repNF, 10000, "The number of steps to retract the right extruder's filament when the pipeline of buffered moves empties, the bot is paused, or \"deprime on travel\" is enabled and a travel move is detected.  Set to a value of 0 to disable this feature for this extruder.  Do not use with Skeinforge's Reversal plugin nor Skeinforge's Dimension plugin's \"Retraction Distance\".");
            this.slowdownFlagBox = new JCheckBox();
            this.slowdownFlagBox.setToolTipText(MachineOnboardParameters.wrap2HTML(60, "If you are printing an object with fine details or at very fast speeds, it is possible that the planner will be unable to keep up with printing.  This may be evidenced by frequent pauses accompanied by unwanted plastic blobs or zits.  You may be able to mitigate this by enabling \"slowdown\".  When slowdown is enabled and the planner is having difficulty keeping up, the printing feed rate is reduced so as to cause each segment to take more time to print.  The reduction in printing speed then gives the planner a chance to catch up."));
            int dismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
            if (dismissDelay < 10000) {
                ToolTipManager.sharedInstance().setDismissDelay(10000);
            }
            this.draftButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    JettyMightyBoardMachineOnboardAccelerationParameters.this.setUIFields(JettyMightyBoardMachineOnboardAccelerationParameters.this.draftParams);
                }
            });
            this.qualityButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    JettyMightyBoardMachineOnboardAccelerationParameters.this.setUIFields(JettyMightyBoardMachineOnboardAccelerationParameters.this.qualityParams);
                }
            });
        }

        AccelParams getAccelParamsFromUI() {
            return new AccelParams(new AccelParamsTab1(this.accelerationBox.isSelected(), new int[]{((Number)this.normalMoveAcceleration.getValue()).intValue(), ((Number)this.extruderMoveAcceleration.getValue()).intValue()}, new int[]{((Number)this.xAxisMaxAcceleration.getValue()).intValue(), ((Number)this.yAxisMaxAcceleration.getValue()).intValue(), ((Number)this.zAxisMaxAcceleration.getValue()).intValue(), ((Number)this.aAxisMaxAcceleration.getValue()).intValue(), ((Number)this.bAxisMaxAcceleration.getValue()).intValue()}, new int[]{((Number)this.xAxisMaxSpeedChange.getValue()).intValue(), ((Number)this.yAxisMaxSpeedChange.getValue()).intValue(), ((Number)this.zAxisMaxSpeedChange.getValue()).intValue(), ((Number)this.aAxisMaxSpeedChange.getValue()).intValue(), ((Number)this.bAxisMaxSpeedChange.getValue()).intValue()}), new AccelParamsTab2(this.slowdownFlagBox.isSelected(), new int[]{((Number)this.extruderDeprimeA.getValue()).intValue(), ((Number)this.extruderDeprimeB.getValue()).intValue()}, new double[]{((Number)this.JKNAdvance1.getValue()).doubleValue(), ((Number)this.JKNAdvance2.getValue()).doubleValue()}));
        }

        public boolean isAccelerationEnabled() {
            return this.accelerationBox.isSelected();
        }

        private void setEEPROMFromUI(AccelParams params) {
            this.target.setAccelerationStatus(params.tab1.accelerationEnabled ? (byte)1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_SLOWDOWN_FLAG, params.tab2.slowdownEnabled ? 1 : 0);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_EXTRUDER_NORM, params.tab1.accelerations[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_EXTRUDER_RETRACT, params.tab1.accelerations[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_X, params.tab1.maxAccelerations[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Y, params.tab1.maxAccelerations[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Z, params.tab1.maxAccelerations[2]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_A, params.tab1.maxAccelerations[3]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_B, params.tab1.maxAccelerations[4]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_X, params.tab1.maxSpeedChanges[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Y, params.tab1.maxSpeedChanges[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Z, params.tab1.maxSpeedChanges[2]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_A, params.tab1.maxSpeedChanges[3]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_B, params.tab1.maxSpeedChanges[4]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K, params.tab2.JKNadvance[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K2, params.tab2.JKNadvance[1]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_A, params.tab2.deprime[0]);
            this.target.setEEPROMParam(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_B, params.tab2.deprime[1]);
        }

        public void setEEPROMFromUI() {
            this.setEEPROMFromUI(this.getAccelParamsFromUI());
        }

        private void setUIFields(AccelParamsTab1 params) {
            this.setUIFields(1, params.accelerationEnabled, false, params.accelerations, params.maxAccelerations, params.maxSpeedChanges, null, null);
        }

        private void setUIFields(int tabs, boolean accelerationEnabled, boolean slowdownEnabled, int[] accelerations, int[] maxAccelerations, int[] maxSpeedChanges, double[] JKNadvance, int[] deprime) {
            if ((tabs & 1) != 0) {
                this.accelerationBox.setSelected(accelerationEnabled);
                if (accelerations != null) {
                    this.normalMoveAcceleration.setValue(accelerations[0]);
                    this.extruderMoveAcceleration.setValue(accelerations[1]);
                }
                if (maxAccelerations != null) {
                    this.xAxisMaxAcceleration.setValue(maxAccelerations[0]);
                    this.yAxisMaxAcceleration.setValue(maxAccelerations[1]);
                    this.zAxisMaxAcceleration.setValue(maxAccelerations[2]);
                    this.aAxisMaxAcceleration.setValue(maxAccelerations[3]);
                    this.bAxisMaxAcceleration.setValue(maxAccelerations[4]);
                }
                if (maxSpeedChanges != null) {
                    this.xAxisMaxSpeedChange.setValue(maxSpeedChanges[0]);
                    this.yAxisMaxSpeedChange.setValue(maxSpeedChanges[1]);
                    this.zAxisMaxSpeedChange.setValue(maxSpeedChanges[2]);
                    this.aAxisMaxSpeedChange.setValue(maxSpeedChanges[3]);
                    this.bAxisMaxSpeedChange.setValue(maxSpeedChanges[4]);
                }
            }
            if ((tabs & 2) != 0) {
                this.slowdownFlagBox.setSelected(slowdownEnabled);
                if (JKNadvance != null) {
                    this.JKNAdvance1.setValue(JKNadvance[0]);
                    this.JKNAdvance2.setValue(JKNadvance[1]);
                }
                if (deprime != null) {
                    this.extruderDeprimeA.setValue(deprime[0]);
                    this.extruderDeprimeB.setValue(deprime[1]);
                }
            }
        }

        public void setUIFromEEPROM() {
            boolean accelerationEnabled = this.target.getAccelerationStatus() != 0;
            boolean slowdownEnabled = this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_SLOWDOWN_FLAG) != 0;
            int[] maxAccelerations = new int[]{this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_X), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Y), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_Z), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_A), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_ACCELERATION_B)};
            int[] maxSpeedChanges = new int[]{this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_X), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Y), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_Z), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_A), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_SPEED_CHANGE_B)};
            int[] accelerations = new int[]{this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_EXTRUDER_NORM), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_MAX_EXTRUDER_RETRACT)};
            double[] JKNadvance = new double[]{this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K), this.target.getEEPROMParamFloat(OnboardParameters.EEPROMParams.ACCEL_ADVANCE_K2)};
            int[] deprime = new int[]{this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_A), this.target.getEEPROMParamInt(OnboardParameters.EEPROMParams.ACCEL_EXTRUDER_DEPRIME_B)};
            this.setUIFields(3, accelerationEnabled, slowdownEnabled, accelerations, maxAccelerations, maxSpeedChanges, JKNadvance, deprime);
        }

        public void buildUI() {
            JPanel accelerationTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l][r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Acceleration", accelerationTab);
            JPanel accelerationMiscTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Acceleration (Misc)", accelerationMiscTab);
            this.normalMoveAcceleration.setColumns(8);
            this.extruderMoveAcceleration.setColumns(8);
            this.xAxisMaxAcceleration.setColumns(8);
            this.xAxisMaxSpeedChange.setColumns(4);
            this.yAxisMaxAcceleration.setColumns(8);
            this.yAxisMaxSpeedChange.setColumns(4);
            this.zAxisMaxAcceleration.setColumns(8);
            this.zAxisMaxSpeedChange.setColumns(4);
            this.aAxisMaxAcceleration.setColumns(8);
            this.aAxisMaxSpeedChange.setColumns(4);
            this.bAxisMaxAcceleration.setColumns(8);
            this.bAxisMaxSpeedChange.setColumns(4);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Acceleration enabled", this.accelerationBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Max acceleration (magnitude of acceleration vector; mm/s\u00b2)", "span 2, gapleft push", this.normalMoveAcceleration, "wrap, gapright push ");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Max acceleration for extruder-only moves (mm/s\u00b2)", "span 2, gapleft push", this.extruderMoveAcceleration, "wrap, gapright push");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "X max acceleration (mm/s\u00b2)", this.xAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "X max speed change (mm/s)", this.xAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Y max acceleration (mm/s\u00b2)", this.yAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Y max speed change (mm/s)", this.yAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Z max acceleration (mm/s\u00b2)", this.zAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Z max speed change (mm/s)", this.zAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Right extruder max acceleration (mm/s\u00b2)", this.aAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Right extruder max speed change (mm/s)", this.aAxisMaxSpeedChange, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Left extruder acceleration (mm/s\u00b2)", this.bAxisMaxAcceleration);
            MachineOnboardParameters.addWithSharedToolTips(accelerationTab, "Left extruder max speed change (mm/s)", this.bAxisMaxSpeedChange, "wrap");
            accelerationTab.add((Component)this.qualityButton, "span 2, gapleft push");
            accelerationTab.add((Component)this.draftButton, "span 2, gapright push");
            this.JKNAdvance1.setColumns(8);
            this.JKNAdvance2.setColumns(8);
            this.extruderDeprimeA.setColumns(8);
            this.extruderDeprimeB.setColumns(8);
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Slow printing when acceleration planing falls behind", this.slowdownFlagBox, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "JKN Advance K", this.JKNAdvance1, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "JKN Advance K2", this.JKNAdvance2, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Right extruder deprime (steps)", this.extruderDeprimeA, "wrap");
            MachineOnboardParameters.addWithSharedToolTips(accelerationMiscTab, "Left extruder deprime (steps)", this.extruderDeprimeB, "wrap");
        }

        private class AccelParams {
            public AccelParamsTab1 tab1;
            public AccelParamsTab2 tab2;

            AccelParams(AccelParamsTab1 params1, AccelParamsTab2 params2) {
                this.tab1 = params1;
                this.tab2 = params2;
            }
        }

        class AccelParamsTab2 {
            boolean slowdownEnabled;
            int[] deprime;
            double[] JKNadvance;

            AccelParamsTab2(boolean slowdownEnabled, int[] deprime, double[] JKNadvance) {
                this.slowdownEnabled = slowdownEnabled;
                this.deprime = deprime;
                this.JKNadvance = JKNadvance;
            }
        }

        class AccelParamsTab1 {
            boolean accelerationEnabled;
            int[] accelerations;
            int[] maxAccelerations;
            int[] maxSpeedChanges;

            AccelParamsTab1(boolean accelerationEnabled, int[] accelerations, int[] maxAccelerations, int[] maxSpeedChanges) {
                this.accelerationEnabled = accelerationEnabled;
                this.accelerations = accelerations;
                this.maxAccelerations = maxAccelerations;
                this.maxSpeedChanges = maxSpeedChanges;
            }

            boolean isEqual(AccelParamsTab1 params) {
                if (this == params) {
                    return true;
                }
                return this.accelerationEnabled == params.accelerationEnabled && Arrays.equals(this.accelerations, params.accelerations) && Arrays.equals(this.maxAccelerations, params.maxAccelerations) && Arrays.equals(this.maxSpeedChanges, params.maxSpeedChanges);
            }
        }
    }

    private class MightyBoardMachineOnboardAccelerationParameters
    extends MachineOnboardAccelerationParameters {
        private JCheckBox accelerationBox;
        private JFormattedTextField masterAcceleration;
        private JFormattedTextField xAxisAcceleration;
        private JFormattedTextField yAxisAcceleration;
        private JFormattedTextField zAxisAcceleration;
        private JFormattedTextField aAxisAcceleration;
        private JFormattedTextField bAxisAcceleration;
        private JFormattedTextField xyJunctionJerk;
        private JFormattedTextField zJunctionJerk;
        private JFormattedTextField aJunctionJerk;
        private JFormattedTextField bJunctionJerk;
        private JFormattedTextField minimumSpeed;

        public MightyBoardMachineOnboardAccelerationParameters(OnboardParameters target, Driver driver, JTabbedPane subtabs) {
            super(target, driver, subtabs);
            this.accelerationBox = new JCheckBox();
            this.masterAcceleration = new JFormattedTextField(MachineOnboardParameters.this.threePlaces);
            this.xAxisAcceleration = new JFormattedTextField(MachineOnboardParameters.this.threePlaces);
            this.yAxisAcceleration = new JFormattedTextField(MachineOnboardParameters.this.threePlaces);
            this.zAxisAcceleration = new JFormattedTextField(MachineOnboardParameters.this.threePlaces);
            this.aAxisAcceleration = new JFormattedTextField(MachineOnboardParameters.this.threePlaces);
            this.bAxisAcceleration = new JFormattedTextField(MachineOnboardParameters.this.threePlaces);
            this.xyJunctionJerk = new JFormattedTextField(MachineOnboardParameters.this.threePlaces);
            this.zJunctionJerk = new JFormattedTextField(MachineOnboardParameters.this.threePlaces);
            this.aJunctionJerk = new JFormattedTextField(MachineOnboardParameters.this.threePlaces);
            this.bJunctionJerk = new JFormattedTextField(MachineOnboardParameters.this.threePlaces);
            this.minimumSpeed = new JFormattedTextField(MachineOnboardParameters.this.threePlaces);
        }

        public boolean isAccelerationEnabled() {
            return this.accelerationBox.isSelected();
        }

        public void buildUI() {
            JPanel accelerationTab = new JPanel((LayoutManager)new MigLayout("fill", "[r][l][r][l]"));
            MachineOnboardParameters.this.subTabs.addTab("Acceleration", accelerationTab);
            this.masterAcceleration.setColumns(4);
            this.xAxisAcceleration.setColumns(8);
            this.xyJunctionJerk.setColumns(4);
            this.yAxisAcceleration.setColumns(8);
            this.zAxisAcceleration.setColumns(8);
            this.zJunctionJerk.setColumns(4);
            this.aAxisAcceleration.setColumns(8);
            this.aJunctionJerk.setColumns(4);
            this.bAxisAcceleration.setColumns(8);
            this.bJunctionJerk.setColumns(4);
            accelerationTab.add(new JLabel("Acceleration On"));
            accelerationTab.add((Component)this.accelerationBox, "span 2, wrap");
            accelerationTab.add(new JLabel("Master acceleration rate (mm/s/s)"));
            accelerationTab.add((Component)this.masterAcceleration, "span 2, wrap");
            accelerationTab.add(new JLabel("X acceleration rate (mm/s/s)"));
            accelerationTab.add(this.xAxisAcceleration);
            accelerationTab.add(new JLabel("X/Y max junction jerk (mm/s)"));
            accelerationTab.add((Component)this.xyJunctionJerk, "wrap");
            accelerationTab.add(new JLabel("Y acceleration rate (mm/s/s)"));
            accelerationTab.add((Component)this.yAxisAcceleration, "span 2, wrap");
            accelerationTab.add(new JLabel("Z acceleration rate (mm/s/s)"));
            accelerationTab.add(this.zAxisAcceleration);
            accelerationTab.add(new JLabel("Z maximum junction jerk (mm/s)"));
            accelerationTab.add((Component)this.zJunctionJerk, "wrap");
            accelerationTab.add(new JLabel("A acceleration rate (mm/s/s)"));
            accelerationTab.add(this.aAxisAcceleration);
            accelerationTab.add(new JLabel("A maximum junction jerk (mm/s)"));
            accelerationTab.add((Component)this.aJunctionJerk, "wrap");
            accelerationTab.add(new JLabel("B acceleration rate (mm/s/s)"));
            accelerationTab.add(this.bAxisAcceleration);
            accelerationTab.add(new JLabel("B maximum junction jerk (mm/s)"));
            accelerationTab.add((Component)this.bJunctionJerk, "wrap");
            accelerationTab.add(new JLabel("Minimum Print Speed (mm/s)"));
            accelerationTab.add((Component)this.minimumSpeed, "wrap");
        }

        public void setEEPROMFromUI() {
            this.target.setAccelerationStatus(this.accelerationBox.isSelected() ? (byte)1 : 0);
            this.target.setAccelerationRate(((Number)this.masterAcceleration.getValue()).intValue());
            this.target.setAxisAccelerationRate(0, ((Number)this.xAxisAcceleration.getValue()).intValue());
            this.target.setAxisAccelerationRate(1, ((Number)this.yAxisAcceleration.getValue()).intValue());
            this.target.setAxisAccelerationRate(2, ((Number)this.zAxisAcceleration.getValue()).intValue());
            this.target.setAxisAccelerationRate(3, ((Number)this.aAxisAcceleration.getValue()).intValue());
            this.target.setAxisAccelerationRate(4, ((Number)this.bAxisAcceleration.getValue()).intValue());
            this.target.setAxisJerk(0, ((Number)this.xyJunctionJerk.getValue()).doubleValue());
            this.target.setAxisJerk(2, ((Number)this.zJunctionJerk.getValue()).doubleValue());
            this.target.setAxisJerk(3, ((Number)this.aJunctionJerk.getValue()).doubleValue());
            this.target.setAxisJerk(4, ((Number)this.bJunctionJerk.getValue()).doubleValue());
            this.target.setAccelerationMinimumSpeed(((Number)this.minimumSpeed.getValue()).intValue());
        }

        public void setUIFromEEPROM() {
            this.accelerationBox.setSelected(this.target.getAccelerationStatus() != 0);
            this.masterAcceleration.setValue(this.target.getAccelerationRate());
            this.xAxisAcceleration.setValue(this.target.getAxisAccelerationRate(0));
            this.yAxisAcceleration.setValue(this.target.getAxisAccelerationRate(1));
            this.zAxisAcceleration.setValue(this.target.getAxisAccelerationRate(2));
            this.aAxisAcceleration.setValue(this.target.getAxisAccelerationRate(3));
            this.bAxisAcceleration.setValue(this.target.getAxisAccelerationRate(4));
            this.xyJunctionJerk.setValue(this.target.getAxisJerk(0));
            this.zJunctionJerk.setValue(this.target.getAxisJerk(2));
            this.aJunctionJerk.setValue(this.target.getAxisJerk(3));
            this.bJunctionJerk.setValue(this.target.getAxisJerk(4));
            this.minimumSpeed.setValue(this.target.getAccelerationMinimumSpeed());
        }
    }

    private class MachineOnboardAccelerationParameters {
        protected final OnboardParameters target;
        protected final Driver driver;
        protected final JTabbedPane subtabs;

        public MachineOnboardAccelerationParameters(OnboardParameters target, Driver driver, JTabbedPane subtabs) {
            this.target = target;
            this.driver = driver;
            this.subtabs = subtabs;
        }

        public boolean isAccelerationEnabled() {
            return false;
        }

        public void buildUI() {
        }

        public void setUIFromEEPROM() {
        }

        public void setEEPROMFromUI() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DriverType {
        OTHER,
        MIGHTYBOARD,
        MIGHTYSAILFISH,
        SAILFISH;

    }
}

