/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.commands;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import replicatorg.app.Base;
import replicatorg.drivers.Driver;
import replicatorg.drivers.InteractiveDisplay;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.StopException;
import replicatorg.drivers.commands.DriverCommand;

public class SetBuildPercent
implements DriverCommand {
    int percentDone;
    String comment;
    String printName = "RepG Build";

    public SetBuildPercent(double codeValue, String comment) {
        this.percentDone = (int)codeValue;
        this.comment = comment;
        Matcher m = Pattern.compile("'.*'").matcher(comment);
        if (m.find()) {
            this.printName = m.group().substring(1, m.group().length() - 1);
        }
    }

    public void run(Driver driver) throws RetryException, StopException {
        if (driver instanceof InteractiveDisplay) {
            if (this.percentDone <= 0) {
                ((InteractiveDisplay)((Object)driver)).sendBuildStartNotification(this.printName, 0);
            }
            ((InteractiveDisplay)((Object)driver)).updateBuildPercent(this.percentDone);
            if (this.percentDone >= 100) {
                ((InteractiveDisplay)((Object)driver)).sendBuildEndNotification(0);
            }
        } else {
            Base.logger.severe("driver " + driver + "is not an instance of IntractiveDisplay");
        }
    }
}

