/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine;

import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.app.Base;
import replicatorg.app.tools.XML;
import replicatorg.drivers.Driver;
import replicatorg.drivers.DriverError;
import replicatorg.drivers.DriverFactory;
import replicatorg.drivers.OnboardParameters;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.SDCardCapture;
import replicatorg.drivers.SimulationDriver;
import replicatorg.drivers.StopException;
import replicatorg.drivers.UsesSerial;
import replicatorg.drivers.commands.AssessState;
import replicatorg.drivers.commands.ReadTemperature;
import replicatorg.machine.Machine;
import replicatorg.machine.MachineCommand;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.builder.Direct;
import replicatorg.machine.builder.MachineBuilder;
import replicatorg.machine.builder.ToLocalFile;
import replicatorg.machine.builder.ToRemoteFile;
import replicatorg.machine.builder.UsingRemoteFile;
import replicatorg.machine.model.MachineModel;
import replicatorg.machine.model.ToolModel;
import replicatorg.model.GCodeSource;
import replicatorg.model.GCodeSourceCollection;
import replicatorg.model.StringListSource;

class MachineThread
extends Thread {
    AssessStatusThread statusThread;
    private MachineTimer pollingTimer;
    ConcurrentLinkedQueue<MachineCommand> pendingQueue;
    private Node machineNode;
    private Machine controller;
    private Vector<String> warmupCommands;
    private Vector<String> cooldownCommands;
    private String name;
    private double estimatedBuildTime = 0.0;
    private double startTimeMillis = -1.0;
    private Driver driver = null;
    private SimulationDriver simulator;
    private MachineState state = new MachineState(MachineState.State.NOT_ATTACHED);
    MachineModel cachedModel = null;
    private MachineBuilder machineBuilder;

    public MachineThread(Machine controller, Node machineNode) {
        super("Machine Thread");
        this.pollingTimer = new MachineTimer();
        this.pollingTimer.start(1000L);
        this.pendingQueue = new ConcurrentLinkedQueue();
        this.machineNode = machineNode;
        this.controller = controller;
        this.loadDriver();
        this.loadExtraPrefs();
        this.parseName();
        this.statusThread = new AssessStatusThread(this);
        this.statusThread.start();
    }

    private void loadExtraPrefs() {
        int i;
        String[] commands = null;
        String command = null;
        this.warmupCommands = new Vector();
        if (XML.hasChildNode(this.machineNode, "warmup")) {
            String warmup = XML.getChildNodeValue(this.machineNode, "warmup");
            commands = warmup.split("\n");
            for (i = 0; i < commands.length; ++i) {
                command = commands[i].trim();
                this.warmupCommands.add(new String(command));
            }
        }
        this.cooldownCommands = new Vector();
        if (XML.hasChildNode(this.machineNode, "cooldown")) {
            String cooldown = XML.getChildNodeValue(this.machineNode, "cooldown");
            commands = cooldown.split("\n");
            for (i = 0; i < commands.length; ++i) {
                command = commands[i].trim();
                this.cooldownCommands.add(new String(command));
            }
        }
    }

    GCodeSource buildGCodeJob(GCodeSource source) {
        Vector<GCodeSource> sources = new Vector<GCodeSource>();
        sources.add(new StringListSource(this.warmupCommands));
        sources.add(source);
        sources.add(new StringListSource(this.cooldownCommands));
        return new GCodeSourceCollection(sources);
    }

    private String readyMessage() {
        return "Machine " + this.getMachineName() + " ready";
    }

    private String notConnectedMessage() {
        return "Not Connected";
    }

    private String buildingMessage() {
        return "Building...";
    }

    void runCommand(MachineCommand command) {
        switch (command.type) {
            case CONNECT: {
                if (this.state.getState() != MachineState.State.NOT_ATTACHED) break;
                this.setState(new MachineState(MachineState.State.CONNECTING), "Connecting to " + this.getMachineName() + " on " + command.remoteName);
                boolean connected = false;
                if (this.driver instanceof UsesSerial) {
                    UsesSerial us = (UsesSerial)((Object)this.driver);
                    String targetPort = command.remoteName;
                    if (us.isExplicit()) {
                        targetPort = us.getPortName();
                    }
                    us.openSerial(targetPort);
                    connected = us.isConnected();
                } else {
                    if (!this.driver.isInitialized()) {
                        this.driver.initialize();
                    }
                    connected = this.driver.isInitialized();
                }
                if (!connected) {
                    String errorMessage = null;
                    if (this.driver.hasError()) {
                        errorMessage = this.driver.getError().getMessage();
                    }
                    this.setState(new MachineState(MachineState.State.NOT_ATTACHED), errorMessage);
                    break;
                }
                this.driver.initialize();
                if (this.driver.isInitialized()) {
                    this.readName();
                    this.setState(new MachineState(MachineState.State.READY), this.readyMessage());
                    break;
                }
                this.setState(new MachineState(MachineState.State.NOT_ATTACHED));
                break;
            }
            case DISCONNECT: {
                if (this.state.isConnected()) {
                    this.driver.uninitialize();
                    this.setState(new MachineState(MachineState.State.NOT_ATTACHED), this.notConnectedMessage());
                    if (!(this.driver instanceof UsesSerial)) break;
                    UsesSerial us = (UsesSerial)((Object)this.driver);
                    us.closeSerial();
                    break;
                }
                this.controller.emitStateChange(new MachineState(MachineState.State.NOT_ATTACHED), "Not Connected");
                break;
            }
            case RESET: {
                if (!this.state.isConnected()) break;
                this.driver.reset();
                this.readName();
                this.setState(new MachineState(MachineState.State.READY), this.readyMessage());
                break;
            }
            case BUILD_DIRECT: {
                if (!this.state.canPrint()) break;
                this.startTimeMillis = System.currentTimeMillis();
                if (!this.isSimulating()) {
                    this.driver.getCurrentPosition(false);
                }
                GCodeSource combinedSource = this.buildGCodeJob(command.source);
                this.machineBuilder = new Direct(this.driver, this.simulator, combinedSource);
                this.driver.invalidatePosition();
                this.setState(new MachineState(MachineState.State.BUILDING), this.buildingMessage());
                break;
            }
            case SIMULATE: {
                break;
            }
            case BUILD_TO_REMOTE_FILE: {
                if (!this.state.canPrint() || !(this.driver instanceof SDCardCapture)) break;
                this.startTimeMillis = System.currentTimeMillis();
                GCodeSource combinedSource = this.buildGCodeJob(command.source);
                ToRemoteFile trf = new ToRemoteFile(this.driver, this.simulator, combinedSource, command.remoteName);
                if (trf.setupFailed) {
                    this.setState(new MachineState(MachineState.State.NOT_ATTACHED));
                    this.setState(new MachineState(MachineState.State.READY));
                    break;
                }
                this.machineBuilder = trf;
                this.driver.invalidatePosition();
                this.setState(new MachineState(MachineState.State.BUILDING));
                break;
            }
            case BUILD_TO_FILE: {
                if (!this.state.canPrint() && this.state.getState() != MachineState.State.NOT_ATTACHED || !(this.driver instanceof SDCardCapture)) break;
                this.startTimeMillis = System.currentTimeMillis();
                GCodeSource combinedSource = this.buildGCodeJob(command.source);
                ToLocalFile lf = new ToLocalFile(this.driver, this.simulator, combinedSource, command.remoteName);
                if (lf.setupFailed) {
                    boolean connected = this.state.canPrint();
                    this.setState(new MachineState(MachineState.State.ERROR));
                    this.setState(new MachineState(MachineState.State.NOT_ATTACHED));
                    if (!connected) break;
                    this.setState(new MachineState(MachineState.State.READY));
                    break;
                }
                this.machineBuilder = lf;
                if (this.state.canPrint()) {
                    this.setState(new MachineState(MachineState.State.BUILDING), this.buildingMessage());
                    break;
                }
                this.setState(new MachineState(MachineState.State.BUILDING_OFFLINE), this.buildingMessage());
                break;
            }
            case BUILD_REMOTE: {
                if (!this.state.canPrint() || !(this.driver instanceof SDCardCapture)) break;
                this.startTimeMillis = System.currentTimeMillis();
                this.machineBuilder = new UsingRemoteFile(this.driver, command.remoteName);
                this.driver.invalidatePosition();
                this.setState(new MachineState(MachineState.State.BUILDING), this.buildingMessage());
                break;
            }
            case PAUSE: {
                if (this.state.getState() != MachineState.State.BUILDING) break;
                this.setState(new MachineState(MachineState.State.PAUSED), "Build paused");
                break;
            }
            case UNPAUSE: {
                if (this.state.getState() != MachineState.State.PAUSED) break;
                this.setState(new MachineState(MachineState.State.BUILDING), this.buildingMessage());
                break;
            }
            case STOP_MOTION: {
                this.driver.stop(false);
                if (this.state.getState() == MachineState.State.BUILDING) {
                    this.setState(new MachineState(MachineState.State.READY), this.readyMessage());
                    break;
                }
                if (this.state.getState() != MachineState.State.BUILDING_OFFLINE) break;
                this.setState(new MachineState(MachineState.State.NOT_ATTACHED), this.notConnectedMessage());
                break;
            }
            case STOP_ALL: {
                this.driver.stop(true);
                if (this.state.getState() == MachineState.State.BUILDING) {
                    this.setState(new MachineState(MachineState.State.READY), this.readyMessage());
                    break;
                }
                if (this.state.getState() != MachineState.State.BUILDING_OFFLINE) break;
                this.setState(new MachineState(MachineState.State.NOT_ATTACHED), this.notConnectedMessage());
                break;
            }
            case RUN_COMMAND: {
                if (!this.state.isConnected()) break;
                boolean completed = false;
                while (!completed) {
                    try {
                        command.command.run(this.driver);
                        completed = true;
                    }
                    catch (RetryException e) {
                    }
                    catch (StopException stopException) {}
                }
                break;
            }
            case SHUTDOWN: {
                this.setState(new MachineState(MachineState.State.NOT_ATTACHED), this.notConnectedMessage());
                this.interrupt();
                break;
            }
            default: {
                Base.logger.severe("Ignored command: " + command.type.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do {
            Object progress;
            if (this.driver.hasError()) {
                DriverError error = this.driver.getError();
                if (this.state.isConnected() && error.getDisconnected()) {
                    this.setState(new MachineState(MachineState.State.NOT_ATTACHED), error.getMessage());
                } else {
                    this.setState(new MachineState(MachineState.State.ERROR), error.getMessage());
                }
            }
            while (!this.pendingQueue.isEmpty()) {
                this.runCommand((MachineCommand)this.pendingQueue.remove());
            }
            if (this.state.isConnected() && this.pollingTimer.elapsed()) {
                boolean checkTempDuringBuild = Base.preferences.getBoolean("build.monitor_temp", true);
                if (!this.state.isBuilding() || checkTempDuringBuild) {
                    MachineCommand pollCmd = new MachineCommand(Machine.RequestType.RUN_COMMAND, new ReadTemperature());
                    this.scheduleRequest(pollCmd);
                    Vector<ToolModel> tools = this.controller.getModel().getTools();
                    for (ToolModel t : tools) {
                        this.controller.emitToolStatus(t);
                    }
                }
            }
            if (this.state.isBuilding() && !this.state.isPaused()) {
                this.machineBuilder.runNext();
                progress = new MachineProgressEvent((double)System.currentTimeMillis() - this.startTimeMillis, this.estimatedBuildTime, this.machineBuilder.getLinesProcessed(), this.machineBuilder.getLinesTotal());
                this.controller.emitProgress((MachineProgressEvent)progress);
                if (this.machineBuilder.finished()) {
                    if (this.state.getState() == MachineState.State.BUILDING) {
                        this.setState(new MachineState(MachineState.State.READY), this.readyMessage());
                    } else {
                        this.setState(new MachineState(MachineState.State.NOT_ATTACHED), this.notConnectedMessage());
                    }
                }
            }
            if (this.state.isBuilding()) continue;
            try {
                progress = this;
                synchronized (progress) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                break;
            }
        } while (!Thread.interrupted());
        Base.logger.fine("MachineThread interrupted, terminating.");
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleRequest(MachineCommand request) {
        this.pendingQueue.add(request);
        MachineThread machineThread = this;
        synchronized (machineThread) {
            this.notify();
        }
        return true;
    }

    public boolean isReadyToPrint() {
        return this.state.canPrint();
    }

    public boolean isSimulating() {
        return false;
    }

    public boolean isInteractiveTarget() {
        if (this.machineBuilder != null) {
            return this.machineBuilder.isInteractive();
        }
        return false;
    }

    public Machine.JobTarget getTarget() {
        if (this.machineBuilder != null) {
            return this.machineBuilder.getTarget();
        }
        return Machine.JobTarget.NONE;
    }

    public int getLinesProcessed() {
        if (this.machineBuilder != null) {
            return this.machineBuilder.getLinesProcessed();
        }
        return -1;
    }

    public MachineState getMachineState() {
        return this.state.clone();
    }

    private void setState(MachineState state) {
        this.setState(state, null);
    }

    private void setState(MachineState state, String message) {
        MachineState oldState = this.state;
        this.state = state;
        if (!oldState.equals(state)) {
            this.controller.emitStateChange(state, message);
        }
    }

    public Driver getDriver() {
        return this.driver;
    }

    public SimulationDriver getSimulator() {
        return this.simulator;
    }

    public boolean isConnected() {
        return this.driver != null && this.driver.isInitialized();
    }

    public void loadDriver() {
        if (Base.preferences.getBoolean("machinecontroller.simulator", true)) {
            Base.logger.info("Loading simulator.");
            this.simulator = new SimulationDriver();
            this.simulator.setMachine(this.loadModel());
        }
        Node driverXml = null;
        NodeList kids = this.machineNode.getChildNodes();
        for (int j = 0; j < kids.getLength(); ++j) {
            Node kid = kids.item(j);
            if (!kid.getNodeName().equals("driver")) continue;
            driverXml = kid;
        }
        this.driver = DriverFactory.factory(driverXml);
        this.driver.setMachine(this.getModel());
    }

    private void dispose() {
        if (this.driver != null) {
            this.driver.dispose();
        }
        if (this.simulator != null) {
            this.simulator.dispose();
        }
        if (this.statusThread != null) {
            try {
                this.statusThread.interrupt();
                this.statusThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setState(new MachineState(MachineState.State.NOT_ATTACHED));
    }

    public void readName() {
        if (this.driver instanceof OnboardParameters) {
            String n = ((OnboardParameters)((Object)this.driver)).getMachineName();
            if (n != null && n.length() > 0) {
                this.name = n;
            } else {
                Base.logger.fine("No name on the machine. Using the XML name of the machine");
                this.parseName();
            }
        }
    }

    private void parseName() {
        NodeList kids = this.machineNode.getChildNodes();
        for (int j = 0; j < kids.getLength(); ++j) {
            Node kid = kids.item(j);
            if (!kid.getNodeName().equals("name")) continue;
            this.name = kid.getFirstChild().getNodeValue().trim();
            return;
        }
        this.name = "Unknown";
    }

    private MachineModel loadModel() {
        MachineModel model = new MachineModel();
        model.loadXML(this.machineNode);
        return model;
    }

    public MachineModel getModel() {
        if (this.cachedModel == null) {
            this.cachedModel = this.loadModel();
        }
        return this.cachedModel;
    }

    public void setEstimatedBuildTime(double estimatedBuildTime) {
        this.estimatedBuildTime = estimatedBuildTime;
    }

    public String getMachineName() {
        return this.name;
    }

    class MachineTimer {
        private long lastEventTime = 0L;
        private boolean enabled = false;
        private long intervalMs = 3000L;

        MachineTimer() {
        }

        public void start(long interval) {
            this.enabled = true;
            this.intervalMs = interval;
            this.lastEventTime = System.currentTimeMillis();
        }

        public void stop() {
            this.enabled = false;
        }

        public boolean elapsed() {
            if (!this.enabled) {
                return false;
            }
            long curMillis = System.currentTimeMillis();
            if (this.lastEventTime + this.intervalMs <= curMillis) {
                this.lastEventTime = curMillis;
                return true;
            }
            return false;
        }
    }

    class AssessStatusThread
    extends Thread {
        MachineThread machineThread;

        public AssessStatusThread(MachineThread machineThread2) {
            super("Assess Status");
            this.machineThread = machineThread2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    AssessStatusThread assessStatusThread = this;
                    synchronized (assessStatusThread) {
                        AssessState assessCommand = new AssessState();
                        this.machineThread.scheduleRequest(new MachineCommand(Machine.RequestType.RUN_COMMAND, assessCommand));
                        AssessStatusThread.sleep(1000L);
                    }
                }
            }
            catch (InterruptedException e) {
                Base.logger.fine("taking assess status thread down");
                return;
            }
        }
    }
}

