/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;
import replicatorg.app.Base;
import replicatorg.app.ui.CallbackTextField;
import replicatorg.drivers.commands.Delay;
import replicatorg.drivers.commands.DisableFan;
import replicatorg.drivers.commands.DisableMotor;
import replicatorg.drivers.commands.DriverCommand;
import replicatorg.drivers.commands.EnableExtruderMotor;
import replicatorg.drivers.commands.EnableFan;
import replicatorg.drivers.commands.SelectTool;
import replicatorg.drivers.commands.SetMotorDirection;
import replicatorg.drivers.commands.SetMotorSpeedPWM;
import replicatorg.drivers.commands.SetMotorSpeedRPM;
import replicatorg.drivers.commands.SetPlatformTemperature;
import replicatorg.drivers.commands.SetTemperature;
import replicatorg.drivers.commands.ToggleAutomatedBuildPlatform;
import replicatorg.machine.MachineInterface;
import replicatorg.machine.model.ToolModel;

public class ExtruderPanel
extends JPanel {
    private final MachineInterface machine;
    private final ToolModel tool0;
    private final ToolModel tool1;
    private JFormattedTextField t0CurrentTemperatureField;
    private JFormattedTextField t1CurrentTemperatureField;
    private JFormattedTextField pCurrentTemperatureField;
    private JFormattedTextField t0TargetTemperatureField;
    private JFormattedTextField t1TargetTemperatureField;
    private JFormattedTextField pTargetTemperatureField;
    private double t0TargetTemperature;
    private double t1TargetTemperature;
    private double pTargetTemperature;
    private static final Color t0TargetColor = Color.MAGENTA;
    private static final Color t0MeasuredColor = Color.RED;
    private static final Color t1TargetColor = Color.CYAN;
    private static final Color t1MeasuredColor = Color.BLUE;
    private static final Color pTargetColor = Color.YELLOW;
    private static final Color pMeasuredColor = Color.GREEN;
    long startMillis = System.currentTimeMillis();
    private TimeTableXYDataset t0MeasuredDataset = new TimeTableXYDataset();
    private TimeTableXYDataset t0TargetDataset = new TimeTableXYDataset();
    private TimeTableXYDataset t1MeasuredDataset = new TimeTableXYDataset();
    private TimeTableXYDataset t1TargetDataset = new TimeTableXYDataset();
    private TimeTableXYDataset pMeasuredDataset = new TimeTableXYDataset();
    private TimeTableXYDataset pTargetDataset = new TimeTableXYDataset();
    protected Pattern extrudeTimePattern;
    protected String[] extrudeTimeStrings = new String[]{"1s", "2s", "5s", "10s", "30s", "60s", "300s"};
    protected boolean continuousJogMode = false;
    protected long extrudeTime;
    private final String EXTRUDE_TIME_PREF_NAME = "extruderpanel.extrudetime";
    private final Dimension labelMinimumSize = new Dimension(175, 25);

    private JLabel makeKeyLabel(String text, Color c) {
        BufferedImage image = new BufferedImage(10, 10, 1);
        Graphics g = image.getGraphics();
        g.setColor(c);
        g.fillRect(0, 0, 10, 10);
        ImageIcon icon = new ImageIcon(image);
        return new JLabel(text, icon, 2);
    }

    public ChartPanel makeChart() {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)this.t0MeasuredDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBorderVisible(false);
        chart.setBackgroundPaint(null);
        XYPlot plot = chart.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setLowerMargin(0.0);
        axis.setFixedAutoRange(180000.0);
        TickUnits unitSource = new TickUnits();
        unitSource.add((TickUnit)new NumberTickUnit(60000.0));
        unitSource.add((TickUnit)new NumberTickUnit(1000.0));
        axis.setStandardTickUnits((TickUnitSource)unitSource);
        axis.setTickLabelsVisible(false);
        axis = plot.getRangeAxis();
        axis.setRange(0.0, 300.0);
        XYStepRenderer renderer = new XYStepRenderer();
        plot.setDataset(1, (XYDataset)this.t0TargetDataset);
        plot.setRenderer(1, (XYItemRenderer)renderer);
        plot.getRenderer(1).setSeriesPaint(0, (Paint)t0TargetColor);
        plot.getRenderer(0).setSeriesPaint(0, (Paint)t0MeasuredColor);
        boolean hasPlatform = this.tool0.hasHeatedPlatform();
        if (this.machine.getModel().getTools().size() > 1) {
            plot.setDataset(4, (XYDataset)this.t1MeasuredDataset);
            plot.setRenderer(4, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            plot.getRenderer(4).setSeriesPaint(0, (Paint)t1MeasuredColor);
            plot.setDataset(5, (XYDataset)this.t1TargetDataset);
            plot.setRenderer(5, (XYItemRenderer)new XYStepRenderer());
            plot.getRenderer(5).setSeriesPaint(0, (Paint)t1TargetColor);
            if (!hasPlatform) {
                hasPlatform = this.tool1.hasHeatedPlatform();
            }
        }
        if (hasPlatform) {
            plot.setDataset(2, (XYDataset)this.pMeasuredDataset);
            plot.setRenderer(2, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            plot.getRenderer(2).setSeriesPaint(0, (Paint)pMeasuredColor);
            plot.setDataset(3, (XYDataset)this.pTargetDataset);
            plot.setRenderer(3, (XYItemRenderer)new XYStepRenderer());
            plot.getRenderer(3).setSeriesPaint(0, (Paint)pTargetColor);
        }
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(400, 160));
        chartPanel.setOpaque(false);
        return chartPanel;
    }

    private JLabel makeLabel(String text) {
        JLabel label = new JLabel();
        label.setText(text);
        label.setMinimumSize(this.labelMinimumSize);
        label.setMaximumSize(this.labelMinimumSize);
        label.setPreferredSize(this.labelMinimumSize);
        label.setHorizontalAlignment(2);
        return label;
    }

    private void setExtrudeTime(String mode) {
        if ("Continuous Jog".equals(mode)) {
            this.continuousJogMode = true;
            this.extrudeTime = 0L;
        } else {
            if (this.continuousJogMode) {
                this.machine.stopMotion();
            }
            this.continuousJogMode = false;
            Matcher jogMatcher = this.extrudeTimePattern.matcher(mode);
            if (jogMatcher.find()) {
                this.extrudeTime = Long.parseLong(jogMatcher.group(1));
            }
        }
        if (mode != null && mode.length() > 0) {
            Base.preferences.put("extruderpanel.extrudetime", mode);
        }
    }

    protected JPanel getMotorControls(final ToolModel tool) {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill"));
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ExtruderPanel.this.handleChangedItem(e, tool);
            }
        };
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExtruderPanel.this.handleMotorAction(e, tool);
            }
        };
        if (tool.hasMotor()) {
            AbstractButton motorForwardButton;
            AbstractButton motorStoppedButton;
            AbstractButton motorReverseButton;
            CallbackTextField field;
            JLabel label;
            if (tool.getMotorStepperAxisName() == "" && !tool.motorHasEncoder() && !tool.motorIsStepper()) {
                label = this.makeLabel("Motor Speed (PWM)");
                field = new CallbackTextField(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JFormattedTextField source = (JFormattedTextField)e.getSource();
                        if (source.getText().length() > 0) {
                            double newValue = ((Number)source.getValue()).doubleValue();
                            ExtruderPanel.this.machine.runCommand(new SetMotorSpeedPWM((int)newValue, tool.getIndex()));
                        }
                    }
                }, "handleTextField", "motor-speed-pwm", 5, Base.getLocalFormat());
                field.setValue(this.machine.getDriverQueryInterface().getMotorSpeedPWM());
                panel.add(label);
                panel.add((Component)field, "wrap");
            }
            if (tool.motorHasEncoder() || tool.motorIsStepper()) {
                label = this.makeLabel("Motor Speed (RPM)");
                field = new CallbackTextField(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JFormattedTextField source = (JFormattedTextField)e.getSource();
                        if (source.getText().length() > 0) {
                            double newValue = ((Number)source.getValue()).doubleValue();
                            ExtruderPanel.this.machine.runCommand(new SetMotorSpeedRPM(newValue, tool.getIndex()));
                        }
                    }
                }, "handleTextField", "motor-speed", 5, Base.getLocalFormat());
                field.setValue(tool.getMotorSpeedReadingRPM());
                panel.add((Component)label, "");
                panel.add((Component)field, "wrap");
                if (tool.getMotorStepperAxisName() != "") {
                    label = this.makeLabel("Extrude duration");
                    JComboBox<String> timeList = new JComboBox<String>(this.extrudeTimeStrings);
                    timeList.setSelectedItem(Base.preferences.get("extruderpanel.extrudetime", "5s"));
                    timeList.setActionCommand("Extrude-duration");
                    timeList.addActionListener(actionListener);
                    this.setExtrudeTime((String)timeList.getSelectedItem());
                    panel.add(label);
                    panel.add(timeList, "wrap");
                }
            }
            JLabel motorEnabledLabel = this.makeLabel("Motor Control");
            if (tool.motorHasEncoder() || tool.motorIsStepper() && tool.getMotorStepperAxisName() != "") {
                motorReverseButton = new JButton("reverse");
                motorReverseButton.setActionCommand("reverse");
                motorReverseButton.addActionListener(actionListener);
                motorStoppedButton = new JButton("stop");
                motorStoppedButton.setActionCommand("stop");
                motorStoppedButton.addActionListener(actionListener);
                motorForwardButton = new JButton("forward");
                motorForwardButton.setActionCommand("forward");
                motorForwardButton.addActionListener(actionListener);
                ButtonGroup motorControl = new ButtonGroup();
                motorControl.add(motorReverseButton);
                motorControl.add(motorStoppedButton);
                motorControl.add(motorForwardButton);
                panel.add((Component)motorEnabledLabel, "split,spanx");
                panel.add(motorReverseButton);
                panel.add(motorStoppedButton);
                panel.add((Component)motorForwardButton, "wrap");
            } else {
                motorReverseButton = new JRadioButton("reverse");
                motorReverseButton.setName("motor-reverse");
                motorReverseButton.setActionCommand("motor-reverse");
                motorReverseButton.addItemListener(itemListener);
                motorStoppedButton = new JRadioButton("stop");
                motorStoppedButton.setName("motor-stop");
                motorStoppedButton.setActionCommand("motor-stop");
                motorStoppedButton.addItemListener(itemListener);
                motorForwardButton = new JRadioButton("forward");
                motorForwardButton.setName("motor-forward");
                motorForwardButton.setActionCommand("motor-forward");
                motorForwardButton.addItemListener(itemListener);
                ButtonGroup motorControl = new ButtonGroup();
                motorControl.add(motorReverseButton);
                motorControl.add(motorStoppedButton);
                motorControl.add(motorForwardButton);
                panel.add((Component)motorEnabledLabel, "split,spanx");
                panel.add(motorReverseButton);
                panel.add(motorStoppedButton);
                panel.add((Component)motorForwardButton, "wrap");
            }
        }
        if (tool.hasAutomatedPlatform()) {
            String abpString = "Build platform belt";
            String enableString = "enable";
            JLabel abpLabel = this.makeLabel(abpString);
            JCheckBox abpCheck = new JCheckBox(enableString);
            abpCheck.setName("abp-check");
            abpCheck.addItemListener(itemListener);
            panel.add(abpLabel);
            panel.add((Component)abpCheck, "wrap");
        }
        return panel;
    }

    public ExtruderPanel(MachineInterface machine) {
        JLabel currentTempLabel;
        JLabel targetTempLabel;
        this.machine = machine;
        Vector<ToolModel> tools = machine.getModel().getTools();
        this.tool0 = tools.size() > 0 ? (ToolModel)tools.get(0) : null;
        this.tool1 = tools.size() > 1 ? (ToolModel)tools.get(1) : null;
        this.extrudeTimePattern = Pattern.compile("([.0-9]+)");
        ActionListener temperatureListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExtruderPanel.this.handleChangedTextField((JFormattedTextField)e.getSource());
            }
        };
        this.setLayout((LayoutManager)new MigLayout("fill"));
        if (tools.size() == 1) {
            JPanel motorControl = this.getMotorControls(this.tool0);
            motorControl.setBorder(BorderFactory.createTitledBorder("Extruder Motor Control"));
            this.add((Component)motorControl, "aligny top, spanx, growx, wrap");
        } else if (tools.size() > 1) {
            JTabbedPane motorTabs = new JTabbedPane();
            String tool0Name = this.tool0.getName() + " Plastic Extruder";
            String tool1Name = this.tool1.getName() + " Plastic Extruder";
            if (this.tool0.getIndex() == 0) {
                motorTabs.addTab(tool1Name, this.getMotorControls(this.tool1));
                motorTabs.addTab(tool0Name, this.getMotorControls(this.tool0));
            } else if (this.tool0.getIndex() == 1) {
                motorTabs.addTab(tool0Name, this.getMotorControls(this.tool0));
                motorTabs.addTab(tool1Name, this.getMotorControls(this.tool1));
            }
            this.add((Component)motorTabs, "aligny top, spanx, growx, wrap");
        }
        JPanel temperaturePanel = new JPanel((LayoutManager)new MigLayout("fillx, filly"));
        temperaturePanel.setBorder(BorderFactory.createTitledBorder("Extruder Temperature Controls"));
        if (this.tool0 != null && this.tool0.hasHeater()) {
            targetTempLabel = this.makeKeyLabel("<html>" + this.tool0.getName() + " Target (&deg;C)</html>", t0TargetColor);
            this.t0TargetTemperatureField = new CallbackTextField(temperatureListener, "handleTextField", "target-temp", 5, Base.getLocalFormat());
            this.t0TargetTemperatureField.setValue(this.tool0.getTargetTemperature());
            currentTempLabel = this.makeKeyLabel("<html>" + this.tool0.getName() + " Current (&deg;C)</html>", t0MeasuredColor);
            this.t0CurrentTemperatureField = new JFormattedTextField(Base.getLocalFormat());
            this.t0CurrentTemperatureField.setColumns(5);
            this.t0CurrentTemperatureField.setEnabled(false);
            temperaturePanel.add(targetTempLabel);
            temperaturePanel.add(this.t0TargetTemperatureField);
            temperaturePanel.add(currentTempLabel);
            temperaturePanel.add((Component)this.t0CurrentTemperatureField, "wrap");
        }
        if (this.tool1 != null && this.tool1.hasHeater()) {
            targetTempLabel = this.makeKeyLabel("<html>" + this.tool1.getName() + " Target (&deg;C)</html>", t1TargetColor);
            this.t1TargetTemperatureField = new CallbackTextField(temperatureListener, "handleTextField", "target-temp", 5, Base.getLocalFormat());
            this.t1TargetTemperatureField.setValue(this.tool1.getTargetTemperature());
            currentTempLabel = this.makeKeyLabel("<html>" + this.tool1.getName() + " Current (&deg;C)</html>", t1MeasuredColor);
            this.t1CurrentTemperatureField = new JFormattedTextField(Base.getLocalFormat());
            this.t1CurrentTemperatureField.setColumns(5);
            this.t1CurrentTemperatureField.setEnabled(false);
            temperaturePanel.add(targetTempLabel);
            temperaturePanel.add(this.t1TargetTemperatureField);
            temperaturePanel.add(currentTempLabel);
            temperaturePanel.add((Component)this.t1CurrentTemperatureField, "wrap");
        }
        if (this.tool0.hasHeatedPlatform() || this.tool1 != null && this.tool1.hasHeatedPlatform()) {
            ToolModel tool = this.tool0.hasHeatedPlatform() ? this.tool0 : this.tool1;
            JLabel targetTempLabel2 = this.makeKeyLabel("<html>Platform Target (&deg;C)</html>", pTargetColor);
            this.pTargetTemperatureField = new CallbackTextField(temperatureListener, "handleTextField", "platform-target-temp", 5, Base.getLocalFormat());
            this.pTargetTemperatureField.setValue(tool.getPlatformTargetTemperature());
            JLabel currentTempLabel2 = this.makeKeyLabel("<html>Platform Current (&deg;C)</html>", pMeasuredColor);
            this.pCurrentTemperatureField = new JFormattedTextField(Base.getLocalFormat());
            this.pCurrentTemperatureField.setColumns(5);
            this.pCurrentTemperatureField.setEnabled(false);
            temperaturePanel.add(targetTempLabel2);
            temperaturePanel.add(this.pTargetTemperatureField);
            temperaturePanel.add(currentTempLabel2);
            temperaturePanel.add((Component)this.pCurrentTemperatureField, "wrap");
        }
        temperaturePanel.add((Component)new JLabel("Temperature Chart"), "growx,spanx,wrap");
        temperaturePanel.add((Component)this.makeChart(), "growx, growy, spanx, wrap");
        this.add((Component)temperaturePanel, "growx, growy");
    }

    public void updateStatus() {
        Second second = new Second(new Date(System.currentTimeMillis() - this.startMillis));
        ToolModel platform = null;
        if (this.tool0 != null) {
            this.t0CurrentTemperatureField.setValue(this.tool0.getCurrentTemperature());
            this.t0MeasuredDataset.add((TimePeriod)second, this.tool0.getCurrentTemperature(), "a");
            this.t0TargetDataset.add((TimePeriod)second, this.t0TargetTemperature, "a");
            if (this.tool0.hasHeatedPlatform()) {
                platform = this.tool0;
            }
        }
        if (this.tool1 != null) {
            this.t1CurrentTemperatureField.setValue(this.tool1.getCurrentTemperature());
            this.t1MeasuredDataset.add((TimePeriod)second, this.tool1.getCurrentTemperature(), "a");
            this.t1TargetDataset.add((TimePeriod)second, this.t1TargetTemperature, "a");
            if (this.tool1.hasHeatedPlatform()) {
                platform = this.tool1;
            }
        }
        if (platform != null) {
            this.pCurrentTemperatureField.setValue(platform.getPlatformCurrentTemperature());
            this.pMeasuredDataset.add((TimePeriod)second, platform.getPlatformCurrentTemperature(), "a");
            this.pTargetDataset.add((TimePeriod)second, this.pTargetTemperature, "a");
        }
    }

    private double confirmTemperature(double target, String limitPrefName, double defaultLimit) {
        double limit = Base.preferences.getDouble("temperature.acceptedLimit", defaultLimit);
        if (target > limit) {
            int n = JOptionPane.showConfirmDialog(this, "<html>Setting the temperature to <b>" + Double.toString(target) + "\u00b0C</b> may<br>" + "involve health and/or safety risks or cause damage to your machine!<br>" + "The maximum recommended temperature is <b>" + Double.toString(limit) + "</b>.<br>" + "Do you accept the risk and still want to set this temperature?", "Danger", 0, 2);
            if (n == 0) {
                return target;
            }
            if (n == 1) {
                return Double.MIN_VALUE;
            }
            return Double.MIN_VALUE;
        }
        return target;
    }

    private void handleChangedTextField(JFormattedTextField source) {
        int toolhead;
        String name = source.getName();
        double newValue = Double.NaN;
        if (source == this.t0TargetTemperatureField) {
            toolhead = this.tool0.getIndex();
        } else if (source == this.t1TargetTemperatureField) {
            toolhead = this.tool1.getIndex();
        } else if (source == this.pTargetTemperatureField) {
            toolhead = -1;
        } else {
            Base.logger.warning("Unhandled text field: " + name);
            return;
        }
        if (source.getText().length() > 0) {
            newValue = ((Number)source.getValue()).doubleValue();
            if (toolhead != -1) {
                if ((newValue = this.confirmTemperature(newValue, "temperature.acceptedLimit", 260.0)) == Double.MIN_VALUE) {
                    return;
                }
                this.machine.runCommand(new SetTemperature(newValue, toolhead));
            } else {
                if ((newValue = this.confirmTemperature(newValue, "temperature.acceptedLimit.bed", 130.0)) == Double.MIN_VALUE) {
                    return;
                }
                this.machine.runCommand(new SetPlatformTemperature(newValue, toolhead));
            }
        }
        if (newValue != Double.NaN) {
            if (source == this.t0TargetTemperatureField) {
                this.t0TargetTemperature = newValue;
            } else if (source == this.t1TargetTemperatureField) {
                this.t1TargetTemperature = newValue;
            } else if (source == this.pTargetTemperatureField) {
                this.pTargetTemperature = newValue;
            }
        }
    }

    private void handleChangedItem(ItemEvent e, ToolModel tool) {
        int toolhead = tool.getIndex();
        Component source = (Component)((Object)e.getItemSelectable());
        String name = source.getName();
        if (e.getStateChange() == 1) {
            if (name.equals("motor-forward")) {
                this.machine.runCommand(new SetMotorDirection(DriverCommand.AxialDirection.CLOCKWISE, toolhead));
                if (tool.motorHasEncoder() || tool.motorIsStepper()) {
                    this.machine.runCommand(new SetMotorSpeedRPM(this.machine.getDriver().getMotorRPM(), toolhead));
                }
                this.machine.runCommand(new EnableExtruderMotor(toolhead));
            } else if (name.equals("motor-reverse")) {
                this.machine.runCommand(new SetMotorDirection(DriverCommand.AxialDirection.COUNTERCLOCKWISE, toolhead));
                if (tool.motorHasEncoder() || tool.motorIsStepper()) {
                    this.machine.runCommand(new SetMotorSpeedRPM(this.machine.getDriver().getMotorRPM(), toolhead));
                }
                this.machine.runCommand(new EnableExtruderMotor(toolhead));
            } else if (name.equals("motor-stop")) {
                this.machine.runCommand(new DisableMotor(toolhead));
            } else if (name.equals("abp-check")) {
                this.machine.runCommand(new ToggleAutomatedBuildPlatform(true, toolhead));
                this.machine.runCommand(new EnableFan(toolhead));
            }
        } else if (name.equals("motor-enabled")) {
            this.machine.runCommand(new DisableMotor(toolhead));
        } else if (name.equals("fan-check")) {
            this.machine.runCommand(new DisableFan(toolhead));
        } else if (name.equals("abp-check")) {
            this.machine.runCommand(new ToggleAutomatedBuildPlatform(false, toolhead));
            this.machine.runCommand(new DisableFan(toolhead));
        }
    }

    private void handleMotorAction(ActionEvent e, ToolModel tool) {
        int toolhead = tool.getIndex();
        String actionName = e.getActionCommand();
        if (actionName.equals("Extrude-duration")) {
            JComboBox cb = (JComboBox)e.getSource();
            String timeText = (String)cb.getSelectedItem();
            this.setExtrudeTime(timeText);
        }
        if (actionName.equals("forward")) {
            if (tool.getMotorStepperAxisName() != "") {
                this.machine.runCommand(new SetMotorDirection(DriverCommand.AxialDirection.CLOCKWISE, toolhead));
                if (this.machine.getDriver().getDriverName().equals("RepRap5D")) {
                    this.machine.runCommand(new EnableExtruderMotor(this.extrudeTime * 1000L, toolhead));
                } else {
                    this.machine.runCommand(new SelectTool(toolhead));
                    this.machine.runCommand(new EnableExtruderMotor(toolhead));
                    this.machine.runCommand(new Delay(this.extrudeTime * 1000L, toolhead));
                    this.machine.runCommand(new DisableMotor(toolhead));
                }
            }
        } else if (actionName.equals("reverse")) {
            if (tool.getMotorStepperAxisName() != "") {
                this.machine.runCommand(new SetMotorDirection(DriverCommand.AxialDirection.COUNTERCLOCKWISE, toolhead));
                if (this.machine.getDriver().getDriverName().equals("RepRap5D")) {
                    this.machine.runCommand(new EnableExtruderMotor(this.extrudeTime * 1000L, toolhead));
                } else {
                    this.machine.runCommand(new SelectTool(toolhead));
                    this.machine.runCommand(new EnableExtruderMotor(toolhead));
                    this.machine.runCommand(new Delay(this.extrudeTime * 1000L, toolhead));
                    this.machine.runCommand(new DisableMotor(toolhead));
                }
            }
        } else if (actionName.equals("stop")) {
            this.machine.runCommand(new DisableMotor(toolhead));
            if (tool.getMotorStepperAxisName() != "") {
                this.machine.stopMotion();
            }
        }
    }
}

