/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.util.serial;

import replicatorg.app.util.serial.UsbHardwareId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Name
implements Comparable<Name> {
    private String name;
    private String alias;
    private boolean available;
    private UsbHardwareId hardwareId;

    public Name(String name, boolean available) {
        this.name = name;
        this.alias = null;
        this.available = available;
        this.hardwareId = UsbHardwareId.NONE;
    }

    public Name(String name, String alias, boolean available) {
        this.name = name;
        this.alias = alias;
        this.available = available;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public void setHardwareId(UsbHardwareId newId) {
        this.hardwareId = newId;
    }

    public boolean isValidConnectorForMachineName(String machineName) {
        return this.hardwareId == UsbHardwareId.MIGHTY_BOARD && (machineName.contains("MightyBoard") || machineName.contains("Replicator"));
    }

    public boolean isVerified() {
        return this.hardwareId.isVerified();
    }

    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public int compareTo(Name other) {
        return this.name.compareTo(other.name);
    }

    public String toString() {
        if (this.alias != null) {
            return this.name + " (" + this.alias + ")";
        }
        return this.name;
    }
}

