/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.model;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;
import replicatorg.app.Base;
import replicatorg.app.ui.MainWindow;
import replicatorg.model.BuildCode;
import replicatorg.model.BuildElement;
import replicatorg.model.BuildModel;

public class Build {
    MainWindow editor;
    private String name;
    private boolean hasMainWindow;
    String mainFilename;
    public File folder;
    private Vector<BuildElement> elements = new Vector();
    private BuildElement openedElement;
    File modelFile = null;

    public String getName() {
        return this.name;
    }

    public BuildElement getOpenedElement() {
        return this.openedElement;
    }

    public Build(String path) throws IOException {
        this.hasMainWindow = false;
        if (path == null) {
            this.mainFilename = null;
            this.name = "Untitled";
            this.folder = new File("~");
            BuildCode code = new BuildCode(null, null);
            this.openedElement = code;
            code.setModified(true);
            this.elements.add(code);
        } else {
            File mainFile = new File(path);
            this.mainFilename = mainFile.getName();
            String suffix = "";
            int lastIdx = this.mainFilename.lastIndexOf(46);
            if (lastIdx > 0) {
                suffix = this.mainFilename.substring(lastIdx + 1);
                this.name = this.mainFilename.substring(0, lastIdx);
            } else {
                this.name = this.mainFilename;
            }
            String parentPath = new File(path).getParent();
            if (parentPath == null) {
                parentPath = ".";
            }
            this.folder = new File(parentPath);
            if ("stl".equalsIgnoreCase(suffix) || "obj".equalsIgnoreCase(suffix) || "dae".equalsIgnoreCase(suffix)) {
                this.modelFile = mainFile;
            }
            this.loadCode();
            this.loadModel();
            this.openedElement = ("gcode".equalsIgnoreCase(suffix) || "ngc".equalsIgnoreCase(suffix)) && this.getCode() != null ? this.getCode() : this.getModel();
        }
    }

    public Build(MainWindow editor, String path) throws IOException {
        this.hasMainWindow = true;
        this.editor = editor;
        if (path == null) {
            this.mainFilename = null;
            this.name = "Untitled";
            this.folder = new File("~");
            BuildCode code = new BuildCode(null, null);
            this.openedElement = code;
            code.setModified(true);
            this.elements.add(code);
        } else {
            File mainFile = new File(path);
            this.mainFilename = mainFile.getName();
            String suffix = "";
            int lastIdx = this.mainFilename.lastIndexOf(46);
            if (lastIdx > 0) {
                suffix = this.mainFilename.substring(lastIdx + 1);
                this.name = this.mainFilename.substring(0, lastIdx);
            } else {
                this.name = this.mainFilename;
            }
            File crashCheck = new File(this.name + ".crash");
            if (crashCheck.exists()) {
                crashCheck.delete();
                int op = JOptionPane.showConfirmDialog(null, "It looks as though ReplicatorG may have crashed\nlast time it tried to load this file.\nRe-loading the same file could cause another crash,\nwould you like to load this file anyway?", "Remnants of a crash detected!", 0, 2);
                if (op != 0) {
                    return;
                }
            }
            crashCheck.createNewFile();
            String parentPath = new File(path).getParent();
            if (parentPath == null) {
                parentPath = ".";
            }
            this.folder = new File(parentPath);
            if ("stl".equalsIgnoreCase(suffix) || "obj".equalsIgnoreCase(suffix) || "dae".equalsIgnoreCase(suffix)) {
                this.modelFile = mainFile;
            }
            this.loadCode();
            this.loadModel();
            this.openedElement = ("gcode".equalsIgnoreCase(suffix) || "ngc".equalsIgnoreCase(suffix)) && this.getCode() != null ? this.getCode() : this.getModel();
            crashCheck.delete();
        }
    }

    public void reloadCode() {
        for (BuildElement e : this.elements) {
            if (!(e instanceof BuildCode)) continue;
            this.elements.removeElement(e);
            break;
        }
        this.loadCode();
    }

    public void loadCode() {
        File codeFile = new File(this.folder, this.name + ".gcode");
        if (codeFile.exists()) {
            this.elements.add(new BuildCode(this.name, codeFile));
        } else {
            codeFile = new File(this.folder, this.name + ".ngc");
            if (codeFile.exists()) {
                this.elements.add(new BuildCode(this.name, codeFile));
            }
        }
    }

    public void loadModel() {
        if (this.modelFile == null || !this.modelFile.exists()) {
            this.modelFile = new File(this.folder, this.name + ".stl");
        }
        if (this.modelFile.exists()) {
            this.elements.add(new BuildModel(this, this.modelFile));
        }
    }

    public boolean save() throws IOException {
        BuildModel model;
        if (this.mainFilename == null) {
            return this.saveAs();
        }
        if (this.isReadOnly()) {
            Base.showMessage("File is read-only", "This file is marked \"read-only\", so you'll\nneed to re-save this file to another location.");
            return this.saveAs();
        }
        BuildCode code = this.getCode();
        if (code != null && this.hasMainWindow && code.isModified()) {
            code.program = this.editor.getText();
            code.save();
        }
        if ((model = this.getModel()) != null && model.isModified()) {
            model.save();
        }
        return true;
    }

    public boolean saveAs() throws IOException {
        BuildModel model;
        BuildCode code;
        FileDialog fd = new FileDialog(new Frame(), "Save file as...", 1);
        fd.setDirectory(this.folder.getCanonicalPath());
        fd.setFile(this.mainFilename);
        fd.setVisible(true);
        String parentDir = fd.getDirectory();
        String newName = fd.getFile();
        if (newName == null) {
            return false;
        }
        File folder = new File(parentDir);
        if (newName.toLowerCase().endsWith(".gcode")) {
            newName = newName.substring(0, newName.length() - 6);
        }
        if (newName.toLowerCase().endsWith(".ngc")) {
            newName = newName.substring(0, newName.length() - 4);
        }
        if (newName.toLowerCase().endsWith(".stl")) {
            newName = newName.substring(0, newName.length() - 4);
        }
        if (newName.toLowerCase().endsWith(".obj")) {
            newName = newName.substring(0, newName.length() - 4);
        }
        if (newName.toLowerCase().endsWith(".dae")) {
            newName = newName.substring(0, newName.length() - 4);
        }
        if ((code = this.getCode()) != null) {
            if (this.hasMainWindow && code.isModified()) {
                code.program = this.editor.getText();
            }
            File newFile = new File(folder, newName + ".gcode");
            code.saveAs(newFile);
        }
        if ((model = this.getModel()) != null) {
            File newFile = new File(folder, newName + ".stl");
            model.saveAs(newFile);
        }
        this.name = newName;
        this.mainFilename = fd.getFile();
        this.folder = folder;
        return true;
    }

    public BuildCode getCode() {
        for (BuildElement e : this.elements) {
            if (!(e instanceof BuildCode)) continue;
            return (BuildCode)e;
        }
        return null;
    }

    public BuildModel getModel() {
        for (BuildElement e : this.elements) {
            if (!(e instanceof BuildModel)) continue;
            return (BuildModel)e;
        }
        return null;
    }

    public int getLines() {
        BuildCode code = this.getCode();
        int ret = null != code ? this.countLines(code.program) : 0;
        return ret;
    }

    protected int countLines(String what) {
        return what.split("\n").length - 1;
    }

    public static String scrubComments(String what) {
        char[] p = what.toCharArray();
        int index = 0;
        while (index < p.length) {
            if (p[index] == '/' && index < p.length - 1 && p[index + 1] == '/') {
                p[index++] = 32;
                p[index++] = 32;
                while (index < p.length && p[index] != '\n') {
                    p[index++] = 32;
                }
                continue;
            }
            if (p[index] == '/' && index < p.length - 1 && p[index + 1] == '*') {
                p[index++] = 32;
                p[index++] = 32;
                boolean endOfRainbow = false;
                while (index < p.length - 1) {
                    if (p[index] == '*' && p[index + 1] == '/') {
                        p[index++] = 32;
                        p[index++] = 32;
                        endOfRainbow = true;
                        break;
                    }
                    ++index;
                }
                if (endOfRainbow) continue;
                throw new RuntimeException("Missing the */ from the end of a /* comment */");
            }
            ++index;
        }
        return new String(p);
    }

    public boolean isReadOnly() {
        BuildCode code = this.getCode();
        if (code == null) {
            return false;
        }
        return code.isModified() && !code.file.canWrite() && code.file.exists();
    }

    public String getMainFilePath() {
        BuildCode code = this.getCode();
        if (code != null && code.file != null) {
            return code.file.getAbsolutePath();
        }
        return null;
    }

    public boolean hasModifiedElements() {
        boolean rv = false;
        for (BuildElement e : this.elements) {
            if (!e.isModified()) continue;
            rv = true;
        }
        return rv;
    }
}

