/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.skeinforge;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.swing.ListModel;
import replicatorg.app.Base;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileUtils {
    public boolean delete(SkeinforgeGenerator.Profile p) {
        return this.delete(new File(p.getFullPath()));
    }

    private boolean delete(File file) {
        boolean result = true;
        if (file.exists()) {
            if (file.isDirectory()) {
                try {
                    if (!file.getAbsolutePath().equals(file.getCanonicalPath())) {
                        return false;
                    }
                }
                catch (IOException ioe) {
                    return false;
                }
                for (File f : file.listFiles()) {
                    result = result && this.delete(f);
                }
            }
            return result && file.delete();
        }
        return false;
    }

    public boolean openFolder(SkeinforgeGenerator.Profile p) {
        return this.openFolder(new File(p.getFullPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openFolder(File file) {
        if (!Base.openFolderAvailable()) {
            Base.logger.info("The profile can be found in this directory: \"" + file + "\".");
            return false;
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                Base.logger.fine("The profile can be found in this directory: " + file);
                Base.openFolder(file);
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public static boolean shouldDisplay(SkeinforgeGenerator.Profile p) {
        String selectedMachine = Base.preferences.get("machine.name", "no machine selected");
        return "no machine selected".equals(selectedMachine) || p.getTargetMachines().isEmpty() || p.getTargetMachines().contains(selectedMachine);
    }

    public static SkeinforgeGenerator.Profile getListedProfile(ListModel model, Collection<SkeinforgeGenerator.Profile> profiles, int idx) {
        String selected = (String)model.getElementAt(idx);
        for (SkeinforgeGenerator.Profile p : profiles) {
            if (!selected.equals(p.toString())) continue;
            return p;
        }
        Base.logger.severe("Could not find profile! The programmer has done something foolish.");
        return null;
    }
}

