/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.skeinforge;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.gcode.MutableGCodeSource;
import replicatorg.machine.model.MachineType;
import replicatorg.machine.model.ToolheadAlias;
import replicatorg.model.BuildCode;
import replicatorg.model.GCodeSource;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;

public class SkeinforgePostProcessor {
    private final SkeinforgeGenerator generator;
    private MutableGCodeSource source;
    private MutableGCodeSource startCode = null;
    private MutableGCodeSource endCode = null;
    private ToolheadAlias toolheadTarget = null;
    private MachineType machineType = null;
    private boolean dualstruding = false;
    private boolean prependStart = false;
    private boolean appendEnd = false;
    private boolean prependMetaInfo = false;
    private boolean multiHead = false;
    private boolean addProgressUpdates = false;
    private PostProcessorPreference ppp;

    public SkeinforgePostProcessor(SkeinforgeGenerator generator) {
        this.generator = generator;
        this.ppp = new PostProcessorPreference(this);
    }

    protected BuildCode runPostProcessing() {
        this.source = new MutableGCodeSource(this.generator.output.file);
        if (!this.dualstruding) {
            if (this.prependStart) {
                this.runPrependStartCode();
            }
            if (this.appendEnd) {
                this.runAppend(this.endCode);
            }
            if (!this.multiHead) {
                this.toolheadTarget = ToolheadAlias.SINGLE;
            }
            if (this.toolheadTarget != null) {
                this.runToolheadSwap(this.toolheadTarget);
            }
        }
        if (this.addProgressUpdates) {
            this.source.addProgressUpdates();
        }
        if (this.prependMetaInfo) {
            MutableGCodeSource metaInfo = new MutableGCodeSource();
            String curDate = this.getPrettyPrintDate();
            String machineName = this.machineType != null ? this.machineType.getName() : "CNC Machine";
            metaInfo.add("(** This GCode was generated by ReplicatorG " + Base.VERSION_NAME + " **)");
            metaInfo.add("(*  using " + SkeinforgeGenerator.displayName + "  *)");
            metaInfo.add("(*  for a " + (this.multiHead ? "Dual headed " : "Single headed ") + machineName + "  *)");
            metaInfo.add("(*  on " + curDate + " *)");
            this.runPrepend(metaInfo);
        }
        this.source.writeToFile(this.generator.output.file);
        return this.generator.output;
    }

    private String getPrettyPrintDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss (Z)");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private void runToolheadSwap(ToolheadAlias switchTo) {
        System.out.println("runToolheadSwap");
        this.source.changeToolhead(switchTo);
    }

    private void runPrependStartCode() {
        SkeinforgePostProcessor.prependAndModifyStartCode(this.source, this.startCode);
    }

    public static void prependAndModifyStartCode(MutableGCodeSource sourceGCode, MutableGCodeSource startGCode) {
        MutableGCodeSource newStart = new MutableGCodeSource();
        int matched = 0;
        for (String line : startGCode) {
            Pattern p = Pattern.compile("^M104\\s+S(\\d+)\\s+T(\\d)\\s+(.*)\\s*$");
            Matcher m = p.matcher(line);
            if (m.matches()) {
                int newTemp = Base.preferences.getInt("replicatorg.skeinforge.printOMatic5D.printTemp", 220);
                Base.logger.finer("new temp" + newTemp);
                String newStr = "M104 S" + newTemp + " T" + m.group(2);
                if (m.groupCount() >= 3) {
                    newStr = newStr + " " + m.group(3);
                }
                newStr = newStr + " (temp updated by printOMatic)";
                Base.logger.finer("New Temp String: " + newStr);
                ++matched;
                newStart.add(newStr);
                continue;
            }
            newStart.add(line);
        }
        sourceGCode.add(0, newStart);
        Base.logger.finer("printTemp replace count : " + matched);
    }

    private void runPrepend(GCodeSource newCode) {
        if (newCode != null) {
            this.source.add(0, newCode);
        }
    }

    private void runAppend(GCodeSource newCode) {
        if (newCode != null) {
            this.source.add(newCode);
        }
    }

    public void enableDualstrusion() {
        this.dualstruding = true;
        List<SkeinforgeGenerator.SkeinforgePreference> prefs = this.generator.getPreferences();
        prefs.add(0, new SkeinforgeGenerator.SkeinforgePreference(){
            SkeinforgeGenerator.SkeinforgeBooleanPreference outlineActive = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Outline Active", "skeinforge.dualstrusion.outlineActive", false, "<html>Having Outline active for any layer but the first layer<br/>for the first toolhead can damage dualstrusion prints.</html>");
            SkeinforgeGenerator.SkeinforgeBooleanPreference coolActive;
            {
                this.outlineActive.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("outline.csv", "Activate Outline", "True"));
                this.coolActive = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Cool Active", "skeinforge.dualstrusion.coolActive", false, "<html>Cool makes the tool move slowly on very small layers,<br/> with dualstrusion, those layers are usually supported by the other half of the print.</html>");
                this.coolActive.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("cool.csv", "Activate Cool", "True"));
            }

            @Override
            public JComponent getUI() {
                JPanel panel = new JPanel();
                panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                panel.setLayout((LayoutManager)new MigLayout("fillx, filly"));
                panel.add((Component)new JLabel("Dualstruding..."), "growx, wrap");
                panel.add((Component)this.outlineActive.getUI(), "growx, wrap");
                panel.add((Component)this.coolActive.getUI(), "growx, wrap");
                return panel;
            }

            @Override
            public List<SkeinforgeGenerator.SkeinforgeOption> getOptions(String displayName) {
                ArrayList<SkeinforgeGenerator.SkeinforgeOption> result = new ArrayList<SkeinforgeGenerator.SkeinforgeOption>();
                result.add(new SkeinforgeGenerator.SkeinforgeOption("preface.csv", "Name of Start File:", ""));
                result.add(new SkeinforgeGenerator.SkeinforgeOption("preface.csv", "Name of End File:", ""));
                result.addAll(this.outlineActive.getOptions(""));
                result.addAll(this.coolActive.getOptions(""));
                return result;
            }

            @Override
            public String valueSanityCheck() {
                return null;
            }

            @Override
            public String getName() {
                return "Dualstrusion options";
            }
        });
    }

    public static void stripNonLayerTagComments(MutableGCodeSource source) {
        Iterator<String> i = source.iterator();
        while (i.hasNext()) {
            String line = i.next();
            if (!line.startsWith("(<") || line.startsWith("(<layer>") || line.startsWith("(</layer")) continue;
            i.remove();
        }
    }

    public void setToolheadTarget(ToolheadAlias tool) {
        this.toolheadTarget = tool;
    }

    public void setMachineType(MachineType type) {
        this.machineType = type;
    }

    public void setStartCode(GCodeSource source) {
        Base.logger.severe("gcode source" + source);
        this.startCode = source == null ? null : (source instanceof MutableGCodeSource ? (MutableGCodeSource)source : new MutableGCodeSource(source));
    }

    public void setEndCode(GCodeSource source) {
        if (source == null) {
            this.endCode = null;
        }
        this.endCode = source instanceof MutableGCodeSource ? (MutableGCodeSource)source : new MutableGCodeSource(source);
    }

    public void setPrependStart(boolean doPrepend) {
        this.prependStart = doPrepend;
    }

    public void setAppendEnd(boolean doAppend) {
        this.appendEnd = doAppend;
    }

    public void setPrependMetaInfo(boolean doPrepend) {
        this.prependMetaInfo = doPrepend;
    }

    public void setMultiHead(boolean isMulti) {
        this.multiHead = isMulti;
        this.ppp.refreshPreferences();
    }

    public void setAddProgressUpdates(boolean doAdd) {
        this.addProgressUpdates = doAdd;
    }

    public PostProcessorPreference getPreference() {
        return this.ppp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PostProcessorPreference
    implements SkeinforgeGenerator.SkeinforgePreference {
        private final JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, ins 0"));
        private final SkeinforgePostProcessor processor;

        public PostProcessorPreference(SkeinforgePostProcessor spp) {
            this.processor = spp;
        }

        public void refreshPreferences() {
            this.panel.removeAll();
            if (SkeinforgePostProcessor.this.multiHead && !SkeinforgePostProcessor.this.dualstruding) {
                Vector<String> extruders = new Vector<String>();
                extruders.add(ToolheadAlias.RIGHT.guiName);
                extruders.add(ToolheadAlias.LEFT.guiName);
                String value = Base.preferences.get("replicatorg.skeinforge.printOMatic.toolheadOrientation", (String)extruders.firstElement());
                final DefaultComboBoxModel model = new DefaultComboBoxModel(extruders);
                JComboBox input = new JComboBox(model);
                final JCheckBox toolSwap = new JCheckBox("Use");
                this.panel.add((Component)toolSwap, "split");
                this.panel.add(input, "split");
                this.panel.add((Component)new JLabel("extruder"), "wrap");
                ActionListener toolSelected = new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        Base.preferences.putBoolean("replicatorg.skeinforge.setToolheadOrientation", toolSwap.isSelected());
                        if (toolSwap.isSelected()) {
                            if (model.getSelectedItem().equals(ToolheadAlias.LEFT.guiName)) {
                                PostProcessorPreference.this.processor.toolheadTarget = ToolheadAlias.LEFT;
                                Base.preferences.put("replicatorg.skeinforge.printOMatic.toolheadOrientation", ToolheadAlias.LEFT.guiName);
                            } else if (model.getSelectedItem().equals(ToolheadAlias.RIGHT.guiName)) {
                                PostProcessorPreference.this.processor.toolheadTarget = ToolheadAlias.RIGHT;
                                Base.preferences.put("replicatorg.skeinforge.printOMatic.toolheadOrientation", ToolheadAlias.RIGHT.guiName);
                            }
                        } else {
                            PostProcessorPreference.this.processor.toolheadTarget = null;
                            Base.preferences.put("replicatorg.skeinforge.printOMatic.toolheadOrientation", "-");
                        }
                    }
                };
                input.addActionListener(toolSelected);
                toolSwap.addActionListener(toolSelected);
                toolSwap.setSelected(Base.preferences.getBoolean("replicatorg.skeinforge.setToolheadOrientation", true));
                model.setSelectedItem(value);
                input.setToolTipText("select which extruder this gcode prints on");
            }
        }

        @Override
        public JComponent getUI() {
            return this.panel;
        }

        @Override
        public List<SkeinforgeGenerator.SkeinforgeOption> getOptions(String displayName) {
            return new ArrayList<SkeinforgeGenerator.SkeinforgeOption>();
        }

        @Override
        public String valueSanityCheck() {
            return null;
        }

        @Override
        public String getName() {
            return "Post-Processor options";
        }
    }
}

