/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.sei;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.server.Invoker;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.InvokerTube;
import com.sun.xml.internal.ws.server.sei.DispatchException;
import com.sun.xml.internal.ws.server.sei.EndpointMethodDispatcher;
import com.sun.xml.internal.ws.server.sei.EndpointMethodDispatcherGetter;
import com.sun.xml.internal.ws.server.sei.EndpointMethodHandler;
import java.text.MessageFormat;
import java.util.List;

public class SEIInvokerTube
extends InvokerTube {
    private final SOAPVersion soapVersion;
    private final WSBinding binding;
    private final AbstractSEIModelImpl model;
    private final List<EndpointMethodDispatcher> dispatcherList;

    public SEIInvokerTube(AbstractSEIModelImpl abstractSEIModelImpl, Invoker invoker, WSBinding wSBinding) {
        super(invoker);
        this.soapVersion = wSBinding.getSOAPVersion();
        this.binding = wSBinding;
        this.model = abstractSEIModelImpl;
        EndpointMethodDispatcherGetter endpointMethodDispatcherGetter = new EndpointMethodDispatcherGetter(abstractSEIModelImpl, wSBinding, this);
        this.dispatcherList = endpointMethodDispatcherGetter.getDispatcherList();
    }

    @NotNull
    public NextAction processRequest(@NotNull Packet packet) {
        Object object;
        for (EndpointMethodDispatcher object22 : this.dispatcherList) {
            try {
                object = object22.getEndpointMethodHandler(packet);
            }
            catch (DispatchException packet2) {
                return this.doReturnWith(packet.createServerResponse(packet2.fault, this.model.getPort(), null, this.binding));
            }
            if (object == null) continue;
            Packet packet2 = ((EndpointMethodHandler)object).invoke(packet);
            assert (packet2 != null);
            return this.doReturnWith(packet2);
        }
        String string = MessageFormat.format("Request=[SOAPAction={0},Payload='{'{1}'}'{2}]", packet.soapAction, packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart());
        String string2 = ServerMessages.DISPATCH_CANNOT_FIND_METHOD(string);
        object = SOAPFaultBuilder.createSOAPFaultMessage(this.binding.getSOAPVersion(), string2, this.binding.getSOAPVersion().faultCodeClient);
        return this.doReturnWith(packet.createServerResponse((Message)object, this.model.getPort(), null, this.binding));
    }

    @NotNull
    public NextAction processResponse(@NotNull Packet packet) {
        throw new IllegalStateException("InovkerPipe's processResponse shouldn't be called.");
    }

    @NotNull
    public NextAction processException(@NotNull Throwable throwable) {
        throw new IllegalStateException("InovkerPipe's processException shouldn't be called.");
    }
}

