/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.CodePointIterator;

final class CharArrayCodePointIterator
extends CodePointIterator {
    private char[] text;
    private int start;
    private int limit;
    private int index;

    public CharArrayCodePointIterator(char[] cArray) {
        this.text = cArray;
        this.limit = cArray.length;
    }

    public CharArrayCodePointIterator(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < n || n2 > cArray.length) {
            throw new IllegalArgumentException();
        }
        this.text = cArray;
        this.start = this.index = n;
        this.limit = n2;
    }

    public void setToStart() {
        this.index = this.start;
    }

    public void setToLimit() {
        this.index = this.limit;
    }

    public int next() {
        if (this.index < this.limit) {
            char c;
            char c2;
            if (Character.isHighSurrogate(c2 = this.text[this.index++]) && this.index < this.limit && Character.isLowSurrogate(c = this.text[this.index])) {
                ++this.index;
                return Character.toCodePoint(c2, c);
            }
            return c2;
        }
        return -1;
    }

    public int prev() {
        if (this.index > this.start) {
            char c;
            char c2;
            if (Character.isLowSurrogate(c2 = this.text[--this.index]) && this.index > this.start && Character.isHighSurrogate(c = this.text[this.index - 1])) {
                --this.index;
                return Character.toCodePoint(c, c2);
            }
            return c2;
        }
        return -1;
    }

    public int charIndex() {
        return this.index;
    }
}

