/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.modeling;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.modeling.PreviewPanel;
import replicatorg.app.ui.modeling.Tool;
import replicatorg.app.ui.modeling.ToolPanel;

public class ScalingTool
extends Tool {
    boolean isOnPlatform = false;
    double scaleDragChange = 1.0;
    JFormattedTextField scaleFactor;

    public ScalingTool(ToolPanel parent) {
        super(parent);
    }

    Icon getButtonIcon() {
        return null;
    }

    String getButtonName() {
        return "Scale";
    }

    JPanel getControls() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("fillx,filly,gap 0"));
        this.scaleFactor = new JFormattedTextField(Base.getLocalFormat());
        this.scaleFactor.setValue(1.0);
        p.add((Component)this.scaleFactor, "growx");
        JButton b = new JButton("Scale");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                double scale = ((Number)ScalingTool.this.scaleFactor.getValue()).doubleValue();
                if (scale == 0.0) {
                    JOptionPane.showConfirmDialog(null, "Cannot Scale by 0.0!!", "Scale", -1, 1);
                } else {
                    ScalingTool.this.parent.getModel().scale(scale, ScalingTool.this.parent.getModel().isOnPlatform());
                }
            }
        });
        p.add((Component)b, "growx,wrap");
        b = this.createToolButton("inches->mm", "images/center-object.png");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ScalingTool.this.parent.getModel().scale(25.4, ScalingTool.this.parent.getModel().isOnPlatform());
            }
        });
        p.add((Component)b, "growx,wrap");
        b = this.createToolButton("mm->inches", "images/center-object.png");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ScalingTool.this.parent.getModel().scale(0.03937007874015748, ScalingTool.this.parent.getModel().isOnPlatform());
            }
        });
        p.add((Component)b, "growx,wrap");
        JButton emBiggen = this.createToolButton("Fill Build Space!", "");
        emBiggen.setToolTipText("Keith it! (Make the object as large as possible)");
        emBiggen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Double newScale = ScalingTool.this.parent.getModel().scaleMax();
                if (newScale.isNaN()) {
                    JOptionPane.showConfirmDialog(null, "No Machine is Selected!  Cannot scale to max size!!", "Scale to max", -1, 1);
                } else {
                    JOptionPane.showConfirmDialog(null, "Scaled by " + newScale, "Scale to max", -1, 1);
                }
            }
        });
        p.add((Component)emBiggen, "growx,wrap");
        return p;
    }

    public String getInstructions() {
        return Base.isMacOS() ? "<html><body>Drag to scale object<br>Shift-drag to rotate view<br>Mouse wheel to zoom</body></html>" : "<html><body>Left drag to scale object<br>Right drag to rotate view<br>Mouse wheel to zoom</body></html>";
    }

    String getTitle() {
        return "Scale object";
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.scaleDragChange = this.parent.getModel().model.getTransform().getScale();
        this.isOnPlatform = this.parent.getModel().isOnPlatform();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.startPoint == null) {
            return;
        }
        Point p = e.getPoint();
        PreviewPanel.DragMode mode = PreviewPanel.DragMode.NONE;
        if (Base.isMacOS()) {
            if (this.button == 1 && !e.isShiftDown()) {
                mode = PreviewPanel.DragMode.SCALE_OBJECT;
            }
        } else if (this.button == 1) {
            mode = PreviewPanel.DragMode.SCALE_OBJECT;
        }
        double xd = p.x - this.startPoint.x;
        double yd = -((double)(p.y - this.startPoint.y));
        switch (mode) {
            case NONE: {
                super.mouseDragged(e);
                break;
            }
            case SCALE_OBJECT: {
                this.scaleDragChange += 0.01 * (xd + yd) * this.scaleDragChange;
                double currentScale = this.parent.getModel().model.getTransform().getScale();
                double targetScale = this.scaleDragChange / currentScale;
                this.parent.getModel().scale(targetScale, this.isOnPlatform);
                this.scaleFactor.setValue((double)((int)(100.0 * this.scaleDragChange)) / 100.0);
            }
        }
        this.startPoint = p;
    }
}

