/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import replicatorg.drivers.RetryException;
import replicatorg.machine.model.AxisId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface OnboardParameters {
    public static final int EXTRUDER = 0;
    public static final int BUILD_PLATFORM = 1;

    public List<Integer> toolheadsWithStoredData();

    public EnumSet<AxisId> getInvertedAxes();

    public EnumMap<AxisId, String> getAxisAlises();

    public void setInvertedAxes(EnumSet<AxisId> var1);

    public String getMachineName();

    public void setMachineName(String var1);

    public boolean canVerifyMachine();

    public boolean verifyMachineId();

    public double getAxisHomeOffset(int var1);

    public void setAxisHomeOffset(int var1, double var2);

    public boolean hasAcceleration();

    public String getDriverName();

    public void setAccelerationStatus(byte var1);

    public void setAccelerationRate(int var1);

    public void setAxisAccelerationRate(int var1, int var2);

    public void setAxisJerk(int var1, double var2);

    public void setAccelerationMinimumSpeed(int var1);

    public byte getAccelerationStatus();

    public int getAccelerationRate();

    public int getAxisAccelerationRate(int var1);

    public double getAxisJerk(int var1);

    public int getAccelerationMinimumSpeed();

    public int getEEPROMParamInt(EEPROMParams var1);

    public long getEEPROMParamUInt(EEPROMParams var1);

    public double getEEPROMParamFloat(EEPROMParams var1);

    public void setEEPROMParam(EEPROMParams var1, int var2);

    public void setEEPROMParam(EEPROMParams var1, long var2);

    public void setEEPROMParam(EEPROMParams var1, double var2);

    public boolean hasToolheadsOffset();

    public double getToolheadsOffset(int var1);

    public void eepromStoreToolDelta(int var1, double var2);

    public EndstopType getInvertedEndstops();

    public void setInvertedEndstops(EndstopType var1);

    public boolean hasFeatureOnboardParameters();

    public void createThermistorTable(int var1, double var2, double var4, double var6, int var8);

    public int getR0(int var1, int var2);

    public int getT0(int var1, int var2);

    public int getBeta(int var1, int var2);

    public boolean getCoolingFanEnabled(int var1);

    public int getCoolingFanSetpoint(int var1);

    public void setCoolingFanParameters(boolean var1, int var2, int var3);

    public BackoffParameters getBackoffParameters(int var1);

    public void setBackoffParameters(BackoffParameters var1, int var2);

    public PIDParameters getPIDParameters(int var1, int var2);

    public void setPIDParameters(int var1, PIDParameters var2, int var3);

    public ExtraFeatures getExtraFeatures(int var1);

    public void setExtraFeatures(ExtraFeatures var1, int var2);

    public EstopType getEstopConfig();

    public void setEstopConfig(EstopType var1);

    public void resetSettingsToFactory() throws RetryException;

    public void resetSettingsToBlank() throws RetryException;

    public void resetToolToFactory(int var1);

    public void resetToolToBlank(int var1);

    public boolean hasVrefSupport();

    public void setStoredStepperVoltage(int var1, int var2);

    public int getStoredStepperVoltage(int var1);

    public CommunicationStatistics getCommunicationStatistics();

    public String getMachineType();

    public int toolCountOnboard();

    public boolean hasToolCountOnboard();

    public void setToolCountOnboard(int var1);

    public boolean hasHbp();

    public void setHbpSetting(boolean var1);

    public boolean hasJettyAcceleration();

    public boolean hasAdvancedFeatures();

    public void setPStop(boolean var1);

    public boolean getPStop();

    public static class CommunicationStatistics {
        public int packetCount;
        public int sentPacketCount;
        public int packetFailureCount;
        public int packetRetryCount;
        public int noiseByteCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EstopType {
        NOT_PRESENT(0),
        ACTIVE_HIGH(1),
        ACTIVE_LOW(2);

        final byte value;

        private EstopType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EstopType estopTypeForValue(byte value) {
            if (value == EstopType.ACTIVE_HIGH.value) {
                return ACTIVE_HIGH;
            }
            if (value == EstopType.ACTIVE_LOW.value) {
                return ACTIVE_LOW;
            }
            return NOT_PRESENT;
        }
    }

    public static class ExtraFeatures {
        static final int CHA = 0;
        static final int CHB = 1;
        static final int CHC = 2;
        public boolean swapMotorController;
        public int heaterChannel;
        public int hbpChannel;
        public int abpChannel;
    }

    public static class PIDParameters {
        public float p;
        public float i;
        public float d;
    }

    public static class BackoffParameters {
        public int stopMs;
        public int reverseMs;
        public int forwardMs;
        public int triggerMs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EndstopType {
        NOT_PRESENT(0),
        ALL_INVERTED(-97),
        NON_INVERTED(-128);

        final byte value;

        private EndstopType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EndstopType endstopTypeForValue(byte value) {
            if ((value & 0x80) == 0) {
                return NOT_PRESENT;
            }
            return (value & 1) == 0 ? NON_INVERTED : ALL_INVERTED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EEPROMParams {
        ABP_COPIES,
        ACCEL_ADVANCE_K,
        ACCEL_ADVANCE_K2,
        ACCEL_CLOCKWISE_EXTRUDER,
        ACCEL_EXTRUDER_DEPRIME_A,
        ACCEL_EXTRUDER_DEPRIME_B,
        ACCEL_E_STEPS_PER_MM,
        ACCEL_MAX_ACCELERATION_A,
        ACCEL_MAX_ACCELERATION_B,
        ACCEL_MAX_ACCELERATION_X,
        ACCEL_MAX_ACCELERATION_Y,
        ACCEL_MAX_ACCELERATION_Z,
        ACCEL_MAX_EXTRUDER_NORM,
        ACCEL_MAX_EXTRUDER_RETRACT,
        ACCEL_MAX_FEEDRATE_A,
        ACCEL_MAX_FEEDRATE_B,
        ACCEL_MAX_FEEDRATE_X,
        ACCEL_MAX_FEEDRATE_Y,
        ACCEL_MAX_FEEDRATE_Z,
        ACCEL_MAX_SPEED_CHANGE_A,
        ACCEL_MAX_SPEED_CHANGE_B,
        ACCEL_MAX_SPEED_CHANGE_X,
        ACCEL_MAX_SPEED_CHANGE_Y,
        ACCEL_MAX_SPEED_CHANGE_Z,
        ACCEL_MIN_FEED_RATE,
        ACCEL_MIN_PLANNER_SPEED,
        ACCEL_MIN_SEGMENT_TIME,
        ACCEL_MIN_TRAVEL_FEED_RATE,
        ACCEL_NOODLE_DIAMETER,
        ACCEL_REV_MAX_FEED_RATE,
        ACCEL_SLOWDOWN_LIMIT,
        ACCEL_SLOWDOWN_FLAG,
        ALEVEL_MAX_ZDELTA,
        ALEVEL_MAX_ZPROBE_HITS,
        AXIS_HOME_POSITIONS,
        AXIS_INVERSION,
        BUZZER_REPEATS,
        CLEAR_FOR_ESTOP,
        DEPRIME_ON_TRAVEL,
        DITTO_PRINT_ENABLED,
        ENABLE_ALTERNATE_UART,
        ENDSTOPS_USED,
        ENDSTOP_INVERSION,
        ENDSTOP_Z_MIN,
        ESTOP_CONFIGURATION,
        EXTRUDE_DURATION,
        EXTRUDER_HOLD,
        EXTRUDE_MMS,
        FILAMENT_USED,
        FILAMENT_USED_TRIP,
        HBP_PRESENT,
        HOMING_FEED_RATE_X,
        HOMING_FEED_RATE_Y,
        HOMING_FEED_RATE_Z,
        INVERTED_EXTRUDER_5D,
        JOG_MODE_SETTINGS,
        LCD_TYPE,
        MACHINE_NAME,
        MOOD_LIGHT_CUSTOM_BLUE,
        MOOD_LIGHT_CUSTOM_GREEN,
        MOOD_LIGHT_CUSTOM_RED,
        MOOD_LIGHT_SCRIPT,
        MOOD_LIGHT_SHOW_HEATING,
        OVERRIDE_GCODE_TEMP,
        PLATFORM_TEMP,
        PSTOP_ENABLE,
        PREHEAT_DURING_ESTIMATE,
        PREHEAT_DURING_PAUSE,
        RAM_USAGE_DEBUG,
        SD_USE_CRC,
        STEPPER_DRIVER,
        STEPS_PER_MM_A,
        STEPS_PER_MM_B,
        STEPS_PER_MM_X,
        STEPS_PER_MM_Y,
        STEPS_PER_MM_Z,
        TOOL0_TEMP,
        TOOL1_TEMP,
        TOOLHEAD_OFFSET_SYSTEM,
        VERSION_HIGH,
        VERSION_LOW;

    }
}

