/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine;

public class MachineState
implements Cloneable {
    private State state;

    public MachineState(State state) {
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public boolean isBuilding() {
        return this.state == State.BUILDING || this.state == State.PAUSED || this.state == State.BUILDING_OFFLINE;
    }

    public boolean isConnected() {
        return this.state == State.READY || this.state == State.BUILDING || this.state == State.PAUSED || this.state == State.ERROR;
    }

    public boolean canPrint() {
        return this.state == State.READY;
    }

    public boolean isPrinting() {
        return this.state == State.BUILDING || this.state == State.BUILDING_OFFLINE || this.state == State.PAUSED;
    }

    public boolean isPaused() {
        return this.state == State.PAUSED;
    }

    public boolean isConfigurable() {
        return this.isConnected() && !this.isPrinting();
    }

    public MachineState clone() {
        try {
            return (MachineState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(MachineState other) {
        return other.state == this.state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_ATTACHED,
        CONNECTING,
        READY,
        BUILDING,
        BUILDING_OFFLINE,
        PAUSED,
        ERROR;

    }
}

