/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine.builder;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import replicatorg.app.Base;
import replicatorg.app.gcode.GCodeParser;
import replicatorg.drivers.Driver;
import replicatorg.drivers.DriverQueryInterface;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.SimulationDriver;
import replicatorg.drivers.StopException;
import replicatorg.drivers.commands.DriverCommand;
import replicatorg.machine.Machine;
import replicatorg.machine.builder.MachineBuilder;
import replicatorg.model.GCodeSource;

public class Direct
implements MachineBuilder {
    GCodeSource source;
    Iterator<String> i;
    int linesProcessed;
    int linesTotal;
    Driver driver;
    GCodeParser parser;
    Queue<DriverCommand> driverQueue;
    boolean building;
    SimulationDriver simulator;
    GCodeParser simulationParser;
    Queue<DriverCommand> simulatorQueue;
    boolean simulating;
    boolean retry = false;
    State state;

    public Direct(Driver driver, SimulationDriver simulator, GCodeSource source) {
        this.driver = driver;
        this.source = source;
        this.linesProcessed = 0;
        this.linesTotal = source.getLineCount();
        this.i = source.iterator();
        if (driver == null) {
            this.building = false;
        } else {
            this.building = true;
            this.parser = new GCodeParser();
            this.driverQueue = new LinkedList<DriverCommand>();
            this.parser.init((DriverQueryInterface)((Object)driver));
        }
        if (simulator == null) {
            this.simulating = false;
        } else {
            this.simulating = true;
            this.simulator = simulator;
            this.simulationParser = new GCodeParser();
            this.simulatorQueue = new LinkedList<DriverCommand>();
            this.simulationParser.init(simulator);
        }
        this.simulating = false;
        this.state = State.RUNNING_GCODE;
    }

    public boolean finished() {
        return this.state == State.FINISHED;
    }

    public void runNext() {
        if (!this.i.hasNext()) {
            this.state = this.driver.isFinished() ? State.FINISHED : State.WAITING_FOR_MACHINE_FINISH;
            return;
        }
        if (this.building && this.driver.hasError()) {
            Base.logger.severe("Driver reported an error, aborting build");
            return;
        }
        if (!this.retry) {
            String line = this.i.next();
            ++this.linesProcessed;
            if (this.building) {
                this.parser.parse(line, this.driverQueue);
            }
            if (this.simulating) {
                this.simulationParser.parse(line, this.simulatorQueue);
            }
        }
        if (!this.retry && this.simulating) {
            for (DriverCommand command : this.simulatorQueue) {
                try {
                    command.run(this.simulator);
                }
                catch (RetryException r) {
                }
                catch (StopException stopException) {}
            }
            this.simulatorQueue.clear();
        }
        try {
            if (this.building) {
                while (!this.driverQueue.isEmpty()) {
                    this.driverQueue.peek().run(this.driver);
                    this.driverQueue.remove();
                }
            }
            this.retry = false;
        }
        catch (RetryException r) {
            Base.logger.log(Level.FINE, "Message delivery failed, retrying");
            this.retry = true;
        }
        catch (StopException e) {
            switch (e.getType()) {
                case UNCONDITIONAL_HALT: {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Unconditional halt: build ended", 1);
                    this.state = State.FINISHED;
                    break;
                }
                case PROGRAM_END: {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Program end: Build ended", 1);
                    this.state = State.FINISHED;
                    break;
                }
                case OPTIONAL_HALT: {
                    int result = JOptionPane.showConfirmDialog(null, e.getMessage(), "Optional halt: Continue build?", 0);
                    if (result == 0) {
                        this.driverQueue.remove();
                        break;
                    }
                    this.state = State.FINISHED;
                    break;
                }
                case PROGRAM_REWIND: {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Program rewind: Build ended", 1);
                    this.state = State.FINISHED;
                }
            }
        }
    }

    public int getLinesTotal() {
        return this.linesTotal;
    }

    public int getLinesProcessed() {
        return this.linesProcessed;
    }

    public boolean isInteractive() {
        return true;
    }

    public Machine.JobTarget getTarget() {
        return Machine.JobTarget.MACHINE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        RUNNING_GCODE,
        WAITING_FOR_MACHINE_FINISH,
        FINISHED;

    }
}

