/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine.model;

import java.text.ParseException;
import java.util.logging.Level;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.tools.XML;
import replicatorg.machine.model.ToolheadAlias;

public class WipeModel {
    private ToolheadAlias tool;
    private double height;
    private String x1;
    private String y1;
    private String z1;
    private String x2;
    private String y2;
    private String z2;
    private String wait;
    private String purgeDuration;
    private String reverseDuration;
    private String purgeRPM;
    private String reverseRPM;
    Node xml;

    public WipeModel(Node n) {
        this.xml = n;
        this.loadXML();
    }

    public void loadXML() {
        try {
            String n = XML.getAttributeValue(this.xml, "index");
            if (n != null) {
                int idx = Integer.parseInt(n);
                if (idx == ToolheadAlias.LEFT.number) {
                    this.tool = ToolheadAlias.LEFT;
                }
                if (idx == ToolheadAlias.RIGHT.number) {
                    this.tool = ToolheadAlias.RIGHT;
                }
            }
            this.x1 = (n = XML.getAttributeValue(this.xml, "X1")) != null ? "X" + n : "";
            n = XML.getAttributeValue(this.xml, "Y1");
            this.y1 = n != null ? "Y" + n : "";
            n = XML.getAttributeValue(this.xml, "Z1");
            if (n != null) {
                this.z1 = "Z" + n;
                this.height = Base.getGcodeFormat().parse(n).doubleValue();
            } else {
                this.z1 = "";
                this.height = 0.0;
            }
            n = XML.getAttributeValue(this.xml, "X2");
            this.x2 = n != null ? "X" + n : "";
            n = XML.getAttributeValue(this.xml, "Y2");
            this.y2 = n != null ? "Y" + n : "";
            n = XML.getAttributeValue(this.xml, "Z2");
            this.z2 = n != null ? "Z" + n : "";
            n = XML.getAttributeValue(this.xml, "wait");
            this.wait = n != null ? "P" + n : "";
            n = XML.getAttributeValue(this.xml, "purge_duration");
            this.purgeDuration = n != null ? "P" + n : "";
            n = XML.getAttributeValue(this.xml, "reverse_duration");
            this.reverseDuration = n != null ? "P" + n : "";
            n = XML.getAttributeValue(this.xml, "purge_rpm");
            this.purgeRPM = n != null ? "R" + n : "";
            n = XML.getAttributeValue(this.xml, "reverse_rpm");
            this.reverseRPM = n != null ? "R" + n : "";
        }
        catch (NumberFormatException e) {
            Base.logger.log(Level.SEVERE, "Could not parse your xml wipe, please make sure everything is formatted correctly", e);
        }
        catch (ParseException e) {
            Base.logger.log(Level.SEVERE, "Could not parse your xml wipe, please make sure everything is formatted correctly", e);
        }
    }

    public ToolheadAlias getTool() {
        return this.tool;
    }

    public String getX1() {
        return this.x1;
    }

    public String getX2() {
        return this.x2;
    }

    public String getY1() {
        return this.y1;
    }

    public String getY2() {
        return this.y2;
    }

    public String getZ1() {
        return this.z1;
    }

    public String getZ2() {
        return this.z2;
    }

    public String getWait() {
        return this.wait;
    }

    public String getPurgeDuration() {
        return this.purgeDuration;
    }

    public String getReverseDuration() {
        return this.reverseDuration;
    }

    public String getPurgeRPM() {
        return this.purgeRPM;
    }

    public String getReverseRPM() {
        return this.reverseRPM;
    }

    public double getHeight() {
        return this.height;
    }
}

