/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath;

import java.awt.Frame;
import java.util.EventObject;
import java.util.LinkedList;
import replicatorg.app.Base;
import replicatorg.model.BuildCode;
import replicatorg.model.BuildModel;

public abstract class ToolpathGenerator {
    public static String displayName = "A Toolpath Generator";
    protected BuildModel model;
    protected LinkedList<GeneratorListener> listeners = new LinkedList();

    public void addListener(GeneratorListener listener) {
        this.listeners.add(listener);
    }

    public void setModel(BuildModel model) {
        this.model = model;
    }

    public boolean visualConfigure(Frame parent) {
        assert (parent != null);
        assert (this.model != null);
        return true;
    }

    public boolean visualConfigure(Frame parent, int x, int y, String name) {
        assert (parent != null);
        assert (this.model != null);
        return true;
    }

    public boolean nonvisualConfigure() {
        assert (this.model != null);
        return true;
    }

    public void editProfiles(Frame parent) {
        assert (parent != null);
    }

    public abstract BuildCode generateToolpath();

    public abstract BuildCode getGeneratedToolpath();

    public void emitUpdate(String message) {
        for (GeneratorListener listener : this.listeners) {
            listener.updateGenerator(new GeneratorEvent(this, message, null));
        }
    }

    public void emitCompletion(GeneratorListener.Completion completion) {
        for (GeneratorListener listener : this.listeners) {
            Base.logger.finest("emitCompletion! sent to " + listener.toString());
            listener.generationComplete(new GeneratorEvent(this, null, completion));
        }
    }

    public class GeneratorEvent
    extends EventObject {
        private GeneratorListener.Completion completion;
        private String message;

        public GeneratorEvent(Object source) {
            this(source, "", null);
        }

        public GeneratorEvent(Object source, String message, GeneratorListener.Completion completion) {
            super(source);
            this.message = message;
            this.completion = completion;
        }

        public GeneratorListener.Completion getCompletion() {
            return this.completion;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static interface GeneratorListener {
        public void updateGenerator(GeneratorEvent var1);

        public void generationComplete(GeneratorEvent var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Completion {
            SUCCESS,
            FAILURE;

        }
    }
}

