/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.skeinforge;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.plugin.toolpath.skeinforge.ProfileUtils;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;

class ConfigurationDialog
extends JDialog {
    final boolean postProcessToolheadIndex = true;
    final String profilePref = "replicatorg.skeinforge.profilePref";
    JButton generateButton = new JButton("Generate Gcode");
    JButton cancelButton = new JButton("Cancel");
    private SkeinforgeGenerator parentGenerator = null;
    private List<SkeinforgeGenerator.Profile> profiles = null;
    JPanel profilePanel = new JPanel();
    final JComboBox prefPulldown = new JComboBox();

    private void loadList(JComboBox comboBox) {
        comboBox.removeAllItems();
        this.profiles = this.parentGenerator.getProfiles();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        int i = 0;
        int selectedProfile = -1;
        for (SkeinforgeGenerator.Profile p : this.profiles) {
            model.addElement(p.toString());
            if (p.toString().equals(Base.preferences.get("lastGeneratorProfileSelected", "---"))) {
                Base.logger.fine("Selecting last used element: " + p);
                if (ProfileUtils.shouldDisplay(p)) {
                    selectedProfile = i;
                }
            }
            ++i;
        }
        comboBox.setModel(model);
        if (selectedProfile != -1) {
            comboBox.setSelectedIndex(selectedProfile);
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.parentGenerator = null;
            this.profiles = null;
        }
    }

    public ConfigurationDialog(final Frame parent, SkeinforgeGenerator parentGeneratorIn) {
        super(parent, true);
        this.parentGenerator = parentGeneratorIn;
        this.setTitle("GCode Generator");
        this.setLayout((LayoutManager)new MigLayout("aligny, top, ins 5, fill"));
        this.add((Component)new JLabel("Slicing Profile:"), "split 2");
        this.prefPulldown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ConfigurationDialog.this.generateButton.setEnabled(true);
                ConfigurationDialog.this.generateButton.requestFocusInWindow();
                ConfigurationDialog.this.generateButton.setFocusPainted(true);
            }
        });
        this.loadList(this.prefPulldown);
        this.add((Component)this.prefPulldown, "wrap, growx, gapbottom 10");
        for (SkeinforgeGenerator.SkeinforgePreference preference : this.parentGenerator.getPreferences()) {
            this.add((Component)preference.getUI(), "growx, wrap");
        }
        this.generateButton.setToolTipText("Generates GCode instructions for your machine.");
        this.add((Component)this.generateButton, "tag ok, split 2");
        this.add((Component)this.cancelButton, "tag cancel");
        this.generateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ConfigurationDialog.this.checkIfAccelSpeeds(parent);
                ((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.configSuccess = ConfigurationDialog.this.configureGenerator();
                ConfigurationDialog.this.setVisible(!((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.configSuccess);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.configSuccess = false;
                ConfigurationDialog.this.setVisible(false);
            }
        });
    }

    private void checkIfAccelSpeeds(Frame parent) {
        double travel_rate = 0.0;
        double feed_rate = 0.0;
        for (SkeinforgeGenerator.SkeinforgePreference preference : this.parentGenerator.getPreferences()) {
            List<SkeinforgeGenerator.SkeinforgeOption> options = preference.getOptions("Skeinforge (35) - Legacy");
            if (options == null) continue;
            for (SkeinforgeGenerator.SkeinforgeOption option : options) {
                if (option.getPreference().equals("Travel Feed Rate (mm/s):")) {
                    travel_rate = Double.parseDouble(option.getValue());
                }
                if (!option.getPreference().equals("Feed Rate (mm/s):")) continue;
                feed_rate = Double.parseDouble(option.getValue());
            }
        }
        System.out.println("\n**FEED_RATES**\ndesired:" + feed_rate + "travel:" + travel_rate);
        if ((feed_rate > 40.0 || travel_rate > 55.0) && Base.preferences.getBoolean("build.speed_warning", true)) {
            JOptionPane.showMessageDialog(parent, "You are now slicing with accelerated build speeds.\nDo not print files generated at these speeds unless you have acceleration turned on.\nBuilding high speed files with acceleration turned off can harm your Makerbot.\n\nYou can turn acceleration on in the Onboard Preferences menu or via your Makerbot's onboard menus\n\nTo disable this message, uncheck 'Display Accelerated Speed Warning' in  File->Preferences", "Acceleration Warning", 2);
        }
    }

    protected boolean configureGenerator() {
        if (!this.parentGenerator.runSanityChecks()) {
            return false;
        }
        int idx = this.prefPulldown.getSelectedIndex();
        if (idx == -1) {
            return false;
        }
        SkeinforgeGenerator.Profile p = ProfileUtils.getListedProfile(this.prefPulldown.getModel(), this.profiles, idx);
        Base.preferences.put("lastGeneratorProfileSelected", p.toString());
        this.parentGenerator.profile = p.getFullPath();
        SkeinforgeGenerator.setSelectedProfile(p.toString());
        return true;
    }
}

