/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.slic3r;

import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.util.StreamLoggerThread;
import replicatorg.machine.model.ToolheadAlias;
import replicatorg.model.BuildCode;
import replicatorg.plugin.toolpath.ToolpathGenerator;
import replicatorg.plugin.toolpath.slic3r.ConfigurationDialog;
import replicatorg.plugin.toolpath.slic3r.EditProfileDialog;
import replicatorg.plugin.toolpath.slic3r.Slic3rPostProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Slic3rGenerator
extends ToolpathGenerator {
    public boolean configSuccess;
    ConfigurationDialog cd;
    String profile;
    List<Slic3rPreference> preferences;
    BuildCode output;
    protected final Slic3rPostProcessor postprocess;

    public Slic3rGenerator() {
        displayName = "Slic3r";
        this.configSuccess = false;
        this.profile = null;
        this.postprocess = new Slic3rPostProcessor(this);
    }

    public boolean runSanityChecks() {
        String errors = "";
        for (Slic3rPreference preference : this.getPreferences()) {
            String error = preference.valueSanityCheck();
            if (error == null) continue;
            errors = errors + error;
        }
        if (errors.equals("")) {
            return true;
        }
        int result = JOptionPane.showConfirmDialog(null, "The following non-optimal profile settings were detected:\n\n" + errors + "\n\n" + "Press OK to attempt to generate profile anyway, or Cancel to go back and correct the settings.", "Profile warnings", 2);
        return result == 0;
    }

    public static String getSelectedProfile() {
        String name = Base.preferences.get("replicatorg.slic3r.profile", "");
        return name;
    }

    public static void setSelectedProfile(String name) {
        Base.preferences.put("replicatorg.slic3r.profile", name);
    }

    void getProfilesIn(File dir, List<Profile> profiles) {
        if (dir.exists() && dir.isDirectory()) {
            for (String subpath : dir.list()) {
                File subDir = new File(dir, subpath);
                if (!subDir.isDirectory()) continue;
                profiles.add(new Profile(subDir.getAbsolutePath()));
            }
        }
    }

    public abstract File getUserProfilesDir();

    List<Profile> getProfiles() {
        LinkedList<Profile> profiles = new LinkedList<Profile>();
        File dir = new File(Base.getApplicationFile("slic3r"), "prefs");
        Base.logger.finest("Looking for profiles in: " + dir.toString());
        this.getProfilesIn(dir, profiles);
        dir = this.getUserProfilesDir();
        Base.logger.finest("Looking for profiles in: " + dir.toString());
        this.getProfilesIn(dir, profiles);
        Collections.sort(profiles);
        return profiles;
    }

    public boolean configure(Frame parent, String name) {
        if (name == null) {
            name = "Generate GCode";
        }
        if (parent != null) {
            parent.setName(name);
        }
        this.cd = new ConfigurationDialog(parent, this);
        this.cd.setName(name);
        this.cd.setTitle(name);
        if (Base.preferences.getBoolean("replicatorg.slic3r.printOMatic.enabled", false)) {
            String extruderChoice = Base.preferences.get("replicatorg.slic3r.printOMatic.toolheadOrientation", "does not exist");
            if (extruderChoice.equalsIgnoreCase("right")) {
                this.postprocess.setToolheadTarget(ToolheadAlias.RIGHT);
            } else if (extruderChoice.equalsIgnoreCase("left")) {
                this.postprocess.setToolheadTarget(ToolheadAlias.LEFT);
            }
        }
        return true;
    }

    public ConfigurationDialog visualConfiguregetCD(Frame parent, int x, int y, String name) {
        parent.setName(name);
        this.cd = new ConfigurationDialog(parent, this);
        this.cd.setName(name);
        this.cd.setTitle(name);
        this.cd.pack();
        this.cd.setLocation(x, y);
        this.cd.setVisible(true);
        this.emitUpdate("Config Done");
        return this.cd;
    }

    @Override
    public boolean visualConfigure(Frame parent, int x, int y, String name) {
        this.configure(parent, name);
        if (x == -1 || y == -1) {
            double x2 = parent.getBounds().getCenterX();
            double y2 = parent.getBounds().getCenterY();
            this.cd.pack();
            x = (int)(x2 -= (double)this.cd.getWidth() / 2.0);
            y = (int)(y2 -= (double)this.cd.getHeight() / 2.0);
        } else {
            this.cd.pack();
        }
        this.cd.setLocation(x, y);
        this.cd.setVisible(true);
        this.emitUpdate("Config Done");
        return this.configSuccess;
    }

    @Override
    public boolean visualConfigure(Frame parent) {
        return this.visualConfigure(parent, -1, -1, null);
    }

    @Override
    public boolean nonvisualConfigure() {
        this.configure(null, "");
        this.configSuccess = this.cd.configureGenerator();
        this.emitUpdate("Config Done");
        return this.configSuccess;
    }

    @Override
    public void editProfiles(Frame parent) {
        EditProfileDialog ep = new EditProfileDialog(parent, this);
        double x = parent.getBounds().getCenterX();
        double y = parent.getBounds().getCenterY();
        ep.pack();
        ep.setLocation((int)(x -= (double)ep.getWidth() / 2.0), (int)(y -= (double)ep.getHeight() / 2.0));
        ep.setVisible(true);
    }

    public abstract File getDefaultSlic3rDir();

    public File getSlic3rDir() {
        String slic3rPath = System.getProperty("replicatorg.slic3r.path");
        if (slic3rPath == null || slic3rPath.length() == 0) {
            return this.getDefaultSlic3rDir();
        }
        return new File(slic3rPath);
    }

    public Profile duplicateProfile(Profile originalProfile, String newName) {
        File newProfDir = new File(this.getUserProfilesDir(), newName);
        File oldProfDir = new File(originalProfile.getFullPath());
        try {
            Base.copyDir(oldProfDir, newProfDir);
            Profile newProf = new Profile(newProfDir.getAbsolutePath());
            this.editProfile(newProf);
            return newProf;
        }
        catch (IOException ioe) {
            Base.logger.log(Level.SEVERE, "Couldn't copy directory", ioe);
            return null;
        }
    }

    public void editProfile(Profile profile) {
        block13: {
            String[] arguments;
            ProcessBuilder pb = null;
            if (Base.isWindows()) {
                arguments = new String[]{this.getSlic3rDir() + "\\slic3r.exe", "--ignore-nonexistent-config", "--load", profile.getFullPath() + "\\config.ini"};
                pb = new ProcessBuilder(arguments);
            } else {
                arguments = new String[]{this.getSlic3rDir() + "/slic3r", "--ignore-nonexistent-config", "--load", profile.getFullPath() + "/config.ini"};
                pb = new ProcessBuilder(arguments);
            }
            File slic3rDir = this.getSlic3rDir();
            pb.directory(slic3rDir);
            Process process = null;
            Base.logger.log(Level.FINEST, "Starting Slic3r process...");
            try {
                long timeoutValue;
                int value = 1;
                process = pb.start();
                if (timeoutValue == -1L) {
                    Base.logger.log(Level.FINEST, "\tRunning Slic3r without a timeout");
                    value = process.waitFor();
                } else {
                    Base.logger.log(Level.FINEST, "\tRunning Slic3r with a timeout");
                    for (timeoutValue = (long)Base.preferences.getInt("replicatorg.slic3r.timeout", -1); timeoutValue > 0L; --timeoutValue) {
                        Thread.sleep(1000L);
                        try {
                            value = process.exitValue();
                            break;
                        }
                        catch (IllegalThreadStateException itse) {
                            continue;
                        }
                    }
                    if (timeoutValue == 0L) {
                        JOptionPane.showConfirmDialog(null, "\tSlic3r has not returned, This may be due to a communication error\nbetween Slic3r and ReplicatorG. If you are still editing a Slic3r\nprofile, ignore this message; any changes you make in the Slic3r window\nand save will be used when generating the gcode file.\n\n\tAdjusting the \"Slic3r timeout\" in the preferences window will affect how\nlong ReplicatorG waits before assuming that Slic3r has failed, if you\nfrequently encounter this message you may want to increase the timeout.", "SF Timeout", -1, 1);
                    }
                }
                Base.logger.log(Level.FINEST, "Slic3r process returned");
                if (value != 0) {
                    Base.logger.severe("Unrecognized error code returned by Slic3r.");
                } else {
                    Base.logger.log(Level.FINEST, "Normal Exit on Slic3r close");
                }
            }
            catch (IOException ioe) {
                Base.logger.log(Level.SEVERE, "Could not run Slic3r.", ioe);
            }
            catch (InterruptedException e) {
                System.out.println("Slic3rGenerator.editProfile() interrupted: " + e);
                if (process == null) break block13;
                process.destroy();
            }
        }
    }

    public abstract List<Slic3rPreference> initPreferences();

    public List<Slic3rPreference> getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.initPreferences();
        }
        return this.preferences;
    }

    public Slic3rPostProcessor getPostProcessor() {
        return this.postprocess;
    }

    @Override
    public BuildCode generateToolpath() {
        String path = this.model.getPath();
        LinkedList<String> arguments = new LinkedList<String>();
        String[] baseArguments = new String[]{};
        baseArguments = Base.isWindows() ? new String[]{this.getSlic3rDir() + "\\slic3r-console.exe", "--debug", "--ignore-nonexistent-config", "--load", this.profile + "\\config.ini"} : new String[]{this.getSlic3rDir() + "/slic3r", "--debug", "--ignore-nonexistent-config", "--load", this.profile + "/config.ini"};
        for (String arg : baseArguments) {
            arguments.add(arg);
        }
        for (Slic3rPreference preference : this.getPreferences()) {
            List<Slic3rOption> options = preference.getOptions();
            if (options == null) continue;
            for (Slic3rOption option : options) {
                arguments.add(option.getParameter());
                String arg = option.getArgument();
                if (arg.length() <= 0) continue;
                arguments.add(arg);
            }
        }
        arguments.add(path);
        for (String a : arguments) {
            System.out.println(a);
        }
        ProcessBuilder pb = new ProcessBuilder(arguments);
        pb.directory(this.getSlic3rDir());
        Process process = null;
        try {
            process = pb.start();
            StreamLoggerThread ist = new StreamLoggerThread(process.getInputStream()){

                protected void logMessage(String line) {
                    Slic3rGenerator.this.emitUpdate(line);
                    super.logMessage(line);
                }
            };
            StreamLoggerThread est = new StreamLoggerThread(process.getErrorStream());
            est.setDefaultLevel(Level.SEVERE);
            ist.setDefaultLevel(Level.FINE);
            ist.start();
            est.start();
            int value = process.waitFor();
            if (value != 0) {
                Base.logger.severe("Unrecognized error code returned by Slic3r.");
                return null;
            }
        }
        catch (IOException ioe) {
            Base.logger.log(Level.SEVERE, "Could not run Slic3r.", ioe);
            return null;
        }
        catch (InterruptedException e) {
            if (process != null) {
                process.destroy();
            }
            return null;
        }
        int lastIdx = path.lastIndexOf(46);
        String root = lastIdx >= 0 ? path.substring(0, lastIdx) : path;
        this.output = new BuildCode(root, new File(root + ".gcode"));
        if (this.postprocess != null) {
            Base.logger.log(Level.FINER, "pre-post-processor");
            this.postprocess.runPostProcessing();
            Base.logger.log(Level.FINER, "post-post-processor");
        }
        return this.output;
    }

    @Override
    public BuildCode getGeneratedToolpath() {
        return this.output;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Slic3rBooleanPreference
    implements Slic3rPreference {
        private boolean isSet;
        private JCheckBox component;
        private List<Slic3rOption> trueOptions = new LinkedList<Slic3rOption>();
        private List<Slic3rOption> falseOptions = new LinkedList<Slic3rOption>();
        private String name;

        public Slic3rBooleanPreference(String name, final String preferenceName, boolean defaultState, String toolTip) {
            this.isSet = defaultState;
            if (preferenceName != null) {
                this.isSet = Base.preferences.getBoolean(preferenceName, defaultState);
            }
            this.name = name;
            this.component = new JCheckBox(name, this.isSet);
            this.component.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Slic3rBooleanPreference.this.isSet = Slic3rBooleanPreference.this.component.isSelected();
                    if (preferenceName != null) {
                        Base.preferences.putBoolean(preferenceName, Slic3rBooleanPreference.this.isSet);
                    }
                }
            });
            if (toolTip != null) {
                this.component.setToolTipText(toolTip);
            }
        }

        @Override
        public JComponent getUI() {
            return this.component;
        }

        public void addTrueOption(Slic3rOption o) {
            this.trueOptions.add(o);
        }

        public void addFalseOption(Slic3rOption o) {
            this.falseOptions.add(o);
        }

        public void addNegateableOption(Slic3rOption o) {
            this.trueOptions.add(o);
            String negated = o.value.equalsIgnoreCase("1") ? "0" : "1";
            this.falseOptions.add(new Slic3rOption(o.parameter, negated));
        }

        @Override
        public List<Slic3rOption> getOptions() {
            return this.isSet ? this.trueOptions : this.falseOptions;
        }

        @Override
        public String valueSanityCheck() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Slic3rChoicePreference
    implements Slic3rPreference {
        private Map<String, List<Slic3rOption>> optionsMap = new HashMap<String, List<Slic3rOption>>();
        private JPanel component = new JPanel((LayoutManager)new MigLayout("ins 5"));
        private DefaultComboBoxModel model;
        private String chosen;
        private String name;

        public Slic3rChoicePreference(String name, final String preferenceName, String defaultState, String toolTip) {
            this.chosen = defaultState;
            if (preferenceName != null) {
                this.chosen = Base.preferences.get(preferenceName, defaultState);
            }
            this.model = new DefaultComboBoxModel();
            this.model.setSelectedItem(this.chosen);
            this.name = name;
            this.component.add(new JLabel(name));
            JComboBox cb = new JComboBox(this.model);
            this.component.add(cb);
            cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Slic3rChoicePreference.this.chosen = (String)Slic3rChoicePreference.this.model.getSelectedItem();
                    if (preferenceName != null) {
                        Base.preferences.put(preferenceName, Slic3rChoicePreference.this.chosen);
                    }
                }
            });
            if (toolTip != null) {
                this.component.setToolTipText(toolTip);
            }
        }

        @Override
        public JComponent getUI() {
            return this.component;
        }

        public void addOption(String name, Slic3rOption o) {
            if (!this.optionsMap.containsKey(name)) {
                this.model.addElement(name);
                this.optionsMap.put(name, new LinkedList());
                if (name.equals(this.chosen)) {
                    this.model.setSelectedItem(name);
                }
            }
            List<Slic3rOption> list = this.optionsMap.get(name);
            list.add(o);
        }

        @Override
        public List<Slic3rOption> getOptions() {
            if (this.optionsMap.containsKey(this.chosen)) {
                List<Slic3rOption> l = this.optionsMap.get(this.chosen);
                for (Slic3rOption o : l) {
                    Base.logger.fine(o.getArgument());
                }
                return this.optionsMap.get(this.chosen);
            }
            return new LinkedList<Slic3rOption>();
        }

        @Override
        public String valueSanityCheck() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Slic3rPreference {
        public JComponent getUI();

        public List<Slic3rOption> getOptions();

        public String valueSanityCheck();

        public String getName();
    }

    protected static class Slic3rOption {
        final String parameter;
        final String module;
        final String preference;
        final String value;

        public Slic3rOption(String parameter) {
            this.parameter = parameter;
            this.module = null;
            this.preference = null;
            this.value = "";
        }

        public Slic3rOption(String parameter, String value) {
            this.parameter = parameter;
            this.module = null;
            this.preference = null;
            this.value = value;
        }

        public String getParameter() {
            return this.parameter;
        }

        public String getArgument() {
            return (this.module != null ? this.module + ":" : "") + (this.preference != null ? this.preference + "=" : "") + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Profile
    implements Comparable<Profile> {
        private String fullPath;
        private String name;
        private Set<String> targetMachines = new TreeSet<String>();

        public Profile(String fullPath) {
            this.fullPath = fullPath;
            int idx = fullPath.lastIndexOf(File.separatorChar);
            this.name = idx >= 0 ? fullPath.substring(idx + 1) : fullPath;
            File targetsFile = new File(fullPath + File.separator + "targetMachines.csv");
            if (targetsFile.exists()) {
                try {
                    BufferedReader bir = new BufferedReader(new FileReader(targetsFile));
                    String curline = bir.readLine();
                    while (curline != null) {
                        this.targetMachines.addAll(Arrays.asList(curline.split(",")));
                        curline = bir.readLine();
                    }
                    bir.close();
                    for (String machine : this.targetMachines) {
                        machine = machine.trim();
                    }
                }
                catch (FileNotFoundException e) {
                    Base.logger.log(Level.FINEST, "Didn't find a targetMachines file in " + fullPath, e);
                }
                catch (IOException e) {
                    Base.logger.log(Level.FINEST, "Didn't find a targetMachines file in " + fullPath, e);
                }
            }
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public String toString() {
            return this.name;
        }

        public Set<String> getTargetMachines() {
            return this.targetMachines;
        }

        @Override
        public int compareTo(Profile o) {
            return this.name.compareTo(o.name);
        }
    }
}

