/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.slic3r;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.gcode.MutableGCodeSource;
import replicatorg.machine.model.MachineType;
import replicatorg.machine.model.ToolheadAlias;
import replicatorg.model.BuildCode;
import replicatorg.model.GCodeSource;
import replicatorg.plugin.toolpath.slic3r.Slic3rGenerator;

public class Slic3rPostProcessor {
    private final Slic3rGenerator generator;
    private MutableGCodeSource source;
    private MutableGCodeSource startCode = null;
    private MutableGCodeSource endCode = null;
    private ToolheadAlias toolheadTarget = null;
    private MachineType machineType = null;
    private boolean dualstruding = false;
    private boolean prependStart = false;
    private boolean appendEnd = false;
    private boolean prependMetaInfo = false;
    private boolean multiHead = false;
    private boolean addProgressUpdates = true;
    private PostProcessorPreference ppp;

    public Slic3rPostProcessor(Slic3rGenerator generator) {
        this.generator = generator;
        this.ppp = new PostProcessorPreference(this);
    }

    protected BuildCode runPostProcessing() {
        this.source = new MutableGCodeSource(this.generator.output.file);
        if (!this.dualstruding) {
            if (this.prependStart) {
                this.runPrepend(this.startCode);
            }
            if (this.appendEnd) {
                this.runAppend(this.endCode);
            }
            if (!this.multiHead) {
                this.toolheadTarget = ToolheadAlias.SINGLE;
            }
            if (this.toolheadTarget != null) {
                this.runToolheadSwap(this.toolheadTarget);
            }
        }
        if (this.addProgressUpdates) {
            this.source.addSlic3rProgressUpdates();
        }
        if (this.prependMetaInfo) {
            MutableGCodeSource metaInfo = new MutableGCodeSource();
            String curDate = this.getPrettyPrintDate();
            String machineName = this.machineType != null ? this.machineType.getName() : "CNC Machine";
            metaInfo.add("(** This GCode was generated by ReplicatorG " + Base.VERSION_NAME + " **)");
            metaInfo.add("(*  using " + Slic3rGenerator.displayName + "  *)");
            metaInfo.add("(*  for a " + (this.multiHead ? "Dual headed " : "Single headed ") + machineName + "  *)");
            metaInfo.add("(*  on " + curDate + " *)");
            this.runPrepend(metaInfo);
        }
        this.source.writeToFile(this.generator.output.file);
        return this.generator.output;
    }

    private String getPrettyPrintDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss (Z)");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private void runToolheadSwap(ToolheadAlias switchTo) {
        System.out.println("runToolheadSwap");
        this.source.changeToolhead(switchTo);
    }

    private void runPrepend(GCodeSource newCode) {
        if (newCode != null) {
            this.source.add(0, newCode);
        }
    }

    private void runAppend(GCodeSource newCode) {
        if (newCode != null) {
            this.source.add(newCode);
        }
    }

    public void enableDualstrusion() {
        this.dualstruding = true;
        List<Slic3rGenerator.Slic3rPreference> prefs = this.generator.getPreferences();
        prefs.add(0, new Slic3rGenerator.Slic3rPreference(){
            Slic3rGenerator.Slic3rBooleanPreference outlineActive = new Slic3rGenerator.Slic3rBooleanPreference("Outline Active", "slic3r.dualstrusion.outlineActive", false, "<html>Having Outline active for any layer but the first layer<br/>for the first toolhead can damage dualstrusion prints.</html>");
            Slic3rGenerator.Slic3rBooleanPreference coolActive;
            {
                this.outlineActive.addNegateableOption(new Slic3rGenerator.Slic3rOption("--skirts", "1"));
            }

            @Override
            public JComponent getUI() {
                JPanel panel = new JPanel();
                panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                panel.setLayout((LayoutManager)new MigLayout("fillx, filly"));
                panel.add((Component)new JLabel("Dualstruding..."), "growx, wrap");
                panel.add((Component)this.outlineActive.getUI(), "growx, wrap");
                return panel;
            }

            @Override
            public List<Slic3rGenerator.Slic3rOption> getOptions() {
                ArrayList<Slic3rGenerator.Slic3rOption> result = new ArrayList<Slic3rGenerator.Slic3rOption>();
                result.add(new Slic3rGenerator.Slic3rOption("--start-gcode", ""));
                result.add(new Slic3rGenerator.Slic3rOption("--end-gcode", ""));
                result.addAll(this.outlineActive.getOptions());
                return result;
            }

            @Override
            public String valueSanityCheck() {
                return null;
            }

            @Override
            public String getName() {
                return "Dualstrusion options";
            }
        });
    }

    public void setToolheadTarget(ToolheadAlias tool) {
        this.toolheadTarget = tool;
    }

    public void setMachineType(MachineType type) {
        this.machineType = type;
    }

    public void setStartCode(GCodeSource source) {
        this.startCode = source == null ? null : (source instanceof MutableGCodeSource ? (MutableGCodeSource)source : new MutableGCodeSource(source));
    }

    public void setEndCode(GCodeSource source) {
        if (source == null) {
            this.endCode = null;
        }
        this.endCode = source instanceof MutableGCodeSource ? (MutableGCodeSource)source : new MutableGCodeSource(source);
    }

    public void setPrependStart(boolean doPrepend) {
        this.prependStart = doPrepend;
    }

    public void setAppendEnd(boolean doAppend) {
        this.appendEnd = doAppend;
    }

    public void setPrependMetaInfo(boolean doPrepend) {
        this.prependMetaInfo = doPrepend;
    }

    public void setMultiHead(boolean isMulti) {
        this.multiHead = isMulti;
        this.ppp.refreshPreferences();
    }

    public void setAddProgressUpdates(boolean doAdd) {
        this.addProgressUpdates = doAdd;
    }

    public PostProcessorPreference getPreference() {
        return this.ppp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PostProcessorPreference
    implements Slic3rGenerator.Slic3rPreference {
        private final JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, ins 0"));
        private final Slic3rPostProcessor processor;

        public PostProcessorPreference(Slic3rPostProcessor spp) {
            this.processor = spp;
        }

        public void refreshPreferences() {
            this.panel.removeAll();
            if (Slic3rPostProcessor.this.multiHead && !Slic3rPostProcessor.this.dualstruding) {
                Vector<String> extruders = new Vector<String>();
                extruders.add(ToolheadAlias.RIGHT.guiName);
                extruders.add(ToolheadAlias.LEFT.guiName);
                String value = Base.preferences.get("replicatorg.slic3r.toolheadOrientation", (String)extruders.firstElement());
                final DefaultComboBoxModel model = new DefaultComboBoxModel(extruders);
                JComboBox input = new JComboBox(model);
                final JCheckBox toolSwap = new JCheckBox("Use");
                this.panel.add((Component)toolSwap, "split");
                this.panel.add(input, "split");
                this.panel.add((Component)new JLabel("extruder"), "wrap");
                ActionListener toolSelected = new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        Base.preferences.putBoolean("replicatorg.slic3r.setToolheadOrientation", toolSwap.isSelected());
                        if (toolSwap.isSelected()) {
                            if (model.getSelectedItem().equals(ToolheadAlias.LEFT.guiName)) {
                                PostProcessorPreference.this.processor.toolheadTarget = ToolheadAlias.LEFT;
                                Base.preferences.put("replicatorg.slic3r.toolheadOrientation", ToolheadAlias.LEFT.guiName);
                            } else if (model.getSelectedItem().equals(ToolheadAlias.RIGHT.guiName)) {
                                PostProcessorPreference.this.processor.toolheadTarget = ToolheadAlias.RIGHT;
                                Base.preferences.put("replicatorg.slic3r.toolheadOrientation", ToolheadAlias.RIGHT.guiName);
                            }
                        } else {
                            PostProcessorPreference.this.processor.toolheadTarget = null;
                            Base.preferences.put("replicatorg.slic3r.toolheadOrientation", "-");
                        }
                    }
                };
                input.addActionListener(toolSelected);
                toolSwap.addActionListener(toolSelected);
                toolSwap.setSelected(Base.preferences.getBoolean("replicatorg.slic3r.setToolheadOrientation", true));
                model.setSelectedItem(value);
                input.setToolTipText("select which extruder this gcode prints on");
            }
        }

        @Override
        public JComponent getUI() {
            return this.panel;
        }

        @Override
        public List<Slic3rGenerator.Slic3rOption> getOptions() {
            return new ArrayList<Slic3rGenerator.Slic3rOption>();
        }

        @Override
        public String valueSanityCheck() {
            return null;
        }

        @Override
        public String getName() {
            return "Post-Processor options";
        }
    }
}

