/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app;

import ch.randelshofer.quaqua.QuaquaManager;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOpenDocumentHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import replicatorg.app.DataCapture;
import replicatorg.app.ui.MainWindow;
import replicatorg.app.ui.NotificationHandler;
import replicatorg.drivers.DriverQueryInterface;
import replicatorg.machine.MachineInterface;
import replicatorg.machine.MachineLoader;
import replicatorg.uploader.FirmwareUploader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base {
    public static final int VERSION = 40;
    public static final int REVISION = 34;
    public static final String VERSION_NAME = String.format("Sailfish - %dr%2d", 40, 34);
    private static MachineLoader machineLoader;
    public static Preferences preferences;
    public static DataCapture capture;
    public static Logger logger;
    public static FileHandler logFileHandler;
    public static String logFilePath;
    public static String openedAtStartup;
    private static String alternatePrefs;
    private static NumberFormat localNF;
    private static NumberFormat gcodeNF;
    static MainWindow editor;
    private static NotificationHandler notificationHandler;
    private static final String[] supportedExtensions;
    public static final String javaVersionName;
    public static final float javaVersion;
    public static Platform platform;
    public static Arch arch;
    public static String platformName;

    public static String expanduser(String path) {
        String user = System.getProperty("user.home");
        return path.replaceFirst("~", user);
    }

    public static void setLogFile(String path) {
        boolean useLogFile = preferences.getBoolean("replicatorg.useLogFile", false);
        String explicitPath = Base.expanduser(path);
        if (useLogFile && explicitPath.equals(logFilePath)) {
            return;
        }
        if (logFileHandler != null) {
            logger.removeHandler(logFileHandler);
            logFileHandler = null;
        }
        logFilePath = explicitPath;
        if (useLogFile && logFilePath != null && logFilePath.length() > 0) {
            boolean append = true;
            try {
                FileHandler fh = new FileHandler(logFilePath, append);
                fh.setFormatter(new SimpleFormatter());
                fh.setLevel(Level.ALL);
                logFileHandler = fh;
                logger.addHandler(fh);
            }
            catch (IOException ioe) {
                String msg = "LOG INIT ERROR: Could not open file.\n" + ioe.getMessage();
                System.err.println(msg);
                logger.log(Level.SEVERE, msg);
            }
        }
    }

    public static void setAlternatePrefs(String name) {
        alternatePrefs = name;
        preferences = Base.getUserPreferences();
    }

    static Preferences getUserPreferences() {
        Preferences prefs = Preferences.userNodeForPackage(Base.class);
        if (alternatePrefs != null) {
            prefs = prefs.node("alternate/" + alternatePrefs);
        }
        return prefs;
    }

    private static void moveAll(File source, File target) {
        try {
            if (source.isDirectory()) {
                if (!target.exists()) {
                    target.mkdir();
                }
                for (String s : source.list()) {
                    Base.moveAll(new File(source, s), new File(target, s));
                }
                source.delete();
            } else if (source.isFile()) {
                source.renameTo(target);
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
    }

    public static void resetPreferences() {
        try {
            preferences.removeNode();
            preferences.flush();
            preferences = Base.getUserPreferences();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
        File userDir = Base.getUserDirectory();
        try {
            File backupDir = new File(userDir.getParentFile(), ".replicatorg-backup-" + Long.toString(System.nanoTime()));
            backupDir.mkdir();
            Base.moveAll(userDir, backupDir);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
    }

    public static String getToolsPath() {
        String toolsDir = System.getProperty("replicatorg.toolpath");
        if (toolsDir == null || toolsDir.length() == 0) {
            File appDir = Base.getApplicationDirectory();
            toolsDir = appDir.getAbsolutePath() + File.separator + "tools";
        }
        return toolsDir;
    }

    public static File getUserDirectory() {
        File dir;
        String path = System.getProperty("user.home") + File.separator + ".replicatorg";
        if (alternatePrefs != null) {
            path = path + File.separator + alternatePrefs;
        }
        if (!(dir = new File(path)).exists()) {
            dir.mkdirs();
            if (!dir.exists()) {
                logger.severe("We could not create a user directory at: " + path);
                return null;
            }
        }
        return dir;
    }

    public static File getApplicationDirectory() {
        if (Base.isMacOS()) {
            try {
                File x = new File(".");
                String baseDir = x.getCanonicalPath();
                if (new File(baseDir + "/ReplicatorG.app/Contents/Resources").exists()) {
                    return new File(baseDir + "/ReplicatorG.app/Contents/Resources");
                }
                logger.severe(baseDir + "/ReplicatorG.app not found, using " + baseDir + "/replicatorg/");
                return new File(baseDir + "/replicatorg");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new File(System.getProperty("user.dir"));
    }

    public static File getApplicationFile(String path) {
        return new File(Base.getApplicationDirectory(), path);
    }

    public static File getUserFile(String path) {
        return Base.getUserFile(path, true);
    }

    public static File getUserDir(String path) {
        return Base.getUserDir(path, true);
    }

    public static NumberFormat getLocalFormat() {
        return localNF;
    }

    public static NumberFormat getGcodeFormat() {
        return gcodeNF;
    }

    public static File getUserFile(String path, boolean autoCopy) {
        File original;
        if (path.contains("..")) {
            logger.info("Attempted to access parent directory in " + path + ", skipping");
            return null;
        }
        File f = new File(Base.getUserDirectory(), path);
        File dir = f.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (autoCopy && !f.exists() && (original = Base.getApplicationFile(path)).exists()) {
            try {
                Base.copyFile(original, f);
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Couldn't copy " + path + " to your local .replicatorG directory", f);
            }
        }
        return f;
    }

    public static File getUserDir(String path, boolean autoCopy) {
        File original;
        if (path.contains("..")) {
            logger.info("Attempted to access parent directory in " + path + ", skipping");
            return null;
        }
        File f = new File(Base.getUserDirectory(), path);
        File dir = f.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (autoCopy && !f.exists() && (original = Base.getApplicationFile(path)).exists()) {
            try {
                Base.copyDir(original, f);
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Couldn't copy " + path + " to your local .replicatorG directory", f);
            }
        }
        return f;
    }

    public static Font getFontPref(String name, String defaultValue) {
        String s = preferences.get(name, defaultValue);
        StringTokenizer st = new StringTokenizer(s, ",");
        String fontname = st.nextToken();
        String fontstyle = st.nextToken();
        return new Font(fontname, (fontstyle.indexOf("bold") != -1 ? 1 : 0) | (fontstyle.indexOf("italic") != -1 ? 2 : 0), Integer.parseInt(st.nextToken()));
    }

    public static Color getColorPref(String name, String defaultValue) {
        String s = preferences.get(name, defaultValue);
        Color parsed = null;
        if (s != null && s.indexOf("#") == 0) {
            try {
                int v = Integer.parseInt(s.substring(1), 16);
                parsed = new Color(v);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return parsed;
    }

    public static MainWindow getEditor() {
        return editor;
    }

    public static String getExtension(String path) {
        String[] split = path.split("\\.");
        return split[split.length - 1];
    }

    public static boolean supportedExtension(String path) {
        String suffix = Base.getExtension(path);
        for (String s : supportedExtensions) {
            if (!s.equals(suffix)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        if (javaVersion < 1.5f) {
            Base.quitWithError("Need to install Java 1.5", "This version of ReplicatorG requires\nJava 1.5 or later to run properly.\nPlease visit java.com to upgrade.", null);
        }
        if (Base.isMacOS()) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "ReplicatorG");
        }
        boolean cleanPrefs = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--alternate-prefs")) {
                if (i + 1 >= args.length) continue;
                Base.setAlternatePrefs(args[++i]);
                continue;
            }
            if (args[i].equals("--clean-prefs")) {
                cleanPrefs = true;
                continue;
            }
            if (args[i].equals("--debug")) {
                int debugLevelArg = 2;
                if (i + 1 < args.length) {
                    try {
                        debugLevelArg = Integer.parseInt(args[i + 1]);
                        ++i;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (debugLevelArg == 0) {
                    logger.setLevel(Level.INFO);
                    logger.info("Debug level is 'INFO'");
                    continue;
                }
                if (debugLevelArg == 1) {
                    logger.setLevel(Level.FINE);
                    logger.info("Debug level is 'FINE'");
                    continue;
                }
                if (debugLevelArg == 2) {
                    logger.setLevel(Level.FINER);
                    logger.info("Debug level is 'FINER'");
                    continue;
                }
                if (debugLevelArg == 3) {
                    logger.setLevel(Level.FINEST);
                    logger.info("Debug level is 'FINEST'");
                    continue;
                }
                if (debugLevelArg < 4) continue;
                logger.setLevel(Level.ALL);
                logger.info("Debug level is 'ALL'");
                continue;
            }
            if (args[i].startsWith("-")) {
                System.out.println("Usage: ./replicatorg [--debug DEBUGLEVEL] [--alternate-prefs ALTERNATE_PREFS_NAME] [--clean-prefs] [filename.stl]");
                System.exit(1);
                continue;
            }
            if (!Base.supportedExtension(args[i])) continue;
            openedAtStartup = args[i];
        }
        System.setProperty("java.net.useSystemProxies", "true");
        System.setProperty("j3d.implicitAntialiasing", "true");
        FirmwareUploader.checkFirmware();
        MRJOpenDocumentHandler startupOpen = new MRJOpenDocumentHandler(){

            public void handleOpenFile(File file) {
                if (openedAtStartup == null) {
                    openedAtStartup = file.getAbsolutePath();
                }
            }
        };
        MRJApplicationUtils.registerOpenDocumentHandler((MRJOpenDocumentHandler)startupOpen);
        new Base(cleanPrefs);
    }

    private void checkDirectories() {
        File repGDir;
        File userDir = Base.getUserDirectory();
        String header = null;
        if (!userDir.exists()) {
            header = new String("Unable to create user directory");
        } else if (!userDir.canWrite()) {
            header = new String("Unable to write to user directory");
        } else if (!userDir.isDirectory()) {
            header = new String("User directory must be a directory");
        }
        if (header != null) {
            Base.showMessage(header, "<html><body>ReplicatorG can not write to the directory " + userDir.getAbsolutePath() + ".<br>" + "Some functions of ReplicatorG, like toolpath generation and firmware updates,<br>" + "require ReplicatorG to write data to this directory.  You should end this<br>" + "session, change the permissions on this directory, and start again.");
        }
        if (!(repGDir = Base.getApplicationDirectory()).canWrite()) {
            Base.showMessage("ReplicatorG directory is read-only", "<html><body>ReplicatorG can not write to the directory " + repGDir.getPath() + ".<br>" + "You may be running ReplicatorG from an archive or other read-only directory.<br>" + "Please quit ReplicatorG and extract it to a writeable location, then start again.");
        }
    }

    public Base(boolean cleanPrefs) {
        String levelName = preferences.get("replicatorg.debuglevel", Level.INFO.getName());
        Level l = Level.parse(levelName);
        logger.setLevel(l);
        String logPath = preferences.get("replicatorg.logpath", "");
        Base.setLogFile(logPath);
        gcodeNF = new DecimalFormat("##0.0##");
        DecimalFormatSymbols dfs = ((DecimalFormat)gcodeNF).getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        if (cleanPrefs) {
            Base.resetPreferences();
        }
        try {
            if (Base.isMacOS()) {
                HashSet<String> includes = new HashSet<String>();
                includes.add("ColorChooser");
                includes.add("FileChooser");
                includes.add("Component");
                includes.add("Browser");
                includes.add("Tree");
                includes.add("SplitPane");
                QuaquaManager.setIncludedUIs(includes);
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            } else if (Base.isLinux()) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String machine = preferences.get("machine.name", null);
                if (machine == null) {
                    preferences.put("machine.name", "The Replicator Dual (Sailfish)");
                }
                editor = new MainWindow();
                notificationHandler = NotificationHandler.Factory.getHandler(editor, preferences.getBoolean("ui.preferSystemTrayNotifications", false));
                editor.restorePreferences();
                Runtime.getRuntime().addShutdownHook(new Thread("Shutdown Hook"){
                    private final MainWindow w;
                    {
                        this.w = editor;
                    }

                    public void run() {
                        this.w.onShutdown();
                    }
                });
                boolean autoconnect = preferences.getBoolean("replicatorg.autoconnect", false);
                String machineName = preferences.get("machine.name", "");
                editor.loadMachine(machineName, autoconnect);
                editor.setVisible(true);
                Base.this.checkDirectories();
            }
        });
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
            logger.fine("JVM: " + System.getProperty("java.version") + " " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.version") + " " + System.getProperty("java.vendor") + ")");
        }
    }

    public static boolean isMacOS() {
        return platform == Platform.MACOSX;
    }

    public static boolean isWindows() {
        return platform == Platform.WINDOWS;
    }

    public static boolean isLinux() {
        return platform == Platform.LINUX;
    }

    public static boolean isx86_64() {
        return arch == Arch.x86_64;
    }

    public static boolean isx86() {
        return arch == Arch.x86;
    }

    public static void registerWindowCloseKeys(JRootPane root, ActionListener disposer) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        root.registerKeyboardAction(disposer, stroke, 2);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        stroke = KeyStroke.getKeyStroke(87, modifiers);
        root.registerKeyboardAction(disposer, stroke, 2);
    }

    public static void openURL(String url) {
        try {
            if (Base.isWindows()) {
                if (url.startsWith("http://")) {
                    Runtime.getRuntime().exec("cmd /c start " + url);
                } else {
                    Runtime.getRuntime().exec("cmd /c \"" + url + "\"");
                }
            } else if (Base.isMacOS()) {
                if (!url.startsWith("http://") && (url = "file://" + url).indexOf(32) != -1) {
                    StringBuffer sb = new StringBuffer();
                    char[] c = url.toCharArray();
                    for (int i = 0; i < c.length; ++i) {
                        if (c[i] == ' ') {
                            sb.append("%20");
                            continue;
                        }
                        sb.append(c[i]);
                    }
                    url = sb.toString();
                }
                MRJFileUtils.openURL((String)url);
            } else if (Base.isLinux()) {
                String launcher = preferences.get("launcher.linux", "gnome-open");
                if (launcher != null) {
                    Runtime.getRuntime().exec(new String[]{launcher, url});
                }
            } else {
                String launcher = preferences.get("launcher", null);
                if (launcher != null) {
                    Runtime.getRuntime().exec(new String[]{launcher, url});
                } else {
                    logger.warning("Unspecified platform, no launcher available.");
                }
            }
        }
        catch (IOException e) {
            Base.showWarning("Could not open URL", "An error occurred while trying to open\n" + url, e);
        }
    }

    public static boolean openFolderAvailable() {
        if (Base.isWindows() || Base.isMacOS()) {
            return true;
        }
        if (Base.isLinux()) {
            if (preferences.get("launcher.linux", null) != null) {
                return true;
            }
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                p.waitFor();
                preferences.put("launcher.linux", "gnome-open");
                return true;
            }
            catch (Exception e) {
                try {
                    Process p = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    p.waitFor();
                    preferences.put("launcher.linux", "kde-open");
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static void openFolder(File file) {
        try {
            String launcher;
            String folder = file.getAbsolutePath();
            if (Base.isWindows()) {
                Runtime.getRuntime().exec("explorer \"" + folder + "\"");
            } else if (Base.isMacOS()) {
                Base.openURL(folder);
            } else if (Base.isLinux() && (launcher = preferences.get("launcher.linux", null)) != null) {
                Runtime.getRuntime().exec(new String[]{launcher, folder});
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void showMessage(String title, String message) {
        if (notificationHandler == null) {
            notificationHandler = NotificationHandler.Factory.getHandler(null, false);
        }
        notificationHandler.showMessage(title, message);
    }

    public static void showWarning(String title, String message, Exception e) {
        if (notificationHandler == null) {
            notificationHandler = NotificationHandler.Factory.getHandler(null, false);
        }
        notificationHandler.showWarning(title, message, e);
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void quitWithError(String title, String message, Throwable e) {
        notificationHandler.showError(title, message, e);
        if (e != null) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    public static String getContents(String what) {
        File appBase = Base.getApplicationDirectory();
        return appBase.getAbsolutePath() + File.separator + what;
    }

    public static String getLibContents(String what) {
        String appResources = System.getProperty("replicatorg.app-resources");
        if (appResources != null) {
            return appResources + File.separator + what;
        }
        return Base.getContents("lib" + File.separator + what);
    }

    public static Image getDirectImage(String name, Component who) {
        Image image = null;
        URL url = ClassLoader.getSystemResource(name);
        try {
            image = Toolkit.getDefaultToolkit().createImage(url);
            MediaTracker tracker = new MediaTracker(who);
            tracker.addImage(image, 0);
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return image;
    }

    public static BufferedImage getImage(String name, Component who) {
        BufferedImage image = null;
        URL url = ClassLoader.getSystemResource(name);
        try {
            image = ImageIO.read(url);
            MediaTracker tracker = new MediaTracker(who);
            tracker.addImage(image, 0);
            tracker.waitForAll();
            BufferedImage img2 = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            img2.getGraphics().drawImage(image, 0, 0, null);
            image = img2;
        }
        catch (InterruptedException e) {
            logger.log(Level.FINE, "Could not load image: " + name, e);
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Could not load image: " + name, ioe);
        }
        catch (IllegalArgumentException iae) {
            logger.log(Level.FINE, "Could not load image: " + name, iae);
        }
        return image;
    }

    public static InputStream getStream(String filename) throws IOException {
        return new FileInputStream(Base.getLibContents(filename));
    }

    public static void copyFile(File afile, File bfile) throws IOException {
        int bytesRead;
        BufferedInputStream from = new BufferedInputStream(new FileInputStream(afile));
        BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(bfile));
        byte[] buffer = new byte[16384];
        while ((bytesRead = ((InputStream)from).read(buffer)) != -1) {
            ((OutputStream)to).write(buffer, 0, bytesRead);
        }
        ((OutputStream)to).flush();
        ((InputStream)from).close();
        from = null;
        ((OutputStream)to).close();
        to = null;
        bfile.setLastModified(afile.lastModified());
    }

    public static String loadFile(File file) throws IOException {
        logger.info("Load file : " + file.getAbsolutePath());
        if (file.length() == 0L) {
            return "";
        }
        InputStreamReader isr = new InputStreamReader(new FileInputStream(file));
        BufferedReader reader = new BufferedReader(isr);
        StringBuffer buffer = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append('\n');
        }
        reader.close();
        return buffer.toString();
    }

    public static void saveFile(String str, File file) throws IOException {
        logger.info("Saving as " + file.getCanonicalPath());
        ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes());
        InputStreamReader isr = new InputStreamReader(bis);
        BufferedReader reader = new BufferedReader(isr);
        FileWriter fw = new FileWriter(file);
        PrintWriter writer = new PrintWriter(new BufferedWriter(fw));
        String line = null;
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        writer.flush();
        writer.close();
    }

    public static void copyDir(File sourceDir, File targetDir) throws IOException {
        targetDir.mkdirs();
        String[] files = sourceDir.list();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(".") || files[i].equals("..")) continue;
            File source = new File(sourceDir, files[i]);
            File target = new File(targetDir, files[i]);
            if (source.isDirectory()) {
                Base.copyDir(source, target);
                target.setLastModified(source.lastModified());
                continue;
            }
            Base.copyFile(source, target);
        }
    }

    public static String[] listFiles(String path, boolean relative) {
        return Base.listFiles(new File(path), relative);
    }

    public static String[] listFiles(File folder, boolean relative) {
        String path = folder.getAbsolutePath();
        Vector<String> vector = new Vector<String>();
        Base.addToFileList(relative ? path + File.separator : "", path, vector);
        Object[] outgoing = new String[vector.size()];
        vector.copyInto(outgoing);
        return outgoing;
    }

    protected static void addToFileList(String basePath, String path, Vector<String> fileList) {
        File folder = new File(path);
        String[] list = folder.list();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].charAt(0) == '.') continue;
            File file = new File(path, list[i]);
            String newPath = file.getAbsolutePath();
            if (newPath.startsWith(basePath)) {
                newPath = newPath.substring(basePath.length());
            }
            fileList.add(newPath);
            if (!file.isDirectory()) continue;
            Base.addToFileList(basePath, newPath, fileList);
        }
    }

    public static MachineLoader getMachineLoader() {
        if (machineLoader == null) {
            machineLoader = new MachineLoader();
        }
        return machineLoader;
    }

    public static String findDefaultByGlobalStatus(String valueKey, String defaultValue) {
        MachineInterface mi = Base.getMachineLoader().getMachineInterface();
        DriverQueryInterface qi = mi.getDriverQueryInterface();
        if (mi.isConnected()) {
            return qi.getConfigValue(valueKey, defaultValue);
        }
        return defaultValue;
    }

    static {
        preferences = Base.getUserPreferences();
        logger = Logger.getLogger("replicatorg.log");
        logFileHandler = null;
        logFilePath = null;
        alternatePrefs = null;
        localNF = NumberFormat.getInstance();
        editor = null;
        notificationHandler = null;
        supportedExtensions = new String[]{"gcode", "ngc", "stl", "dae", "obj"};
        javaVersionName = System.getProperty("java.version");
        javaVersion = new Float(javaVersionName.substring(0, 3)).floatValue();
        platformName = System.getProperty("os.name");
        if (platformName.toLowerCase().indexOf("mac") != -1) {
            if (System.getProperty("mrj.version") != null) {
                platform = platformName.equals("Mac OS X") ? Platform.MACOSX : Platform.MACOS9;
            }
        } else {
            String osname = System.getProperty("os.name");
            platform = osname.indexOf("Windows") != -1 ? Platform.WINDOWS : (osname.equals("Linux") ? Platform.LINUX : Platform.OTHER);
            String aString = System.getProperty("os.arch");
            if ("i386".equals(aString)) {
                arch = Arch.x86;
            } else if ("x86_64".equals(aString) || "amd64".equals(aString)) {
                arch = Arch.x86_64;
            } else if ("universal".equals(aString) || "ppc".equals(aString)) {
                arch = Arch.OTHER;
                throw new RuntimeException("Can not use use arch: '" + (Object)((Object)arch) + "'");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arch {
        x86_64,
        x86,
        ARM,
        PPC,
        OTHER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Platform {
        WINDOWS,
        MACOS9,
        MACOSX,
        LINUX,
        OTHER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InitialOpenBehavior {
        OPEN_LAST,
        OPEN_NEW,
        OPEN_SPECIFIC_FILE;

    }
}

