/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.gcode;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import replicatorg.app.Base;
import replicatorg.app.gcode.GCodeCommand;
import replicatorg.app.gcode.Layer;
import replicatorg.app.gcode.MutableGCodeSource;
import replicatorg.machine.model.MachineType;
import replicatorg.machine.model.ToolheadAlias;
import replicatorg.machine.model.WipeModel;
import replicatorg.model.GCodeSource;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgePostProcessor;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DualStrusionConstruction {
    private final File leftFile;
    private final File rightFile;
    private final MutableGCodeSource startGCode;
    private final MutableGCodeSource endGCode;
    private final boolean useWipes;
    private final WipeModel leftWipe;
    private final WipeModel rightWipe;
    private final MachineType machineType;
    private MutableGCodeSource result;

    public DualStrusionConstruction(File leftFile, File rightFile, MutableGCodeSource startSource, MutableGCodeSource endSource, MachineType type, boolean useWipes) {
        this.leftFile = leftFile;
        this.rightFile = rightFile;
        this.useWipes = useWipes;
        this.machineType = type;
        this.startGCode = startSource.copy();
        this.endGCode = endSource.copy();
        if (useWipes) {
            this.leftWipe = Base.getMachineLoader().getMachineInterface().getModel().getWipeFor(ToolheadAlias.LEFT);
            this.rightWipe = Base.getMachineLoader().getMachineInterface().getModel().getWipeFor(ToolheadAlias.RIGHT);
            if (this.leftWipe == null || this.rightWipe == null) {
                String error = "Could not find wipes for the current machine: " + Base.getMachineLoader().getMachineInterface().getModel().toString() + ". Continuing without wipes.";
                JOptionPane.showConfirmDialog(null, error, "Could not find wipes!", -1, 0);
                useWipes = false;
            }
        } else {
            this.leftWipe = null;
            this.rightWipe = null;
        }
    }

    public MutableGCodeSource getCombinedFile() {
        return this.result;
    }

    public void combine() {
        MutableGCodeSource left = new MutableGCodeSource(this.leftFile);
        MutableGCodeSource right = new MutableGCodeSource(this.rightFile);
        SkeinforgePostProcessor.stripNonLayerTagComments(left);
        SkeinforgePostProcessor.stripNonLayerTagComments(right);
        LinkedList<Layer> leftLayers = this.parseLayers(left);
        LinkedList<Layer> rightLayers = this.parseLayers(right);
        LinkedList<Layer> layers = this.doMerge(leftLayers, rightLayers);
        this.result = new MutableGCodeSource();
        for (Layer l : layers) {
            this.result.add(l.getCommands());
        }
        SkeinforgePostProcessor.prependAndModifyStartCode(this.result, this.startGCode);
        Layer endLayer = new Layer(Double.MAX_VALUE, this.endGCode.asList());
        this.result.add(endLayer.toString());
        this.result.addProgressUpdates();
    }

    private LinkedList<Layer> testParseLayers(GCodeSource source) {
        LinkedList<Layer> layers = new LinkedList<Layer>();
        LinkedList<String> read = new LinkedList<String>();
        layers.add(new Layer(0.0, (List<String>)new ArrayList<String>(){
            {
                this.add("(*************start layer*************)");
            }
        }));
        String lastM103 = null;
        double lastZHeight = Double.MIN_VALUE;
        for (String line : source) {
            GCodeCommand gcode = new GCodeCommand(line);
            if (gcode.getCodeValue('M') == 103.0) {
                lastM103 = line;
            }
            if (gcode.hasCode('Z')) {
                double newZ = gcode.getCodeValue('Z');
                if (lastZHeight == Double.MIN_VALUE) {
                    lastZHeight = newZ;
                } else if (newZ > lastZHeight) {
                    ArrayList<String> tmpLayer = new ArrayList<String>();
                    while (read.peek() != null && read.peek() != lastM103) {
                        tmpLayer.add((String)read.poll());
                    }
                    if (read.peek() == lastM103) {
                        tmpLayer.add((String)read.poll());
                    }
                    layers.add(new Layer(lastZHeight, tmpLayer));
                    lastZHeight = newZ;
                }
            }
            read.add(line);
        }
        layers.add(new Layer(0.0, (List<String>)new ArrayList<String>(){
            {
                this.add("(*************end layer*************)");
            }
        }));
        return layers;
    }

    private LinkedList<Layer> parseLayers(GCodeSource source) {
        LinkedList<Layer> result = new LinkedList<Layer>();
        Iterator<String> it = source.iterator();
        while (it.hasNext()) {
            String line = it.next();
            if (!line.startsWith("(<layer>")) continue;
            float layerHeight = 0.0f;
            try {
                layerHeight = Float.parseFloat(line.split(" ")[1]);
            }
            catch (NumberFormatException e) {
                Base.logger.log(Level.SEVERE, "one of your layer heights was unparseable, please check and make sure all of them are in the format (<layer> 0.00)");
            }
            ArrayList<String> accumulate = new ArrayList<String>();
            String next = line;
            while (!next.startsWith("(</layer>)")) {
                accumulate.add(next);
                next = it.next();
            }
            if (accumulate.size() <= 1) continue;
            result.add(new Layer(layerHeight, accumulate));
        }
        return result;
    }

    private Layer toolchange(ToolheadAlias fromTool, Layer fromLayer, ToolheadAlias toTool, Layer toLayer) {
        String feedrate;
        ArrayList<String> result = new ArrayList<String>();
        result.add("(*************start toolchange*************)");
        if (this.useWipes) {
            result.addAll(this.wipe(this.leftWipe));
            if (this.machineType != MachineType.THE_REPLICATOR) {
                result.addAll(this.wipe(this.rightWipe));
            }
        }
        result.add(toTool.getRecallOffsetGcodeCommand());
        result.add("M108 " + toTool.getTcode() + "(Set tool)");
        result.add("M18 A B");
        DecimalFormat nf = (DecimalFormat)Base.getGcodeFormat();
        Point5d firstPos = this.getFirstPosition(toLayer);
        firstPos.setZ(this.getLayerZ(toLayer));
        if (firstPos != null) {
            result.add("G1 Z" + nf.format(firstPos.z()) + " F3000");
            result.add("G1 X" + nf.format(firstPos.x()) + " Y" + nf.format(firstPos.y()) + " Z" + nf.format(firstPos.z()) + " F3000");
        }
        if ((feedrate = this.getFirstFeedrate(toLayer)).equals("")) {
            feedrate = this.getLastFeedrate(fromLayer);
        }
        result.add("G1 " + feedrate);
        result.add("(*************end toolchange*************)");
        double height = (toLayer.getHeight() - fromLayer.getHeight()) / 2.0;
        return new Layer(height, result);
    }

    private Point5d getFirstPosition(Layer l) {
        List<String> search = l.getCommands();
        for (int i = 0; i < search.size(); ++i) {
            GCodeCommand gcode = new GCodeCommand(search.get(i));
            if (gcode.getCodeValue('G') != 1.0) continue;
            Point5d result = new Point5d();
            result.setX(gcode.getCodeValue('X'));
            result.setY(gcode.getCodeValue('Y'));
            result.setZ(gcode.getCodeValue('Z'));
            return result;
        }
        return null;
    }

    private Double getLayerZ(Layer l) {
        List<String> search = l.getCommands();
        for (int i = search.size() - 1; i >= 0; --i) {
            GCodeCommand gcode = new GCodeCommand(search.get(i));
            if (gcode.getCodeValue('G') != 1.0 || !gcode.hasCode('Z')) continue;
            return gcode.getCodeValue('Z');
        }
        return null;
    }

    private String getLastFeedrate(Layer l) {
        List<String> search = l.getCommands();
        for (int i = search.size() - 1; i >= 0; --i) {
            GCodeCommand gcode = new GCodeCommand(search.get(i));
            if (gcode.getCodeValue('F') == -1.0) continue;
            return "F" + Base.getGcodeFormat().format(gcode.getCodeValue('F'));
        }
        return "";
    }

    private String getFirstFeedrate(Layer l) {
        List<String> search = l.getCommands();
        for (int i = 0; i < search.size(); ++i) {
            GCodeCommand gcode = new GCodeCommand(search.get(i));
            if (gcode.getCodeValue('F') == -1.0) continue;
            return "F" + Base.getGcodeFormat().format(gcode.getCodeValue('F'));
        }
        return "";
    }

    private ArrayList<String> wipe(WipeModel toolWipe) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("(*************start wipe*************)");
        String feedrate = "F3000";
        result.add("G53");
        result.add("G1 " + toolWipe.getY1() + " " + "F3000");
        result.add("G1 " + toolWipe.getZ1() + " " + "F3000");
        result.add("G1 " + toolWipe.getX1() + " " + "F3000");
        result.add("M108 " + toolWipe.getPurgeRPM());
        result.add("M101");
        result.add("G04 " + toolWipe.getPurgeDuration());
        result.add("M103");
        result.add("M108 " + toolWipe.getReverseRPM());
        result.add("M102");
        result.add("G04 " + toolWipe.getReverseDuration());
        result.add("M103");
        result.add("G04 " + toolWipe.getWait());
        result.add("G1 " + toolWipe.getX2() + " " + toolWipe.getY2() + " " + toolWipe.getZ2() + " " + "F3000");
        result.add("(*************end wipe*************)");
        return result;
    }

    private LinkedList<Layer> doMerge(LinkedList<Layer> left, LinkedList<Layer> right) {
        LinkedList<Layer> result = new LinkedList<Layer>();
        LinkedList<Layer> lastLayer = null;
        final ToolheadAlias initialTool = right.peek().getHeight() < left.peek().getHeight() ? ToolheadAlias.RIGHT : ToolheadAlias.LEFT;
        result.add(new Layer(0.0, (List<String>)new ArrayList<String>(){
            {
                this.add(initialTool.getRecallOffsetGcodeCommand());
                this.add("M108 " + initialTool.getTcode() + "(Set tool)");
            }
        }));
        while (!left.isEmpty() || !right.isEmpty()) {
            if (right.isEmpty()) {
                if (right.equals(lastLayer)) {
                    result.add(this.toolchange(ToolheadAlias.RIGHT, result.getLast(), ToolheadAlias.LEFT, left.peek()));
                }
                result.add(left.pop());
                lastLayer = left;
                continue;
            }
            if (left.isEmpty()) {
                if (left.equals(lastLayer)) {
                    result.add(this.toolchange(ToolheadAlias.LEFT, result.getLast(), ToolheadAlias.RIGHT, right.peek()));
                }
                result.add(right.pop());
                lastLayer = right;
                continue;
            }
            if (left.peek().getHeight() < right.peek().getHeight()) {
                if (right.equals(lastLayer)) {
                    result.add(this.toolchange(ToolheadAlias.RIGHT, result.getLast(), ToolheadAlias.LEFT, left.peek()));
                }
                result.add(left.pop());
                lastLayer = left;
                continue;
            }
            if (right.peek().getHeight() < left.peek().getHeight()) {
                if (left.equals(lastLayer)) {
                    result.add(this.toolchange(ToolheadAlias.LEFT, result.getLast(), ToolheadAlias.RIGHT, right.peek()));
                }
                result.add(right.pop());
                lastLayer = right;
                continue;
            }
            if (lastLayer == null) {
                result.add(left.pop());
                lastLayer = left;
                continue;
            }
            if (lastLayer == left) {
                result.add(left.pop());
                continue;
            }
            result.add(right.pop());
        }
        return result;
    }
}

