/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.gcode;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import replicatorg.app.Base;
import replicatorg.app.gcode.GCodeCommand;
import replicatorg.machine.model.ToolheadAlias;
import replicatorg.model.GCodeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableGCodeSource
implements GCodeSource {
    ArrayList<String> source = new ArrayList();

    public MutableGCodeSource() {
    }

    public MutableGCodeSource(GCodeSource shallowCopy) {
        this.source.addAll(shallowCopy.asList());
    }

    public MutableGCodeSource(Collection<String> shallowCopy) {
        this.source.addAll(shallowCopy);
    }

    public MutableGCodeSource(File sourceFile) {
        if (sourceFile == null) {
            Base.logger.warning("MutableGCodeSource passed a null sourceFile");
            return;
        }
        try {
            BufferedReader bir = new BufferedReader(new FileReader(sourceFile));
            String curline = bir.readLine();
            while (curline != null) {
                this.source.add(curline);
                curline = bir.readLine();
            }
            bir.close();
        }
        catch (IOException e) {
            System.err.println("couldnt read file " + sourceFile.getAbsolutePath());
            return;
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.source.iterator();
    }

    @Override
    public List<String> asList() {
        return this.source;
    }

    @Override
    public int getLineCount() {
        return this.source.size();
    }

    public void add(String line) {
        this.source.add(line);
    }

    public void add(GCodeSource toAdd) {
        this.add(toAdd.asList());
    }

    public void add(Collection<String> toAdd) {
        this.source.addAll(toAdd);
    }

    public void add(int location, String line) {
        this.source.add(location, line);
    }

    public void add(int location, GCodeSource toAdd) {
        this.add(location, toAdd.asList());
    }

    public void add(int location, Collection<String> toAdd) {
        this.source.addAll(location, toAdd);
    }

    public void writeToFile(File f) {
        try {
            FileWriter bwr = new FileWriter(f);
            for (String s : this.source) {
                bwr.write(s + "\n");
            }
            bwr.close();
        }
        catch (IOException e) {
            Base.logger.log(Level.SEVERE, "Could not write MutableGCodeSource to file.", e);
        }
    }

    public void changeToolhead(ToolheadAlias tool) {
        ArrayList<String> newSource = new ArrayList<String>(this.source.size());
        for (String line : this.source) {
            int value;
            GCodeCommand gcode = new GCodeCommand(line);
            if (gcode.hasCode('T') && (value = (int)gcode.getCodeValue('T')) != tool.number) {
                if (value == 0) {
                    line = line.replace("T0", "T1");
                } else if (value == 1) {
                    line = line.replace("T1", "T0");
                }
            }
            if (gcode.getCodeValue('G') == 54.0 && !tool.getRecallOffsetGcodeCommand().equals("G54")) {
                line = line.replace("G54", tool.getRecallOffsetGcodeCommand());
            }
            if (gcode.getCodeValue('G') == 55.0 && !tool.getRecallOffsetGcodeCommand().equals("G55")) {
                line = line.replace("G55", tool.getRecallOffsetGcodeCommand());
            }
            newSource.add(line);
        }
        this.source = newSource;
    }

    public void coolUnusedToolhead() {
        int additionPoint = 0;
        boolean addPointFound = false;
        boolean seenT0 = false;
        boolean seenT1 = false;
        for (String line : this.source) {
            GCodeCommand gcode = new GCodeCommand(line);
            double tval = gcode.getCodeValue('T');
            if (tval == 0.0) {
                seenT0 = true;
            }
            if (tval == 1.0) {
                seenT1 = true;
            }
            if (!addPointFound) {
                ++additionPoint;
            }
            if (gcode.getCodeValue('M') == 104.0) {
                addPointFound = true;
            }
            if (!seenT0 || !seenT1) continue;
            return;
        }
        if (seenT0 && !seenT1) {
            this.add(additionPoint, "M104 T1 S0");
        }
        if (seenT1 && !seenT0) {
            this.add(additionPoint, "M104 T0 S0");
        }
    }

    public void addSlic3rProgressUpdates() {
        int index = 0;
        int sourceSize = this.source.size();
        ArrayList<String> newSource = new ArrayList<String>();
        for (String line : this.source) {
            if (line.startsWith("(<layer>")) {
                int percentDone = index * 100 / sourceSize;
                if (percentDone == 0) {
                    percentDone = 1;
                }
                if (percentDone == 100) {
                    percentDone = 99;
                }
                newSource.add("M73 P" + percentDone + " (display progress)");
            }
            newSource.add(line);
            ++index;
        }
        this.source = newSource;
    }

    public void addProgressUpdates() {
        int index = 0;
        int sourceSize = this.source.size();
        ArrayList<String> newSource = new ArrayList<String>();
        int last_percent = 0;
        for (String line : this.source) {
            int percentDone = index * 100 / sourceSize;
            if (percentDone != last_percent) {
                if (percentDone == 0) {
                    percentDone = 1;
                }
                if (percentDone == 100) {
                    percentDone = 99;
                }
                newSource.add("M73 P" + percentDone + " (display progress)");
                last_percent = percentDone;
            }
            newSource.add(line);
            ++index;
        }
        this.source = newSource;
    }

    public MutableGCodeSource copy() {
        MutableGCodeSource newSource = new MutableGCodeSource();
        for (String line : this.source) {
            newSource.add(new String(line));
        }
        return newSource;
    }
}

