/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.Format;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import replicatorg.app.Base;

public abstract class ActionTextField
extends JFormattedTextField {
    Color defaultColor;
    Color modifiedColor;
    boolean valueModified;
    String origionalString;

    public void notifyRestoreOriginalValue() {
        if (this.valueModified) {
            this.valueModified = false;
            this.setText(this.origionalString);
            this.origionalString = null;
            try {
                this.commitEdit();
            }
            catch (ParseException e) {
                Base.logger.severe("parse err in ActionTextField" + e);
            }
            this.setBackground(this.defaultColor);
        }
    }

    public void notifyValueModified() {
        if (!this.valueModified) {
            this.valueModified = true;
            this.origionalString = this.getText();
            this.setBackground(this.modifiedColor);
        }
    }

    public void notifyDoneModifying() {
        if (this.valueModified) {
            try {
                this.commitEdit();
            }
            catch (ParseException e) {
                Base.logger.severe("parse err in ActionTextField" + e);
            }
            this.valueModified = false;
            this.origionalString = null;
            this.setBackground(this.defaultColor);
            this.doSaveEvent();
        }
    }

    public abstract void doSaveEvent();

    public ActionTextField(Object value, int columns, Format format) {
        super(format);
        this.setColumns(columns);
        if (format == null) {
            super.setFormatter(new DefaultFormatter());
        }
        if (value != null) {
            this.setValue(value);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.defaultColor = this.getBackground();
        this.modifiedColor = new Color(128, 128, 255);
        this.valueModified = false;
        this.addFocusListener(new StoringFocusListener(this));
        this.addKeyListener(new NotifyingKeyListener(this));
    }

    private class NotifyingKeyListener
    implements KeyListener {
        final ActionTextField textField;

        public NotifyingKeyListener(ActionTextField textField) {
            this.textField = textField;
        }

        public void keyPressed(KeyEvent arg0) {
        }

        public void keyReleased(KeyEvent arg0) {
        }

        public void keyTyped(KeyEvent arg0) {
            if (arg0.getKeyChar() == '\n') {
                this.textField.notifyDoneModifying();
            }
            if (arg0.getKeyChar() == '\u001b') {
                this.textField.notifyRestoreOriginalValue();
            } else {
                this.textField.notifyValueModified();
            }
        }
    }

    private class StoringFocusListener
    implements FocusListener {
        final ActionTextField textField;

        public StoringFocusListener(ActionTextField textField) {
            this.textField = textField;
        }

        public void focusGained(FocusEvent arg0) {
        }

        public void focusLost(FocusEvent arg0) {
            this.textField.notifyDoneModifying();
        }
    }
}

