/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.gcode.DualStrusionConstruction;
import replicatorg.app.gcode.MutableGCodeSource;
import replicatorg.app.ui.GcodeSaveWindow;
import replicatorg.app.ui.GcodeSelectWindow;
import replicatorg.machine.model.MachineType;
import replicatorg.machine.model.ToolheadAlias;
import replicatorg.model.Build;
import replicatorg.plugin.toolpath.ToolpathGenerator;
import replicatorg.plugin.toolpath.ToolpathGeneratorFactory;
import replicatorg.plugin.toolpath.ToolpathGeneratorThread;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgePostProcessor;

public class DualStrusionWindow
extends JFrame {
    private static final long serialVersionUID = 2548421042732389328L;
    File dest;
    boolean uWipe;
    File leftStl = null;
    File rightStl = null;
    File leftGcode = null;
    File rightGcode = null;
    MutableGCodeSource startSource;
    MutableGCodeSource endSource;
    boolean failure = false;
    JLabel failureLabel = new JLabel();
    CountDownLatch completed;
    JPanel panels;
    private static final String SELECT_PANEL = "Selection Panel";
    private static final String SKEINFORGE_PANEL = "SkeinForge Panel";
    private static final String WAITING_PANEL = "Waiting Panel";
    private static final String ABORT_PANEL = "Abort Panel";
    final MachineType type;

    public DualStrusionWindow(MachineType type, MutableGCodeSource startCode, MutableGCodeSource endCode) {
        this(type, startCode, endCode, null);
    }

    public DualStrusionWindow(MachineType type, MutableGCodeSource startCode, MutableGCodeSource endCode, String path) {
        super("DualStrusion Window");
        Base.logger.log(Level.FINE, "Dualstrusion window booting up...");
        this.startSource = startCode;
        this.endSource = endCode;
        this.type = type;
        this.panels = new JPanel(new CardLayout());
        this.add(this.panels);
        this.panels.add((Component)this.createSelectionPanel(), SELECT_PANEL);
        this.panels.add((Component)this.createSFWaitingPanel(), SKEINFORGE_PANEL);
        this.panels.add((Component)this.createWaitingPanel(), WAITING_PANEL);
        this.panels.add((Component)this.createApologyPanel(), ABORT_PANEL);
        ((CardLayout)this.panels.getLayout()).show(this.panels, SELECT_PANEL);
        this.pack();
        Base.logger.log(Level.FINE, "Finishing construction of Dualstrusion window");
    }

    private JPanel createSelectionPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill"));
        final JTextField leftToolhead = new JTextField(50);
        leftToolhead.setText(Base.preferences.get("dualstrusionwindow.leftfile", ""));
        JButton leftChooserButton = new JButton("Browse...");
        leftChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String s = null;
                s = !leftToolhead.getText().equals("") ? GcodeSelectWindow.goString(new File(leftToolhead.getText())) : GcodeSelectWindow.goString();
                if (s != null) {
                    leftToolhead.setText(s);
                }
            }
        });
        panel.add((Component)new JLabel("Left Extruder"), "split");
        panel.add((Component)leftToolhead, "split, growx");
        panel.add((Component)leftChooserButton, "wrap");
        final JTextField rightToolhead = new JTextField(50);
        rightToolhead.setText(Base.preferences.get("dualstrusionwindow.rightfile", ""));
        JButton rightChooserButton = new JButton("Browse...");
        rightChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String s = null;
                s = !rightToolhead.getText().equals("") ? GcodeSelectWindow.goString(new File(rightToolhead.getText())) : GcodeSelectWindow.goString();
                if (s != null) {
                    rightToolhead.setText(s);
                }
            }
        });
        panel.add((Component)new JLabel("Right Extruder"), "split");
        panel.add((Component)rightToolhead, "split, growx");
        panel.add((Component)rightChooserButton, "wrap");
        final JTextField destinationTextField = new JTextField(50);
        destinationTextField.setText(Base.preferences.get("dualstrusionwindow.destfile", ""));
        JButton destinationChooserButton = new JButton("Browse...");
        destinationChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String s = null;
                if (!destinationTextField.getText().equals("")) {
                    s = GcodeSaveWindow.goString(new File(destinationTextField.getText()));
                } else if (!leftToolhead.getText().equals("")) {
                    int i = leftToolhead.getText().lastIndexOf("/");
                    String a = leftToolhead.getText().substring(0, i + 1) + "untitled.gcode";
                    File untitled = new File(a);
                    System.out.println(a);
                    s = GcodeSaveWindow.goString(untitled);
                } else {
                    s = GcodeSaveWindow.goString();
                }
                if (s != null) {
                    if (s.contains(".")) {
                        int lastp = s.lastIndexOf(".");
                        if (!s.substring(lastp + 1, s.length()).equals("gcode")) {
                            s = s.substring(0, lastp) + ".gcode";
                        }
                    } else {
                        s = s + ".gcode";
                    }
                    destinationTextField.setText(s);
                }
            }
        });
        panel.add((Component)new JLabel("Save As: "), "split");
        panel.add((Component)destinationTextField, "split, growx");
        panel.add((Component)destinationChooserButton, "wrap");
        JButton merge = new JButton("Merge");
        merge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String ext;
                File test;
                if (leftToolhead.getText().equals(rightToolhead.getText())) {
                    int option = JOptionPane.showConfirmDialog(null, "You are trying to combine two of the same file. Are you sure you want to do this?", "Continue?", 0, 2);
                    System.out.println(option);
                    if (option == 1) {
                        return;
                    }
                }
                if ((test = new File(leftToolhead.getText())).exists()) {
                    ext = DualStrusionWindow.getExtension(test.getName());
                    if ("stl".equalsIgnoreCase(ext)) {
                        DualStrusionWindow.this.leftStl = test;
                    } else if ("gcode".equalsIgnoreCase(ext)) {
                        DualStrusionWindow.this.leftGcode = test;
                    } else {
                        JOptionPane.showConfirmDialog(null, "File for Extruder A not an stl or gcode. Please select something I can understand.", "Select a different file.", -1, 2);
                        return;
                    }
                }
                if ((test = new File(rightToolhead.getText())).exists()) {
                    ext = DualStrusionWindow.getExtension(test.getName());
                    if ("stl".equalsIgnoreCase(ext)) {
                        DualStrusionWindow.this.rightStl = test;
                    } else if ("gcode".equalsIgnoreCase(ext)) {
                        DualStrusionWindow.this.rightGcode = test;
                    } else {
                        JOptionPane.showConfirmDialog(null, "File for Extruder B not an stl or gcode. Please select something I can understand.", "Select a different file.", -1, 2);
                        return;
                    }
                }
                Base.preferences.put("dualstrusionwindow.leftfile", leftToolhead.getText());
                Base.preferences.put("dualstrusionwindow.rightfile", rightToolhead.getText());
                Base.preferences.put("dualstrusionwindow.destfile", destinationTextField.getText());
                DualStrusionWindow.this.dest = new File(destinationTextField.getText());
                DualStrusionWindow.this.uWipe = false;
                DualStrusionWindow.this.completed = new CountDownLatch(2);
                if (DualStrusionWindow.this.leftGcode != null) {
                    DualStrusionWindow.this.completed.countDown();
                }
                if (DualStrusionWindow.this.rightGcode != null) {
                    DualStrusionWindow.this.completed.countDown();
                }
                if (DualStrusionWindow.this.completed.getCount() == 0L) {
                    DualStrusionWindow.this.combineGcodes();
                    return;
                }
                if (DualStrusionWindow.this.leftStl != null) {
                    DualStrusionWindow.this.leftGcode = new File(DualStrusionWindow.replaceExtension(DualStrusionWindow.this.leftStl.getAbsolutePath(), "gcode"));
                    DualStrusionWindow.this.stlToGcode(DualStrusionWindow.this.leftStl, DualStrusionWindow.this.leftGcode, ToolheadAlias.LEFT, DualStrusionWindow.this.type);
                }
                if (DualStrusionWindow.this.rightStl != null) {
                    DualStrusionWindow.this.rightGcode = new File(DualStrusionWindow.replaceExtension(DualStrusionWindow.this.rightStl.getAbsolutePath(), "gcode"));
                    DualStrusionWindow.this.stlToGcode(DualStrusionWindow.this.rightStl, DualStrusionWindow.this.rightGcode, ToolheadAlias.RIGHT, DualStrusionWindow.this.type);
                }
                ((CardLayout)DualStrusionWindow.this.panels.getLayout()).show(DualStrusionWindow.this.panels, DualStrusionWindow.SKEINFORGE_PANEL);
            }
        });
        panel.add((Component)merge, "split");
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    Desktop.getDesktop().browse(new URI("http://goo.gl/DV5vn"));
                }
                catch (Exception e) {
                    Base.logger.log(Level.WARNING, "Could not load online help! See log level FINEST for more details");
                    Base.logger.log(Level.FINEST, "" + e);
                }
            }
        });
        panel.add(help);
        return panel;
    }

    private JPanel createWaitingPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill"));
        panel.add((Component)new JLabel("Running dualstrusion..."), "growx, growy");
        return panel;
    }

    private JPanel createSFWaitingPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill"));
        panel.add((Component)new JLabel("Waiting for SkeinForge..."), "growx, growy");
        return panel;
    }

    private JPanel createApologyPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill"));
        panel.add((Component)new JLabel("Sorry, something has gone wrong with the dualstrusion generation."), "growx, wrap");
        panel.add((Component)this.failureLabel, "growx, wrap");
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                DualStrusionWindow.this.dispose();
            }
        });
        return panel;
    }

    private void stlToGcode(File stl, File gcode, ToolheadAlias tool, MachineType machineType) {
        try {
            if (!gcode.exists()) {
                gcode.createNewFile();
            }
            String title = "STL to GCode ";
            if (tool == ToolheadAlias.LEFT) {
                title = title + "(Left) ";
            }
            if (tool == ToolheadAlias.RIGHT) {
                title = title + "(Right) ";
            }
            title = title + "Progress";
            JFrame progress = new JFrame(title);
            ToolpathGenerator gen = ToolpathGeneratorFactory.createSelectedGenerator();
            if (gen instanceof SkeinforgeGenerator) {
                SkeinforgePostProcessor spp = ((SkeinforgeGenerator)gen).getPostProcessor();
                spp.enableDualstrusion();
                spp.setMachineType(machineType);
                spp.setAddProgressUpdates(false);
            }
            Build b = new Build(stl.getAbsolutePath());
            ToolpathGeneratorThread tgt = new ToolpathGeneratorThread(progress, gen, b);
            tgt.addListener(new ToolpathGenerator.GeneratorListener(){

                public void updateGenerator(ToolpathGenerator.GeneratorEvent evt) {
                    if ("Config Done".equals(evt.getMessage()) && !((SkeinforgeGenerator)evt.getSource()).configSuccess) {
                        DualStrusionWindow.this.abort("Skeinforge generation canceled.");
                    }
                }

                public void generationComplete(ToolpathGenerator.GeneratorEvent evt) {
                    if (evt.getCompletion() == ToolpathGenerator.GeneratorListener.Completion.FAILURE || DualStrusionWindow.this.failure) {
                        DualStrusionWindow.this.abort("SkeinForge returned FAILURE - Aborting dualstrusion generation");
                        return;
                    }
                    DualStrusionWindow.this.completed.countDown();
                    if (DualStrusionWindow.this.completed.getCount() == 0L) {
                        DualStrusionWindow.this.combineGcodes();
                    }
                }
            });
            if (tool == ToolheadAlias.LEFT) {
                tgt.setDualStrusionSupportFlag(true, 200, 300, stl.getName());
            } else {
                tgt.setDualStrusionSupportFlag(true, 500, 300, stl.getName());
            }
            Base.logger.log(Level.FINE, "Init finished, starting conversion");
            tgt.start();
        }
        catch (IOException e) {
            Base.logger.log(Level.SEVERE, "Cannot read stl! Aborting dualstrusion generation, see log level FINEST for more details.");
            Base.logger.log(Level.FINEST, "more details:", e);
            this.abort("Cannot read stl! Aborting dualstrusion generation.");
            return;
        }
    }

    private static String getExtension(String path) {
        int i = path.lastIndexOf(".");
        String ext = path.substring(i + 1, path.length());
        return ext;
    }

    private static String replaceExtension(String s, String newExtension) {
        int i = s.lastIndexOf(".");
        s = s.substring(0, i + 1);
        s = s + newExtension;
        return s;
    }

    private void combineGcodes() {
        ((CardLayout)this.panels.getLayout()).show(this.panels, WAITING_PANEL);
        if (this.leftGcode == null || this.rightGcode == null) {
            this.abort("Expected two gcode files after conversion from stl. One or both is/are absent. Cancelling Dualstrusion combination");
            return;
        }
        DualStrusionConstruction dsConstruction = new DualStrusionConstruction(this.leftGcode, this.rightGcode, this.startSource, this.endSource, this.type, this.uWipe);
        dsConstruction.combine();
        dsConstruction.getCombinedFile().writeToFile(this.dest);
        this.dispose();
        Base.getEditor().handleOpenFile(this.dest);
        Base.logger.log(Level.FINE, "Finished DualStrusionWindow's part");
    }

    public File getCombined() {
        return this.dest;
    }

    private void abort(String message) {
        this.failure = true;
        if (message == null || message.equals("")) {
            this.failureLabel.setText("I don't have an explanation for the failure, perhaps you should try again later.");
        } else {
            this.failureLabel.setText(message);
        }
        Base.logger.log(Level.SEVERE, message);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((CardLayout)DualStrusionWindow.this.panels.getLayout()).show(DualStrusionWindow.this.panels, DualStrusionWindow.ABORT_PANEL);
            }
        });
    }
}

