/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.BGPanel;
import replicatorg.app.ui.MainWindow;
import replicatorg.drivers.SDCardCapture;
import replicatorg.machine.Machine;
import replicatorg.machine.MachineInterface;
import replicatorg.machine.MachineListener;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineToolStatusEvent;

public class MainButtonPanel
extends BGPanel
implements MachineListener,
ActionListener {
    static final int BUTTON_WIDTH = 27;
    static final int BUTTON_HEIGHT = 32;
    static final float[] disabledFactors = new float[]{1.0f, 1.0f, 1.0f, 0.5f};
    static final float[] disabledOffsets = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private static RescaleOp disabledOp = new RescaleOp(disabledFactors, disabledOffsets, null);
    static final float[] activeFactors = new float[]{-1.0f, -1.0f, -1.0f, 1.0f};
    static final float[] activeOffsets = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    private static RescaleOp activeOp = new RescaleOp(activeFactors, activeOffsets, null);
    static final int BUTTON_GAP = 15;
    MainWindow editor;
    Image offscreen;
    int maxLabelWidth;
    int width;
    int height;
    Color bgcolor;
    JLabel statusLabel;
    static final Color BACK_COLOR = new Color(95, 115, 37);
    MainButton simButton;
    MainButton pauseButton;
    MainButton stopButton;
    MainButton buildButton;
    MainButton resetButton;
    MainButton cpButton;
    MainButton rcButton;
    MainButton disconnectButton;
    MainButton connectButton;
    MainButton generateButton;
    MainButton uploadButton;
    MainButton playbackButton;
    MainButton fileButton;

    public MainButtonPanel(MainWindow editor) {
        this.setLayout((LayoutManager)new MigLayout("gap 5, ins 5"));
        this.editor = editor;
        this.setBackground(BACK_COLOR);
        Font statusFont = Base.getFontPref("buttons.status.font", "SansSerif,plain,12");
        Color statusColor = Base.getColorPref("buttons.status.color", "#FFFFFF");
        this.buildButton = this.makeButton("Build", "images/button-build.png");
        this.add(this.buildButton);
        this.playbackButton = this.makeButton("Build from SD card currently in printer", "images/button-playback.png");
        this.add(this.playbackButton);
        this.fileButton = this.makeButton("Build to file for use with SD card", "images/button-to-file.png");
        this.add(this.fileButton);
        this.generateButton = this.makeButton("Model to GCode", "images/button-to-gcode.png");
        this.add(this.generateButton);
        this.pauseButton = this.makeButton("Pause", "images/button-pause.png");
        this.add((Component)this.pauseButton, "gap unrelated");
        this.stopButton = this.makeButton("Stop", "images/button-stop.png");
        this.add(this.stopButton);
        this.cpButton = this.makeButton("Control panel", "images/button-control-panel.png");
        this.rcButton = this.makeButton("Live tuning", "images/button-realtime-panel.png");
        this.add((Component)this.cpButton, "gap unrelated");
        this.add((Component)this.rcButton, "hidemode 1");
        this.resetButton = this.makeButton("Reset machine", "images/button-reset.png");
        this.add((Component)this.resetButton, "gap unrelated");
        this.connectButton = this.makeButton("Connect", "images/button-connect.png");
        this.add((Component)this.connectButton, "gap unrelated");
        this.disconnectButton = this.makeButton("Disconnect", "images/button-disconnect.png");
        this.add(this.disconnectButton);
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(statusFont);
        this.statusLabel.setForeground(statusColor);
        this.add((Component)this.statusLabel, "gap unrelated");
        this.playbackButton.setToolTipText("This will build an object from an SD card currently inserted in the printer");
        this.fileButton.setToolTipText("This will generate an .s3g file that can be put on an SD card and printed locally on the printer.");
        this.generateButton.setToolTipText("This will generate gcode for the currently open model.");
        this.buildButton.setToolTipText("This will start building the object on the machine.");
        this.pauseButton.setToolTipText("This will pause or resume the build.");
        this.stopButton.setToolTipText("This will abort the build in progress.");
        this.cpButton.setToolTipText("Here you'll find manual controls for the machine.");
        this.rcButton.setToolTipText("This can be used to tune the process, in real time, during a print job.");
        this.resetButton.setToolTipText("This will restart the firmware on the machine.");
        this.connectButton.setToolTipText("Connect to the machine.");
        this.disconnectButton.setToolTipText("Disconnect from the machine.");
        this.setPreferredSize(new Dimension(750, 60));
        this.machineStateChangedInternal(new MachineStateChangeEvent(null, new MachineState(MachineState.State.NOT_ATTACHED)));
    }

    public MainButton makeButton(String rolloverText, String source) {
        BufferedImage img = Base.getImage(source, this);
        if (img == null) {
            Base.logger.severe("Couldn't load button image: " + source + ". Check that your path (" + System.getProperty("user.dir") + ") contains this file");
            System.exit(1);
        }
        BufferedImage disabled = disabledOp.filter(img, null);
        BufferedImage inactive = img;
        BufferedImage rollover = img;
        BufferedImage active = activeOp.filter(img, null);
        MainButton mb = new MainButton(rolloverText, active, inactive, rollover, disabled);
        mb.setEnabled(false);
        return mb;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.generateButton) {
            this.editor.runToolpathGenerator(false);
        } else if (e.getSource() == this.buildButton) {
            this.editor.handleBuild();
        } else if (e.getSource() == this.uploadButton) {
            this.editor.handleUpload();
        } else if (e.getSource() == this.fileButton) {
            this.editor.handleBuildToFile();
        } else if (e.getSource() == this.playbackButton) {
            this.editor.handlePlayback();
        } else if (e.getSource() == this.pauseButton) {
            this.editor.handlePause();
        } else if (e.getSource() == this.stopButton) {
            this.editor.handleStop();
        } else if (e.getSource() == this.resetButton) {
            this.editor.handleReset();
        } else if (e.getSource() == this.cpButton) {
            this.editor.handleControlPanel();
        } else if (e.getSource() == this.connectButton) {
            this.editor.handleConnect();
        } else if (e.getSource() == this.disconnectButton) {
            this.editor.handleDisconnect(false, false);
        } else if (e.getSource() == this.rcButton) {
            this.editor.handleRealTimeControl();
        }
    }

    public void machineStateChanged(MachineStateChangeEvent evt) {
        final MachineStateChangeEvent e = evt;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainButtonPanel.this.machineStateChangedInternal(e);
            }
        });
    }

    private void updateFromState(MachineState s, MachineInterface machine) {
        boolean connected = s.isConnected();
        boolean readyToPrint = s.canPrint();
        boolean configurable = s.isConfigurable();
        boolean building = s.isBuilding();
        boolean paused = s.isPaused();
        boolean hasMachine = machine != null;
        boolean hasPlayback = hasMachine && machine.getDriver() != null && machine.getDriver() instanceof SDCardCapture && ((SDCardCapture)((Object)machine.getDriver())).hasFeatureSDCardCapture();
        boolean hasGcode = this.editor != null && this.editor.getBuild() != null && this.editor.getBuild().getCode() != null;
        boolean hasModel = this.editor != null && this.editor.getBuild() != null && this.editor.getBuild().getModel() != null;
        this.fileButton.setEnabled(!building && hasGcode);
        this.buildButton.setEnabled(readyToPrint);
        this.generateButton.setEnabled(hasModel);
        this.playbackButton.setEnabled(readyToPrint && hasPlayback);
        this.pauseButton.setEnabled(building && connected);
        this.stopButton.setEnabled(building);
        this.pauseButton.setSelected(paused);
        this.rcButton.setEnabled(building);
        Machine.JobTarget runningTarget = s.isBuilding() ? machine.getTarget() : null;
        this.buildButton.setSelected(runningTarget == Machine.JobTarget.MACHINE);
        this.fileButton.setSelected(runningTarget == Machine.JobTarget.FILE);
        this.playbackButton.setSelected(runningTarget == Machine.JobTarget.NONE);
        this.resetButton.setEnabled(connected);
        this.disconnectButton.setEnabled(connected);
        this.connectButton.setEnabled(!connected);
        this.cpButton.setEnabled(configurable);
        this.rcButton.setVisible(this.editor.supportsRealTimeControl());
    }

    public void updateFromMachine(MachineInterface machine) {
        MachineState s = new MachineState(MachineState.State.NOT_ATTACHED);
        if (machine != null) {
            s = machine.getMachineState();
        }
        this.updateFromState(s, machine);
    }

    public void machineStateChangedInternal(MachineStateChangeEvent evt) {
        MachineState s = evt.getState();
        MachineInterface machine = evt.getSource();
        this.updateFromState(s, machine);
    }

    public void machineProgress(MachineProgressEvent event) {
    }

    public void toolStatusChanged(MachineToolStatusEvent event) {
    }

    class MainButton
    extends JButton
    implements ChangeListener {
        private String rolloverText;

        public MainButton(String rolloverText, Image active, Image inactive, Image rollover, Image disabled) {
            this.rolloverText = rolloverText;
            this.setIcon(new ImageIcon(inactive));
            this.setSelectedIcon(new ImageIcon(active));
            this.setDisabledIcon(new ImageIcon(disabled));
            this.setRolloverEnabled(true);
            this.setRolloverIcon(new ImageIcon(rollover));
            this.setSize(new Dimension(active.getWidth(null), active.getHeight(null)));
            this.setBorder(null);
            this.getModel().addChangeListener(this);
            this.addActionListener(MainButtonPanel.this);
        }

        public String getRolloverText() {
            return this.rolloverText;
        }

        public void paint(Graphics g) {
            Rectangle b = this.getBounds();
            if (this.getModel().isSelected()) {
                g.setColor(new Color(1.0f, 1.0f, 0.5f, 0.8f));
                g.fillRect(0, 0, b.width, b.height);
                this.getSelectedIcon().paintIcon(this, g, 0, 0);
            } else if (this.getModel().isEnabled()) {
                if (this.getModel().isPressed()) {
                    g.setColor(new Color(1.0f, 1.0f, 0.5f, 0.3f));
                    g.fillRect(0, 0, b.width, b.height);
                    this.getSelectedIcon().paintIcon(this, g, 0, 0);
                } else if (this.getModel().isRollover()) {
                    g.setColor(new Color(1.0f, 1.0f, 0.5f, 0.3f));
                    g.fillRect(0, 0, b.width, b.height);
                    this.getRolloverIcon().paintIcon(this, g, 0, 0);
                } else {
                    g.setColor(BACK_COLOR);
                    g.fillRect(0, 0, b.width, b.height);
                    this.getIcon().paintIcon(this, g, 0, 0);
                }
            } else {
                g.setColor(BACK_COLOR);
                g.fillRect(0, 0, b.width, b.height);
                this.getDisabledIcon().paintIcon(this, g, 0, 0);
            }
        }

        public void stateChanged(ChangeEvent ce) {
            if (MainButtonPanel.this.statusLabel == null) {
                return;
            }
            if (this.getModel().isRollover()) {
                MainButtonPanel.this.statusLabel.setText(this.getRolloverText());
            } else {
                MainButtonPanel.this.statusLabel.setText("");
            }
        }
    }
}

