/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.util;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import replicatorg.app.Base;

public class PythonUtils {
    static final String PYTHON_PATH_PREF = "python.default_path";
    static final String PYPY_PATH_PREF = "pypy.default_path";
    private static Selector selector = null;
    static String pythonPath = null;
    static Version pythonVersion = null;
    static String pypyPath = null;

    public static void setSelector(Selector selector) {
        PythonUtils.selector = selector;
    }

    public static String getPythonPath() {
        return PythonUtils.getPythonPath(null, null);
    }

    public static String getPythonPath(Version minVersion, Version maxVersion) {
        File candidate;
        boolean versionOk = false;
        if (pythonVersion != null) {
            versionOk = true;
            if (minVersion != null && pythonVersion.compareTo(minVersion) < 0) {
                versionOk = false;
            }
            if (maxVersion != null && maxVersion.compareTo(pythonVersion) < 0) {
                versionOk = false;
            }
        }
        if (versionOk && pythonPath != null) {
            return pythonPath;
        }
        pythonPath = null;
        pythonVersion = null;
        TreeSet<String> candidates = new TreeSet<String>();
        String path = Base.preferences.get(PYTHON_PATH_PREF, null);
        if (path != null && (candidate = new File(path)).exists()) {
            candidates.add(candidate.getAbsolutePath());
        }
        String[] paths = System.getenv("PATH").split(File.pathSeparator);
        String[] pythonNames = new String[]{"python", "python2"};
        for (String path2 : paths) {
            for (String name : pythonNames) {
                File candidate2 = new File(path2, name);
                if (!candidate2.exists()) continue;
                candidates.add(candidate2.getAbsolutePath());
            }
        }
        if (Base.isWindows()) {
            Pattern pythonPat = Pattern.compile("Python([0-9]+)");
            File driveDir = new File("C:/");
            if (driveDir.exists() && driveDir.isDirectory()) {
                for (String path3 : driveDir.list()) {
                    File python;
                    Matcher match = pythonPat.matcher(path3);
                    if (!match.matches() || !(python = new File(new File(driveDir, path3), "python.exe")).exists()) continue;
                    candidates.add(python.getAbsolutePath());
                }
            }
        }
        for (String c : candidates) {
            Version v = PythonUtils.checkVersion(c, minVersion, maxVersion);
        }
        Vector<String> viableCandidates = new Vector<String>();
        for (String candidate3 : candidates) {
            Version v = PythonUtils.checkVersion(candidate3, minVersion, maxVersion);
            if (v == null) continue;
            viableCandidates.add(candidate3);
        }
        if (selector != null && viableCandidates.size() > 1) {
            String path4 = selector.selectPythonPath(viableCandidates);
            if (path4 != null) {
                Base.preferences.put(PYTHON_PATH_PREF, path4);
                pythonPath = path4;
                pythonVersion = PythonUtils.checkVersion(pythonPath);
            }
        } else if (viableCandidates.size() > 0) {
            pythonPath = (String)viableCandidates.firstElement();
            pythonVersion = PythonUtils.checkVersion(pythonPath);
        }
        return pythonPath;
    }

    public static Version checkVersion(String path, Version minVersion, Version maxVersion) {
        Version v = PythonUtils.checkVersion(path);
        if (v != null) {
            if (minVersion != null && v.compareTo(minVersion) < 0) {
                return null;
            }
            if (maxVersion != null && v.compareTo(maxVersion) > 0) {
                return null;
            }
        }
        return v;
    }

    public static String getPyPyPath() {
        return PythonUtils.getPyPyPath(null, null);
    }

    public static String getPyPyPath(Version minVersion, Version maxVersion) {
        File candidate;
        if (pypyPath != null) {
            return pypyPath;
        }
        String path = Base.preferences.get(PYPY_PATH_PREF, null);
        if (path != null && (candidate = new File(path)).exists()) {
            pypyPath = candidate.getAbsolutePath();
            return pypyPath;
        }
        return PythonUtils.getPythonPath(minVersion, maxVersion);
    }

    public static Version checkVersion(String path) {
        ProcessBuilder pb = new ProcessBuilder(path, "-V");
        pb.redirectErrorStream(true);
        try {
            Process p = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int returnCode = p.waitFor();
            if (returnCode != 0) {
                return null;
            }
            String line = reader.readLine();
            Pattern pattern = Pattern.compile("Python ([0-9]+)\\.([0-9]+)(?:\\.([0-9]+))?");
            while (line != null) {
                Matcher m = pattern.matcher(line);
                if (m.find()) {
                    int major = Integer.parseInt(m.group(1));
                    int minor = Integer.parseInt(m.group(2));
                    int revision = m.group(3) != null ? Integer.parseInt(m.group(3)) : 0;
                    return new Version(major, minor, revision);
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            Base.logger.log(Level.SEVERE, "Error attempting to detect python", e);
        }
        return null;
    }

    public static boolean checkTkInter() {
        if (PythonUtils.getPythonPath() == null) {
            return false;
        }
        ProcessBuilder pb = new ProcessBuilder(PythonUtils.getPythonPath(), "-c", "import Tkinter");
        try {
            Process p = pb.start();
            int returnCode = p.waitFor();
            if (returnCode != 0) {
                return false;
            }
        }
        catch (Exception e) {
            Base.logger.log(Level.SEVERE, "Error attempting to detect TkInter", e);
        }
        return true;
    }

    public static boolean interactiveCheckTkInter(Frame parent, String procedureName) {
        boolean hasTkInter = PythonUtils.checkTkInter();
        if (procedureName == null) {
            procedureName = "This operation";
        }
        if (!hasTkInter) {
            String s = procedureName + " requires TkInter to be installed.  No valid TkInter install was found.";
            PythonUtils.displayPythonErrorDialog(parent, s);
        }
        return hasTkInter;
    }

    public static boolean interactiveCheckVersion(Frame parent, String procedureName, Version min, Version max) {
        PythonUtils.getPythonPath(min, max);
        Version v = pythonVersion;
        if (procedureName == null) {
            procedureName = "This operation";
        }
        if (v != null) {
            if (min != null && min.compareTo(v) == 1) {
                PythonUtils.displayPythonErrorDialog(parent, procedureName + " requires Python version " + min.toString() + " or later.  Python version " + v.toString() + " was detected.");
                return false;
            }
            if (max != null && max.compareTo(v) != 1) {
                System.err.println("Comparing " + max.toString() + " to " + v.toString());
                System.err.println("Returned " + Integer.toString(max.compareTo(v)));
                PythonUtils.displayPythonErrorDialog(parent, procedureName + " requires a version of Python earlier than version " + max.toString() + ".  Python version " + v.toString() + " was detected.");
                return false;
            }
            return true;
        }
        PythonUtils.displayPythonErrorDialog(parent, procedureName + " requires that a Python interpreter be installed.");
        return false;
    }

    private static void displayPythonErrorDialog(final Frame parent, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (Base.isLinux()) {
                    String s = "<html><p>" + message + "</p><p>Make sure your system has the 'python' and 'python-tk' packages installed.</p></html>";
                    JOptionPane.showMessageDialog(parent, s, "Missing or incorrect Python interpreter detected", 0);
                } else {
                    String s = "<html><p>" + message + "</p><p>Would you like to visit the Python download page now?</p></html>";
                    int rsp = JOptionPane.showConfirmDialog(parent, s, "Missing or incorrect Python interpreter detected", 0, 0);
                    if (rsp == 0) {
                        Base.openURL("http://python.org/download");
                    }
                }
            }
        });
    }

    public static void setPythonPath(String path) {
        Base.preferences.put(PYTHON_PATH_PREF, path);
        pythonPath = path;
    }

    public static void setPyPyPath(String path) {
        Base.preferences.put(PYPY_PATH_PREF, path);
        pypyPath = path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Version
    implements Comparable<Version> {
        public int major;
        public int minor;
        public int revision;

        public Version(int major, int minor, int revision) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
        }

        @Override
        public int compareTo(Version other) {
            if (this.major < other.major) {
                return -1;
            }
            if (this.major > other.major) {
                return 1;
            }
            if (this.minor < other.minor) {
                return -1;
            }
            if (this.minor > other.minor) {
                return 1;
            }
            if (this.revision < other.revision) {
                return -1;
            }
            if (this.revision > other.revision) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return Integer.toString(this.major) + "." + Integer.toString(this.minor) + "." + Integer.toString(this.revision);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Selector {
        public String selectPythonPath(Vector<String> var1);
    }
}

