/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.awt.Color;
import java.util.EnumSet;
import javax.vecmath.Point3d;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.exceptions.BuildFailureException;
import replicatorg.drivers.Driver;
import replicatorg.drivers.DriverError;
import replicatorg.drivers.DriverQueryInterface;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.Version;
import replicatorg.drivers.VersionException;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.MachineModel;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualPrinter
implements Driver,
DriverQueryInterface {
    final String firmwareInfo = "No Firmware";
    final Version version = new Version(0, 0);
    final Version minimumVersion = new Version(0, 0);
    final Version preferredVersion = new Version(0, 0);
    final Version minimumAccelerationVersion = new Version(0, 0);
    final Version minimumJettyAccelerationVersion = new Version(0, 0);
    final Version minAdvancedFeatureVersion = new Version(0, 0);
    final boolean hasSoftStop = true;
    final boolean hasEStop = true;
    double toolTemperature = 0.0;
    double toolTemperatureSetting = 0.0;
    double platformTemperature = 0.0;
    double platformTemperatureSetting = 0.0;
    boolean isInitialized = false;
    MachineModel machineModel = new MachineModel();
    Point5d currentPosition = new Point5d();
    Point5d maximumFeedrates = new Point5d(1.0, 1.0, 1.0, 1.0, 1.0);
    Point3d[] currentOffset = new Point3d[]{new Point3d(), new Point3d(), new Point3d(), new Point3d(), new Point3d()};

    @Override
    public void loadXML(Node xml) {
        this.machineModel.loadXML(xml);
    }

    @Override
    public boolean isPassthroughDriver() {
        return false;
    }

    @Override
    public void executeGCodeLine(String code) {
    }

    @Override
    public boolean isFinished() {
        return true;
    }

    @Override
    public boolean isBufferEmpty() {
        return true;
    }

    @Override
    public void assessState() {
    }

    @Override
    public boolean hasError() {
        return false;
    }

    @Override
    public DriverError getError() {
        return null;
    }

    @Override
    public void checkErrors() throws BuildFailureException {
    }

    @Override
    public void initialize() throws VersionException {
        this.isInitialized = true;
    }

    @Override
    public void uninitialize() {
        this.isInitialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void dispose() {
    }

    @Override
    public MachineModel getMachine() {
        return this.machineModel;
    }

    @Override
    public void setMachine(MachineModel m) {
        this.machineModel = m;
    }

    @Override
    public String getDriverName() {
        return "VirtualPrinter";
    }

    @Override
    public String getFirmwareInfo() {
        return "No Firmware";
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void updateManualControl() {
    }

    @Override
    public Version getMinimumVersion() {
        return this.minimumVersion;
    }

    @Override
    public Version getMinimumAccelerationVersion() {
        return this.minimumAccelerationVersion;
    }

    @Override
    public Version getMinimumJettyAccelerationVersion() {
        return this.minimumJettyAccelerationVersion;
    }

    @Override
    public Version getMinimumAdvancedFeatureVersion() {
        return this.minAdvancedFeatureVersion;
    }

    @Override
    public Version getPreferredVersion() {
        return this.preferredVersion;
    }

    @Override
    public void setCurrentPosition(Point5d p) throws RetryException {
        this.currentPosition = p;
    }

    @Override
    public void storeHomePositions(EnumSet<AxisId> axes) throws RetryException {
    }

    @Override
    public void recallHomePositions(EnumSet<AxisId> axes) throws RetryException {
    }

    @Override
    public boolean positionLost() {
        return false;
    }

    @Override
    public Point5d getCurrentPosition(boolean update) {
        if (this.currentPosition == null) {
            this.currentPosition = new Point5d();
        }
        return this.currentPosition;
    }

    @Override
    public void invalidatePosition() {
        this.currentPosition = null;
    }

    @Override
    public void queuePoint(Point5d p) throws RetryException {
        this.currentPosition = p;
    }

    @Override
    public Point3d getOffset(int i) {
        return this.currentOffset[i];
    }

    @Override
    public void setOffsetX(int i, double j) {
        this.currentOffset[i].x = j;
    }

    @Override
    public void setOffsetY(int i, double j) {
        this.currentOffset[i].y = j;
    }

    @Override
    public void setOffsetZ(int i, double j) {
        this.currentOffset[i].z = j;
    }

    @Override
    public int getBuildToFileVersion() {
        return 0;
    }

    @Override
    public void setBuildToFileVersion(int version) {
    }

    @Override
    public Point5d getPosition() {
        return this.currentPosition;
    }

    @Override
    public void requestToolChange(int toolIndex, int timeout) throws RetryException {
    }

    @Override
    public void selectTool(int toolIndex) throws RetryException {
    }

    @Override
    public void setFeedrateMM(double feed) {
    }

    @Override
    public double getCurrentFeedrate() {
        return 0.0;
    }

    @Override
    public void setAccelerationToggle(boolean on) throws RetryException {
    }

    @Override
    public void pauseAtZPos(double zpos) throws RetryException {
    }

    @Override
    public void homeAxes(EnumSet<AxisId> axes, boolean positive, double feedrate) throws RetryException {
    }

    @Override
    public void delay(long millis) throws RetryException {
    }

    @Override
    public void openClamp(int clampIndex) {
    }

    @Override
    public void closeClamp(int clampIndex) {
    }

    @Override
    public void enableDrives() throws RetryException {
    }

    @Override
    public void disableDrives() throws RetryException {
    }

    @Override
    public void enableAxes(EnumSet<AxisId> axes) throws RetryException {
    }

    @Override
    public void disableAxes(EnumSet<AxisId> axes) throws RetryException {
    }

    @Override
    public void changeGearRatio(int ratioIndex) {
    }

    @Override
    public void readToolStatus() {
    }

    @Override
    public int getToolStatus() {
        return 0;
    }

    @Override
    public void setMotorDirection(int dir) {
    }

    @Override
    public void setMotorRPM(double rpm, int toolhead) throws RetryException {
    }

    @Override
    public void setMotorSpeedPWM(int pwm) throws RetryException {
    }

    @Override
    public double getMotorRPM() {
        return 0.0;
    }

    @Override
    public int getMotorSpeedPWM() {
        return 0;
    }

    @Override
    public void enableMotor() throws RetryException {
    }

    @Override
    public void enableMotor(long millis) throws RetryException {
    }

    @Override
    public void disableMotor() throws RetryException {
    }

    @Override
    public void setSpindleRPM(double rpm) throws RetryException {
    }

    @Override
    public void setSpindleSpeedPWM(int pwm) throws RetryException {
    }

    @Override
    public void setSpindleDirection(int dir) {
    }

    @Override
    public double getSpindleRPM() {
        return 0.0;
    }

    @Override
    public int getSpindleSpeedPWM() {
        return 0;
    }

    @Override
    public void enableSpindle() throws RetryException {
    }

    @Override
    public void disableSpindle() throws RetryException {
    }

    @Override
    public void setTemperature(double temperature) throws RetryException {
        this.toolTemperature = temperature;
        this.toolTemperatureSetting = temperature;
    }

    @Override
    public void setTemperature(double temperature, int toolhead) throws RetryException {
        this.toolTemperature = temperature;
        this.toolTemperatureSetting = temperature;
    }

    @Override
    public void readTemperature() {
    }

    @Override
    @Deprecated
    public double getTemperature() {
        return this.toolTemperature;
    }

    @Override
    public double getTemperature(int toolheadIndex) {
        return this.toolTemperature;
    }

    @Override
    public double getTemperatureSetting() {
        return this.toolTemperatureSetting;
    }

    @Override
    public void setPlatformTemperature(double temperature) throws RetryException {
        this.platformTemperature = temperature;
        this.platformTemperatureSetting = temperature;
    }

    @Override
    public void setPlatformTemperature(double temperature, int toolhead) throws RetryException {
        this.platformTemperature = temperature;
        this.platformTemperatureSetting = temperature;
    }

    @Override
    public void readPlatformTemperature() {
    }

    @Override
    public double getPlatformTemperature() {
        return this.platformTemperature;
    }

    @Override
    @Deprecated
    public double getPlatformTemperature(int toolheadIndex) {
        return this.platformTemperature;
    }

    @Override
    public double getPlatformTemperatureSetting() {
        return this.platformTemperatureSetting;
    }

    @Override
    public void setChamberTemperature(double temperature) {
    }

    @Override
    public void readChamberTemperature() {
    }

    @Override
    public double getChamberTemperature() {
        return 0.0;
    }

    @Override
    public void enableFloodCoolant() {
    }

    @Override
    public void disableFloodCoolant() {
    }

    @Override
    public void enableMistCoolant() {
    }

    @Override
    public void disableMistCoolant() {
    }

    @Override
    public void enableFan() throws RetryException {
    }

    @Override
    public void disableFan() throws RetryException {
    }

    @Override
    public void setAutomatedBuildPlatformRunning(boolean state) throws RetryException {
    }

    @Override
    public void openValve() throws RetryException {
    }

    @Override
    public void closeValve() throws RetryException {
    }

    @Override
    public void setStepperVoltage(int stepperId, int referenceValue) {
        Base.logger.finer("VirtualPrinter::setStepperVoltage");
    }

    @Override
    public int getStepperVoltage(int stepperId) {
        Base.logger.finer("VirtualPrinter::setStepperVoltage");
        return 0;
    }

    public void storeStepperVoltage(int stepperId, int referenceValue) {
        Base.logger.finer("VirtualPrinter::storeStepperVoltage");
    }

    @Override
    public void setLedStrip(Color color, int effectId) {
        Base.logger.finer("VirtualPrinter::setLedStrip");
    }

    @Override
    public void sendBeep(int frequencyHz, int durationMs, int effect) throws RetryException {
        Base.logger.finer("VirtualPrinter::sendBeep");
    }

    @Override
    public void openCollet() {
    }

    @Override
    public void closeCollet() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void unpause() {
    }

    @Override
    public void stop(boolean abort) {
    }

    @Override
    public boolean hasSoftStop() {
        return true;
    }

    @Override
    public boolean hasEmergencyStop() {
        return true;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean heartbeat() {
        return false;
    }

    @Override
    public Point5d getMaximumFeedrates() {
        return this.maximumFeedrates;
    }

    @Override
    public boolean hasAutomatedBuildPlatform() {
        return true;
    }

    @Override
    public void readAllTemperatures() {
    }

    @Override
    public void readAllPlatformTemperatures() {
    }

    @Override
    public void setMotorDirection(int dir, int toolhead) {
    }

    @Override
    public void setMotorSpeedPWM(int pwm, int toolhead) throws RetryException {
    }

    @Override
    public void enableMotor(int toolhead) throws RetryException {
    }

    @Override
    public void enableMotor(long millis, int toolhead) throws RetryException {
    }

    @Override
    public void disableMotor(int toolhead) throws RetryException {
    }

    @Override
    public void enableFan(int toolhead) throws RetryException {
    }

    @Override
    public void disableFan(int toolhead) throws RetryException {
    }

    @Override
    public void setAutomatedBuildPlatformRunning(boolean state, int toolhead) throws RetryException {
    }

    @Override
    public String getConfigValue(String value, String baseline) {
        return baseline;
    }

    @Override
    public boolean getPStop() {
        return false;
    }

    @Override
    public void setPStop(boolean enable) {
    }
}

