/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.gen3;

import java.util.EnumMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.w3c.dom.Element;
import replicatorg.app.Base;
import replicatorg.drivers.OnboardParameters;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.Version;
import replicatorg.drivers.gen3.MotherboardCommandCode;
import replicatorg.drivers.gen3.PacketBuilder;
import replicatorg.drivers.gen3.PacketResponse;
import replicatorg.drivers.gen3.Sanguino3GDriver;
import replicatorg.drivers.gen3.ToolCommandCode;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.MachineModel;
import replicatorg.machine.model.ToolModel;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Makerbot4GDriver
extends Sanguino3GDriver {
    private boolean accelerationEnabled = false;
    private boolean stepperExtruderFanEnabled = false;
    EnumMap<AxisId, ToolModel> extruderHijackedMap = new EnumMap(AxisId.class);

    public Makerbot4GDriver() {
        this.minimumAccelerationVersion = new Version(3, 2);
        this.minimumJettyAccelerationVersion = new Version(3, 2);
    }

    @Override
    public String getDriverName() {
        return "Makerbot4G";
    }

    @Override
    public boolean hasAcceleration() {
        return this.version.compareTo(this.getMinimumAccelerationVersion()) >= 0;
    }

    @Override
    public boolean hasJettyAcceleration() {
        if (this.version.compareTo(this.getMinimumJettyAccelerationVersion()) < 0) {
            return false;
        }
        return this.hasAcceleration();
    }

    @Override
    public void reset() {
        this.stepperExtruderFanEnabled = false;
        super.reset();
    }

    @Override
    public void stop(boolean abort) {
        this.machine.currentTool().disableMotor();
        this.stepperExtruderFanEnabled = false;
        super.stop(abort);
    }

    private Iterable<AxisId> getHijackedAxes(int toolhead) {
        Vector<AxisId> axes = new Vector<AxisId>();
        AxisId toolheadAxis = this.machine.getTool(toolhead).getMotorStepperAxis();
        if (this.extruderHijackedMap.containsKey((Object)toolheadAxis)) {
            axes.add(toolheadAxis);
        }
        return axes;
    }

    private Iterable<AxisId> getAllHijackedAxes() {
        Vector<AxisId> axes = new Vector<AxisId>();
        for (Map.Entry<AxisId, ToolModel> entry : this.extruderHijackedMap.entrySet()) {
            AxisId axis = entry.getKey();
            axes.add(axis);
        }
        return axes;
    }

    @Override
    @Deprecated
    protected void queueAbsolutePoint(Point5d steps, long micros) throws RetryException {
        int toolhead = this.machine.currentTool().getIndex();
        for (AxisId axis : this.getHijackedAxes(toolhead)) {
            if (steps.axis(axis) == 0.0) continue;
            this.enableStepperExtruderFan(true, toolhead);
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.QUEUE_POINT_EXT.getCode());
        if (Base.logger.isLoggable(Level.FINE)) {
            Base.logger.log(Level.FINE, "Queued absolute point " + steps + " at " + Long.toString(micros) + " usec.");
        }
        pb.add32((int)steps.x());
        pb.add32((int)steps.y());
        pb.add32((int)steps.z());
        pb.add32((int)steps.a());
        pb.add32((int)steps.b());
        pb.add32((int)micros);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void setCurrentPosition(Point5d p) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.SET_POSITION_EXT.getCode());
        Point5d excess = new Point5d(this.pastExcess);
        if (this.absoluteXYZ) {
            excess.setX(0.0);
            excess.setY(0.0);
            excess.setZ(0.0);
        }
        Point5d steps = this.machine.mmToSteps(p, excess);
        pb.add32((long)steps.x());
        pb.add32((long)steps.y());
        pb.add32((long)steps.z());
        pb.add32((long)steps.a());
        pb.add32((long)steps.b());
        Base.logger.log(Level.FINE, "Set current position to " + p + " (" + steps + ")");
        this.runCommand(pb.getPacket());
        this.currentPosition.set(p);
    }

    @Override
    protected Point5d reconcilePosition() {
        Point5d steps;
        if (this.fileCaptureOstream != null) {
            return null;
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.GET_POSITION_EXT.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        try {
            steps = new Point5d(pr.get32(), pr.get32(), pr.get32(), pr.get32(), pr.get32());
        }
        catch (NullPointerException npe) {
            Base.logger.log(Level.FINEST, "Invalid response packet");
            return null;
        }
        return this.machine.stepsToMM(steps);
    }

    @Override
    public void enableMotor() throws RetryException {
        Base.logger.fine("MakerBot4G.enableMotor()");
        this.machine.currentTool().enableMotor();
    }

    @Override
    public void disableMotor() throws RetryException {
        Base.logger.fine("MakerBot4G.enableMotor()");
        this.machine.currentTool().disableMotor();
    }

    @Override
    public void setMotorSpeedPWM(int pwm) throws RetryException {
        this.machine.currentTool().setMotorSpeedPWM(pwm);
    }

    @Override
    public void setMotorRPM(double rpm, int toolhead) throws RetryException {
        if (toolhead == -1) {
            this.machine.currentTool().setMotorSpeedRPM(rpm);
        } else {
            this.machine.getTool(toolhead).setMotorSpeedRPM(rpm);
        }
    }

    @Override
    public void enableDrives() throws RetryException {
        this.enableStepperExtruderFan(true, this.machine.currentTool().getIndex());
        super.enableDrives();
    }

    @Override
    public void disableDrives() throws RetryException {
        this.enableStepperExtruderFan(false, this.machine.currentTool().getIndex());
        super.disableDrives();
    }

    @Deprecated
    public void enableStepperExtruderFan(boolean enabled) throws RetryException {
        this.enableStepperExtruderFan(enabled, this.machine.currentTool().getIndex());
    }

    public void enableStepperExtruderFan(boolean enabled, int toolIndex) throws RetryException {
        if (this.stepperExtruderFanEnabled == enabled) {
            return;
        }
        byte flags = (byte)(enabled ? 1 : 0);
        flags = (byte)(flags | 2);
        Base.logger.log(Level.FINE, "Stepper Extruder fan w/flags: " + Integer.toBinaryString(flags));
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolIndex);
        pb.add8(ToolCommandCode.TOGGLE_MOTOR_1.getCode());
        pb.add8(1);
        pb.add8(flags);
        this.runCommand(pb.getPacket());
        pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)toolIndex);
        pb.add8(ToolCommandCode.SET_MOTOR_1_PWM.getCode());
        pb.add8(1);
        pb.add8(-1);
        this.runCommand(pb.getPacket());
        this.stepperExtruderFanEnabled = enabled;
    }

    @Override
    public void setMachine(MachineModel m) {
        super.setMachine(m);
        for (ToolModel tm : m.getTools()) {
            Element e = (Element)tm.getXml();
            if (!e.hasAttribute("stepper_axis")) continue;
            String stepAxisStr = e.getAttribute("stepper_axis");
            try {
                AxisId axis = AxisId.valueOf(stepAxisStr.toUpperCase());
                if (m.hasAxis(axis)) {
                    this.extruderHijackedMap.put(axis, tm);
                    continue;
                }
                Base.logger.severe("Tool claims unavailable axis " + axis.name());
            }
            catch (IllegalArgumentException iae) {
                Base.logger.severe("Unintelligible axis designator " + stepAxisStr);
            }
        }
    }

    @Override
    public EnumMap<AxisId, String> getAxisAlises() {
        EnumMap<AxisId, String> map = new EnumMap<AxisId, String>(AxisId.class);
        for (AxisId id : this.extruderHijackedMap.keySet()) {
            ToolModel t = this.extruderHijackedMap.get((Object)id);
            map.put(id, t.getName());
        }
        return map;
    }

    @Override
    public String getMachineType() {
        return "Thing-O-Matic/CupCake CNC";
    }

    private void getAccelerationState() {
        Base.logger.fine("Geting Acceleration Status from Bot");
        boolean bl = this.accelerationEnabled = 0 != (this.getAccelerationStatus() & 1);
        if (this.accelerationEnabled) {
            Base.logger.finest("Found accelerated firmware active");
        }
    }

    @Override
    public String getConfigValue(String key, String baseline) {
        this.getAccelerationState();
        if (this.accelerationEnabled) {
            if (key.equals("desiredFeedrate")) {
                return "80";
            }
            if (key.equals("travelFeedrate")) {
                return "150";
            }
            if (key.equals("printTemp")) {
                return "240";
            }
        } else {
            if (key.equals("desiredFeedrate")) {
                return "40";
            }
            if (key.equals("travelFeedrate")) {
                return "55";
            }
            if (key.equals("printTemp")) {
                return "220";
            }
        }
        return baseline;
    }

    private int readInt32FromEEPROM(int offset) {
        byte[] r = this.readFromEEPROM(offset, 4);
        if (r == null || r.length < 4) {
            Base.logger.severe("invalid read from read32FromEEPROM at " + offset);
            return 0;
        }
        int val = r[0] & 0xFF;
        val += (r[1] & 0xFF) << 8;
        val += (r[2] & 0xFF) << 16;
        val += (r[3] & 0x7F) << 24;
        if (r[3] < 0) {
            val = -val;
        }
        return val;
    }

    private long readUInt32FromEEPROM(int offset) {
        byte[] r = this.readFromEEPROM(offset, 4);
        if (r == null || r.length < 4) {
            Base.logger.severe("invalid read from read32FromEEPROM at " + offset);
            return 0L;
        }
        long val = (long)r[0] & 0xFFL;
        val += ((long)r[1] & 0xFFL) << 8;
        val += ((long)r[2] & 0xFFL) << 16;
        return val += ((long)r[3] & 0xFFL) << 24;
    }

    private void writeInt32ToEEPROM(int offset, int value) {
        int s = value;
        byte[] buf = new byte[4];
        for (int i = 0; i < 4; ++i) {
            buf[i] = (byte)(s & 0xFF);
            s >>>= 8;
        }
        this.writeToEEPROM(offset, buf);
    }

    private void writeUInt32ToEEPROM(int offset, long value) {
        int v = value > 0xFFFFFFFFL ? -1 : (value > 0L ? (int)(0xFFFFFFFFL & value) : 0);
        this.writeInt32ToEEPROM(offset, v);
    }

    private int getUInt8EEPROM(int offset) {
        byte[] val = this.readFromEEPROM(offset, 1);
        int i = (val[0] & 0x7F) + ((0x80 & val[0]) != 0 ? 128 : 0);
        return i;
    }

    private void setUInt8EEPROM(int offset, int val) {
        byte[] b = new byte[1];
        if (val > 255) {
            val = 255;
        }
        b[0] = (byte)(0xFF & val);
        this.writeToEEPROM(offset, b);
    }

    private long getUInt32EEPROM(int offset) {
        return this.readUInt32FromEEPROM(offset);
    }

    private void setUInt32EEPROM(int offset, long val) {
        this.writeUInt32ToEEPROM(offset, val);
    }

    @Override
    public byte getAccelerationStatus() {
        byte[] val = this.readFromEEPROM(294, 1);
        return val[0];
    }

    @Override
    public void setAccelerationStatus(byte status) {
        byte[] b = new byte[1];
        if (0 == ((status = (byte)(status & 7)) & 1)) {
            status = 0;
        }
        b[0] = status;
        this.writeToEEPROM(294, b);
    }

    @Override
    public int getEEPROMParamInt(OnboardParameters.EEPROMParams param) {
        switch (param) {
            case ABP_COPIES: {
                return this.getUInt8EEPROM(195);
            }
            case AXIS_INVERSION: {
                return this.getUInt8EEPROM(2);
            }
            case BUZZER_REPEATS: {
                return this.getUInt8EEPROM(138);
            }
            case ENDSTOPS_USED: {
                return this.getUInt8EEPROM(372);
            }
            case ENDSTOP_INVERSION: {
                return this.getUInt8EEPROM(3);
            }
            case ESTOP_CONFIGURATION: {
                return this.getUInt8EEPROM(116);
            }
            case EXTRUDE_DURATION: {
                return this.getUInt8EEPROM(131);
            }
            case EXTRUDE_MMS: {
                return this.getUInt8EEPROM(132);
            }
            case INVERTED_EXTRUDER_5D: {
                return this.getUInt8EEPROM(401);
            }
            case JOG_MODE_SETTINGS: {
                return this.getUInt8EEPROM(137);
            }
            case LCD_TYPE: {
                return this.getUInt8EEPROM(371);
            }
            case MOOD_LIGHT_CUSTOM_BLUE: {
                return this.getUInt8EEPROM(136);
            }
            case MOOD_LIGHT_CUSTOM_GREEN: {
                return this.getUInt8EEPROM(135);
            }
            case MOOD_LIGHT_CUSTOM_RED: {
                return this.getUInt8EEPROM(134);
            }
            case MOOD_LIGHT_SCRIPT: {
                return this.getUInt8EEPROM(133);
            }
            case OVERRIDE_GCODE_TEMP: {
                return this.getUInt8EEPROM(197);
            }
            case PLATFORM_TEMP: {
                return this.getUInt8EEPROM(130);
            }
            case PREHEAT_DURING_ESTIMATE: {
                return this.getUInt8EEPROM(196);
            }
            case STEPPER_DRIVER: {
                return this.getUInt8EEPROM(294);
            }
            case TOOL0_TEMP: {
                return this.getUInt8EEPROM(128);
            }
            case TOOL1_TEMP: {
                return this.getUInt8EEPROM(129);
            }
            case VERSION_HIGH: {
                return this.getUInt8EEPROM(1);
            }
            case VERSION_LOW: {
                return this.getUInt8EEPROM(0);
            }
        }
        Base.logger.log(Level.WARNING, "getEEPROMParamInt(" + (Object)((Object)param) + ") call failed");
        return 0;
    }

    @Override
    public long getEEPROMParamUInt(OnboardParameters.EEPROMParams param) {
        switch (param) {
            case ACCEL_CLOCKWISE_EXTRUDER: {
                return this.getUInt32EEPROM(397);
            }
            case ACCEL_MAX_ACCELERATION_A: {
                return this.getUInt32EEPROM(327);
            }
            case ACCEL_MAX_ACCELERATION_X: {
                return this.getUInt32EEPROM(315);
            }
            case ACCEL_MAX_ACCELERATION_Y: {
                return this.getUInt32EEPROM(319);
            }
            case ACCEL_MAX_ACCELERATION_Z: {
                return this.getUInt32EEPROM(323);
            }
            case ACCEL_MAX_EXTRUDER_NORM: {
                return this.getUInt32EEPROM(331);
            }
            case ACCEL_MAX_EXTRUDER_RETRACT: {
                return this.getUInt32EEPROM(335);
            }
            case ACCEL_MAX_FEEDRATE_A: {
                return this.getUInt32EEPROM(307);
            }
            case ACCEL_MAX_FEEDRATE_B: {
                return this.getUInt32EEPROM(311);
            }
            case ACCEL_MAX_FEEDRATE_X: {
                return this.getUInt32EEPROM(295);
            }
            case ACCEL_MAX_FEEDRATE_Y: {
                return this.getUInt32EEPROM(299);
            }
            case ACCEL_MAX_FEEDRATE_Z: {
                return this.getUInt32EEPROM(303);
            }
            case ACCEL_MIN_PLANNER_SPEED: {
                return this.getUInt32EEPROM(355);
            }
            case ACCEL_REV_MAX_FEED_RATE: {
                return this.getUInt32EEPROM(385);
            }
            case ACCEL_SLOWDOWN_LIMIT: {
                return this.getUInt32EEPROM(393);
            }
            case HOMING_FEED_RATE_X: {
                return this.getUInt32EEPROM(373);
            }
            case HOMING_FEED_RATE_Y: {
                return this.getUInt32EEPROM(377);
            }
            case HOMING_FEED_RATE_Z: {
                return this.getUInt32EEPROM(381);
            }
            case RAM_USAGE_DEBUG: {
                return this.getUInt32EEPROM(464);
            }
        }
        Base.logger.log(Level.WARNING, "getEEPROMParamUInt(" + (Object)((Object)param) + ") call failed");
        return 0L;
    }

    @Override
    public double getEEPROMParamFloat(OnboardParameters.EEPROMParams param) {
        switch (param) {
            case ACCEL_ADVANCE_K: {
                return (double)this.getUInt32EEPROM(359) / 100000.0;
            }
            case ACCEL_ADVANCE_K2: {
                return (double)this.getUInt32EEPROM(351) / 100000.0;
            }
            case ACCEL_EXTRUDER_DEPRIME_A: {
                return (double)this.getUInt32EEPROM(389) / 10.0;
            }
            case ACCEL_E_STEPS_PER_MM: {
                return (double)this.getUInt32EEPROM(339) / 10.0;
            }
            case ACCEL_MAX_SPEED_CHANGE_A: {
                return (double)this.getUInt32EEPROM(414) / 10.0;
            }
            case ACCEL_MAX_SPEED_CHANGE_X: {
                return (double)this.getUInt32EEPROM(402) / 10.0;
            }
            case ACCEL_MAX_SPEED_CHANGE_Y: {
                return (double)this.getUInt32EEPROM(406) / 10.0;
            }
            case ACCEL_MAX_SPEED_CHANGE_Z: {
                return (double)this.getUInt32EEPROM(410) / 10.0;
            }
            case ACCEL_MIN_FEED_RATE: {
                return (double)this.getUInt32EEPROM(343) / 10.0;
            }
            case ACCEL_MIN_SEGMENT_TIME: {
                return (double)this.getUInt32EEPROM(367) / 10000.0;
            }
            case ACCEL_MIN_TRAVEL_FEED_RATE: {
                return (double)this.getUInt32EEPROM(347) / 10.0;
            }
            case ACCEL_NOODLE_DIAMETER: {
                return (double)this.getUInt32EEPROM(363) / 100.0;
            }
        }
        Base.logger.log(Level.WARNING, "getEEPROMParamFloat(" + (Object)((Object)param) + ") call failed");
        return 0.0;
    }

    @Override
    public void setEEPROMParam(OnboardParameters.EEPROMParams param, int val) {
        if (val < 0) {
            val = 0;
        }
        switch (param) {
            case ABP_COPIES: {
                this.setUInt8EEPROM(195, val);
                break;
            }
            case AXIS_INVERSION: {
                this.setUInt8EEPROM(2, val);
                break;
            }
            case BUZZER_REPEATS: {
                this.setUInt8EEPROM(138, val);
                break;
            }
            case ENDSTOPS_USED: {
                this.setUInt8EEPROM(372, val);
                break;
            }
            case ENDSTOP_INVERSION: {
                this.setUInt8EEPROM(3, val);
                break;
            }
            case ESTOP_CONFIGURATION: {
                this.setUInt8EEPROM(116, val);
                break;
            }
            case EXTRUDE_DURATION: {
                this.setUInt8EEPROM(131, val);
                break;
            }
            case EXTRUDE_MMS: {
                this.setUInt8EEPROM(132, val);
                break;
            }
            case INVERTED_EXTRUDER_5D: {
                this.setUInt8EEPROM(401, val);
                break;
            }
            case JOG_MODE_SETTINGS: {
                this.setUInt8EEPROM(137, val);
                break;
            }
            case LCD_TYPE: {
                this.setUInt8EEPROM(371, val);
                break;
            }
            case MOOD_LIGHT_CUSTOM_BLUE: {
                this.setUInt8EEPROM(136, val);
                break;
            }
            case MOOD_LIGHT_CUSTOM_GREEN: {
                this.setUInt8EEPROM(135, val);
                break;
            }
            case MOOD_LIGHT_CUSTOM_RED: {
                this.setUInt8EEPROM(134, val);
                break;
            }
            case MOOD_LIGHT_SCRIPT: {
                this.setUInt8EEPROM(133, val);
                break;
            }
            case OVERRIDE_GCODE_TEMP: {
                this.setUInt8EEPROM(197, val);
                break;
            }
            case PLATFORM_TEMP: {
                this.setUInt8EEPROM(130, val);
                break;
            }
            case PREHEAT_DURING_ESTIMATE: {
                this.setUInt8EEPROM(196, val);
                break;
            }
            case STEPPER_DRIVER: {
                this.setUInt8EEPROM(294, val);
                break;
            }
            case TOOL0_TEMP: {
                this.setUInt8EEPROM(128, val);
                break;
            }
            case TOOL1_TEMP: {
                this.setUInt8EEPROM(129, val);
                break;
            }
            case VERSION_HIGH: {
                this.setUInt8EEPROM(1, val);
                break;
            }
            case VERSION_LOW: {
                this.setUInt8EEPROM(0, val);
                break;
            }
            default: {
                Base.logger.log(Level.WARNING, "setEEPROMParam(" + (Object)((Object)param) + ", " + val + ") call failed");
            }
        }
    }

    @Override
    public void setEEPROMParam(OnboardParameters.EEPROMParams param, long val) {
        if (val < 0L) {
            val = 0L;
        }
        switch (param) {
            case ACCEL_CLOCKWISE_EXTRUDER: {
                this.setUInt32EEPROM(397, val);
                break;
            }
            case ACCEL_MAX_ACCELERATION_A: {
                this.setUInt32EEPROM(327, val);
                break;
            }
            case ACCEL_MAX_ACCELERATION_X: {
                this.setUInt32EEPROM(315, val);
                break;
            }
            case ACCEL_MAX_ACCELERATION_Y: {
                this.setUInt32EEPROM(319, val);
                break;
            }
            case ACCEL_MAX_ACCELERATION_Z: {
                this.setUInt32EEPROM(323, val);
                break;
            }
            case ACCEL_MAX_EXTRUDER_NORM: {
                this.setUInt32EEPROM(331, val);
                break;
            }
            case ACCEL_MAX_EXTRUDER_RETRACT: {
                this.setUInt32EEPROM(335, val);
                break;
            }
            case ACCEL_MAX_FEEDRATE_A: {
                this.setUInt32EEPROM(307, val);
                break;
            }
            case ACCEL_MAX_FEEDRATE_B: {
                this.setUInt32EEPROM(311, val);
                break;
            }
            case ACCEL_MAX_FEEDRATE_X: {
                this.setUInt32EEPROM(295, val);
                break;
            }
            case ACCEL_MAX_FEEDRATE_Y: {
                this.setUInt32EEPROM(299, val);
                break;
            }
            case ACCEL_MAX_FEEDRATE_Z: {
                this.setUInt32EEPROM(303, val);
                break;
            }
            case ACCEL_MIN_PLANNER_SPEED: {
                this.setUInt32EEPROM(355, val);
                break;
            }
            case ACCEL_REV_MAX_FEED_RATE: {
                this.setUInt32EEPROM(385, val);
                break;
            }
            case ACCEL_SLOWDOWN_LIMIT: {
                this.setUInt32EEPROM(393, val);
                break;
            }
            case HOMING_FEED_RATE_X: {
                this.setUInt32EEPROM(373, val);
                break;
            }
            case HOMING_FEED_RATE_Y: {
                this.setUInt32EEPROM(377, val);
                break;
            }
            case HOMING_FEED_RATE_Z: {
                this.setUInt32EEPROM(381, val);
                break;
            }
            case RAM_USAGE_DEBUG: {
                this.setUInt32EEPROM(464, val);
                break;
            }
            default: {
                Base.logger.log(Level.WARNING, "setEEPROMParam(" + (Object)((Object)param) + ", " + val + ") call failed");
            }
        }
    }

    @Override
    public void setEEPROMParam(OnboardParameters.EEPROMParams param, double val) {
        if (val < 0.0) {
            val = 0.0;
        }
        switch (param) {
            case ACCEL_ADVANCE_K: {
                this.setUInt32EEPROM(359, (long)(val * 100000.0));
                break;
            }
            case ACCEL_ADVANCE_K2: {
                this.setUInt32EEPROM(351, (long)(val * 100000.0));
                break;
            }
            case ACCEL_EXTRUDER_DEPRIME_A: {
                this.setUInt32EEPROM(389, (long)(val * 10.0));
                break;
            }
            case ACCEL_E_STEPS_PER_MM: {
                this.setUInt32EEPROM(339, (long)(val * 10.0));
                break;
            }
            case ACCEL_MAX_SPEED_CHANGE_A: {
                this.setUInt32EEPROM(414, (long)(val * 10.0));
                break;
            }
            case ACCEL_MAX_SPEED_CHANGE_X: {
                this.setUInt32EEPROM(402, (long)(val * 10.0));
                break;
            }
            case ACCEL_MAX_SPEED_CHANGE_Y: {
                this.setUInt32EEPROM(406, (long)(val * 10.0));
                break;
            }
            case ACCEL_MAX_SPEED_CHANGE_Z: {
                this.setUInt32EEPROM(410, (long)(val * 10.0));
                break;
            }
            case ACCEL_MIN_FEED_RATE: {
                this.setUInt32EEPROM(343, (long)(val * 10.0));
                break;
            }
            case ACCEL_MIN_SEGMENT_TIME: {
                this.setUInt32EEPROM(367, (long)(val * 10000.0));
                break;
            }
            case ACCEL_MIN_TRAVEL_FEED_RATE: {
                this.setUInt32EEPROM(347, (long)(val * 10.0));
                break;
            }
            case ACCEL_NOODLE_DIAMETER: {
                this.setUInt32EEPROM(363, (long)(val * 100.0));
                break;
            }
            default: {
                Base.logger.log(Level.WARNING, "setEEPROMParam(" + (Object)((Object)param) + ", " + val + ") call failed");
            }
        }
    }

    @Override
    public void resetSettingsToFactory() throws RetryException {
        Base.logger.finer("resetting to factory in Makerbot4G");
        if (this.hasAcceleration()) {
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.RESET_TO_FACTORY.getCode());
            pb.add8(-1);
            PacketResponse packetResponse = this.runCommand(pb.getPacket());
        } else {
            super.resetSettingsToBlank();
        }
    }
}

