/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine;

import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import replicatorg.app.Base;
import replicatorg.machine.MachineListener;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineToolStatusEvent;

public class MachineCallbackHandler
extends Thread {
    private Vector<MachineListener> listeners = new Vector();
    ConcurrentLinkedQueue<MachineStateChangeEvent> machineStateChangeEventQueue = new ConcurrentLinkedQueue();
    ConcurrentLinkedQueue<MachineProgressEvent> machineProgressEventQueue = new ConcurrentLinkedQueue();
    ConcurrentLinkedQueue<MachineToolStatusEvent> machineToolStatusEventQueue = new ConcurrentLinkedQueue();

    public MachineCallbackHandler() {
        super("Machine Callback Handler");
    }

    private synchronized void sendMessages() {
        while (!this.machineStateChangeEventQueue.isEmpty()) {
            for (MachineListener l : this.listeners) {
                l.machineStateChanged(this.machineStateChangeEventQueue.peek());
            }
            Base.logger.fine("Sending machine state change event: " + this.machineStateChangeEventQueue.peek().getState().getState().toString());
            this.machineStateChangeEventQueue.remove();
        }
        while (!this.machineProgressEventQueue.isEmpty()) {
            for (MachineListener l : this.listeners) {
                l.machineProgress(this.machineProgressEventQueue.peek());
            }
            this.machineProgressEventQueue.remove();
        }
        while (!this.machineToolStatusEventQueue.isEmpty()) {
            for (MachineListener l : this.listeners) {
                l.toolStatusChanged(this.machineToolStatusEventQueue.peek());
            }
            this.machineToolStatusEventQueue.remove();
        }
    }

    public void run() {
        try {
            while (true) {
                this.sendMessages();
                MachineCallbackHandler.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            Base.logger.fine("taking callback handler down, state change queue: " + this.machineStateChangeEventQueue.size());
            return;
        }
    }

    public synchronized void addMachineListener(MachineListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeMachineListener(MachineListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void schedule(MachineStateChangeEvent status) {
        this.machineStateChangeEventQueue.add(status);
        Base.logger.fine("Scheduling machine state change event: " + status.getState().getState().toString());
    }

    public synchronized void schedule(MachineProgressEvent progress) {
        this.machineProgressEventQueue.add(progress);
    }

    public synchronized void schedule(MachineToolStatusEvent e) {
        this.machineToolStatusEventQueue.add(e);
    }
}

