/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine;

import replicatorg.app.Base;
import replicatorg.drivers.Driver;
import replicatorg.machine.MachineCallbackHandler;
import replicatorg.machine.MachineFactory;
import replicatorg.machine.MachineInterface;
import replicatorg.machine.MachineListener;

public class MachineLoader {
    private MachineInterface singletonMI;
    private String singletonMIType = "";
    MachineCallbackHandler callbackHandler = new MachineCallbackHandler();

    public MachineLoader() {
        this.callbackHandler.start();
    }

    public void dispose() {
        if (this.callbackHandler != null) {
            this.callbackHandler.interrupt();
            try {
                this.callbackHandler.join(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public MachineInterface getMachineInterface() {
        return this.singletonMI;
    }

    public MachineInterface getMachineInterface(String machineType) {
        if (this.singletonMI != null && machineType.equals(this.singletonMIType)) {
            return this.singletonMI;
        }
        if (this.singletonMI == null || machineType.equals("")) {
            this.singletonMI = MachineFactory.load(machineType, this.callbackHandler);
            if (this.singletonMI != null) {
                this.singletonMIType = machineType;
            }
            return this.singletonMI;
        }
        if (this.singletonMI != null && !machineType.equals(this.singletonMIType)) {
            Base.logger.finest("MachineLoader loading new machine type " + machineType + " over existing machine " + this.singletonMIType);
            this.singletonMI.dispose();
            this.singletonMI = MachineFactory.load(machineType, this.callbackHandler);
            if (this.singletonMI != null) {
                this.singletonMIType = machineType;
            }
            return this.singletonMI;
        }
        return null;
    }

    public boolean isLoaded() {
        return this.singletonMI != null;
    }

    public boolean isConnected() {
        return this.isLoaded() && this.singletonMI.isConnected();
    }

    @Deprecated
    public Driver getDriver() {
        if (!this.isLoaded()) {
            return null;
        }
        return this.singletonMI.getDriver();
    }

    public void unload() {
        if (this.isLoaded()) {
            this.singletonMI.dispose();
            this.singletonMI = null;
        }
    }

    public void connect(String port) {
        if (!this.isLoaded()) {
            return;
        }
        this.singletonMI.connect(port);
    }

    public void disconnect() {
        if (this.isLoaded()) {
            this.singletonMI.disconnect();
        }
    }

    public void addMachineListener(MachineListener listener) {
        this.callbackHandler.addMachineListener(listener);
    }

    public void removeMachineListener(MachineListener listener) {
        this.callbackHandler.removeMachineListener(listener);
    }

    public void clearSingleton() {
        if (this.singletonMI != null) {
            this.singletonMI.dispose();
            this.singletonMI = null;
        }
    }
}

