/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine.model;

import java.io.File;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.app.Base;
import replicatorg.app.tools.XML;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.BuildVolume;
import replicatorg.machine.model.ClampModel;
import replicatorg.machine.model.Endstops;
import replicatorg.machine.model.MachineType;
import replicatorg.machine.model.ToolModel;
import replicatorg.machine.model.ToolheadAlias;
import replicatorg.machine.model.ToolheadsOffset;
import replicatorg.machine.model.WipeModel;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MachineModel {
    protected Node xml = null;
    private Point5d minimum;
    private Point5d maximum;
    private EnumMap<AxisId, Endstops> endstops = new EnumMap(AxisId.class);
    private Set<AxisId> axes = EnumSet.noneOf(AxisId.class);
    private Point5d maximumFeedrateSteps;
    private Point5d homingFeedrates;
    private Point5d stepsPerMM;
    private Point5d timeOut;
    protected boolean drivesEnabled = true;
    protected int gearRatio = 0;
    protected Vector<ToolModel> tools;
    protected final AtomicReference<ToolModel> currentTool = new AtomicReference();
    protected final ToolModel nullTool = new ToolModel();
    protected Vector<ClampModel> clamps;
    protected Vector<WipeModel> wipes = new Vector();
    protected File dualstartBookendCode = null;
    protected File startBookendCode = null;
    protected File endBookendCode = null;
    protected BuildVolume buildVolume;
    protected ToolheadsOffset toolheadsOfffsets;
    private MachineType machineType = null;

    public MachineModel() {
        this.clamps = new Vector();
        this.tools = new Vector();
        this.buildVolume = new BuildVolume(100, 100, 100);
        this.toolheadsOfffsets = new ToolheadsOffset(0.0, 0.0, 0.0);
        this.minimum = new Point5d();
        this.maximum = new Point5d();
        this.maximumFeedrateSteps = new Point5d();
        this.homingFeedrates = new Point5d();
        this.timeOut = new Point5d();
        this.stepsPerMM = new Point5d(1.0, 1.0, 1.0, 1.0, 1.0);
        this.currentTool.set(this.nullTool);
    }

    public void loadXML(Node node) {
        this.xml = node;
        this.parseType();
        this.parseAxes();
        this.parseClamps();
        this.parseTools();
        this.parseBuildVolume();
        this.parseWipes();
        this.parseExclusion();
        this.parseGCode();
        this.parseOffsets();
    }

    private void parseType() {
        NodeList kids = this.xml.getChildNodes();
        for (int j = 0; j < kids.getLength(); ++j) {
            Node kid = kids.item(j);
            if (!kid.getNodeName().equals("name")) continue;
            String name = kid.getFirstChild().getNodeValue().trim();
            if (name.startsWith("Replicator 2")) {
                this.machineType = MachineType.REPLICATOR_2;
            }
            if (name.startsWith("The Replicator")) {
                this.machineType = MachineType.THE_REPLICATOR;
            } else if (name.startsWith("Thingomatic")) {
                this.machineType = MachineType.THINGOMATIC;
            } else if (name.startsWith("Cupcake")) {
                this.machineType = MachineType.CUPCAKE;
            }
            return;
        }
    }

    private void parseExclusion() {
        if (XML.hasChildNode(this.xml, "exclusion")) {
            Node exclusionNode = XML.getChildNodeByName(this.xml, "wipes");
            NodeList exclusionKids = exclusionNode.getChildNodes();
            for (int i = 0; i < exclusionKids.getLength(); ++i) {
                Node exclusionZoneNode = exclusionKids.item(i);
                if (!exclusionZoneNode.getNodeName().equals("wipe")) continue;
                WipeModel wipe = new WipeModel(exclusionZoneNode);
                this.wipes.add(wipe);
            }
        }
    }

    private void parseWipes() {
        if (XML.hasChildNode(this.xml, "wipes")) {
            Node wipesNode = XML.getChildNodeByName(this.xml, "wipes");
            NodeList wipesKids = wipesNode.getChildNodes();
            for (int i = 0; i < wipesKids.getLength(); ++i) {
                Node wipeNode = wipesKids.item(i);
                if (!wipeNode.getNodeName().equals("wipe")) continue;
                WipeModel wipe = new WipeModel(wipeNode);
                this.wipes.add(wipe);
            }
        }
    }

    private void parseOffsets() {
        if (XML.hasChildNode(this.xml, "offsets")) {
            Node offsetsNode = XML.getChildNodeByName(this.xml, "offsets");
            NodeList offsetsKids = offsetsNode.getChildNodes();
            for (int i = 0; i < offsetsKids.getLength(); ++i) {
                Node offsetNode = offsetsKids.item(i);
                if (!offsetNode.getNodeName().equals("offset")) continue;
                double xNozzleOffset = 0.0;
                double yNozzleOffset = 0.0;
                double zNozzleOffset = 0.0;
                try {
                    xNozzleOffset = Double.parseDouble(XML.getAttributeValue(offsetNode, "xNozzle"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    yNozzleOffset = Double.parseDouble(XML.getAttributeValue(offsetNode, "yNozzle"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    zNozzleOffset = Double.parseDouble(XML.getAttributeValue(offsetNode, "zNozzle"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.toolheadsOfffsets.setX(xNozzleOffset);
                this.toolheadsOfffsets.setY(yNozzleOffset);
                this.toolheadsOfffsets.setZ(zNozzleOffset);
            }
        }
    }

    private void parseAxes() {
        if (XML.hasChildNode(this.xml, "geometry")) {
            Node geometry = XML.getChildNodeByName(this.xml, "geometry");
            NodeList axisNodes = geometry.getChildNodes();
            for (int i = 0; i < axisNodes.getLength(); ++i) {
                Node axis = axisNodes.item(i);
                if (!axis.getNodeName().equals("axis")) continue;
                String idStr = XML.getAttributeValue(axis, "id");
                try {
                    AxisId id = AxisId.valueOf(idStr.toUpperCase());
                    this.axes.add(id);
                    double length = 0.0;
                    double maxFeedrate = 0.0;
                    double homingFeedrate = 0.0;
                    double stepspermm = 1.0;
                    Endstops endstops = Endstops.NONE;
                    double defaultTimeout = 20.0;
                    double timeout = 0.0;
                    try {
                        length = Double.parseDouble(XML.getAttributeValue(axis, "length"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        maxFeedrate = Double.parseDouble(XML.getAttributeValue(axis, "maxfeedrate"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        homingFeedrate = Double.parseDouble(XML.getAttributeValue(axis, "homingfeedrate"));
                    }
                    catch (Exception e) {
                        homingFeedrate = maxFeedrate;
                    }
                    try {
                        String spmm = XML.getAttributeValue(axis, "stepspermm");
                        if (spmm == null) {
                            spmm = XML.getAttributeValue(axis, "scale");
                        }
                        stepspermm = Double.parseDouble(spmm);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        timeout = Double.parseDouble(XML.getAttributeValue(axis, "timeout"));
                    }
                    catch (Exception e) {
                        timeout = defaultTimeout;
                    }
                    String endstopStr = XML.getAttributeValue(axis, "endstops");
                    if (endstopStr != null) {
                        try {
                            endstops = Endstops.valueOf(endstopStr.toUpperCase());
                        }
                        catch (IllegalArgumentException iae) {
                            Base.logger.severe("Unrecognized endstop value " + endstopStr + " for axis " + id.name());
                        }
                    }
                    this.maximum.setAxis(id, length);
                    this.maximumFeedrateSteps.setAxis(id, maxFeedrate);
                    this.homingFeedrates.setAxis(id, homingFeedrate);
                    this.stepsPerMM.setAxis(id, stepspermm);
                    this.timeOut.setAxis(id, timeout);
                    this.endstops.put(id, endstops);
                    Base.logger.fine("Loaded axis " + id.name() + ": (Length: " + length + "mm, max feedrate: " + maxFeedrate + " mm/min, homing feedrate: " + homingFeedrate + " mm/min, scale: " + stepspermm + " steps/mm" + "seconds, timeout: " + timeout + ")");
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    Base.logger.severe("Unrecognized axis " + idStr + " found in machine descriptor!");
                }
            }
        }
    }

    private void parseClamps() {
        if (XML.hasChildNode(this.xml, "clamps")) {
            Node clampsNode = XML.getChildNodeByName(this.xml, "clamps");
            NodeList clampKids = clampsNode.getChildNodes();
            for (int i = 0; i < clampKids.getLength(); ++i) {
                Node clampNode = clampKids.item(i);
                ClampModel clamp = new ClampModel(clampNode);
                this.clamps.add(clamp);
                System.out.println("adding clamp #" + this.clamps.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTools() {
        if (XML.hasChildNode(this.xml, "tools")) {
            Node toolsNode = XML.getChildNodeByName(this.xml, "tools");
            NodeList toolKids = toolsNode.getChildNodes();
            for (int i = 0; i < toolKids.getLength(); ++i) {
                Node toolNode = toolKids.item(i);
                if (!toolNode.getNodeName().equals("tool")) continue;
                ToolModel tool = new ToolModel(toolNode);
                if (tool.getIndex() == -1) {
                    tool.setIndex(this.tools.size());
                    this.tools.add(tool);
                } else {
                    if (this.tools.size() <= tool.getIndex()) {
                        this.tools.setSize(tool.getIndex() + 1);
                    }
                    this.tools.set(tool.getIndex(), tool);
                }
                AtomicReference<ToolModel> atomicReference = this.currentTool;
                synchronized (atomicReference) {
                    if (this.currentTool.get() == this.nullTool) {
                        this.selectTool(tool.getIndex());
                    }
                    continue;
                }
            }
        }
    }

    private void parseBuildVolume() {
        if (XML.hasChildNode(this.xml, "geometry")) {
            Node geometry = XML.getChildNodeByName(this.xml, "geometry");
            NodeList axes = geometry.getChildNodes();
            for (int i = 0; i < axes.getLength(); ++i) {
                Node axis = axes.item(i);
                if (!axis.getNodeName().equals("axis")) continue;
                String id = XML.getAttributeValue(axis, "id");
                double length = 100.0;
                try {
                    length = Double.parseDouble(XML.getAttributeValue(axis, "length"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (id.toLowerCase().equals("x")) {
                    this.buildVolume.setX((int)length);
                    continue;
                }
                if (id.toLowerCase().equals("y")) {
                    this.buildVolume.setY((int)length);
                    continue;
                }
                if (!id.toLowerCase().equals("z")) continue;
                this.buildVolume.setZ((int)length);
            }
        }
    }

    private void parseGCode() {
        if (XML.hasChildNode(this.xml, "bookend")) {
            Node bookend = XML.getChildNodeByName(this.xml, "bookend");
            String dualstartLocation = XML.getAttributeValue(bookend, "dualstart");
            String startLocation = XML.getAttributeValue(bookend, "start");
            String endLocation = XML.getAttributeValue(bookend, "end");
            if (dualstartLocation != null) {
                this.dualstartBookendCode = Base.getApplicationFile(dualstartLocation);
            }
            if (startLocation != null) {
                this.startBookendCode = Base.getApplicationFile(startLocation);
            }
            if (endLocation != null) {
                this.endBookendCode = Base.getApplicationFile(endLocation);
            }
        } else {
            Base.logger.severe("No bookend metadata specified for this machine");
        }
    }

    public Set<AxisId> getAvailableAxes() {
        return this.axes;
    }

    public boolean hasAxis(AxisId id) {
        return this.axes.contains((Object)id);
    }

    public Point5d stepsToMM(Point5d steps) {
        Point5d temp = new Point5d();
        temp.div(steps, this.stepsPerMM);
        return temp;
    }

    public Point5d getStepsPerMM() {
        return this.stepsPerMM;
    }

    public Point5d getAxisLengths() {
        return this.maximum;
    }

    public ToolheadsOffset getToolheadsOffsets() {
        return this.toolheadsOfffsets;
    }

    public Point5d mmToSteps(Point5d mm) {
        Point5d temp = new Point5d();
        temp.mul(mm, this.stepsPerMM);
        temp.round();
        return temp;
    }

    public Point5d mmToSteps(Point5d mm, Point5d excess) {
        Point5d temp = new Point5d();
        temp.mul(mm, this.stepsPerMM);
        temp.add(excess);
        temp.round(excess);
        return temp;
    }

    public void enableDrives() {
        this.drivesEnabled = true;
    }

    public void disableDrives() {
        this.drivesEnabled = false;
    }

    public boolean areDrivesEnabled() {
        return this.drivesEnabled;
    }

    public void changeGearRatio(int ratioIndex) {
        this.gearRatio = ratioIndex;
    }

    public ClampModel getClamp(int index) {
        try {
            ClampModel c = this.clamps.get(index);
            return c;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Base.logger.severe("Cannot get non-existant clamp (#" + index + ".");
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectTool(int index) {
        AtomicReference<ToolModel> atomicReference = this.currentTool;
        synchronized (atomicReference) {
            try {
                this.currentTool.set(this.tools.get(index));
                if (this.currentTool.get() == null) {
                    Base.logger.severe("Cannot select non-existant tool (#" + index + ").");
                    this.currentTool.set(this.nullTool);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (this.xml != null) {
                    Base.logger.severe("Cannot select non-existant tool (#" + index + ").");
                }
                this.currentTool.set(this.nullTool);
            }
        }
    }

    public ToolModel currentTool() {
        return this.currentTool.get();
    }

    public ToolModel getTool(int index) {
        try {
            return this.tools.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Base.logger.severe("Cannot get nonexistent tool (#" + index + ".");
            return null;
        }
    }

    public BuildVolume getBuildVolume() {
        return this.buildVolume;
    }

    public Vector<ToolModel> getTools() {
        return this.tools;
    }

    public void addTool(ToolModel t) {
        this.tools.add(t);
    }

    public void setTool(int index, ToolModel t) {
        try {
            this.tools.set(index, t);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Base.logger.severe("Cannot set non-existant tool (#" + index + ".");
            e.printStackTrace();
        }
    }

    public Point5d getMaximumFeedrates() {
        return this.maximumFeedrateSteps;
    }

    public Point5d getHomingFeedrates() {
        return this.homingFeedrates;
    }

    public Point5d getTimeOut() {
        return this.timeOut;
    }

    public Endstops getEndstops(AxisId axis) {
        return this.endstops.get((Object)axis);
    }

    public Vector<WipeModel> getWipes() {
        return this.wipes;
    }

    public WipeModel getWipeFor(ToolheadAlias tool) {
        for (WipeModel wm : this.wipes) {
            if (wm.getTool() != tool) continue;
            return wm;
        }
        return null;
    }

    public File getDualstartBookendCode() {
        return this.dualstartBookendCode;
    }

    public File getStartBookendCode() {
        return this.startBookendCode;
    }

    public File getEndBookendCode() {
        return this.endBookendCode;
    }

    public MachineType getMachineType() {
        return this.machineType;
    }
}

