/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath;

import java.awt.Frame;
import javax.swing.SwingUtilities;
import replicatorg.app.Base;
import replicatorg.model.Build;
import replicatorg.model.BuildCode;
import replicatorg.plugin.toolpath.ProgressDialog;
import replicatorg.plugin.toolpath.ToolpathGenerator;

public class ToolpathGeneratorThread
extends Thread {
    private Frame parent;
    private ToolpathGenerator generator;
    private Build build;
    private boolean supportDualStrusion = false;
    private boolean skipConfig = false;
    int x;
    int y;
    String name;

    public ToolpathGeneratorThread(Frame parent, ToolpathGenerator generator, Build build) {
        super("ToolpathGeneratorThread");
        this.parent = parent;
        this.generator = generator;
        this.build = build;
    }

    public ToolpathGeneratorThread(Frame parent, ToolpathGenerator generator, Build build, boolean skipConfig) {
        this(parent, generator, build);
        this.skipConfig = skipConfig;
    }

    public void addListener(ToolpathGenerator.GeneratorListener listener) {
        if (listener == null) {
            Base.logger.severe("AddListener failure. Please check your GCode generator" + listener);
        } else if (this.generator == null) {
            Base.logger.severe("AddListener failure. Please check your GCode generator (2):" + this.generator);
        } else {
            this.generator.addListener(listener);
        }
    }

    public void setDualStrusionSupportFlag(boolean b, int lox, int loy, String loName) {
        this.supportDualStrusion = b;
        this.x = lox;
        this.y = loy;
        this.name = loName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.generator.setModel(this.build.getModel());
        ProgressDialog progressDialog = null;
        if (this.parent != null) {
            ProgressDialog pdHandle;
            if (this.skipConfig) {
                if (!this.generator.nonvisualConfigure()) {
                    return;
                }
            } else {
                if (!this.supportDualStrusion && !this.generator.visualConfigure(this.parent)) {
                    return;
                }
                if (this.supportDualStrusion && !this.generator.visualConfigure(this.parent, this.x, this.y, this.name)) {
                    return;
                }
            }
            progressDialog = new ProgressDialog(this.parent, this.build, this, ToolpathGenerator.displayName);
            this.generator.addListener(progressDialog);
            if (!this.supportDualStrusion) {
                pdHandle = progressDialog;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!pdHandle.isDone()) {
                            double xl = ToolpathGeneratorThread.this.parent.getBounds().getCenterX();
                            double yl = ToolpathGeneratorThread.this.parent.getBounds().getCenterY();
                            pdHandle.pack();
                            pdHandle.setLocation((int)(xl -= (double)pdHandle.getWidth() / 2.0), (int)(yl -= (double)pdHandle.getHeight() / 2.0));
                            pdHandle.setVisible(true);
                        }
                    }
                });
            }
            if (this.supportDualStrusion) {
                pdHandle = progressDialog;
                System.out.println("pd attempt start");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!pdHandle.isDone()) {
                            pdHandle.pack();
                            pdHandle.setLocation(ToolpathGeneratorThread.this.x, ToolpathGeneratorThread.this.y);
                            pdHandle.setName(ToolpathGeneratorThread.this.name);
                            pdHandle.setVisible(true);
                        }
                    }
                });
            }
        }
        Base.logger.info("Beginning toolpath generation.");
        try {
            BuildCode code = this.generator.generateToolpath();
            if (code != null) {
                this.build.reloadCode();
                this.generator.emitCompletion(ToolpathGenerator.GeneratorListener.Completion.SUCCESS);
            } else {
                this.generator.emitCompletion(ToolpathGenerator.GeneratorListener.Completion.FAILURE);
            }
        }
        catch (Exception e) {
            this.generator.emitCompletion(ToolpathGenerator.GeneratorListener.Completion.FAILURE);
        }
        finally {
            if (progressDialog != null) {
                ProgressDialog progressDialog2 = progressDialog;
                synchronized (progressDialog2) {
                    progressDialog.setVisible(false);
                    progressDialog.setDone(true);
                }
            }
        }
    }
}

