/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.slic3r;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.plugin.toolpath.slic3r.ProfileUtils;
import replicatorg.plugin.toolpath.slic3r.Slic3rGenerator;

class ConfigurationDialog
extends JDialog {
    final boolean postProcessToolheadIndex = true;
    final String profilePref = "replicatorg.slic3r.profilePref";
    JButton generateButton = new JButton("Generate Gcode");
    JButton cancelButton = new JButton("Cancel");
    private Slic3rGenerator parentGenerator = null;
    private List<Slic3rGenerator.Profile> profiles = null;
    JPanel profilePanel = new JPanel();
    final JComboBox prefPulldown = new JComboBox();

    private void loadList(JComboBox comboBox) {
        comboBox.removeAllItems();
        this.profiles = this.parentGenerator.getProfiles();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        int i = 0;
        int foundLastProfile = -1;
        for (Slic3rGenerator.Profile p : this.profiles) {
            if (!ProfileUtils.shouldDisplay(p)) continue;
            model.addElement(p.toString());
            if (p.toString().equals(Base.preferences.get("lastGeneratorProfileSelected", "---"))) {
                Base.logger.fine("Selecting last used element: " + p);
                foundLastProfile = i;
            }
            ++i;
        }
        comboBox.setModel(model);
        if (foundLastProfile != -1) {
            comboBox.setSelectedIndex(foundLastProfile);
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.parentGenerator = null;
            this.profiles = null;
        }
    }

    public ConfigurationDialog(Frame parent, Slic3rGenerator parentGeneratorIn) {
        super(parent, true);
        this.parentGenerator = parentGeneratorIn;
        this.setTitle("GCode Generator");
        this.setLayout((LayoutManager)new MigLayout("aligny, top, ins 5, fill"));
        this.add((Component)new JLabel("Slicing Profile:"), "split 2");
        this.prefPulldown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ConfigurationDialog.this.generateButton.setEnabled(true);
                ConfigurationDialog.this.generateButton.requestFocusInWindow();
                ConfigurationDialog.this.generateButton.setFocusPainted(true);
            }
        });
        this.loadList(this.prefPulldown);
        this.add((Component)this.prefPulldown, "wrap, growx, gapbottom 10");
        for (Slic3rGenerator.Slic3rPreference preference : this.parentGenerator.getPreferences()) {
            this.add((Component)preference.getUI(), "growx, wrap");
        }
        this.generateButton.setToolTipText("Generates GCode instructions for your machine.");
        this.add((Component)this.generateButton, "tag ok, split 2");
        this.add((Component)this.cancelButton, "tag cancel");
        this.generateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.configSuccess = ConfigurationDialog.this.configureGenerator();
                ConfigurationDialog.this.setVisible(!((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.configSuccess);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.configSuccess = false;
                ConfigurationDialog.this.setVisible(false);
            }
        });
    }

    protected boolean configureGenerator() {
        if (!this.parentGenerator.runSanityChecks()) {
            return false;
        }
        int idx = this.prefPulldown.getSelectedIndex();
        if (idx == -1) {
            return false;
        }
        Slic3rGenerator.Profile p = ProfileUtils.getListedProfile(this.prefPulldown.getModel(), this.profiles, idx);
        Base.preferences.put("lastGeneratorProfileSelected", p.toString());
        this.parentGenerator.profile = p.getFullPath();
        Slic3rGenerator.setSelectedProfile(p.toString());
        return true;
    }
}

