/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.slic3r;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.SavingTextField;
import replicatorg.plugin.toolpath.slic3r.Slic3rGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintOMatic5D
implements Slic3rGenerator.Slic3rPreference {
    private JPanel component = new JPanel((LayoutManager)new MigLayout("ins 0, fillx, hidemode 1"));
    private JCheckBox enabled;
    private String baseName = "replicatorg.Slic3r.printOMatic5D.";
    JTabbedPane printOMatic5D;

    private void addTextParameter(JComponent target, String name, String description, String defaultValue, String toolTip) {
        String fullName = this.baseName + name;
        String value = null;
        if (fullName != null) {
            value = Base.preferences.get(fullName, defaultValue);
            Base.preferences.put(fullName, value);
        }
        target.add(new JLabel(description));
        SavingTextField input = new SavingTextField(fullName, value, 10);
        target.add((Component)input, "wrap");
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    private void addDropDownParameter(JComponent target, String name, String description, Vector<String> options, String toolTip) {
        String fullName = this.baseName + name;
        String value = null;
        if (fullName != null) {
            value = Base.preferences.get(fullName, options.firstElement());
            Base.preferences.put(fullName, value);
        }
        target.add(new JLabel(description));
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(options);
        model.setSelectedItem(value);
        JComboBox<String> input = new JComboBox<String>(model);
        target.add(input, "wrap");
        input.addActionListener(new ComboListener(model, fullName));
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    private void addBooleanParameter(JComponent target, String name, String description, boolean defaultValue, String toolTip) {
        String fullName = this.baseName + name;
        boolean isSet = false;
        if (fullName != null) {
            isSet = Base.preferences.getBoolean(fullName, defaultValue);
            Base.preferences.putBoolean(fullName, isSet);
        }
        target.add(new JLabel(description));
        JCheckBox input = new JCheckBox("", isSet);
        target.add((Component)input, "wrap");
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    private double getValue(String optionName) {
        String value = Base.preferences.get(this.baseName + optionName, null);
        Base.logger.fine("Saved value for preference " + this.baseName + optionName + " is " + value);
        Double number = null;
        try {
            number = Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            Base.logger.severe("Print-O-Matic setting " + optionName + "does not contain a valid number, please correct this!");
        }
        return number;
    }

    private void setValue(String optionName, String value) {
        Base.preferences.put(this.baseName + optionName, value);
    }

    private boolean getBooleanValue(String optionName) {
        boolean value = Base.preferences.getBoolean(this.baseName + optionName, true);
        Base.logger.fine("Saved value for preference " + this.baseName + optionName + " is " + value);
        return value;
    }

    private String getStringValue(String optionName) {
        String value = Base.preferences.get(this.baseName + optionName, null);
        Base.logger.fine("Saved value for preference " + this.baseName + optionName + " is " + value);
        return value;
    }

    private JComponent printPanel() {
        JPanel printPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.addTextParameter(printPanel, "infillPercent", "Object infill (%)", "10", "0= hollow object, 100=solid object");
        this.addTextParameter(printPanel, "desiredLayerHeight", "Layer Height (mm)", "0.27", "Set the desired layer height");
        this.addTextParameter(printPanel, "numberOfShells", "Number of shells:", "1", "Number of shells to add to the perimeter of an object. Set this to 0 if you are printing a model with thin features.");
        this.addTextParameter(printPanel, "desiredFeedrate", "Feedrate (mm/s)", "40", "slow: 0-20, default: 30, Fast: 40+");
        this.addTextParameter(printPanel, "travelFeedrate", "Travel Feedrate", "55", "slow: 0-20, default: 30, Fast: 40+");
        return printPanel;
    }

    private JComponent materialPanel() {
        JPanel materialPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.addTextParameter(materialPanel, "filamentDiameter", "Filament Diameter (mm)", "2.95", "measure feedstock");
        return materialPanel;
    }

    private JComponent machinePanel() {
        JPanel machinePanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.addTextParameter(machinePanel, "desiredPathWidth", "Nozzle Diameter (mm)", "0.4", "Set the desired path width");
        return machinePanel;
    }

    private JComponent defaultsPanel() {
        JPanel defaultsPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        JButton def = new JButton("Load Ultimaker Defaults");
        ActionListener loadDefaults = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOMatic5D.this.setValue("infillPercent", "0.2");
                PrintOMatic5D.this.setValue("desiredLayerHeight", ".1");
                PrintOMatic5D.this.setValue("numberOfShells", "1");
                PrintOMatic5D.this.setValue("desiredFeedrate", "40");
                PrintOMatic5D.this.setValue("travelFeedrate", "55");
                PrintOMatic5D.this.setValue("filamentDiameter", "1.82");
                PrintOMatic5D.this.setValue("desiredPathWidth", ".4");
                PrintOMatic5D.this.printOMatic5D.removeAll();
                PrintOMatic5D.this.makeTabs();
            }
        };
        def.addActionListener(loadDefaults);
        defaultsPanel.add((Component)def, "growx, wrap");
        return defaultsPanel;
    }

    private void makeTabs() {
        this.printOMatic5D.addTab("Settings", this.printPanel());
        this.printOMatic5D.addTab("Plastic", this.materialPanel());
        this.printOMatic5D.addTab("Extruder", this.machinePanel());
        this.printOMatic5D.addTab("Defaults", this.defaultsPanel());
    }

    public PrintOMatic5D() {
        final String enabledName = this.baseName + "enabled";
        this.enabled = new JCheckBox("Use Print-O-Matic (stepper extruders only)", Base.preferences.getBoolean(enabledName, true));
        this.enabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (enabledName != null) {
                    Base.preferences.putBoolean(enabledName, PrintOMatic5D.this.enabled.isSelected());
                    PrintOMatic5D.this.printOMatic5D.setVisible(PrintOMatic5D.this.enabled.isSelected());
                    PrintOMatic5D.this.printOMatic5D.invalidate();
                    Window w = SwingUtilities.getWindowAncestor(PrintOMatic5D.this.printOMatic5D);
                    w.pack();
                }
            }
        });
        this.component.add((Component)this.enabled, "wrap, spanx");
        this.printOMatic5D = new JTabbedPane();
        this.makeTabs();
        this.component.add((Component)this.printOMatic5D, "spanx");
        this.printOMatic5D.setVisible(this.enabled.isSelected());
    }

    @Override
    public JComponent getUI() {
        return this.component;
    }

    @Override
    public String valueSanityCheck() {
        if (this.enabled.isSelected()) {
            // empty if block
        }
        return null;
    }

    @Override
    public List<Slic3rGenerator.Slic3rOption> getOptions() {
        LinkedList<Slic3rGenerator.Slic3rOption> options = new LinkedList<Slic3rGenerator.Slic3rOption>();
        if (this.enabled.isSelected()) {
            double infillRatio = this.getValue("infillPercent") / 100.0;
            double filamentDiameter = this.getValue("filamentDiameter");
            double feedRate = this.getValue("desiredFeedrate");
            double travelFeedRate = this.getValue("travelFeedrate");
            double layerHeight = this.getValue("desiredLayerHeight");
            double extraShellsOnBase = this.getValue("numberOfShells");
            Base.logger.fine("Print-O-Matic settings:\n infillRatio=" + infillRatio + "\n filamentDiameter=" + filamentDiameter + "\n feedRate=" + feedRate + "\n layerHeight=" + layerHeight + "\n extraShellsOnBase=" + extraShellsOnBase);
            options.add(new Slic3rGenerator.Slic3rOption("--fill-density", Double.toString(infillRatio)));
            options.add(new Slic3rGenerator.Slic3rOption("--infill-speed", Double.toString(feedRate)));
            options.add(new Slic3rGenerator.Slic3rOption("--travel-speed", Double.toString(travelFeedRate)));
            options.add(new Slic3rGenerator.Slic3rOption("--perimeter-speed", Double.toString(feedRate)));
            options.add(new Slic3rGenerator.Slic3rOption("--filament-diameter", Double.toString(filamentDiameter)));
            options.add(new Slic3rGenerator.Slic3rOption("--layer-height", Double.toString(layerHeight)));
            options.add(new Slic3rGenerator.Slic3rOption("--perimeters", Double.toString(extraShellsOnBase)));
        }
        return options;
    }

    @Override
    public String getName() {
        return "Print-O-Matic (5D)";
    }

    private class ComboListener
    implements ActionListener {
        final String name;
        final DefaultComboBoxModel input;

        public ComboListener(DefaultComboBoxModel input, String name) {
            this.input = input;
            this.name = name;
        }

        public void actionPerformed(ActionEvent arg0) {
            String value = this.input.getSelectedItem().toString();
            if (this.name != null) {
                Base.logger.fine("here: " + this.name + "=" + value);
                Base.preferences.put(this.name, value);
            }
        }
    }
}

