/*
 * Decompiled with CFR 0.152.
 */
package net.iharder.dnd;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import net.iharder.dnd.TransferableObject;

public class DnDList
extends JList
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DropTarget dropTarget = null;
    private DragSource dragSource = null;
    private int sourceIndex = -1;
    private int dropIndex = -1;
    private Object sourceObject;

    public DnDList() {
        super(new DefaultListModel());
        this.initComponents();
    }

    public DnDList(DefaultListModel defaultListModel) {
        super(defaultListModel);
        this.initComponents();
    }

    public DnDList(Object[] objectArray) {
        this();
        ((DefaultListModel)this.getModel()).copyInto(objectArray);
    }

    public DnDList(Vector vector) {
        this();
        ((DefaultListModel)this.getModel()).copyInto(vector.toArray());
    }

    private void initComponents() {
        this.dropTarget = new DropTarget(this, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        final Object e = this.getSelectedValue();
        if (e != null) {
            this.sourceIndex = this.getSelectedIndex();
            TransferableObject transferableObject = new TransferableObject(new TransferableObject.Fetcher(){

                public Object getObject() {
                    ((DefaultListModel)DnDList.this.getModel()).remove(DnDList.this.sourceIndex);
                    return e;
                }
            });
            this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultLinkDrop, transferableObject, this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(2);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(2);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(TransferableObject.DATA_FLAVOR)) {
            dropTargetDropEvent.acceptDrop(2);
            Object object = null;
            try {
                object = transferable.getTransferData(TransferableObject.DATA_FLAVOR);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (object != null) {
                int n = this.locationToIndex(dropTargetDropEvent.getLocation());
                DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
                if (n < 0) {
                    defaultListModel.addElement(object);
                } else if (this.sourceIndex >= 0 && n > this.sourceIndex) {
                    defaultListModel.add(n - 1, object);
                } else {
                    defaultListModel.add(n, object);
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }
}

