/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Arrays;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.http.Response;

public class IDs
extends TwitterResponse {
    private int[] ids;
    private long previousCursor;
    private long nextCursor;
    private static final long serialVersionUID = -6585026560164704953L;
    private static String[] ROOT_NODE_NAMES = new String[]{"id_list", "ids"};

    IDs(Response res) throws TwitterException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        IDs.ensureRootNodeNameIs(ROOT_NODE_NAMES, elem);
        NodeList idlist = elem.getElementsByTagName("id");
        this.ids = new int[idlist.getLength()];
        for (int i = 0; i < idlist.getLength(); ++i) {
            try {
                this.ids[i] = Integer.parseInt(idlist.item(i).getFirstChild().getNodeValue());
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new TwitterException("Twitter API returned malformed response: " + elem, nfe);
            }
        }
        this.previousCursor = IDs.getChildLong("previous_cursor", elem);
        this.nextCursor = IDs.getChildLong("next_cursor", elem);
    }

    public int[] getIDs() {
        return this.ids;
    }

    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    public long getPreviousCursor() {
        return this.previousCursor;
    }

    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    public long getNextCursor() {
        return this.nextCursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDs)) {
            return false;
        }
        IDs iDs = (IDs)o;
        return Arrays.equals(this.ids, iDs.ids);
    }

    public int hashCode() {
        return this.ids != null ? Arrays.hashCode(this.ids) : 0;
    }

    public String toString() {
        return "IDs{ids=" + this.ids + ", previousCursor=" + this.previousCursor + ", nextCursor=" + this.nextCursor + '}';
    }
}

