/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.http.Response;
import twitter4j.org.json.JSONException;

public class StatusStream {
    private boolean streamAlive = true;
    private BufferedReader br;
    private InputStream is;
    private Response response;

    StatusStream(InputStream stream) throws IOException {
        this.is = stream;
        this.br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
    }

    StatusStream(Response response) throws IOException {
        this(response.asStream());
        this.response = response;
    }

    public Status next() throws TwitterException {
        if (!this.streamAlive) {
            throw new IllegalStateException("Stream already closed.");
        }
        try {
            while (this.streamAlive) {
                String line = this.br.readLine();
                if (null == line || line.length() <= 0) continue;
                try {
                    return new Status(line);
                }
                catch (JSONException ignore) {
                }
            }
            throw new TwitterException("Stream closed.");
        }
        catch (IOException e) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.streamAlive = false;
            throw new TwitterException("Stream closed.", e);
        }
    }

    public void close() throws IOException {
        this.is.close();
        this.br.close();
        if (null != this.response) {
            this.response.disconnect();
        }
    }
}

