/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.AWTException;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JOptionPane;
import replicatorg.app.Base;
import replicatorg.app.ui.MainWindow;

public interface NotificationHandler {
    public void showMessage(String var1, String var2);

    public void showWarning(String var1, String var2, Throwable var3);

    public void showError(String var1, String var2, Throwable var3);

    public static class SystemTrayNotifactionHandler
    extends BaseNotificationHandler {
        private TrayIcon trayIcon;

        private SystemTrayNotifactionHandler(final MainWindow editor) {
            SystemTray systemTray = SystemTray.getSystemTray();
            PopupMenu popup = new PopupMenu();
            MenuItem defaultItem = new MenuItem("Exit");
            defaultItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    editor.handleQuit();
                }
            });
            popup.add(defaultItem);
            BufferedImage icon = Base.getImage("images/icon.gif", editor);
            this.trayIcon = new TrayIcon(icon, editor.getTitle(), popup);
            this.trayIcon.setImageAutoSize(true);
            try {
                systemTray.add(this.trayIcon);
            }
            catch (AWTException e1) {
                e1.printStackTrace();
            }
        }

        protected void showMessage0(String title, String message) {
            this.trayIcon.displayMessage(title, message, TrayIcon.MessageType.INFO);
        }

        protected void showWarning0(String title, String message, Throwable e) {
            this.trayIcon.displayMessage(title, message, TrayIcon.MessageType.WARNING);
        }
    }

    public static class JOptionPaneNotificationHandler
    extends BaseNotificationHandler {
        private JOptionPaneNotificationHandler() {
        }

        protected void showMessage0(String title, String message) {
            JOptionPane.showMessageDialog(new Frame(), message, title, 1);
        }

        protected void showWarning0(String title, String message, Throwable t) {
            JOptionPane.showMessageDialog(new Frame(), message, title, 2);
        }
    }

    public static abstract class BaseNotificationHandler
    implements NotificationHandler {
        private BaseNotificationHandler() {
        }

        public void showMessage(String title, String message) {
            if (title == null) {
                title = "Message";
            }
            this.showMessage0(title, message);
        }

        public void showWarning(String title, String message, Throwable e) {
            if (title == null) {
                title = "Warning";
            }
            this.showWarning0(title, message, e);
        }

        public void showError(String title, String message, Throwable t) {
            if (title == null) {
                title = "Error";
            }
            JOptionPane.showMessageDialog(new Frame(), message, title, 0);
            if (t != null) {
                t.printStackTrace();
            }
        }

        protected abstract void showMessage0(String var1, String var2);

        protected abstract void showWarning0(String var1, String var2, Throwable var3);
    }

    public static class Factory {
        private Factory() {
            throw new AssertionError();
        }

        public static NotificationHandler getHandler(MainWindow editor, boolean preferSystray) {
            if (preferSystray && SystemTray.isSupported()) {
                return new SystemTrayNotifactionHandler(editor);
            }
            return new JOptionPaneNotificationHandler();
        }
    }
}

