/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.drivers.commands.QueuePoint;
import replicatorg.drivers.commands.SetCurrentPosition;
import replicatorg.drivers.commands.SetFeedrate;
import replicatorg.machine.MachineInterface;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.MachineType;
import replicatorg.util.Point5d;

public class JogPanel
extends JPanel
implements ActionListener,
MouseListener {
    private final String JOGMODE_PREF_NAME = "controlpanel.jogmode";
    protected boolean continuousJogMode = false;
    protected double jogRate;
    protected Pattern jogPattern;
    protected String[] jogStrings = new String[]{"0.01mm", "0.05mm", "0.1mm", "0.5mm", "1mm", "5mm", "10mm", "20mm", "50mm", "Continuous Jog"};
    protected final String jogXMinusAction = "X-";
    protected final String jogXPlusAction = "X+";
    protected final String jogYMinusAction = "Y-";
    protected final String jogYPlusAction = "Y+";
    protected final String jogZMinusAction = "Z-";
    protected final String jogZPlusAction = "Z+";
    protected final String stopAction = "Stop";
    protected final Point5d feedrate;
    protected EnumMap<AxisId, JTextField> positionFields = new EnumMap(AxisId.class);
    protected MachineInterface machine;
    private NumberFormat positionFormatter = Base.getLocalFormat();
    Pattern jogActionParser = Pattern.compile("([XYZAB])([\\+\\-])");
    Pattern centerActionParser = Pattern.compile("Center ([XYZAB])");

    private JButton createJogButton(String root, String tooltip, ButtonArrangement arrangement) {
        JogButton b = new JogButton(root, tooltip, arrangement);
        b.addActionListener(this);
        b.addMouseListener(this);
        b.setActionCommand(root);
        return b;
    }

    private JButton createJogButton(String root, String tooltip, ButtonArrangement arrangement, String action) {
        JButton button = this.createJogButton(root, tooltip, arrangement);
        button.setActionCommand(action);
        return button;
    }

    protected JTextField createDisplayField() {
        JTextField tf = new JTextField();
        tf.setEnabled(false);
        tf.setDisabledTextColor(Color.BLACK);
        return tf;
    }

    private void setJogMode(String mode) {
        if ("Continuous Jog".equals(mode)) {
            if (this.machine.getDriver().hasSoftStop()) {
                this.continuousJogMode = true;
                this.jogRate = 0.0;
            }
        } else {
            if (this.continuousJogMode) {
                this.machine.stopMotion();
            }
            this.continuousJogMode = false;
            Matcher jogMatcher = this.jogPattern.matcher(mode);
            if (jogMatcher.find()) {
                this.jogRate = Double.parseDouble(jogMatcher.group(1));
            }
        }
        if (mode != null && mode.length() > 0) {
            Base.preferences.put("controlpanel.jogmode", mode);
        }
    }

    private JPanel buildPositionPanel() {
        JPanel positionPanel = new JPanel((LayoutManager)new MigLayout("flowy"));
        positionPanel.add((Component)new JLabel("Jog Mode"), "growx");
        JComboBox<String> jogList = new JComboBox<String>(this.jogStrings);
        jogList.setSelectedItem(Base.preferences.get("controlpanel.jogmode", "1mm"));
        jogList.setActionCommand("jog size");
        jogList.addActionListener(this);
        this.setJogMode((String)jogList.getSelectedItem());
        positionPanel.add(jogList, "growx");
        for (AxisId axis : this.machine.getModel().getAvailableAxes()) {
            JTextField f = this.createDisplayField();
            this.positionFields.put(axis, f);
            positionPanel.add((Component)new JLabel(axis.name()), "split 3,flowx");
            positionPanel.add((Component)f, "growx");
            JButton centerButton = new JButton("Center " + axis.name());
            centerButton.setToolTipText("Jog " + axis.name() + " axis to the origin");
            centerButton.setActionCommand("Center " + axis.name());
            centerButton.addActionListener(this);
            positionPanel.add(centerButton);
        }
        JButton zeroButton = new JButton("Make current position zero");
        zeroButton.setToolTipText("Mark Current Position as zero (0,0,0).  Will not move the toolhead.");
        zeroButton.setActionCommand("Zero");
        zeroButton.addActionListener(this);
        positionPanel.add((Component)zeroButton, "growx");
        return positionPanel;
    }

    private JPanel makeRotationPanel(AxisId axis) {
        ButtonArrangement arrangement = new ButtonArrangement(this.machine){
            {
                this.buttonFolder = "images/jog/original/";
                this.xScale = 1.0;
                this.yScale = 1.0;
            }

            public JPanel getButtonPanel() {
                return null;
            }
        };
        JButton cwButton = this.createJogButton("CW", "Jog " + axis.name() + " axis in clockwise direction", arrangement, axis.name() + "+");
        JButton ccwButton = this.createJogButton("CCW", "Jog " + axis.name() + " axis in counterclockwise direction", arrangement, axis.name() + "-");
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        panel.add((Component)cwButton, "pos 0 0");
        panel.add((Component)new JLabel(axis.name()), "pos 20 20");
        panel.add((Component)ccwButton, "pos 0 28 ");
        return panel;
    }

    public JogPanel(MachineInterface machine) {
        this.feedrate = new Point5d();
        this.machine = machine;
        Set<AxisId> axes = machine.getModel().getAvailableAxes();
        this.setLayout((LayoutManager)new MigLayout("gap 0, ins 0"));
        this.jogRate = 10.0;
        this.jogPattern = Pattern.compile("([.0-9]+)");
        if (!this.machine.getDriver().hasSoftStop()) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.jogStrings));
            list.removeAll(Arrays.asList("Continuous Jog"));
            this.jogStrings = list.toArray(this.jogStrings);
        }
        JPanel feedratePanel = new JPanel((LayoutManager)new MigLayout("fill"));
        if (axes.contains((Object)AxisId.X) || axes.contains((Object)AxisId.Y)) {
            new FeedrateControl("XY Speed", AxisId.X, feedratePanel);
        }
        if (axes.contains((Object)AxisId.Z)) {
            new FeedrateControl("Z Speed", AxisId.Z, feedratePanel);
        }
        if (axes.contains((Object)AxisId.A)) {
            new FeedrateControl("A Speed", AxisId.A, feedratePanel);
        }
        if (axes.contains((Object)AxisId.B)) {
            new FeedrateControl("B Speed", AxisId.B, feedratePanel);
        }
        DefaultArrangement arrangement = machine.getMachineType() == MachineType.REPLICATOR_2 ? new ReplicatorArrangement(machine) : (machine.getMachineType() == MachineType.THE_REPLICATOR ? new ReplicatorArrangement(machine) : (machine.getMachineType() == MachineType.THINGOMATIC ? new ThingomaticArrangement(machine) : (machine.getMachineType() == MachineType.CUPCAKE ? new CupcakeArrangement(machine) : new DefaultArrangement(machine))));
        this.add(((ButtonArrangement)arrangement).getButtonPanel());
        this.add((Component)this.buildPositionPanel(), "growx, wrap");
        this.add((Component)feedratePanel, "spanx, growx");
        this.setBorder(BorderFactory.createTitledBorder("Jog Controls"));
    }

    public synchronized void updateStatus() {
        Point5d current = this.machine.getDriverQueryInterface().getCurrentPosition(false);
        for (AxisId axis : this.machine.getModel().getAvailableAxes()) {
            double v = current.axis(axis);
            this.positionFields.get((Object)axis).setText(this.positionFormatter.format(v));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Point5d current = this.machine.getDriverQueryInterface().getCurrentPosition(false);
        String s = e.getActionCommand();
        Matcher jogMatch = this.jogActionParser.matcher(s);
        Matcher centerMatch = this.centerActionParser.matcher(s);
        if (jogMatch.matches()) {
            if (!this.continuousJogMode) {
                AxisId axis = AxisId.valueOf(jogMatch.group(1));
                boolean positive = jogMatch.group(2).equals("+");
                current.setAxis(axis, current.axis(axis) + (positive ? this.jogRate : -this.jogRate));
                double f = this.feedrate.axis(axis);
                if (axis.equals((Object)AxisId.Y)) {
                    f = this.feedrate.axis(AxisId.X);
                }
                this.machine.runCommand(new SetFeedrate(f));
                this.machine.runCommand(new QueuePoint(current));
            }
        } else if (s.equals("Stop")) {
            this.machine.stopMotion();
        } else if (centerMatch.matches()) {
            AxisId axis = AxisId.valueOf(centerMatch.group(1));
            current.setAxis(axis, 0.0);
            double f = this.feedrate.axis(axis);
            if (axis.equals((Object)AxisId.Y)) {
                f = this.feedrate.axis(AxisId.X);
            }
            this.machine.runCommand(new SetFeedrate(f));
            this.machine.runCommand(new QueuePoint(current));
        } else if (s.equals("Zero")) {
            this.machine.runCommand(new SetCurrentPosition(new Point5d()));
        } else if (s.equals("jog size")) {
            JComboBox cb = (JComboBox)e.getSource();
            String jogText = (String)cb.getSelectedItem();
            this.setJogMode(jogText);
        } else {
            Base.logger.warning("Unknown Action Event: " + s);
        }
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.continuousJogMode) {
            Point5d current = this.machine.getDriverQueryInterface().getCurrentPosition(false);
            String s = ((JButton)e.getSource()).getActionCommand();
            Matcher jogMatch = this.jogActionParser.matcher(s);
            if (jogMatch.matches()) {
                AxisId axis = AxisId.valueOf(jogMatch.group(1));
                boolean positive = jogMatch.group(2).equals("+");
                current.setAxis(axis, current.axis(axis) + (double)(positive ? 1000 : -1000));
                double f = this.feedrate.axis(axis);
                if (axis.equals((Object)AxisId.Y)) {
                    f = this.feedrate.axis(AxisId.X);
                }
                this.machine.runCommand(new SetFeedrate(f));
                this.machine.runCommand(new QueuePoint(current));
            }
        }
    }

    public void mouseReleased(MouseEvent arg0) {
        if (this.continuousJogMode) {
            this.machine.stopMotion();
        }
    }

    private class FeedrateControl
    implements ActionListener,
    FocusListener,
    ChangeListener {
        final JSlider slider;
        final AxisId axis;
        final JTextField field;

        private FeedrateControl(String display, AxisId axis, JPanel parent) {
            this.axis = axis;
            this.slider = new JSlider(0);
            this.field = new JTextField();
            parent.add((Component)new JLabel(display), "split 4");
            Point5d maxFeedrateSteps = JogPanel.this.machine.getModel().getMaximumFeedrates();
            int maxFeedrate = (int)maxFeedrateSteps.axis(axis);
            int currentFeedrate = Math.min(maxFeedrate, Base.preferences.getInt(this.getPrefName(), 480));
            JogPanel.this.feedrate.setAxis(axis, currentFeedrate);
            this.slider.setMinimum(1);
            this.slider.setMaximum(maxFeedrate);
            this.slider.setValue(currentFeedrate);
            this.slider.addChangeListener(this);
            parent.add((Component)this.slider, "growx");
            this.field.setColumns(5);
            this.field.setEnabled(true);
            this.field.setText(Integer.toString(currentFeedrate));
            this.field.addFocusListener(this);
            this.field.addActionListener(this);
            parent.add(this.field);
            parent.add((Component)new JLabel("mm/min."), "wrap");
        }

        String getPrefName() {
            return "controlpanel.feedrate." + this.axis.name().toLowerCase();
        }

        void updateFromField() {
            int val = Integer.parseInt(this.field.getText());
            JogPanel.this.feedrate.setAxis(this.axis, val);
            Base.preferences.putInt(this.getPrefName(), val);
            this.slider.setValue(val);
        }

        public void actionPerformed(ActionEvent e) {
            this.updateFromField();
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.updateFromField();
        }

        public void stateChanged(ChangeEvent e) {
            int val = this.slider.getValue();
            JogPanel.this.feedrate.setAxis(this.axis, val);
            Base.preferences.putInt(this.getPrefName(), val);
            this.field.setText(Integer.toString(val));
        }
    }

    public class JogButton
    extends JButton {
        public JogButton(String root, String tooltip, ButtonArrangement arrangement) {
            Image downImg;
            String baseImage = arrangement.buttonFolder + root;
            Image img = Base.getImage(baseImage + ".png", this);
            img = arrangement.scaleImage(img);
            this.setIcon(new ImageIcon(img));
            Image overImg = Base.getImage(baseImage + arrangement.overButtonString + ".png", this);
            if (overImg != null) {
                overImg = arrangement.scaleImage(overImg);
                this.setRolloverIcon(new ImageIcon(overImg));
                this.setRolloverEnabled(true);
            }
            if ((downImg = Base.getImage(baseImage + arrangement.pressedButtonString + ".png", this)) != null) {
                downImg = arrangement.scaleImage(downImg);
                this.setSelectedIcon(new ImageIcon(downImg));
            } else if (downImg == null && overImg != null) {
                downImg = overImg;
                this.setSelectedIcon(new ImageIcon(downImg));
            }
            Dimension imgSize = new Dimension(img.getWidth(null), img.getHeight(null));
            this.setSize(imgSize);
            this.setMinimumSize(imgSize);
            this.setPreferredSize(imgSize);
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setToolTipText(tooltip);
        }
    }

    private class ReplicatorArrangement
    extends MakerbotArrangement {
        public ReplicatorArrangement(MachineInterface machine) {
            super(machine);
            this.backgroundImageString = "replicator";
            this.buildplateImageString = "replicator-buildplate";
            this.zMinusButtonString = "UpZ-";
            this.zPlusButtonString = "DownZ+";
            this.xMinusButtonString = "LeftX-";
            this.xPlusButtonString = "RightX+";
            this.yMinusButtonString = "LeftY-";
            this.yPlusButtonString = "RightY+";
            this.backgroundImageLocation = this.scalePoint(0.0, 0.0);
            this.extruderImageLocation = machine.getModel().getTools().size() > 1 ? this.scalePoint(144.0, 60.0) : this.scalePoint(188.0, 60.0);
            this.buildplateImageLocation = this.scalePoint(100.0, 150.0);
            this.xMinusButtonLocation = this.scalePoint(95.0, 200.0);
            this.xPlusButtonLocation = this.scalePoint(185.0, 200.0);
            this.yMinusButtonLocation = this.scalePoint(0.0, 90.0);
            this.yPlusButtonLocation = this.scalePoint(65.0, 65.0);
            this.zMinusButtonLocation = this.scalePoint(357.0, 40.0);
            this.zPlusButtonLocation = this.scalePoint(357.0, 135.0);
            this.stopButtonLocation = this.scalePoint(455.0, 100.0);
        }
    }

    private class CupcakeArrangement
    extends MakerbotArrangement {
        public CupcakeArrangement(MachineInterface machine) {
            super(machine);
            this.backgroundImageString = "cupcake";
            this.buildplateImageString = "cupcake-buildplate";
            this.zMinusButtonString = "DownZ-";
            this.zPlusButtonString = "UpZ+";
            this.zMinusButtonString = "DownZ-";
            this.zPlusButtonString = "UpZ+";
            this.xMinusButtonString = "RightX-";
            this.xPlusButtonString = "LeftX+";
            this.yMinusButtonString = "RightY-";
            this.yPlusButtonString = "LeftY+";
            this.backgroundImageLocation = this.scalePoint(30.0, 0.0);
            this.extruderImageLocation = machine.getModel().getTools().size() > 1 ? this.scalePoint(105.0, 50.0) : this.scalePoint(118.0, 50.0);
            this.buildplateImageLocation = this.scalePoint(85.0, 135.0);
            this.xMinusButtonLocation = this.scalePoint(136.0, 175.0);
            this.xPlusButtonLocation = this.scalePoint(40.0, 175.0);
            this.yMinusButtonLocation = this.scalePoint(65.0, 55.0);
            this.yPlusButtonLocation = this.scalePoint(0.0, 80.0);
            this.zMinusButtonLocation = this.scalePoint(223.0, 115.0);
            this.zPlusButtonLocation = this.scalePoint(223.0, 20.0);
            this.axisAPanelLocation = this.scalePoint(385.0, 0.0);
            this.axisBPanelLocation = this.scalePoint(385.0, 140.0);
            this.stopButtonLocation = this.scalePoint(300.0, 85.0);
        }
    }

    private class ThingomaticArrangement
    extends MakerbotArrangement {
        public ThingomaticArrangement(MachineInterface machine) {
            super(machine);
            this.backgroundImageString = "tom";
            this.buildplateImageString = "tom-buildplate";
            this.zMinusButtonString = "DownZ-";
            this.zPlusButtonString = "UpZ+";
            this.xMinusButtonString = "RightX-";
            this.xPlusButtonString = "LeftX+";
            this.yMinusButtonString = "RightY-";
            this.yPlusButtonString = "LeftY+";
            this.backgroundImageLocation = this.scalePoint(30.0, 0.0);
            this.extruderImageLocation = machine.getModel().getTools().size() > 1 ? this.scalePoint(105.0, 60.0) : this.scalePoint(118.0, 60.0);
            this.buildplateImageLocation = this.scalePoint(100.0, 150.0);
            this.xMinusButtonLocation = this.scalePoint(138.0, 210.0);
            this.xPlusButtonLocation = this.scalePoint(42.0, 210.0);
            this.yMinusButtonLocation = this.scalePoint(65.0, 55.0);
            this.yPlusButtonLocation = this.scalePoint(0.0, 80.0);
            this.zMinusButtonLocation = this.scalePoint(237.0, 135.0);
            this.zPlusButtonLocation = this.scalePoint(237.0, 40.0);
            this.axisAPanelLocation = this.scalePoint(415.0, 0.0);
            this.axisBPanelLocation = this.scalePoint(415.0, 170.0);
            this.stopButtonLocation = this.scalePoint(330.0, 100.0);
        }
    }

    private abstract class MakerbotArrangement
    extends DefaultArrangement {
        public String extruderImageString;
        public Point2i extruderImageLocation;
        public String buildplateImageString;
        public Point2i buildplateImageLocation;

        public MakerbotArrangement(MachineInterface machine) {
            super(machine);
            this.extruderImageString = "extruder";
            this.extruderImageLocation = null;
            this.buildplateImageString = "buildplate";
            this.buildplateImageLocation = null;
            this.buttonFolder = "images/jog/makerbot/";
            this.xScale = 0.5;
            this.yScale = 0.5;
            this.stopButtonString = "Stop";
            if (machine.getModel().getTools().size() > 1) {
                this.extruderImageString = "dual-extruder";
            }
        }

        public JPanel getButtonPanel() {
            JPanel panel = super.getButtonPanel();
            BufferedImage buildplate = Base.getImage(this.buttonFolder + this.buildplateImageString + ".png", panel);
            panel.add((Component)new JLabel(new ImageIcon(this.scaleImage(buildplate))), "pos " + this.buildplateImageLocation.x + " " + this.buildplateImageLocation.y);
            BufferedImage extruder = Base.getImage(this.buttonFolder + this.extruderImageString + ".png", panel);
            panel.add((Component)new JLabel(new ImageIcon(this.scaleImage(extruder))), "pos " + this.extruderImageLocation.x + " " + this.extruderImageLocation.y);
            BufferedImage background = Base.getImage(this.buttonFolder + this.backgroundImageString + ".png", panel);
            panel.add((Component)new JLabel(new ImageIcon(this.scaleImage(background))), "pos " + this.backgroundImageLocation.x + " " + this.backgroundImageLocation.y);
            return panel;
        }
    }

    private class DefaultArrangement
    extends ButtonArrangement {
        public DefaultArrangement(MachineInterface machine) {
            super(machine);
            this.buttonFolder = "images/jog/original/";
            this.xScale = 1.0;
            this.yScale = 1.0;
            this.backgroundImageLocation = this.scalePoint(0.0, 0.0);
            this.xMinusButtonLocation = this.scalePoint(15.0, 60.0);
            this.xPlusButtonLocation = this.scalePoint(113.0, 60.0);
            this.yMinusButtonLocation = this.scalePoint(60.0, 113.0);
            this.yPlusButtonLocation = this.scalePoint(60.0, 15.0);
            this.zMinusButtonLocation = this.scalePoint(165.0, 90.0);
            this.zPlusButtonLocation = this.scalePoint(165.0, 38.0);
            this.axisAPanelLocation = this.scalePoint(5.0, 0.0);
            this.axisBPanelLocation = this.scalePoint(115.0, 0.0);
            this.stopButtonLocation = this.scalePoint(65.0, 65.0);
        }

        public JPanel getButtonPanel() {
            JPanel panel = new JPanel((LayoutManager)new MigLayout());
            Set<AxisId> axes = this.machine.getModel().getAvailableAxes();
            JButton button = JogPanel.this.createJogButton(this.xMinusButtonString, this.xMinusTooltip, this, "X-");
            panel.add((Component)button, "pos " + this.xMinusButtonLocation.x + " " + this.xMinusButtonLocation.y);
            button = JogPanel.this.createJogButton(this.xPlusButtonString, this.xPlusTooltip, this, "X+");
            panel.add((Component)button, "pos " + this.xPlusButtonLocation.x + " " + this.xPlusButtonLocation.y);
            button = JogPanel.this.createJogButton(this.yMinusButtonString, this.yMinusTooltip, this, "Y-");
            panel.add((Component)button, "pos " + this.yMinusButtonLocation.x + " " + this.yMinusButtonLocation.y);
            button = JogPanel.this.createJogButton(this.yPlusButtonString, this.yPlusTooltip, this, "Y+");
            panel.add((Component)button, "pos " + this.yPlusButtonLocation.x + " " + this.yPlusButtonLocation.y);
            if (this.machine.getDriver().hasEmergencyStop()) {
                JButton panicButton = JogPanel.this.createJogButton(this.stopButtonString, this.stopTooltip, this, "Stop");
                panel.add((Component)panicButton, "pos " + this.stopButtonLocation.x + " " + this.stopButtonLocation.y);
            }
            if (axes.contains((Object)AxisId.Z)) {
                button = JogPanel.this.createJogButton(this.zMinusButtonString, this.zMinusTooltip, this, "Z-");
                panel.add((Component)button, "pos " + this.zMinusButtonLocation.x + " " + this.zMinusButtonLocation.y);
                button = JogPanel.this.createJogButton(this.zPlusButtonString, this.zPlusTooltip, this, "Z+");
                panel.add((Component)button, "pos " + this.zPlusButtonLocation.x + " " + this.zPlusButtonLocation.y);
            }
            if (axes.contains((Object)AxisId.A)) {
                panel.add((Component)JogPanel.this.makeRotationPanel(AxisId.A), "pos " + this.axisAPanelLocation.x + " " + this.axisAPanelLocation.y);
            }
            if (axes.contains((Object)AxisId.B)) {
                panel.add((Component)JogPanel.this.makeRotationPanel(AxisId.B), "pos " + this.axisBPanelLocation.x + " " + this.axisBPanelLocation.y);
            }
            return panel;
        }
    }

    private abstract class ButtonArrangement {
        public final MachineInterface machine;
        public String buttonFolder = "images/jog/";
        public String overButtonString = "Over";
        public String pressedButtonString = "Down";
        public String backgroundImageString = null;
        public Point2i backgroundImageLocation = null;
        public String xMinusButtonString = "X-";
        public String xPlusButtonString = "X+";
        public String yMinusButtonString = "Y-";
        public String yPlusButtonString = "Y+";
        public String zMinusButtonString = "Z-";
        public String zPlusButtonString = "Z+";
        public String xMinusTooltip = "Jog X axis in negative direction";
        public String xPlusTooltip = "Jog X axis in positive direction";
        public String yMinusTooltip = "Jog Y axis in negative direction";
        public String yPlusTooltip = "Jog Y axis in positive direction";
        public String zMinusTooltip = "Jog Z axis in negative direction";
        public String zPlusTooltip = "Jog Z axis in positive direction";
        public Point2i xMinusButtonLocation;
        public Point2i xPlusButtonLocation;
        public Point2i yMinusButtonLocation;
        public Point2i yPlusButtonLocation;
        public Point2i zMinusButtonLocation;
        public Point2i zPlusButtonLocation;
        public String stopButtonString = "panic";
        public String stopTooltip = "Emergency stop";
        public Point2i stopButtonLocation = null;
        public Point2i axisAPanelLocation;
        public Point2i axisBPanelLocation;
        public double xScale = 1.0;
        public double yScale = 1.0;

        public ButtonArrangement(MachineInterface machine) {
            this.machine = machine;
        }

        public abstract JPanel getButtonPanel();

        public Point2i scalePoint(double x, double y) {
            return new Point2i((int)(x * this.xScale), (int)(y * this.yScale));
        }

        public Image scaleImage(Image img) {
            return img.getScaledInstance((int)((double)img.getWidth(null) * this.xScale), (int)((double)img.getHeight(null) * this.yScale), 4);
        }
    }

    private class Point2i {
        public int x;
        public int y;

        public Point2i(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

