/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.modeling;

import java.awt.Color;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import replicatorg.app.Base;
import replicatorg.app.ui.MainWindow;
import replicatorg.machine.model.BuildVolume;
import replicatorg.model.BuildModel;

public class EditingModel {
    protected final BuildModel model;
    Material objectMaterial = null;
    private BranchGroup group = null;
    private TransformGroup shapeTransform = new TransformGroup();
    private final MainWindow mainWindow;
    Shape3D originalShape;
    private Point3d centroid = null;
    private Point3d bottom = null;
    boolean inDrag = false;
    boolean firstDrag = false;

    public EditingModel(BuildModel model, MainWindow mainWindow) {
        this.model = model;
        this.mainWindow = mainWindow;
        model.setEditListener(this);
    }

    private BranchGroup makeShape(BuildModel model) {
        this.originalShape = model.getShape();
        if (this.originalShape.getGeometry() == null) {
            BranchGroup wrapper = new BranchGroup();
            wrapper.setCapability(17);
            wrapper.compile();
            return wrapper;
        }
        Shape3D solidShape = (Shape3D)this.originalShape.cloneTree();
        solidShape.setCapability(12);
        solidShape.getGeometry().setCapability(8);
        solidShape.getGeometry().setCapability(0);
        solidShape.getGeometry().setCapability(4);
        this.objectMaterial = new Material();
        this.objectMaterial.setCapability(1);
        this.updateModelColor();
        Appearance solid = new Appearance();
        solid.setMaterial(this.objectMaterial);
        PolygonAttributes pa = new PolygonAttributes();
        pa.setPolygonMode(2);
        pa.setCullFace(0);
        pa.setBackFaceNormalFlip(true);
        solid.setPolygonAttributes(pa);
        solidShape.setAppearance(solid);
        BranchGroup wrapper = new BranchGroup();
        this.shapeTransform = new TransformGroup();
        this.shapeTransform.setCapability(18);
        this.shapeTransform.setCapability(17);
        this.shapeTransform.setCapability(12);
        wrapper.addChild((Node)this.shapeTransform);
        this.shapeTransform.addChild((Node)solidShape);
        wrapper.setCapability(17);
        wrapper.compile();
        return wrapper;
    }

    public BuildModel getBuildModel() {
        return this.model;
    }

    public void updateModelColor() {
        if (this.objectMaterial != null) {
            Color modelColor = new Color(Base.preferences.getInt("ui.modelColor", -19635));
            this.objectMaterial.setAmbientColor(new Color3f(modelColor));
            this.objectMaterial.setDiffuseColor(new Color3f(modelColor));
        }
    }

    public BranchGroup getGroup() {
        if (this.group == null) {
            this.group = this.makeShape(this.model);
        }
        return this.group;
    }

    public ReferenceFrame getReferenceFrame() {
        Transform3D translate = new Transform3D();
        this.shapeTransform.getTransform(translate);
        ReferenceFrame rf = new ReferenceFrame();
        translate.transform(rf.origin);
        translate.transform(rf.zAxis);
        return rf;
    }

    public Transform3D transformOnCentroid(Transform3D transform) {
        Transform3D old = new Transform3D();
        Transform3D t1 = new Transform3D();
        Transform3D t2 = new Transform3D();
        Vector3d t1v = new Vector3d((Tuple3d)this.getCentroid());
        t1v.negate();
        t1.setTranslation(t1v);
        Vector3d t2v = new Vector3d((Tuple3d)this.getCentroid());
        t2.setTranslation(t2v);
        this.shapeTransform.getTransform(old);
        Transform3D composite = new Transform3D();
        composite.mul(t2);
        composite.mul(transform);
        composite.mul(t1);
        composite.mul(old);
        return composite;
    }

    public Transform3D transformOnBottom(Transform3D transform) {
        Transform3D old = new Transform3D();
        Transform3D t1 = new Transform3D();
        Transform3D t2 = new Transform3D();
        Vector3d t1v = new Vector3d((Tuple3d)this.getBottom());
        t1v.negate();
        t1.setTranslation(t1v);
        Vector3d t2v = new Vector3d((Tuple3d)this.getBottom());
        t2.setTranslation(t2v);
        this.shapeTransform.getTransform(old);
        Transform3D composite = new Transform3D();
        composite.mul(t2);
        composite.mul(transform);
        composite.mul(t1);
        composite.mul(old);
        return composite;
    }

    public void rotateObject(double turntable, double elevation) {
        if (turntable == 0.0 && elevation == 0.0) {
            return;
        }
        Transform3D r1 = new Transform3D();
        Transform3D r2 = new Transform3D();
        r1.rotX(elevation);
        r2.rotZ(turntable);
        r2.mul(r1);
        r2 = this.transformOnCentroid(r2);
        this.model.setTransform(r2, "rotation", this.isNewOp());
    }

    public void rotateObject(AxisAngle4d angle) {
        Transform3D t = new Transform3D();
        t.setRotation(angle);
        t = this.transformOnCentroid(t);
        this.model.setTransform(t, "rotation", this.isNewOp());
    }

    public void modelTransformChanged() {
        this.shapeTransform.setTransform(this.model.getTransform());
        this.mainWindow.updateUndo();
    }

    public void translateObject(double x, double y, double z) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return;
        }
        this.invalidateBounds();
        Transform3D translate = new Transform3D();
        translate.setZero();
        translate.setTranslation(new Vector3d(x, y, z));
        Transform3D old = new Transform3D();
        this.shapeTransform.getTransform(old);
        old.add(translate);
        this.model.setTransform(old, "move", this.isNewOp());
    }

    public double getWidth() {
        Point3d lower = new Point3d();
        Point3d upper = new Point3d();
        this.getBoundingBox().getLower(lower);
        this.getBoundingBox().getUpper(upper);
        return upper.x - lower.x;
    }

    public double getDepth() {
        Point3d lower = new Point3d();
        Point3d upper = new Point3d();
        this.getBoundingBox().getLower(lower);
        this.getBoundingBox().getUpper(upper);
        return upper.y - lower.y;
    }

    public double getHeight() {
        Point3d lower = new Point3d();
        Point3d upper = new Point3d();
        this.getBoundingBox().getLower(lower);
        this.getBoundingBox().getUpper(upper);
        return upper.z - lower.z;
    }

    private BoundingBox getBoundingBox(Group group) {
        return this.getBoundingBox(group, new Transform3D());
    }

    private BoundingBox getBoundingBox(Shape3D shape, Transform3D transformation) {
        BoundingBox bb = null;
        Enumeration geometries = shape.getAllGeometries();
        while (geometries.hasMoreElements()) {
            Geometry g = (Geometry)geometries.nextElement();
            if (!(g instanceof GeometryArray)) continue;
            GeometryArray ga = (GeometryArray)g;
            Point3d p = new Point3d();
            for (int i = 0; i < ga.getVertexCount(); ++i) {
                ga.getCoordinate(i, p);
                transformation.transform(p);
                if (bb == null) {
                    bb = new BoundingBox(p, p);
                }
                bb.combine(p);
            }
        }
        return bb;
    }

    public void flipZ() {
        Transform3D flipZ = new Transform3D();
        flipZ.rotY(Math.PI);
        flipZ = this.transformOnCentroid(flipZ);
        this.model.setTransform(flipZ, "flip", this.isNewOp());
    }

    public void mirrorX() {
        Transform3D t = new Transform3D();
        Vector3d v = new Vector3d(-1.0, 1.0, 1.0);
        t.setScale(v);
        t = this.transformOnCentroid(t);
        this.model.setTransform(t, "mirror X", this.isNewOp());
    }

    public void mirrorY() {
        Transform3D t = new Transform3D();
        Vector3d v = new Vector3d(1.0, -1.0, 1.0);
        t.setScale(v);
        t = this.transformOnCentroid(t);
        this.model.setTransform(t, "mirror Y", this.isNewOp());
    }

    public void mirrorZ() {
        Transform3D t = new Transform3D();
        Vector3d v = new Vector3d(1.0, 1.0, -1.0);
        t.setScale(v);
        t = this.transformOnCentroid(t);
        this.model.setTransform(t, "mirror Z", this.isNewOp());
    }

    public boolean isOnPlatform() {
        BoundingBox bb = this.getBoundingBox();
        Point3d lower = new Point3d();
        bb.getLower(lower);
        return lower.z < 0.001 && lower.z > -0.001;
    }

    public void scale(double scale, boolean isOnPlatform) {
        Transform3D t = new Transform3D();
        t.setScale(scale);
        t = isOnPlatform ? this.transformOnBottom(t) : this.transformOnCentroid(t);
        this.shapeTransform.setTransform(t);
        this.model.setTransform(t, "resize", this.isNewOp());
    }

    public Double scaleMax() {
        this.putOnPlatform();
        BoundingBox bb = this.getBoundingBox();
        Point3d lower = new Point3d();
        Point3d upper = new Point3d();
        bb.getLower(lower);
        bb.getUpper(upper);
        BuildVolume bv = this.mainWindow.previewPanel.buildVol;
        Point3d size = new Point3d(upper.x - lower.x, upper.y - lower.y, upper.z - lower.z);
        if (bv == null) {
            return Double.NaN;
        }
        Point3d scale = new Point3d(((double)bv.getX() - 10.0) / size.x, ((double)bv.getY() - 10.0) / size.y, (double)bv.getZ() / size.z);
        Double newScale = new Double(Math.min(scale.x, Math.min(scale.y, scale.z)));
        this.scale(newScale, true);
        return newScale;
    }

    private BoundingBox getBoundingBox(Group group, Transform3D transformation) {
        BoundingBox bb = new BoundingBox(new Point3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE), new Point3d(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE));
        transformation = new Transform3D(transformation);
        if (group instanceof TransformGroup) {
            Transform3D nextTransform = new Transform3D();
            ((TransformGroup)group).getTransform(nextTransform);
            transformation.mul(nextTransform);
        }
        for (int i = 0; i < group.numChildren(); ++i) {
            Node n = group.getChild(i);
            if (n instanceof Shape3D) {
                bb.combine((Bounds)this.getBoundingBox((Shape3D)n, transformation));
                continue;
            }
            if (!(n instanceof Group)) continue;
            bb.combine((Bounds)this.getBoundingBox((Group)n, transformation));
        }
        return bb;
    }

    public BoundingBox getBoundingBox() {
        return this.getBoundingBox((Group)this.shapeTransform);
    }

    private void invalidateBounds() {
        this.centroid = null;
        this.bottom = null;
    }

    private void validateBounds() {
        if (this.centroid == null) {
            BoundingBox bb = this.getBoundingBox();
            Point3d p1 = new Point3d();
            Point3d p2 = new Point3d();
            bb.getLower(p1);
            bb.getUpper(p2);
            p2.interpolate((Tuple3d)p1, 0.5);
            this.centroid = p2;
            this.bottom = new Point3d(this.centroid.x, this.centroid.y, p1.z);
        }
    }

    public Point3d getCentroid() {
        this.validateBounds();
        return this.centroid;
    }

    public Point3d getBottom() {
        this.validateBounds();
        return this.bottom;
    }

    public void center() {
        BoundingBox bb = this.getBoundingBox((Group)this.shapeTransform);
        Point3d lower = new Point3d();
        Point3d upper = new Point3d();
        bb.getLower(lower);
        bb.getUpper(upper);
        double zoff = -lower.z;
        double xoff = -(upper.x + lower.x) / 2.0;
        double yoff = -(upper.y + lower.y) / 2.0;
        this.translateObject(xoff, yoff, zoff);
    }

    public void putOnPlatform() {
        BoundingBox bb = this.getBoundingBox((Group)this.shapeTransform);
        Point3d lower = new Point3d();
        bb.getLower(lower);
        double zoff = -lower.z;
        this.translateObject(0.0, 0.0, zoff);
    }

    public void layFlat() {
        Transform3D t = new Transform3D();
        this.shapeTransform.getTransform(t);
        Enumeration geometries = this.originalShape.getAllGeometries();
        while (geometries.hasMoreElements()) {
            Geometry g = (Geometry)geometries.nextElement();
            double lowest = Double.MAX_VALUE;
            Vector3d flattest = new Vector3d(1.0, 0.0, 0.0);
            if (g instanceof GeometryArray) {
                GeometryArray ga = (GeometryArray)g;
                Point3d p1 = new Point3d();
                Point3d p2 = new Point3d();
                Point3d p3 = new Point3d();
                int i = 0;
                while (i < ga.getVertexCount()) {
                    ga.getCoordinate(i++, p1);
                    ga.getCoordinate(i++, p2);
                    ga.getCoordinate(i++, p3);
                    t.transform(p1);
                    t.transform(p2);
                    t.transform(p3);
                    double triLowest = Math.min(p1.z, Math.min(p2.z, p3.z));
                    if (triLowest < lowest) {
                        flattest = new Vector3d(1.0, 0.0, 0.0);
                        lowest = triLowest;
                    }
                    if (triLowest != lowest) continue;
                    Vector3d v1 = new Vector3d((Tuple3d)p2);
                    v1.sub((Tuple3d)p1);
                    Vector3d v2 = new Vector3d((Tuple3d)p3);
                    v2.sub((Tuple3d)p2);
                    Vector3d v = new Vector3d();
                    v.cross(v1, v2);
                    v.normalize();
                    if (!(v.z < flattest.z)) continue;
                    flattest = v;
                }
            }
            Transform3D flattenTransform = new Transform3D();
            Vector3d downZ = new Vector3d(0.0, 0.0, -1.0);
            double angle = Math.acos(flattest.dot(downZ));
            Vector3d cross = new Vector3d();
            cross.cross(flattest, downZ);
            flattenTransform.setRotation(new AxisAngle4d(cross, angle));
            flattenTransform = this.transformOnCentroid(flattenTransform);
            this.shapeTransform.setTransform(flattenTransform);
            this.model.setTransform(flattenTransform, "Lay flat", this.isNewOp());
            this.invalidateBounds();
        }
    }

    private boolean isNewOp() {
        if (!this.inDrag) {
            return true;
        }
        if (this.firstDrag) {
            this.firstDrag = false;
            return true;
        }
        return false;
    }

    public void startDrag() {
        this.inDrag = true;
        this.firstDrag = true;
    }

    public void endDrag() {
        this.inDrag = false;
    }

    public class ReferenceFrame {
        public Point3d origin = new Point3d();
        public Vector3d zAxis = new Vector3d(0.0, 0.0, 1.0);
    }
}

