/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.gcode.GCodeCommand;
import replicatorg.app.gcode.GCodeEnumeration;
import replicatorg.app.gcode.GCodeParser;
import replicatorg.drivers.Driver;
import replicatorg.drivers.DriverQueryInterface;
import replicatorg.drivers.EstimationDriver;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.SimulationDriver;
import replicatorg.drivers.StopException;
import replicatorg.drivers.commands.DriverCommand;
import replicatorg.machine.MachineCallbackHandler;
import replicatorg.machine.MachineCommand;
import replicatorg.machine.MachineInterface;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineThread;
import replicatorg.machine.MachineToolStatusEvent;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.Endstops;
import replicatorg.machine.model.MachineModel;
import replicatorg.machine.model.MachineType;
import replicatorg.machine.model.ToolModel;
import replicatorg.model.GCodeSource;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Machine
implements MachineInterface {
    MachineThread machineThread;
    final MachineCallbackHandler callbackHandler;
    protected Node machineNode;

    @Override
    public MachineState getMachineState() {
        return this.machineThread.getMachineState();
    }

    @Override
    public String getMachineName() {
        return this.machineThread.getMachineName();
    }

    public Machine(Node mNode, MachineCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        this.machineNode = mNode;
        this.machineThread = new MachineThread(this, mNode);
        this.machineThread.start();
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.DISCONNECT, null, null));
    }

    @Override
    public boolean buildRemote(String remoteName) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_REMOTE, null, remoteName));
        return true;
    }

    @Override
    public void buildDirect(final GCodeSource source) {
        Runnable prepareAndStart = new Runnable(){
            private Map<String, Integer> messages = new TreeMap<String, Integer>();
            private boolean cancelled = false;

            public void run() {
                Base.logger.info("Estimating build time and scanning code for errors...");
                if (Base.preferences.getBoolean("build.safetyChecks", true)) {
                    Machine.this.emitStateChange(new MachineState(MachineState.State.BUILDING), "Running safety checks...");
                    Machine.this.safetyCheck(source, this.messages);
                    if (!this.messages.isEmpty()) {
                        System.out.println("errors");
                        JPanel displayPanel = new JPanel((LayoutManager)new MigLayout("fill"));
                        final JDialog dialog = new JDialog(Base.getEditor(), "GCode warning", true);
                        JTextArea testLabel = new JTextArea();
                        testLabel.setLineWrap(true);
                        testLabel.setWrapStyleWord(true);
                        testLabel.setEditable(false);
                        testLabel.setOpaque(false);
                        testLabel.setBorder(BorderFactory.createEmptyBorder());
                        testLabel.setFont(new JLabel().getFont());
                        testLabel.setText("The pre-run check has found some potentially problematic GCode. This may be a result of trying to run code on a machine other than the one it's intended for (i.e. running dual headed GCode on a single headed machine).\n\nClick on a message to see the last place it occurred.");
                        displayPanel.add((Component)testLabel, "growx, wrap");
                        JPanel messagePanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0"));
                        List<String> displayMessages = new ArrayList<String>(this.messages.keySet());
                        if (displayMessages.size() > 10) {
                            String moreMessage = "And " + (displayMessages.size() - 10) + " more...";
                            displayMessages = displayMessages.subList(0, 10);
                            displayMessages.add(moreMessage);
                        }
                        final JList<Object> messageList = new JList<Object>(displayMessages.toArray());
                        messageList.addMouseListener(new MouseAdapter(){

                            public void mouseClicked(MouseEvent arg0) {
                                if (arg0.getClickCount() == 1) {
                                    this.highlightLine(messageList.getSelectedValue());
                                }
                            }
                        });
                        messageList.setSelectedIndex(0);
                        this.highlightLine(displayMessages.get(0));
                        messageList.addKeyListener(new KeyAdapter(){

                            public void keyPressed(KeyEvent arg0) {
                                if (arg0.getKeyCode() == 10) {
                                    this.highlightLine(messageList.getSelectedValue());
                                } else if (arg0.getKeyCode() == 38) {
                                    messageList.setSelectedIndex(Math.max(messageList.getSelectedIndex(), 0));
                                } else if (arg0.getKeyCode() == 40) {
                                    messageList.setSelectedIndex(Math.min(messageList.getSelectedIndex(), messageList.getModel().getSize()));
                                }
                            }
                        });
                        messagePanel.add(messageList, "growx, growy");
                        displayPanel.add((Component)new JScrollPane(messagePanel), "growx, growy, wrap");
                        JButton proceedButton = new JButton("Proceed anyway");
                        proceedButton.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent arg0) {
                                dialog.dispose();
                            }
                        });
                        displayPanel.add((Component)proceedButton, "align right, split");
                        JButton cancelButton = new JButton("Cancel build");
                        cancelButton.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent arg0) {
                                cancelled = true;
                                boolean connected = Machine.this.getMachineState().canPrint();
                                Machine.this.emitStateChange(new MachineState(MachineState.State.ERROR), "Print cancelled");
                                Machine.this.emitStateChange(new MachineState(MachineState.State.NOT_ATTACHED), "Print cancelled");
                                if (connected) {
                                    Machine.this.emitStateChange(new MachineState(MachineState.State.READY), "Print cancelled");
                                }
                                dialog.dispose();
                            }
                        });
                        displayPanel.add((Component)cancelButton, "align right, wrap");
                        dialog.add(displayPanel);
                        dialog.pack();
                        dialog.setVisible(true);
                    }
                }
                if (!this.cancelled) {
                    Machine.this.emitStateChange(new MachineState(MachineState.State.BUILDING), "Estimating time to completion...");
                    Machine.this.estimate(source);
                    Base.logger.info("Beginning build.");
                    Machine.this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_DIRECT, source, null));
                }
            }

            private void highlightLine(Object atWhichLine) {
                Base.getEditor().highlightLine(this.messages.get(atWhichLine));
            }
        };
        Executors.newSingleThreadExecutor().execute(prepareAndStart);
    }

    @Override
    public void simulate(GCodeSource source) {
        Base.logger.info("Estimating build time...");
        this.estimate(source);
        Base.logger.info("Beginning simulation.");
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.SIMULATE, source, null));
    }

    public void safetyCheck(GCodeSource source, Map<String, Integer> messages) {
        int nToolheads = this.machineThread.getModel().getTools().size();
        Point5d maxRates = this.machineThread.getModel().getMaximumFeedrates();
        Integer lineNumber = 0;
        for (String line : source) {
            String message;
            GCodeCommand gcode;
            try {
                gcode = new GCodeCommand(line);
            }
            catch (Exception e) {
                message = "ReplicatorG can't parse '" + line + "'";
                messages.put(message, lineNumber);
                Base.logger.log(Level.SEVERE, message);
                continue;
            }
            String cmd = gcode.getCommand();
            if (cmd.split(" ").length < 1) continue;
            String mainCode = cmd.split(" ")[0];
            if (!"".equals(mainCode) && GCodeEnumeration.getGCode(mainCode) == null) {
                message = "ReplicatorG doesn't recognize GCode '" + line + "'";
                messages.put(message, lineNumber);
                Base.logger.log(Level.SEVERE, message);
            }
            if (!this.homingDirectionIsSafe(gcode)) {
                message = "Homing in the wrong direction for selected machine: '" + line + "'";
                messages.put(message, lineNumber);
                Base.logger.log(Level.SEVERE, message);
            }
            if (gcode.getCodeValue('T') > (double)(nToolheads - 1) && gcode.getCodeValue('M') != 109.0 && gcode.getCodeValue('M') != 106.0 && gcode.getCodeValue('M') != 107.0) {
                message = "Toolheads index error! You don't have a toolhead numbered " + gcode.getCodeValue('T');
                messages.put(message, lineNumber);
                message = "Only the first Toolhead index error is logged. Please regenrate your GCode or manually check your gcode to correct.";
                messages.put(message, lineNumber);
                Base.logger.log(Level.SEVERE, message);
                return;
            }
            if (gcode.hasCode('F')) {
                double fVal = gcode.getCodeValue('F');
                if (gcode.hasCode('X') && fVal > maxRates.x() || gcode.hasCode('Y') && fVal > maxRates.y() || gcode.hasCode('A') && fVal > maxRates.a() || gcode.hasCode('B') && fVal > maxRates.b()) {
                    message = "You're moving too fast! " + line + " turns at least one axis faster than it's max speed.";
                    messages.put(message, lineNumber);
                    Base.logger.log(Level.WARNING, message);
                }
                if (fVal < 0.0) {
                    message = "Negative feedrate detected! '" + line + "' causes crashes in the reprap driver.";
                    messages.put(message, lineNumber);
                    Base.logger.log(Level.SEVERE, message);
                }
            }
            Integer n = lineNumber;
            Integer n2 = lineNumber = Integer.valueOf(lineNumber + 1);
        }
    }

    private boolean homingDirectionIsSafe(GCodeCommand gcode) {
        Endstops zstop;
        Endstops ystop = zstop = Endstops.BOTH;
        Endstops xstop = zstop;
        if (gcode.hasCode('X')) {
            xstop = this.machineThread.getModel().getEndstops(AxisId.X);
        }
        if (gcode.hasCode('Y')) {
            ystop = this.machineThread.getModel().getEndstops(AxisId.Y);
        }
        if (gcode.hasCode('Z')) {
            zstop = this.machineThread.getModel().getEndstops(AxisId.Z);
        }
        if (gcode.getCodeValue('G') == 161.0) {
            if (xstop != Endstops.MIN && xstop != Endstops.BOTH) {
                return false;
            }
            if (ystop != Endstops.MIN && ystop != Endstops.BOTH) {
                return false;
            }
            if (zstop != Endstops.MIN && zstop != Endstops.BOTH) {
                return false;
            }
        } else if (gcode.getCodeValue('G') == 162.0) {
            if (xstop != Endstops.MAX && xstop != Endstops.BOTH) {
                return false;
            }
            if (ystop != Endstops.MAX && ystop != Endstops.BOTH) {
                return false;
            }
            if (zstop != Endstops.MAX && zstop != Endstops.BOTH) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void estimate(GCodeSource source) {
        if (source == null) {
            return;
        }
        EstimationDriver estimator = new EstimationDriver();
        estimator.setMachine(this.machineThread.getModel());
        LinkedList<DriverCommand> estimatorQueue = new LinkedList<DriverCommand>();
        GCodeParser estimatorParser = new GCodeParser();
        estimatorParser.init(estimator);
        for (String line : source) {
            estimatorParser.parse(line, estimatorQueue);
            for (DriverCommand command : estimatorQueue) {
                try {
                    command.run(estimator);
                }
                catch (RetryException r) {
                }
                catch (StopException e) {}
            }
            estimatorQueue.clear();
        }
        this.machineThread.setEstimatedBuildTime(estimator.getBuildTime());
        Base.logger.info("Estimated build time is: " + EstimationDriver.getBuildTimeString(estimator.getBuildTime()));
    }

    @Override
    public DriverQueryInterface getDriverQueryInterface() {
        return (DriverQueryInterface)((Object)this.machineThread.getDriver());
    }

    @Override
    public Driver getDriver() {
        return this.machineThread.getDriver();
    }

    @Override
    public SimulationDriver getSimulatorDriver() {
        return this.machineThread.getSimulator();
    }

    @Override
    public MachineModel getModel() {
        return this.machineThread.getModel();
    }

    @Override
    public void stopMotion() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.STOP_MOTION, null, null));
    }

    @Override
    public void stopAll() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.STOP_ALL, null, null));
    }

    @Override
    public synchronized boolean isConnected() {
        return this.machineThread.isConnected();
    }

    @Override
    public void pause() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.PAUSE, null, null));
    }

    @Override
    public void upload(GCodeSource source, String remoteName) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_TO_REMOTE_FILE, source, remoteName));
    }

    @Override
    public void buildToFile(GCodeSource source, String path) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_TO_FILE, source, path));
    }

    @Override
    public void unpause() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.UNPAUSE, null, null));
    }

    @Override
    public void reset() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.RESET, null, null));
    }

    @Override
    public void connect(String portName) {
        if (!this.machineThread.isAlive()) {
            this.machineThread = new MachineThread(this, this.machineNode);
            this.machineThread.start();
        }
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.CONNECT, null, portName));
    }

    @Override
    public synchronized void disconnect() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.DISCONNECT, null, null));
    }

    @Override
    public synchronized boolean isPaused() {
        return this.getMachineState().isPaused();
    }

    @Override
    public void runCommand(DriverCommand command) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.RUN_COMMAND, command));
    }

    @Override
    public void dispose() {
        if (this.machineThread != null) {
            this.machineThread.scheduleRequest(new MachineCommand(RequestType.SHUTDOWN, null, null));
            try {
                this.machineThread.join(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void emitStateChange(MachineState current, String message) {
        MachineStateChangeEvent e = new MachineStateChangeEvent(this, current, message);
        this.callbackHandler.schedule(e);
    }

    protected void emitProgress(MachineProgressEvent progress) {
        this.callbackHandler.schedule(progress);
    }

    protected void emitToolStatus(ToolModel tool) {
        MachineToolStatusEvent e = new MachineToolStatusEvent(this, tool);
        this.callbackHandler.schedule(e);
    }

    @Override
    public int getLinesProcessed() {
        return this.machineThread.getLinesProcessed();
    }

    @Override
    public boolean isSimulating() {
        return this.machineThread.isSimulating();
    }

    @Override
    public boolean isInteractiveTarget() {
        return this.machineThread.isInteractiveTarget();
    }

    @Override
    public JobTarget getTarget() {
        return this.machineThread.getTarget();
    }

    @Override
    public MachineType getMachineType() {
        return this.getModel().getMachineType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JobTarget {
        NONE,
        SIMULATOR,
        MACHINE,
        REMOTE_FILE,
        FILE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestType {
        CONNECT,
        DISCONNECT,
        DISCONNECT_REMOTE_BUILD,
        RESET,
        SIMULATE,
        BUILD_DIRECT,
        BUILD_TO_FILE,
        BUILD_TO_REMOTE_FILE,
        BUILD_REMOTE,
        PAUSE,
        UNPAUSE,
        STOP_MOTION,
        STOP_ALL,
        RUN_COMMAND,
        SHUTDOWN;

    }
}

