/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import replicatorg.app.Base;
import replicatorg.plugin.toolpath.ToolpathGenerator;
import replicatorg.plugin.toolpath.skeinforge.PrintOMatic;
import replicatorg.plugin.toolpath.skeinforge.PrintOMatic5D;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;
import replicatorg.plugin.toolpath.slic3r.Slic3rGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolpathGeneratorFactory {
    private static Vector<ToolpathGeneratorDescriptor> generatorList = null;

    public static Vector<ToolpathGeneratorDescriptor> getGeneratorList() {
        if (generatorList == null) {
            generatorList = ToolpathGeneratorFactory.buildGeneratorList();
        }
        return generatorList;
    }

    private static Vector<ToolpathGeneratorDescriptor> buildGeneratorList() {
        Vector<ToolpathGeneratorDescriptor> list = new Vector<ToolpathGeneratorDescriptor>();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Slic3r071
        extends Slic3rGenerator {
            Slic3r071() {
                displayName = "Slic3r";
            }

            @Override
            public File getDefaultSlic3rDir() {
                String slic3rDir = "skein_engines/slic3r_engines";
                if (Base.isMacOS()) {
                    slic3rDir = "/Applications/Slic3r.app/Contents/MacOS";
                    Base.logger.finer("Slic3r in app data");
                    File absSlicerLocation = new File(slic3rDir);
                    if (!absSlicerLocation.exists()) {
                        Base.logger.severe("Slic3r on mac requires Slicer.app is installed in Applications");
                        return Base.getApplicationFile("slicer_unavailable");
                    }
                    return absSlicerLocation;
                }
                if (Base.isLinux()) {
                    slic3rDir = slic3rDir + "/linux/bin";
                }
                if (Base.isWindows()) {
                    slic3rDir = slic3rDir + "/windows";
                }
                File x = Base.getApplicationFile(slic3rDir);
                return x;
            }

            @Override
            public File getUserProfilesDir() {
                return Base.getUserDir("skein_engines/slic3r_engines/prefs");
            }

            @Override
            public List<Slic3rGenerator.Slic3rPreference> initPreferences() {
                LinkedList<Slic3rGenerator.Slic3rPreference> prefs = new LinkedList<Slic3rGenerator.Slic3rPreference>();
                return prefs;
            }
        }
        if (new Slic3r071().getDefaultSlic3rDir().exists()) {
            list.add(new ToolpathGeneratorDescriptor(Slic3r071.displayName, "This is the latest version of Slic3r.", Slic3r071.class));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Skeinforge50
        extends SkeinforgeGenerator {
            Skeinforge50() {
                displayName = "Skeinforge (50)";
            }

            @Override
            public File getDefaultSkeinforgeDir() {
                return Base.getApplicationFile("skein_engines/skeinforge-50/skeinforge_application");
            }

            @Override
            public File getUserProfilesDir() {
                return Base.getUserFile("sf_50_profiles");
            }

            @Override
            public List<SkeinforgeGenerator.SkeinforgePreference> initPreferences() {
                LinkedList<SkeinforgeGenerator.SkeinforgePreference> prefs = new LinkedList<SkeinforgeGenerator.SkeinforgePreference>();
                prefs.add(this.postprocess.getPreference());
                SkeinforgeGenerator.SkeinforgeBooleanPreference raftPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use Raft/Support", "replicatorg.skeinforge.useRaft", true, "Enables Raft and/or support material.  Enabled: add a 'raft' of plastic before starting the build. If overhangs are detected, add support material.");
                raftPref.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Add Raft, Elevate Nozzle, Orbit:", "true"));
                prefs.add(raftPref);
                SkeinforgeGenerator.SkeinforgeChoicePreference supportPref = new SkeinforgeGenerator.SkeinforgeChoicePreference("Use support material", "replicatorg.skeinforge.choiceSupport", "None", "If this option is selected, skeinforge will attempt to support large overhangs by laying down a support structure that you can later remove. Requires that Raft/Support be checked.");
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "true"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                prefs.add(supportPref);
                SkeinforgeGenerator.SkeinforgeBooleanPreference bookendPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use default start/end gcode", "replicatorg.skeinforge.useMachineBookend", true, "<html>Use the start and end.gcode defined in machines/*.xml for the currently selected machine.<br/>Uncheck this to use custom start and end.gcode from the skeinforge profile.</html>");
                bookendPref.addTrueOption(new SkeinforgeGenerator.SkeinforgeOption("alteration.csv", "Name of Start File:", ""));
                bookendPref.addTrueOption(new SkeinforgeGenerator.SkeinforgeOption("alteration.csv", "Name of End File:", ""));
                final JCheckBox bookendBox = (JCheckBox)bookendPref.getUI();
                ActionListener a = new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        if (bookendBox.isSelected()) {
                            postprocess.setPrependStart(true);
                            postprocess.setAppendEnd(true);
                        } else {
                            postprocess.setPrependStart(false);
                            postprocess.setAppendEnd(false);
                        }
                    }
                };
                bookendBox.addActionListener(a);
                a.actionPerformed(null);
                prefs.add(bookendPref);
                PrintOMatic5D printOMatic5D = new PrintOMatic5D();
                prefs.add(printOMatic5D);
                return prefs;
            }
        }
        if (new Skeinforge50().getDefaultSkeinforgeDir().exists()) {
            list.add(new ToolpathGeneratorDescriptor(Skeinforge50.displayName, "This is the default version of skeinforge.", Skeinforge50.class));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Skeinforge47
        extends SkeinforgeGenerator {
            Skeinforge47() {
                displayName = "Skeinforge (47) - Legacy";
            }

            @Override
            public File getDefaultSkeinforgeDir() {
                return Base.getApplicationFile("skein_engines/skeinforge-47/skeinforge_application");
            }

            @Override
            public File getUserProfilesDir() {
                return Base.getUserFile("sf_47_profiles");
            }

            @Override
            public List<SkeinforgeGenerator.SkeinforgePreference> initPreferences() {
                LinkedList<SkeinforgeGenerator.SkeinforgePreference> prefs = new LinkedList<SkeinforgeGenerator.SkeinforgePreference>();
                prefs.add(this.postprocess.getPreference());
                SkeinforgeGenerator.SkeinforgeBooleanPreference raftPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use Raft/Support", "replicatorg.skeinforge.useRaft", true, "Enables Raft and/or support material.  Enabled: add a 'raft' of plastic before starting the build. If overhangs are detected, add support material.");
                raftPref.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Add Raft, Elevate Nozzle, Orbit:", "true"));
                prefs.add(raftPref);
                SkeinforgeGenerator.SkeinforgeChoicePreference supportPref = new SkeinforgeGenerator.SkeinforgeChoicePreference("Use support material", "replicatorg.skeinforge.choiceSupport", "None", "If this option is selected, skeinforge will attempt to support large overhangs by laying down a support structure that you can later remove. Requires that Raft/Support be checked.");
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "true"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                prefs.add(supportPref);
                SkeinforgeGenerator.SkeinforgeBooleanPreference bookendPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use default start/end gcode", "replicatorg.skeinforge.useMachineBookend", true, "<html>Use the start and end.gcode defined in machines/*.xml for the currently selected machine.<br/>Uncheck this to use custom start and end.gcode from the skeinforge profile.</html>");
                bookendPref.addTrueOption(new SkeinforgeGenerator.SkeinforgeOption("alteration.csv", "Name of Start File:", ""));
                bookendPref.addTrueOption(new SkeinforgeGenerator.SkeinforgeOption("alteration.csv", "Name of End File:", ""));
                final JCheckBox bookendBox = (JCheckBox)bookendPref.getUI();
                ActionListener a = new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        if (bookendBox.isSelected()) {
                            postprocess.setPrependStart(true);
                            postprocess.setAppendEnd(true);
                        } else {
                            postprocess.setPrependStart(false);
                            postprocess.setAppendEnd(false);
                        }
                    }
                };
                bookendBox.addActionListener(a);
                a.actionPerformed(null);
                prefs.add(bookendPref);
                PrintOMatic5D printOMatic5D = new PrintOMatic5D();
                prefs.add(printOMatic5D);
                return prefs;
            }
        }
        if (new Skeinforge47().getDefaultSkeinforgeDir().exists()) {
            list.add(new ToolpathGeneratorDescriptor(Skeinforge47.displayName, "This is the an older version of skeinforge.", Skeinforge47.class));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Skeinforge44
        extends SkeinforgeGenerator {
            Skeinforge44() {
                displayName = "Skeinforge (44) - Legacy";
            }

            @Override
            public File getDefaultSkeinforgeDir() {
                return Base.getApplicationFile("skein_engines/skeinforge-44/skeinforge_application");
            }

            @Override
            public File getUserProfilesDir() {
                return Base.getUserFile("sf_44_profiles");
            }

            @Override
            public List<SkeinforgeGenerator.SkeinforgePreference> initPreferences() {
                LinkedList<SkeinforgeGenerator.SkeinforgePreference> prefs = new LinkedList<SkeinforgeGenerator.SkeinforgePreference>();
                PrintOMatic5D printOMatic5D = new PrintOMatic5D();
                prefs.add(printOMatic5D);
                return prefs;
            }
        }
        if (new Skeinforge44().getDefaultSkeinforgeDir().exists()) {
            list.add(new ToolpathGeneratorDescriptor(Skeinforge44.displayName, "This is an experimental version of skeinforge.", Skeinforge44.class));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Skeinforge40
        extends SkeinforgeGenerator {
            Skeinforge40() {
                displayName = "Skeinforge (40) - Legacy ";
            }

            @Override
            public File getDefaultSkeinforgeDir() {
                return Base.getApplicationFile("skein_engines/skeinforge-40/skeinforge_application");
            }

            @Override
            public File getUserProfilesDir() {
                return Base.getUserFile("sf_40_profiles");
            }

            @Override
            public List<SkeinforgeGenerator.SkeinforgePreference> initPreferences() {
                LinkedList<SkeinforgeGenerator.SkeinforgePreference> prefs = new LinkedList<SkeinforgeGenerator.SkeinforgePreference>();
                SkeinforgeGenerator.SkeinforgeBooleanPreference raftPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use Raft/Support", "replicatorg.skeinforge.useRaft", true, "Enables Raft and/or support material.  Enabled: add a 'raft' of plastic before starting the build. If overhangs are detected, add support material.");
                raftPref.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Add Raft, Elevate Nozzle, Orbit:", "true"));
                prefs.add(raftPref);
                SkeinforgeGenerator.SkeinforgeChoicePreference supportPref = new SkeinforgeGenerator.SkeinforgeChoicePreference("Use support material", "replicatorg.skeinforge.choiceSupport", "None", "If this option is selected, skeinforge will attempt to support large overhangs by laying down a support structure that you can later remove. Requires that Raft/Support be checked.");
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "true"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                prefs.add(supportPref);
                PrintOMatic printOMatic = new PrintOMatic();
                prefs.add(printOMatic);
                return prefs;
            }
        }
        if (new Skeinforge40().getDefaultSkeinforgeDir().exists()) {
            list.add(new ToolpathGeneratorDescriptor(Skeinforge40.displayName, "This is a recent version of skeinforge.", Skeinforge40.class));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Skeinforge35
        extends SkeinforgeGenerator {
            Skeinforge35() {
                displayName = "Skeinforge (35) - Legacy";
            }

            @Override
            public File getDefaultSkeinforgeDir() {
                return Base.getApplicationFile("skein_engines/skeinforge-35/skeinforge_application");
            }

            @Override
            public File getUserProfilesDir() {
                return Base.getUserFile("sf_35_profiles");
            }

            @Override
            public List<SkeinforgeGenerator.SkeinforgePreference> initPreferences() {
                LinkedList<SkeinforgeGenerator.SkeinforgePreference> prefs = new LinkedList<SkeinforgeGenerator.SkeinforgePreference>();
                prefs.add(this.postprocess.getPreference());
                SkeinforgeGenerator.SkeinforgeBooleanPreference raftPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use Raft/Support", "replicatorg.skeinforge.useRaft", true, "Enables Raft and/or support material.  Enabled: add a 'raft' of plastic before starting the build. If overhangs are detected, add support material.");
                raftPref.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Add Raft, Elevate Nozzle, Orbit and Set Altitude:", "true"));
                prefs.add(raftPref);
                SkeinforgeGenerator.SkeinforgeChoicePreference supportPref = new SkeinforgeGenerator.SkeinforgeChoicePreference("Use support material", "replicatorg.skeinforge.choiceSupport", "None", "If this option is selected, skeinforge will attempt to support large overhangs by laying down a support structure that you can later remove. Requires that Raft/Support be checked.");
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "true"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                prefs.add(supportPref);
                SkeinforgeGenerator.SkeinforgeBooleanPreference bookendPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use default start/end gcode", "replicatorg.skeinforge.useMachineBookend", true, "<html>Use the start and end.gcode defined in machines/*.xml for the currently selected machine.<br/>Uncheck this to use custom start and end.gcode from the skeinforge profile.</html>");
                bookendPref.addTrueOption(new SkeinforgeGenerator.SkeinforgeOption("preface.csv", "Name of Start File:", ""));
                bookendPref.addTrueOption(new SkeinforgeGenerator.SkeinforgeOption("preface.csv", "Name of End File:", ""));
                final JCheckBox bookendBox = (JCheckBox)bookendPref.getUI();
                ActionListener a = new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        if (bookendBox.isSelected()) {
                            postprocess.setPrependStart(true);
                            postprocess.setAppendEnd(true);
                        } else {
                            postprocess.setPrependStart(false);
                            postprocess.setAppendEnd(false);
                        }
                    }
                };
                bookendBox.addActionListener(a);
                a.actionPerformed(null);
                prefs.add(bookendPref);
                PrintOMatic printOMatic = new PrintOMatic();
                prefs.add(printOMatic);
                return prefs;
            }
        }
        if (new Skeinforge35().getDefaultSkeinforgeDir().exists()) {
            list.add(new ToolpathGeneratorDescriptor(Skeinforge35.displayName, "This is a decent version of skeinforge.", Skeinforge35.class));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Skeinforge31
        extends SkeinforgeGenerator {
            Skeinforge31() {
                displayName = "Skeinforge (31) - Legacy";
            }

            @Override
            public File getDefaultSkeinforgeDir() {
                return Base.getApplicationFile("skein_engines/skeinforge-31/skeinforge_application");
            }

            @Override
            public File getUserProfilesDir() {
                return Base.getUserFile("sf_31_profiles");
            }

            @Override
            public List<SkeinforgeGenerator.SkeinforgePreference> initPreferences() {
                LinkedList<SkeinforgeGenerator.SkeinforgePreference> prefs = new LinkedList<SkeinforgeGenerator.SkeinforgePreference>();
                SkeinforgeGenerator.SkeinforgeBooleanPreference raftPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use Raft/Support", "replicatorg.skeinforge.useRaft", true, "Enables Raft and/or support material.  Enabled: add a 'raft' of plastic before starting the build. If overhangs are detected, add support material.");
                raftPref.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Activate Raft", "true"));
                prefs.add(raftPref);
                return prefs;
            }
        }
        if (new Skeinforge31().getDefaultSkeinforgeDir().exists()) {
            list.add(new ToolpathGeneratorDescriptor(Skeinforge31.displayName, "This is an old version of skeinforge.", Skeinforge31.class));
        }
        return list;
    }

    public static String getSelectedName() {
        String name = Base.preferences.get("replicatorg.generator.name", "Skeinforge (50)");
        return name;
    }

    public static void setSelectedName(String name) {
        Base.preferences.put("replicatorg.generator.name", name);
    }

    public static ToolpathGenerator createSelectedGenerator() {
        String name = ToolpathGeneratorFactory.getSelectedName();
        Vector<ToolpathGeneratorDescriptor> list = ToolpathGeneratorFactory.getGeneratorList();
        ToolpathGenerator tg = null;
        boolean isSelected = false;
        for (ToolpathGeneratorDescriptor tgd : list) {
            if (!name.equals(tgd.name)) continue;
            tg = tgd.instantiate();
            isSelected = true;
            break;
        }
        if (!isSelected) {
            String message = "No Gcode Generator selected. Select a GCode generator \n in the GCode menu, under GCode Generator ";
            JOptionPane.showConfirmDialog(null, message, "No GCode Generator Selected.", 0, 3);
        }
        return tg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToolpathGeneratorDescriptor {
        public String name;
        public String description;
        public Class<?> tpClass;

        public ToolpathGeneratorDescriptor(String name, String description, Class<?> tpClass) {
            this.name = name;
            this.description = description;
            this.tpClass = tpClass;
        }

        public ToolpathGenerator instantiate() {
            try {
                return (ToolpathGenerator)this.tpClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

