/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.skeinforge;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.SavingTextField;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintOMatic5D
implements SkeinforgeGenerator.SkeinforgePreference {
    private JPanel component = new JPanel((LayoutManager)new MigLayout("ins 0, fillx, hidemode 1"));
    private JCheckBox enabled;
    private String baseName = "replicatorg.skeinforge.printOMatic5D.";
    JTabbedPane printOMatic5D;

    public PrintOMatic5D() {
        final String enabledName = this.baseName + "enabled";
        this.enabled = new JCheckBox("Use Print-O-Matic (stepper extruders only)", Base.preferences.getBoolean(enabledName, true));
        this.enabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (enabledName != null) {
                    Base.preferences.putBoolean(enabledName, PrintOMatic5D.this.enabled.isSelected());
                    PrintOMatic5D.this.printOMatic5D.setVisible(PrintOMatic5D.this.enabled.isSelected());
                    PrintOMatic5D.this.printOMatic5D.invalidate();
                    Window w = SwingUtilities.getWindowAncestor(PrintOMatic5D.this.printOMatic5D);
                    w.pack();
                }
            }
        });
        this.component.add((Component)this.enabled, "wrap, spanx");
        this.printOMatic5D = new JTabbedPane();
        this.makeTabs();
        this.component.add((Component)this.printOMatic5D, "spanx");
        this.printOMatic5D.setVisible(this.enabled.isSelected());
    }

    private void addTextParameter(JComponent target, String name, String description, String defaultValue, String toolTip) {
        String fullName = this.baseName + name;
        String value = null;
        if (fullName != null) {
            try {
                if (!Base.preferences.nodeExists(fullName)) {
                    defaultValue = Base.findDefaultByGlobalStatus(name, defaultValue);
                }
            }
            catch (BackingStoreException e) {
                // empty catch block
            }
            value = Base.preferences.get(fullName, defaultValue);
            Base.preferences.put(fullName, value);
        }
        target.add(new JLabel(description));
        SavingTextField input = new SavingTextField(fullName, value, 10);
        target.add((Component)input, "wrap");
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    private void addDropDownParameter(JComponent target, String name, String description, Vector<String> options, String toolTip) {
        String fullName = this.baseName + name;
        String value = null;
        if (fullName != null) {
            value = Base.preferences.get(fullName, options.firstElement());
            Base.preferences.put(fullName, value);
        }
        target.add(new JLabel(description));
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(options);
        model.setSelectedItem(value);
        JComboBox<String> input = new JComboBox<String>(model);
        target.add(input, "wrap");
        input.addActionListener(new ComboListener(model, fullName));
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    private void addBooleanParameter(JComponent target, String name, String description, boolean defaultValue, String toolTip) {
        String fullName = this.baseName + name;
        boolean isSet = false;
        if (fullName != null) {
            isSet = Base.preferences.getBoolean(fullName, defaultValue);
            Base.preferences.putBoolean(fullName, isSet);
        }
        target.add(new JLabel(description));
        JCheckBox input = new JCheckBox("", isSet);
        target.add((Component)input, "wrap");
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    public double getValue(String optionName) {
        String value = Base.preferences.get(this.baseName + optionName, null);
        Base.logger.fine("Saved value for preference " + this.baseName + optionName + " is " + value);
        Double number = null;
        try {
            number = Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            Base.logger.severe("Print-O-Matic setting " + optionName + "does not contain a valid number, please correct this!");
        }
        return number;
    }

    private void setValue(String optionName, String value) {
        Base.preferences.put(this.baseName + optionName, value);
    }

    private boolean getBooleanValue(String optionName) {
        boolean value = Base.preferences.getBoolean(this.baseName + optionName, true);
        Base.logger.fine("Saved value for preference " + this.baseName + optionName + " is " + value);
        return value;
    }

    private String getStringValue(String optionName) {
        String value = Base.preferences.get(this.baseName + optionName, null);
        Base.logger.fine("Saved value for preference " + this.baseName + optionName + " is " + value);
        return value;
    }

    private JComponent generatePrintPanel() {
        JPanel printPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.addTextParameter(printPanel, "infillPercent", "Object infill (%)", "10", "0= hollow object, 100=solid object");
        this.addTextParameter(printPanel, "desiredLayerHeight", "Layer Height (mm)", "0.27", "Set the desired layer height");
        this.addTextParameter(printPanel, "numberOfShells", "Number of shells:", "1", "Number of shells to add to the perimeter of an object. Set this to 0 if you are printing a model with thin features.");
        this.addTextParameter(printPanel, "desiredFeedrate", "Feedrate (mm/s)", "41", "slow: 0-20, default: 30, Fast: 40+, Accelerated: 80+");
        this.addTextParameter(printPanel, "travelFeedrate", "Travel Feedrate", "56", "slow: 0-20, default: 30, Fast: 50+, Accelerated:150+");
        this.addTextParameter(printPanel, "printTemp", "Print temperature ", "220", "220= default, 230=Accelerated");
        return printPanel;
    }

    private JComponent materialPanel() {
        JPanel materialPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.addTextParameter(materialPanel, "filamentDiameter", "Filament Diameter (mm)", "1.82", "measure feedstock");
        return materialPanel;
    }

    private JComponent machinePanel() {
        JPanel machinePanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.addTextParameter(machinePanel, "desiredPathWidth", "Nozzle Diameter (mm)", "0.4", "Set the desired path width");
        return machinePanel;
    }

    private JComponent defaultsPanel() {
        JPanel defaultsPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        JButton repDefaults = new JButton("Load Replicator Defaults");
        JButton tomDefaults = new JButton("Load Thing-o-matic Defaults");
        JButton repAccelDefaults = new JButton("Load Accelerated Defaults");
        ActionListener loadRepDefaults = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOMatic5D.this.setValue("infillPercent", "10");
                PrintOMatic5D.this.setValue("desiredLayerHeight", ".27");
                PrintOMatic5D.this.setValue("numberOfShells", "1");
                PrintOMatic5D.this.setValue("desiredFeedrate", "40");
                PrintOMatic5D.this.setValue("travelFeedrate", "55");
                PrintOMatic5D.this.setValue("filamentDiameter", "1.82");
                PrintOMatic5D.this.setValue("desiredPathWidth", ".4");
                PrintOMatic5D.this.setValue("printTemp", "220");
                PrintOMatic5D.this.printOMatic5D.removeAll();
                PrintOMatic5D.this.makeTabs();
            }
        };
        ActionListener loadTomDefaults = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOMatic5D.this.setValue("infillPercent", "10");
                PrintOMatic5D.this.setValue("desiredLayerHeight", ".27");
                PrintOMatic5D.this.setValue("numberOfShells", "1");
                PrintOMatic5D.this.setValue("desiredFeedrate", "30");
                PrintOMatic5D.this.setValue("travelFeedrate", "30");
                PrintOMatic5D.this.setValue("filamentDiameter", "1.82");
                PrintOMatic5D.this.setValue("desiredPathWidth", ".4");
                PrintOMatic5D.this.setValue("printTemp", "220");
                PrintOMatic5D.this.printOMatic5D.removeAll();
                PrintOMatic5D.this.makeTabs();
            }
        };
        ActionListener loadRepAccelDefaults = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOMatic5D.this.setValue("infillPercent", "10");
                PrintOMatic5D.this.setValue("desiredLayerHeight", ".27");
                PrintOMatic5D.this.setValue("numberOfShells", "1");
                PrintOMatic5D.this.setValue("desiredFeedrate", "80");
                PrintOMatic5D.this.setValue("travelFeedrate", "150");
                PrintOMatic5D.this.setValue("filamentDiameter", "1.82");
                PrintOMatic5D.this.setValue("desiredPathWidth", ".4");
                PrintOMatic5D.this.setValue("printTemp", "230");
                PrintOMatic5D.this.printOMatic5D.removeAll();
                PrintOMatic5D.this.makeTabs();
            }
        };
        repDefaults.addActionListener(loadRepDefaults);
        tomDefaults.addActionListener(loadTomDefaults);
        repAccelDefaults.addActionListener(loadRepAccelDefaults);
        defaultsPanel.add((Component)repDefaults, "growx, wrap");
        defaultsPanel.add((Component)tomDefaults, "growx, wrap");
        defaultsPanel.add((Component)repAccelDefaults, "growx, wrap");
        return defaultsPanel;
    }

    private void makeTabs() {
        this.printOMatic5D.addTab("Settings", this.generatePrintPanel());
        this.printOMatic5D.addTab("Plastic", this.materialPanel());
        this.printOMatic5D.addTab("Extruder", this.machinePanel());
        this.printOMatic5D.addTab("Defaults", this.defaultsPanel());
    }

    @Override
    public JComponent getUI() {
        return this.component;
    }

    @Override
    public String valueSanityCheck() {
        if (this.enabled.isSelected()) {
            // empty if block
        }
        return null;
    }

    @Override
    public List<SkeinforgeGenerator.SkeinforgeOption> getOptions(String displayName) {
        LinkedList<SkeinforgeGenerator.SkeinforgeOption> options = new LinkedList<SkeinforgeGenerator.SkeinforgeOption>();
        if (this.enabled.isSelected()) {
            double perimeterWidthOverThickness;
            double infillRatio = this.getValue("infillPercent") / 100.0;
            double filamentDiameter = this.getValue("filamentDiameter");
            double infillWidthOverThickness = perimeterWidthOverThickness = this.getValue("desiredPathWidth") / this.getValue("desiredLayerHeight");
            double feedRate = this.getValue("desiredFeedrate");
            double travelFeedRate = this.getValue("travelFeedrate");
            double layerHeight = this.getValue("desiredLayerHeight");
            double extraShellsOnAlternatingSolidLayer = this.getValue("numberOfShells");
            double extraShellsOnBase = this.getValue("numberOfShells");
            double extraShellsOnSparseLayer = this.getValue("numberOfShells");
            Base.logger.fine("Print-O-Matic settings:\n infillRatio=" + infillRatio + "\n filamentDiameter=" + filamentDiameter + "\n perimeterWidthOverThickness=" + perimeterWidthOverThickness + "\n infillWidthOverThickness=" + infillWidthOverThickness + "\n feedRate=" + feedRate + "\n layerHeight=" + layerHeight + "\n extraShellsOnAlternatingSolidLayer=" + extraShellsOnAlternatingSolidLayer + "\n extraShellsOnBase=" + extraShellsOnBase + "\n extraShellsOnSparseLayer=" + extraShellsOnSparseLayer);
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Infill Solidity (ratio):", Double.toString(infillRatio)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("speed.csv", "Feed Rate (mm/s):", Double.toString(feedRate)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("speed.csv", "Travel Feed Rate (mm/s):", Double.toString(travelFeedRate)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("speed.csv", "Flow Rate Setting (float):", Double.toString(feedRate)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("dimension.csv", "Filament Diameter (mm):", Double.toString(filamentDiameter)));
            if (displayName.equalsIgnoreCase("Skeinforge (50)")) {
                Base.logger.severe("printomatic 5D sf 50");
                options.add(new SkeinforgeGenerator.SkeinforgeOption("carve.csv", "Edge Width over Height (ratio):", Double.toString(perimeterWidthOverThickness)));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("inset.csv", "Infill Width over Thickness (ratio):", Double.toString(infillWidthOverThickness)));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("carve.csv", "Layer Height (mm):", Double.toString(layerHeight)));
            } else {
                Base.logger.severe("printomatic 5D sf other");
                options.add(new SkeinforgeGenerator.SkeinforgeOption("carve.csv", "Perimeter Width over Thickness (ratio):", Double.toString(perimeterWidthOverThickness)));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Infill Width over Thickness (ratio):", Double.toString(infillWidthOverThickness)));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("carve.csv", "Layer Thickness (mm):", Double.toString(layerHeight)));
            }
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Alternating Solid Layer (layers):", Double.toString(extraShellsOnAlternatingSolidLayer)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Base (layers):", Double.toString(extraShellsOnBase)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Sparse Layer (layers):", Double.toString(extraShellsOnSparseLayer)));
        }
        return options;
    }

    @Override
    public String getName() {
        return "Print-O-Matic (5D)";
    }

    private class ComboListener
    implements ActionListener {
        final String name;
        final DefaultComboBoxModel input;

        public ComboListener(DefaultComboBoxModel input, String name) {
            this.input = input;
            this.name = name;
        }

        public void actionPerformed(ActionEvent arg0) {
            String value = this.input.getSelectedItem().toString();
            if (this.name != null) {
                Base.logger.fine("here: " + this.name + "=" + value);
                Base.preferences.put(this.name, value);
            }
        }
    }
}

